/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.vcf;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPopupMenu;
import org.apache.log4j.Logger;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.session.SessionReader;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.PackedFeatures;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.vcf.VCFMenu;
import org.broad.igv.vcf.VCFRenderer;
import org.broad.tribble.Feature;
import org.broad.tribble.util.variantcontext.Allele;
import org.broad.tribble.util.variantcontext.Genotype;
import org.broad.tribble.util.variantcontext.VariantContext;
import org.broad.tribble.vcf.VCFHeader;

public class VCFTrack
extends FeatureTrack {
    private static Logger log = Logger.getLogger(VCFTrack.class);
    private static final Color OFF_WHITE = new Color(170, 170, 170);
    private static final int GROUP_BORDER_WIDTH = 3;
    private static final Color BAND1_COLOR = new Color(245, 245, 245);
    private static final Color BAND2_COLOR = Color.white;
    private static Map<String, String> REFERENCE_SAMPLE_GROUP_MAP = new HashMap<String, String>();
    private static LinkedHashMap<String, List<String>> REFERENCE_GROUP_SAMPLE_MAP;
    private boolean enableMethylationRateSupport;
    private final int EXPANDED_GENOTYPE_HEIGHT = 15;
    private final int SQUISHED_GENOTYPE_HEIGHT = 4;
    private final int DEFAULT_VARIANT_BAND_HEIGHT = 25;
    private final int MAX_FILTER_LINES = 15;
    private VCFRenderer renderer = new VCFRenderer(this);
    private int top;
    private int variantBandHeight = 25;
    LinkedHashMap<String, List<String>> samples = new LinkedHashMap();
    List<String> allSamples;
    List<String> groupNames;
    int sampleCount;
    private boolean grouped;
    private boolean hasGroups;
    private ColorMode coloring = ColorMode.GENOTYPE;
    private boolean hideAncestral = false;
    private boolean hideFiltered = true;
    private boolean renderID = true;
    private static float[] dash;
    DecimalFormat numFormat = new DecimalFormat("#.###");
    Feature selectedVariant;

    public boolean isEnableMethylationRateSupport() {
        return this.enableMethylationRateSupport;
    }

    public static void addSampleGroups(LinkedHashMap<String, List<String>> map) {
        REFERENCE_GROUP_SAMPLE_MAP = map;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String family = entry.getKey();
            for (String sample : entry.getValue()) {
                REFERENCE_SAMPLE_GROUP_MAP.put(sample, family);
            }
        }
    }

    public VCFTrack(ResourceLocator locator, TribbleFeatureSource source) {
        super(locator, source);
        VCFHeader header = (VCFHeader)source.getHeader();
        if (header.getFormatHeaderLine("MR") != null && header.getFormatHeaderLine("GB") != null) {
            this.enableMethylationRateSupport = true;
            this.coloring = ColorMode.METHYLATION_RATE;
        }
        this.allSamples = new ArrayList<String>(header.getGenotypeSamples());
        this.sampleCount = this.allSamples.size();
        for (String sample : this.allSamples) {
            List<String> sampleList;
            String key = REFERENCE_SAMPLE_GROUP_MAP.get(sample);
            if (key == null) {
                key = "Other";
            }
            if ((sampleList = this.samples.get(key)) == null) {
                sampleList = new ArrayList<String>();
                this.samples.put(key, sampleList);
            }
            sampleList.add(sample);
        }
        this.grouped = this.samples.size() > 1;
        boolean bl = this.hasGroups = this.samples.size() > 1;
        if (this.grouped && REFERENCE_GROUP_SAMPLE_MAP != null) {
            this.sortGroups();
        }
        this.setDisplayMode(Track.DisplayMode.EXPANDED);
        this.setRenderID(false);
        int cnt = Math.max(1, this.sampleCount);
        int beta = 20000;
        int visWindow = Math.min(500000, beta / cnt * 1000);
        this.setVisibilityWindow(visWindow);
    }

    private void sortGroups() {
        final HashMap<String, Integer> groupRank = new HashMap<String, Integer>();
        int idx = 0;
        for (String family : REFERENCE_GROUP_SAMPLE_MAP.keySet()) {
            groupRank.put(family, idx++);
        }
        this.groupNames = new ArrayList<String>(this.samples.keySet());
        Collections.sort(this.groupNames, new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int r1 = groupRank.containsKey(s1) ? (Integer)groupRank.get(s1) : Integer.MAX_VALUE;
                int r2 = groupRank.containsKey(s2) ? (Integer)groupRank.get(s2) : Integer.MAX_VALUE;
                return r1 - r2;
            }
        });
        LinkedHashMap<String, List<String>> newSamples = new LinkedHashMap<String, List<String>>();
        for (String family : this.groupNames) {
            List<String> sampleList = this.samples.get(family);
            if (sampleList == null || sampleList.size() <= 0) continue;
            List<String> referenceGroup = REFERENCE_GROUP_SAMPLE_MAP.get(family);
            if (referenceGroup != null) {
                final HashMap<String, Integer> rank = new HashMap<String, Integer>();
                for (int i2 = 0; i2 < referenceGroup.size(); ++i2) {
                    rank.put(referenceGroup.get(i2), i2);
                    Collections.sort(sampleList, new Comparator<String>(){

                        @Override
                        public int compare(String s1, String s2) {
                            int r1 = rank.containsKey(s1) ? (Integer)rank.get(s1) : Integer.MAX_VALUE;
                            int r2 = rank.containsKey(s2) ? (Integer)rank.get(s2) : Integer.MAX_VALUE;
                            return r1 - r2;
                        }
                    });
                }
            }
            newSamples.put(family, sampleList);
        }
        this.samples = newSamples;
    }

    public int getGenotypeBandHeight() {
        switch (this.getDisplayMode()) {
            case SQUISHED: {
                return 4;
            }
            case COLLAPSED: {
                return 0;
            }
        }
        return 15;
    }

    @Override
    public int getHeight() {
        if (this.getDisplayMode() == Track.DisplayMode.COLLAPSED) {
            return this.variantBandHeight;
        }
        int groupCount = this.samples.size();
        return this.variantBandHeight + (groupCount - 1) * 3 + this.sampleCount * this.getGenotypeBandHeight();
    }

    @Override
    public int getPreferredHeight() {
        return this.getHeight();
    }

    @Override
    public void setHeight(int height) {
        this.height = Math.max(this.minimumHeight, height);
    }

    @Override
    public void setDisplayMode(Track.DisplayMode mode) {
        super.setDisplayMode(mode);
        this.setHeight(this.getPreferredHeight());
    }

    @Override
    protected void renderFeatureImpl(RenderContext context, Rectangle trackRectangle, PackedFeatures packedFeatures) {
        List features;
        Graphics2D g2D = context.getGraphics();
        this.top = trackRectangle.y;
        Rectangle visibleRectangle = context.getVisibleRect();
        Rectangle rect = new Rectangle(trackRectangle);
        rect.height = this.getGenotypeBandHeight();
        rect.y = trackRectangle.y + this.variantBandHeight;
        this.colorBackground(g2D, rect, visibleRectangle, false);
        if (this.top > visibleRectangle.y && (double)this.top < visibleRectangle.getMaxY()) {
            this.drawBorderLine(g2D, this.top + 1, trackRectangle.x, trackRectangle.x + trackRectangle.width);
        }
        if ((features = packedFeatures.getFeatures()).size() > 0) {
            double locScale = context.getScale();
            double origin = context.getOrigin();
            int lastPX = -1;
            double pXMin = rect.getMinX();
            double pXMax = rect.getMaxX();
            for (Feature feature : features) {
                boolean isSelected;
                int end;
                int dX;
                VariantContext variant = (VariantContext)feature;
                int start = variant.getStart() - 1;
                int pX = (int)(((double)start - origin) / locScale);
                if ((double)(pX + (dX = (int)Math.max(2.0, (double)((end = variant.getEnd()) - start) / locScale))) < pXMin) continue;
                if ((double)pX > pXMax) break;
                int w = dX;
                int x = pX;
                if (w < 3) {
                    w = 3;
                    --x;
                }
                if (pX + dX <= lastPX) continue;
                ZygosityCount zygCounts = this.getZygosityCounts(variant);
                rect.y = this.top;
                rect.height = this.variantBandHeight;
                if (rect.intersects(visibleRectangle)) {
                    if (this.allSamples.size() == 0) {
                        this.renderer.renderVariant(variant, rect, pX, dX, context);
                    } else {
                        AlleleCount alleleCounts = new AlleleCount(zygCounts);
                        this.renderer.renderAlleleBand(variant, rect, x, w, context, this.hideFiltered, alleleCounts);
                    }
                }
                if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED) {
                    rect.y += rect.height;
                    rect.height = this.getGenotypeBandHeight();
                    if (this.grouped) {
                        for (Map.Entry entry : this.samples.entrySet()) {
                            for (String sample : (List)entry.getValue()) {
                                if (rect.intersects(visibleRectangle)) {
                                    this.renderer.renderGenotypeBandSNP(variant, context, rect, x, w, sample, this.coloring, this.hideFiltered);
                                }
                                rect.y += rect.height;
                            }
                            g2D.setColor(OFF_WHITE);
                            g2D.fillRect(rect.x, rect.y, rect.width, 3);
                            rect.y += 3;
                        }
                    } else {
                        for (String string : this.allSamples) {
                            if (rect.intersects(visibleRectangle)) {
                                this.renderer.renderGenotypeBandSNP(variant, context, rect, x, w, string, this.coloring, this.hideFiltered);
                            }
                            rect.y += rect.height;
                        }
                    }
                }
                boolean bl = isSelected = this.selectedVariant != null && this.selectedVariant == variant;
                if (isSelected) {
                    Graphics2D graphics2D = context.getGraphic2DForColor(Color.black);
                    graphics2D.drawRect(x, this.top, w, this.getHeight());
                }
                lastPX = pX + dX;
            }
        } else {
            rect.height = this.variantBandHeight;
            rect.y = trackRectangle.y;
            g2D.setColor(Color.gray);
            GraphicUtils.drawCenteredText("No Variants Found", trackRectangle, g2D);
        }
        int bottomY = trackRectangle.y + trackRectangle.height;
        if (bottomY >= visibleRectangle.y && (double)bottomY <= visibleRectangle.getMaxY()) {
            int left = trackRectangle.x;
            int right = (int)trackRectangle.getMaxX();
            this.drawBorderLine(g2D, bottomY, left, right);
        }
    }

    private void drawBorderLine(Graphics2D g2D, int bottomY, int left, int right) {
        g2D.setColor(Color.black);
        g2D.drawLine(left, bottomY, right, bottomY);
    }

    private void colorBackground(Graphics2D g2D, Rectangle bandRectangle, Rectangle visibleRectangle, boolean renderNames) {
        boolean coloredLast = true;
        Rectangle textRectangle = new Rectangle(bandRectangle);
        --textRectangle.height;
        int bandFontSize = Math.min(this.fontSize, (int)bandRectangle.getHeight() - 1);
        Font font = FontManager.getFont(bandFontSize);
        Font oldFont = g2D.getFont();
        g2D.setFont(font);
        if (this.grouped) {
            for (List<String> sampleList : this.samples.values()) {
                for (String sample : sampleList) {
                    if (coloredLast) {
                        g2D.setColor(BAND1_COLOR);
                        coloredLast = false;
                    } else {
                        g2D.setColor(BAND2_COLOR);
                        coloredLast = true;
                    }
                    if (bandRectangle.intersects(visibleRectangle)) {
                        g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, bandRectangle.height);
                        if (renderNames && bandRectangle.height >= 3) {
                            String printName = sample;
                            textRectangle.y = bandRectangle.y + 1;
                            g2D.setColor(Color.black);
                            GraphicUtils.drawWrappedText(printName, bandRectangle, g2D, false);
                        }
                    }
                    bandRectangle.y += bandRectangle.height;
                }
                g2D.setColor(OFF_WHITE);
                g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, 3);
                bandRectangle.y += 3;
            }
        } else {
            for (String sample : this.allSamples) {
                if (coloredLast) {
                    g2D.setColor(BAND1_COLOR);
                    coloredLast = false;
                } else {
                    g2D.setColor(BAND2_COLOR);
                    coloredLast = true;
                }
                if (bandRectangle.intersects(visibleRectangle)) {
                    g2D.fillRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, bandRectangle.height);
                    if (renderNames && bandRectangle.height >= 3) {
                        String printName = sample;
                        textRectangle.y = bandRectangle.y + 1;
                        g2D.setColor(Color.black);
                        g2D.setFont(font);
                        GraphicUtils.drawWrappedText(printName, bandRectangle, g2D, false);
                    }
                }
                bandRectangle.y += bandRectangle.height;
            }
        }
        g2D.setFont(oldFont);
    }

    public void setRenderID(boolean value) {
        this.renderID = value;
    }

    public boolean getRenderID() {
        return this.renderID;
    }

    public void setHideAncestral(boolean value) {
        this.hideAncestral = value;
    }

    public boolean getHideFiltered() {
        return this.hideFiltered;
    }

    public void setHideFiltered(boolean value) {
        this.hideFiltered = value;
    }

    public boolean getHideAncestral() {
        return this.hideAncestral;
    }

    public ColorMode getColorMode() {
        return this.coloring;
    }

    public void setColorMode(ColorMode mode) {
        this.coloring = mode;
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        int bottomY;
        int top = trackRectangle.y;
        Rectangle rect = new Rectangle(trackRectangle);
        g2D.clearRect(rect.x, rect.y, rect.width, rect.height);
        g2D.setFont(FontManager.getFont(this.fontSize));
        g2D.setColor(BAND2_COLOR);
        if (top > visibleRectangle.y && (double)top < visibleRectangle.getMaxY()) {
            this.drawBorderLine(g2D, top + 1, trackRectangle.x, trackRectangle.x + trackRectangle.width);
        }
        g2D.setColor(Color.black);
        rect.height = this.variantBandHeight;
        if (rect.intersects(visibleRectangle)) {
            GraphicUtils.drawWrappedText(this.getName(), rect, g2D, false);
        }
        if (this.grouped) {
            g2D.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
        }
        rect.y += rect.height;
        rect.height = this.getGenotypeBandHeight();
        if (this.getDisplayMode() != Track.DisplayMode.COLLAPSED) {
            this.colorBackground(g2D, rect, visibleRectangle, true);
        }
        if ((bottomY = trackRectangle.y + trackRectangle.height) >= visibleRectangle.y && (double)bottomY <= visibleRectangle.getMaxY()) {
            int left = trackRectangle.x;
            int right = (int)trackRectangle.getMaxX();
            this.drawBorderLine(g2D, bottomY, left, right);
        }
    }

    @Override
    public String getValueStringAt(String chr, double position, int y, ReferenceFrame frame) {
        VariantContext variant = (VariantContext)this.getFeatureAt(chr, position + 1.0, y, frame);
        if (variant != null) {
            if (y < this.top + this.variantBandHeight) {
                return this.getVariantToolTip(variant);
            }
            String sample = null;
            if (this.grouped) {
                int groupHeight = 3 * this.getGenotypeBandHeight() + 3;
                int groupNumber = Math.min(this.groupNames.size() - 1, (y - this.top - this.variantBandHeight) / groupHeight);
                String group = this.groupNames.get(groupNumber);
                List<String> sampleList = this.samples.get(group);
                int sampleNumber = (y - this.top - this.variantBandHeight - groupNumber * groupHeight) / this.getGenotypeBandHeight();
                if (sampleNumber >= 0 || sampleNumber < sampleList.size()) {
                    sample = sampleList.get(sampleNumber);
                }
            } else {
                int sampleNumber = (y - this.top - this.variantBandHeight) / this.getGenotypeBandHeight();
                if (sampleNumber >= 0 && sampleNumber < this.allSamples.size()) {
                    sample = this.allSamples.get(sampleNumber);
                }
            }
            return this.getSampleToolTip(sample, variant);
        }
        return null;
    }

    protected String getVariantInfo(VariantContext variant) {
        Set<String> keys = variant.getAttributes().keySet();
        if (keys.size() > 0) {
            String toolTip = "<br><b>Variant Attributes</b>";
            int count = 0;
            for (String key : keys) {
                try {
                    if (++count > 15) {
                        toolTip = toolTip.concat("<br>....");
                        break;
                    }
                    toolTip = toolTip.concat("<br>" + (Object)((Object)InfoFieldName.findEnum(key)) + ": " + variant.getAttributeAsString(key));
                }
                catch (IllegalArgumentException iae) {
                    toolTip = toolTip.concat("<br>" + key + ": " + variant.getAttributeAsString(key));
                }
            }
            return toolTip;
        }
        return " ";
    }

    private String getSampleInfo(Genotype genotype) {
        Set<String> keys = genotype.getAttributes().keySet();
        if (keys.size() > 0) {
            String tooltip = "<br><b>Sample Attributes</b>";
            for (String key : keys) {
                try {
                    tooltip = tooltip.concat("<br>" + (Object)((Object)InfoFieldName.findEnum(key)) + ": " + genotype.getAttributeAsString(key));
                }
                catch (IllegalArgumentException iae) {
                    tooltip = tooltip.concat("<br>" + key + ": " + genotype.getAttributeAsString(key));
                }
            }
            return tooltip;
        }
        return null;
    }

    public void clearSelectedVariant() {
        this.selectedVariant = null;
    }

    public List<String> getAllSamples() {
        return this.allSamples;
    }

    public void setAllSamples(List<String> samples) {
        this.allSamples = samples;
    }

    public boolean isGrouped() {
        return this.grouped;
    }

    public void setGrouped(boolean grouped) {
        this.grouped = grouped;
    }

    public boolean isHasGroups() {
        return this.hasGroups;
    }

    private String getSampleToolTip(String sample, VariantContext variant) {
        String id = variant.getAttributeAsString("ID");
        StringBuffer toolTip = new StringBuffer();
        toolTip = toolTip.append("Chr:" + variant.getChr());
        toolTip = toolTip.append("<br>Position:" + variant.getStart());
        toolTip = toolTip.append("<br>ID: " + id + "<br>");
        toolTip = toolTip.append("<br><b>Sample Information</b>");
        toolTip = toolTip.append("<br>Sample: " + sample);
        toolTip = toolTip.append("<br>Position:" + variant.getStart());
        Genotype genotype = variant.getGenotype(sample);
        if (genotype != null) {
            toolTip = toolTip.append("<br>Bases: " + genotype.getGenotypeString());
            toolTip = toolTip.append("<br>Quality: " + this.numFormat.format(genotype.getPhredScaledQual()));
            toolTip = toolTip.append("<br>Type: " + (Object)((Object)genotype.getType()));
        }
        if (variant.isFiltered()) {
            toolTip = toolTip.append("<br>Is Filtered Out: Yes</b>");
            toolTip = toolTip.append(this.getFilterTooltip(variant));
        } else {
            toolTip = toolTip.append("<br>Is Filtered Out: No</b><br>");
        }
        if (genotype != null) {
            toolTip = toolTip.append(this.getSampleInfo(genotype) + "<br>");
        }
        return toolTip.toString();
    }

    private String getVariantToolTip(VariantContext variant) {
        String id = variant.getAttributeAsString("ID");
        StringBuffer toolTip = new StringBuffer();
        toolTip = toolTip.append("Chr:" + variant.getChr());
        toolTip = toolTip.append("<br>Position:" + variant.getStart());
        toolTip = toolTip.append("<br>ID: " + id);
        toolTip = toolTip.append("<br>Reference: " + variant.getReference().toString());
        Set<Allele> alternates = variant.getAlternateAlleles();
        if (alternates.size() > 0) {
            toolTip = toolTip.append("<br>Alternate: " + alternates.toString());
        }
        toolTip = toolTip.append("<br>Qual: " + this.numFormat.format(variant.getPhredScaledQual()));
        toolTip = toolTip.append("<br>Type: " + (Object)((Object)variant.getType()));
        if (variant.isFiltered()) {
            toolTip = toolTip.append("<br>Is Filtered Out: Yes</b>");
            toolTip = toolTip.append(this.getFilterTooltip(variant));
        } else {
            toolTip = toolTip.append("<br>Is Filtered Out: No</b><br>");
        }
        toolTip = toolTip.append("<br><b>Alleles:</b>");
        toolTip = toolTip.append(this.getAlleleToolTip(this.getZygosityCounts(variant)));
        toolTip = toolTip.append("<br>Allele Frequency: " + this.numFormat.format(this.getAlleleFreq(variant)) + "<br>");
        toolTip = toolTip.append("<br><b>Genotypes:</b>");
        toolTip = toolTip.append(this.getGenotypeToolTip(this.getZygosityCounts(variant)) + "<br>");
        toolTip = toolTip.append(this.getVariantInfo(variant) + "<br>");
        return toolTip.toString();
    }

    private String getFilterTooltip(VariantContext variant) {
        Set<String> filters = variant.getFilters();
        String toolTip = "<br>";
        for (String filter : filters) {
            toolTip = toolTip.concat("- " + filter + "<br>");
        }
        return toolTip;
    }

    public double getAlleleFreq(VariantContext variant) {
        double alleleFreq = Double.valueOf(variant.getAttributeAsString("AF", "-1"));
        if (alleleFreq == -1.0) {
            ZygosityCount counts = this.getZygosityCounts(variant);
            int total = counts.getHomVar() + counts.getHet() + counts.getHomRef();
            return ((double)counts.getHomVar() + (double)counts.getHet() / 2.0) / (double)total;
        }
        return alleleFreq;
    }

    public ZygosityCount getZygosityCounts(VariantContext variant) {
        ZygosityCount zc = new ZygosityCount();
        for (String sample : this.allSamples) {
            Genotype genotype = variant.getGenotype(sample);
            zc.incrementCount(genotype);
        }
        return zc;
    }

    public AlleleCount getRenderCounts(VariantContext variant) {
        ZygosityCount zygCounts = this.getZygosityCounts(variant);
        AlleleCount alleleCounts = new AlleleCount(zygCounts);
        return alleleCounts;
    }

    private String getAlleleToolTip(ZygosityCount counts) {
        double noCall = counts.getNoCall() * 2;
        double aNum = (counts.getHet() + counts.getHomRef() + counts.getHomVar()) * 2;
        double aCount = (counts.getHomVar() * 2 + counts.getHet()) * 2;
        String toolTip = "<br>No Call: " + (int)noCall;
        toolTip = toolTip.concat("<br>Allele Num: " + (int)aNum);
        toolTip = toolTip.concat("<br>Allele Count: " + (int)aCount);
        return toolTip;
    }

    private String getGenotypeToolTip(ZygosityCount counts) {
        int noCall = counts.getNoCall();
        int homRef = counts.getHomRef();
        int nonVar = noCall + homRef;
        int het = counts.getHet();
        int homVar = counts.getHomVar();
        int var = het + homVar;
        String toolTip = "<br>Non Variant: " + nonVar;
        toolTip = toolTip.concat("<br> - No Call: " + noCall);
        toolTip = toolTip.concat("<br> - Hom Ref: " + homRef);
        toolTip = toolTip.concat("<br>Variant: " + var);
        toolTip = toolTip.concat("<br> - Het: " + het);
        toolTip = toolTip.concat("<br> - Hom Var: " + homVar);
        return toolTip;
    }

    @Override
    public JPopupMenu getPopupMenu(TrackClickEvent te) {
        VariantContext f2 = null;
        if (te.getFrame() != null && te.getFrame().getName() != null) {
            f2 = (VariantContext)this.getFeatureClosest(te.getChromosomePosition(), te.getMouseEvent().getY(), te.getFrame());
            this.selectedVariant = f2;
            IGV.getInstance().doRefresh();
        }
        return new VCFMenu(this, f2);
    }

    public static void refresh() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                IGV.getInstance().doRefresh();
            }
        });
    }

    @Override
    public Map<String, String> getPersistentState() {
        Map<String, String> attributes = super.getPersistentState();
        attributes.put(SessionReader.SessionAttribute.RENDER_NAME.getText(), String.valueOf(this.renderID));
        ColorMode mode = this.getColorMode();
        if (mode != null) {
            attributes.put(SessionReader.SessionAttribute.COLOR_MODE.getText(), mode.toString());
        }
        return attributes;
    }

    @Override
    public void restorePersistentState(Map<String, String> attributes) {
        super.restorePersistentState(attributes);
        String rendername = attributes.get(SessionReader.SessionAttribute.RENDER_NAME.getText());
        String colorModeText = attributes.get(SessionReader.SessionAttribute.COLOR_MODE.getText());
        if (rendername != null) {
            this.setRenderID(rendername.equalsIgnoreCase("true"));
        }
        if (colorModeText != null) {
            try {
                this.setColorMode(ColorMode.valueOf(colorModeText));
            }
            catch (Exception e2) {
                log.error("Error interpreting display mode: " + colorModeText);
            }
        }
        this.setHeight(this.getPreferredHeight());
    }

    static {
        dash = new float[]{4.0f, 1.0f};
    }

    class AlleleCount {
        private int totalAlleles;
        private int alleleNum;
        private int alleleCount;

        public AlleleCount(ZygosityCount zygCounts) {
            this.totalAlleles = VCFTrack.this.allSamples.size() * 2;
            this.alleleNum = (zygCounts.getHomVar() + zygCounts.getHet() + zygCounts.getHomRef()) * 2;
            this.alleleCount = zygCounts.getHomVar() * 2 + zygCounts.getHet();
        }

        public int getTotalAlleles() {
            return this.totalAlleles;
        }

        public int getAlleleNum() {
            return this.alleleNum;
        }

        public int getAlleleCount() {
            return this.alleleCount;
        }

        public float getAllelePercent() {
            return (float)this.alleleCount / (float)this.alleleNum;
        }
    }

    static class ZygosityCount {
        private int homVar = 0;
        private int het = 0;
        private int homRef = 0;
        private int noCall = 0;

        ZygosityCount() {
        }

        public void incrementCount(Genotype genotype) {
            if (genotype != null) {
                if (genotype.isHomVar()) {
                    ++this.homVar;
                } else if (genotype.isHet()) {
                    ++this.het;
                } else if (genotype.isHomRef()) {
                    ++this.homRef;
                } else {
                    ++this.noCall;
                }
            }
        }

        public int getHomVar() {
            return this.homVar;
        }

        public int getHet() {
            return this.het;
        }

        public int getHomRef() {
            return this.homRef;
        }

        public int getNoCall() {
            return this.noCall;
        }

        public int getTotalCall() {
            return this.homVar + this.homRef + this.het;
        }

        public int getVarCall() {
            return this.homVar + this.het;
        }

        public int getSampleCount() {
            return this.homVar + this.homRef + this.het + this.noCall;
        }
    }

    public static enum InfoFieldName {
        AA("Ancestral Allele"),
        AC("Allele Count in Genotypes"),
        AN("Total Alleles in Genotypes"),
        AF("Allele Frequency"),
        DP("Depth"),
        MQ("Mapping Quality"),
        NS("Number of Samples with Data"),
        BQ("RMS Base Quality"),
        SB("Strand Bias"),
        DB("dbSNP Membership"),
        GQ("Genotype Quality"),
        GL("Genotype Likelihoods");

        private String name;

        private InfoFieldName(String name) {
            this.name = name;
        }

        public String getText() {
            return this.name;
        }

        public String toString() {
            return this.getText();
        }

        public static InfoFieldName findEnum(String value) {
            if (value == null) {
                return null;
            }
            return InfoFieldName.valueOf(value);
        }
    }

    public static enum ColorMode {
        GENOTYPE,
        METHYLATION_RATE,
        ALLELE;

    }
}

