/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.vcf;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.ui.FontManager;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.vcf.VCFTrack;
import org.broad.tribble.util.variantcontext.Allele;
import org.broad.tribble.util.variantcontext.Genotype;
import org.broad.tribble.util.variantcontext.VariantContext;

public class VCFRenderer {
    private static Logger log = Logger.getLogger(VCFRenderer.class);
    private static float alphaValue = 0.2f;
    public static Color colorHomRef = new Color(235, 235, 235);
    public static Color colorHomRefAlpha = ColorUtilities.getCompositeColor(colorHomRef.getColorComponents(null), alphaValue);
    public static Color colorHomVar = new Color(0, 245, 255);
    public static Color colorHomVarAlpha = ColorUtilities.getCompositeColor(colorHomVar.getColorComponents(null), alphaValue);
    public static Color colorHet = Color.blue.brighter();
    public static Color colorHetAlpha = ColorUtilities.getCompositeColor(colorHet.getColorComponents(null), alphaValue);
    public static Color colorNoCall = Color.white;
    public static Color colorNoCallAlpha = ColorUtilities.getCompositeColor(colorNoCall.getColorComponents(null), alphaValue);
    public static final Color colorAlleleBand = Color.red;
    public static Color colorAlleleBandAlpha = ColorUtilities.getCompositeColor(colorAlleleBand.getColorComponents(null), alphaValue);
    public static final Color colorAlleleRef = Color.lightGray;
    public static Color colorAlleleRefAlpha = ColorUtilities.getCompositeColor(colorAlleleRef.getColorComponents(null), alphaValue);
    private static int variantWidth = 3;
    static Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();
    private static final Color DARK_GREEN = new Color(30, 120, 30);
    private static final Color BLUE = Color.blue.darker();
    private VCFTrack track;

    public VCFRenderer(VCFTrack track) {
        this.track = track;
    }

    public void renderVariantBand(VariantContext variant, Rectangle bandRectangle, int pX0, int dX, RenderContext context, boolean hideFiltered, VCFTrack.ZygosityCount zygCounts, int idBandHeight) {
        int pY = (int)bandRectangle.getY() + idBandHeight;
        int dY = (int)bandRectangle.getHeight() - idBandHeight;
        int bottomY = bandRectangle.y + bandRectangle.height;
        float sampleHeight = (float)dY / (float)zygCounts.getSampleCount();
        boolean filtered = hideFiltered && variant.isFiltered();
        int totalHeight = (int)((float)zygCounts.getTotalCall() * sampleHeight);
        Color c2 = filtered ? colorHomRefAlpha : colorHomRef;
        context.getGraphic2DForColor(c2).fillRect(pX0, bottomY - totalHeight, dX, totalHeight);
        int varHeight = (int)((float)zygCounts.getVarCall() * sampleHeight);
        c2 = filtered ? colorHomVarAlpha : colorHomVar;
        context.getGraphic2DForColor(c2).fillRect(pX0, bottomY - varHeight, dX, varHeight);
        int hetHeight = (int)((float)zygCounts.getHet() * sampleHeight);
        c2 = filtered ? colorHetAlpha : colorHet;
        context.getGraphic2DForColor(c2).fillRect(pX0, bottomY - hetHeight, dX, hetHeight);
        String id = variant.getAttributeAsString("ID");
        if (!id.equals(".") && idBandHeight > 0) {
            Graphics2D g2 = (Graphics2D)context.getGraphics().create();
            Font f2 = FontManager.getFont(1, 10);
            f2 = f2.deriveFont(AffineTransform.getRotateInstance(-0.5235987755982988));
            g2.setFont(f2);
            g2.setColor(Color.black);
            g2.drawString(variant.getAttributeAsString("ID"), pX0 + dX / 2, pY - 1);
            g2.dispose();
        }
        int w = bandRectangle.width;
        int x = bandRectangle.x;
        if (w < 3) {
            w = 3;
            --x;
        }
        context.getGraphic2DForColor(Color.black).drawRect(x, bandRectangle.y, w, bandRectangle.height);
    }

    public void renderAlleleBand(VariantContext variant, Rectangle bandRectangle, int pX0, int dX, RenderContext context, boolean hideFiltered, VCFTrack.AlleleCount alleleCounts) {
        int bottomY = bandRectangle.y + bandRectangle.height;
        int maxBarHeight = bandRectangle.height - 3;
        float allelePercent = alleleCounts.getAllelePercent();
        int alleleBarHeight = (int)(allelePercent * (float)maxBarHeight);
        int remainderHeight = maxBarHeight - alleleBarHeight;
        boolean filtered = variant.isFiltered() && hideFiltered;
        Color alleleColor = filtered ? colorAlleleBandAlpha : colorAlleleBand;
        Color refColor = filtered ? colorAlleleRefAlpha : colorAlleleRef;
        Graphics2D g2 = context.getGraphic2DForColor(alleleColor);
        g2.fillRect(pX0, bottomY - alleleBarHeight, dX, alleleBarHeight);
        g2 = context.getGraphic2DForColor(refColor);
        g2.fillRect(pX0, bandRectangle.y + 3, dX, remainderHeight);
        int bottom = bandRectangle.y + bandRectangle.height;
        context.getGraphic2DForColor(Color.gray).drawLine(bandRectangle.x, bottom, bandRectangle.x + bandRectangle.width, bottom);
    }

    public void renderVariant(VariantContext variant, Rectangle bandRectangle, int pX0, int dX, RenderContext context) {
        int bottomY = bandRectangle.y + bandRectangle.height;
        int barHeight = (int)(0.8 * (double)bandRectangle.height);
        Graphics2D g2 = context.getGraphic2DForColor(BLUE);
        g2.fillRect(pX0, bottomY - barHeight, dX, barHeight);
        context.getGraphic2DForColor(Color.black).drawRect(bandRectangle.x, bandRectangle.y, bandRectangle.width, bandRectangle.height);
    }

    public void renderGenotypeBandSNP(VariantContext variant, RenderContext context, Rectangle bandRectangle, int pX0, int dX, String sampleName, VCFTrack.ColorMode coloring, boolean hideFiltered) {
        int pY = (int)bandRectangle.getY();
        int dY = (int)bandRectangle.getHeight();
        int tOffset = 6;
        int bOffset = 8;
        Graphics2D g2 = (Graphics2D)context.getGraphics().create();
        if (dX >= 10) {
            Font f2;
            if (dY > 24) {
                f2 = FontManager.getFont(1, Math.min(dX, 12));
                g2.setFont(f2);
            } else if (dY > 18) {
                f2 = FontManager.getFont(1, Math.min(dX, 8));
                tOffset = 4;
                bOffset = 5;
                g2.setFont(f2);
            }
        }
        boolean isFiltered = variant.isFiltered() && hideFiltered;
        Genotype genotype = variant.getGenotype(sampleName);
        if (genotype == null) {
            log.error("Now what?");
        } else {
            Color b2Color;
            Color b1Color;
            char b1 = this.getFirstBase(genotype.getAlleles().get(0));
            char b2 = this.getFirstBase(genotype.getAlleles().get(1));
            switch (coloring) {
                case GENOTYPE: {
                    b2Color = b1Color = this.getGenotypeColor(genotype, isFiltered);
                    break;
                }
                case ALLELE: {
                    b1Color = nucleotideColors.get(Character.valueOf(b1));
                    b2Color = nucleotideColors.get(Character.valueOf(b2));
                    break;
                }
                case METHYLATION_RATE: {
                    Double goodBaseCount = genotype.getAttributeAsDoubleNoException("GB");
                    Double value = genotype.getAttributeAsDoubleNoException("MR");
                    if (goodBaseCount < 10.0 || value == null) {
                        b2Color = b1Color = colorNoCall;
                        break;
                    }
                    float mr = (float)value.doubleValue();
                    b2Color = b1Color = this.convertMethylationRateToColor(mr /= 100.0f);
                    break;
                }
                default: {
                    b2Color = b1Color = colorNoCall;
                }
            }
            if (b1 == '.' || b2 == '.') {
                int offset = (dX /= 2) / 2;
                pX0 += offset;
            }
            int y0 = this.track.getDisplayMode() == Track.DisplayMode.EXPANDED ? pY + 1 : pY;
            int h2 = Math.max(1, this.track.getDisplayMode() == Track.DisplayMode.EXPANDED ? dY - 2 : dY);
            if (coloring == VCFTrack.ColorMode.GENOTYPE) {
                g2.setColor(b1Color);
                g2.fillRect(pX0, y0, dX, h2);
            } else {
                g2.setColor(b1Color);
                g2.fillRect(pX0, y0, dX / 2, h2);
                g2.setColor(b2Color);
                g2.fillRect(pX0 + dX / 2, y0, dX / 2, h2);
            }
            if (dX >= 10 && dY >= 18) {
                if (b1Color == Color.blue) {
                    g2.setColor(Color.white);
                } else {
                    g2.setColor(Color.black);
                }
                this.drawCenteredText(g2, new char[]{b1}, pX0, pY - tOffset, dX, dY);
                this.drawCenteredText(g2, new char[]{b2}, pX0, pY + dY / 2 - bOffset, dX, dY);
            }
        }
    }

    private Color convertMethylationRateToColor(float mr) {
        if ((double)mr >= 0.25) {
            return Color.getHSBColor((mr - 0.25f) * 1.3333334f, 1.0f, 1.0f);
        }
        return new Color(1.0f - mr, 1.0f - mr, 1.0f - mr);
    }

    public char getFirstBase(Allele allele) {
        byte[] bases = allele.getBases();
        if (bases.length > 0) {
            return (char)bases[0];
        }
        return '.';
    }

    public Color getGenotypeColor(Genotype genotype, boolean isFiltered) {
        if (genotype.isNoCall()) {
            return isFiltered ? colorNoCallAlpha : colorNoCall;
        }
        if (genotype.isHomRef()) {
            return isFiltered ? colorHomRefAlpha : colorHomRef;
        }
        if (genotype.isHomVar()) {
            return isFiltered ? colorHomVarAlpha : colorHomVar;
        }
        if (genotype.isHet()) {
            return isFiltered ? colorHetAlpha : colorHet;
        }
        return Color.white;
    }

    private void drawCenteredText(Graphics2D g2, char[] chars, int x, int y, int w, int h2) {
        FontMetrics fm = g2.getFontMetrics();
        int msg_width = fm.charsWidth(chars, 0, 1);
        int ascent = fm.getMaxAscent();
        int descent = fm.getMaxDescent();
        int msgX = x + w / 2 - msg_width / 2;
        int msgY = y + h2 / 2 - descent / 2 + ascent / 2;
        g2.drawChars(chars, 0, 1, msgX, msgY);
    }

    static {
        nucleotideColors.put(Character.valueOf('A'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('a'), Color.GREEN);
        nucleotideColors.put(Character.valueOf('C'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('c'), Color.BLUE);
        nucleotideColors.put(Character.valueOf('T'), Color.RED);
        nucleotideColors.put(Character.valueOf('t'), Color.RED);
        nucleotideColors.put(Character.valueOf('G'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('g'), new Color(242, 182, 65));
        nucleotideColors.put(Character.valueOf('N'), colorAlleleRef);
        nucleotideColors.put(Character.valueOf('n'), colorAlleleRef);
        nucleotideColors.put(Character.valueOf('.'), colorAlleleRef);
        nucleotideColors.put(null, Color.BLACK);
    }
}

