/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import org.broad.igv.ui.WaitCursorManager;
import org.broad.igv.ui.util.OkCancelDialog;
import org.broad.igv.ui.util.PropertyManager;
import org.broad.igv.ui.util.UIUtilities;

public class PropertyDialog
extends OkCancelDialog {
    public static final String CLICK_ITEM_TO_EDIT_TOOLTIP = "Click this item bring up its editor";
    private PropertyManager propertyManager;
    private GroupContentPane content;

    public PropertyDialog(PropertyManager propertyManager, LinkedHashMap<String, PreferenceDescriptor> labelTextToKey, Dialog parent, boolean modal) {
        super(parent, modal);
        this.initialize(propertyManager, labelTextToKey);
    }

    public PropertyDialog(PropertyManager propertyManager, LinkedHashMap<String, PreferenceDescriptor> labelTextToKey, Frame parent, boolean modal) {
        super(parent, modal);
        this.initialize(propertyManager, labelTextToKey);
    }

    private void initialize(PropertyManager propertyManager, LinkedHashMap<String, PreferenceDescriptor> labelTextToKey) {
        this.propertyManager = propertyManager;
        this.configureProperties(labelTextToKey);
        this.pack();
    }

    private void configureProperties(LinkedHashMap<String, PreferenceDescriptor> labelTextToKey) {
        JPanel contentPane = this.getDialogPanel();
        contentPane.setLayout(new BorderLayout());
        this.content = this.getContent(labelTextToKey);
        JScrollPane scrollPane = new JScrollPane(this.content);
        scrollPane.setHorizontalScrollBarPolicy(30);
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setBorder(null);
        contentPane.add(scrollPane);
    }

    private GroupContentPane getContent(Map<String, PreferenceDescriptor> labelTextToKey) {
        GroupContentPane contentPanel = new GroupContentPane(new SpringLayout());
        int verticalGroupSpacing = 1;
        int groupHeight = 25;
        int groupWidth = 600;
        int propertyPanelWidth = 600;
        int propertyPanelHeight = verticalGroupSpacing;
        Spring topSpring = Spring.constant(verticalGroupSpacing);
        verticalGroupSpacing = groupHeight + 10;
        Spring increment = Spring.constant(verticalGroupSpacing);
        Spring centerSpring = Spring.constant((propertyPanelWidth - groupWidth) / 2);
        Set<Map.Entry<String, PreferenceDescriptor>> set = labelTextToKey.entrySet();
        for (Map.Entry<String, PreferenceDescriptor> entry : set) {
            String labelText = entry.getKey();
            PreferenceDescriptor preferenceDescriptor = entry.getValue();
            String externalPreferenceKey = preferenceDescriptor.getValueKey();
            PreferenceType preferenceType = preferenceDescriptor.getType();
            String defaultType = null;
            if (preferenceType.equals((Object)PreferenceType.BOOLEAN)) {
                defaultType = "false";
            }
            String valueText = this.get(externalPreferenceKey, defaultType);
            Dimension groupSize = new Dimension(groupWidth, groupHeight);
            if (valueText != null && ((valueText = valueText.trim()).equalsIgnoreCase("true") || valueText.equalsIgnoreCase("false"))) {
                preferenceType = PreferenceType.BOOLEAN;
            }
            SpringLayout.Constraints constraints = new SpringLayout.Constraints();
            constraints.setConstraint("North", topSpring);
            constraints.setConstraint("West", centerSpring);
            Group group = new Group(externalPreferenceKey, labelText, valueText, groupSize, preferenceType, preferenceDescriptor.defaultValue);
            contentPanel.add((Component)group, constraints);
            topSpring = Spring.sum(topSpring, increment);
            propertyPanelHeight += verticalGroupSpacing;
        }
        Dimension contentSize = new Dimension(propertyPanelWidth, propertyPanelHeight + 10);
        contentPanel.setSize(contentSize);
        contentPanel.setPreferredSize(contentSize);
        contentPanel.setMinimumSize(contentSize);
        return contentPanel;
    }

    @Override
    public boolean okButtonClicked(ActionEvent event) {
        Set<Map.Entry<String, String>> set = this.content.getData().entrySet();
        for (Map.Entry<String, String> entry : set) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (value == null || value.trim().equals("")) {
                this.remove(key);
                continue;
            }
            this.put(key, value);
        }
        return true;
    }

    @Override
    public boolean cancelButtonClicked(ActionEvent event) {
        return true;
    }

    protected PropertyManager getPreferences() {
        return this.propertyManager;
    }

    protected void put(String key, String value) {
        this.propertyManager.put(key, value);
    }

    protected String get(String key, String defaultValue) {
        return this.propertyManager.get(key, defaultValue);
    }

    protected void remove(String key) {
        this.propertyManager.remove(key);
    }

    private static class Group
    extends JPanel {
        static final long serialVersionUID = 1198458423465L;
        private String externalPreferenceKey;
        private JLabel label;
        private JComponent value;
        private StringBuffer scratchBuffer = new StringBuffer();

        public Group() {
            this.setLayout(new FlowLayout(0));
        }

        public Group(String preferenceKey, String labelText, String valueText, Dimension size, PreferenceType valueType, Object defaultValue) {
            int labelHeight;
            int labelWidth = (int)((double)size.width / 2.5);
            int valueHeight = labelHeight = size.height;
            Dimension dimension = null;
            this.externalPreferenceKey = preferenceKey;
            dimension = new Dimension(labelWidth, labelHeight);
            this.label = new JLabel(labelText);
            this.label.setHorizontalAlignment(2);
            this.label.setSize(dimension);
            this.label.setPreferredSize(dimension);
            this.label.setMinimumSize(dimension);
            this.label.setOpaque(true);
            this.add(this.label);
            if (valueType.equals((Object)PreferenceType.BOOLEAN)) {
                valueText = valueText.toLowerCase();
                dimension = new Dimension(labelHeight, valueHeight);
                this.value = new JCheckBox();
                if (valueText == null && defaultValue != null) {
                    ((JCheckBox)this.value).setSelected(new Boolean((String)defaultValue));
                } else {
                    ((JCheckBox)this.value).setSelected(new Boolean(valueText));
                }
                this.value.setSize(dimension);
                this.value.setPreferredSize(dimension);
                this.value.setMinimumSize(dimension);
                this.add(this.value);
            } else if (valueType.equals((Object)PreferenceType.TEXT)) {
                int valueWidth = (int)((double)labelWidth * 1.4);
                dimension = new Dimension(valueWidth, valueHeight);
                this.value = valueText == null && defaultValue != null ? new JTextField((String)defaultValue) : new JTextField(valueText);
                ((JTextField)this.value).setHorizontalAlignment(2);
                this.value.setSize(dimension);
                this.value.setPreferredSize(dimension);
                this.value.setMinimumSize(dimension);
                this.add(this.value);
            } else if (valueType.equals((Object)PreferenceType.COLOR)) {
                int valueWidth = (int)((double)labelWidth * 0.125);
                dimension = new Dimension(valueWidth, valueHeight);
                this.value = new ColorPanel();
                if ((valueText == null || valueText.equals("")) && defaultValue != null) {
                    String[] RGB = ((String)defaultValue).split(",");
                    int redValue = new Integer(RGB[0]);
                    int greenValue = new Integer(RGB[1]);
                    int blueValue = new Integer(RGB[2]);
                    Color color = new Color(redValue, greenValue, blueValue);
                    this.value.setBackground(color);
                } else {
                    String[] RGB = valueText.split(",");
                    int redValue = new Integer(RGB[0]);
                    int greenValue = new Integer(RGB[1]);
                    int blueValue = new Integer(RGB[2]);
                    Color color = new Color(redValue, greenValue, blueValue);
                    this.value.setBackground(color);
                }
                this.value.setSize(dimension);
                this.value.setPreferredSize(dimension);
                this.value.setMinimumSize(dimension);
                this.add(this.value);
            }
            this.setSize(size);
        }

        public String getExternalPreferenceKey() {
            return this.externalPreferenceKey;
        }

        public String getKey() {
            return this.label.getText();
        }

        public String getValue() {
            if (this.value instanceof JTextField) {
                return ((JTextField)this.value).getText();
            }
            if (this.value instanceof JCheckBox) {
                boolean isSelected = ((JCheckBox)this.value).isSelected();
                return isSelected ? "true" : "false";
            }
            if (this.value instanceof ColorPanel) {
                Color selectedColor = ((ColorPanel)this.value).getBackground();
                if (selectedColor != null) {
                    this.scratchBuffer.delete(0, this.scratchBuffer.length());
                    int red = selectedColor.getRed();
                    int green = selectedColor.getGreen();
                    int blue = selectedColor.getBlue();
                    this.scratchBuffer.append(red);
                    this.scratchBuffer.append(",");
                    this.scratchBuffer.append(green);
                    this.scratchBuffer.append(",");
                    this.scratchBuffer.append(blue);
                }
                return this.scratchBuffer.toString();
            }
            return null;
        }

        @Override
        public Component add(Component component) {
            if (component instanceof JLabel) {
                super.add(component);
            } else if (component instanceof JTextField) {
                super.add(component);
            } else {
                super.add(component);
            }
            return component;
        }

        @Override
        public Component add(Component component, int arg) {
            return component;
        }

        @Override
        public Component add(String arg0, Component component) {
            return component;
        }

        @Override
        public void add(Component component, Object arg) {
        }

        @Override
        public void add(Component component, Object arg, int arg2) {
        }
    }

    private static class GroupContentPane
    extends JPanel {
        static final long serialVersionUID = 1198458423465L;

        public GroupContentPane(LayoutManager layoutManager) {
            super(layoutManager);
        }

        public Map<String, String> getData() {
            Component[] components;
            LinkedHashMap<String, String> keyAndValue = new LinkedHashMap<String, String>();
            for (Component component : components = this.getComponents()) {
                Group group = (Group)component;
                keyAndValue.put(group.getExternalPreferenceKey(), group.getValue());
            }
            return keyAndValue;
        }
    }

    private static class ColorPanel
    extends JPanel {
        private WaitCursorManager.CursorToken token;

        public ColorPanel() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e2) {
                    ColorPanel.this.setCursor(Cursor.getPredefinedCursor(12));
                }

                @Override
                public void mouseExited(MouseEvent e2) {
                }

                @Override
                public void mouseClicked(MouseEvent e2) {
                    Color color = UIUtilities.showColorChooserDialog("", null);
                    if (color != null) {
                        JPanel panel = (JPanel)e2.getSource();
                        panel.setBackground(color);
                        panel.repaint();
                    }
                }
            });
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    ColorPanel.this.setToolTipText(PropertyDialog.CLICK_ITEM_TO_EDIT_TOOLTIP);
                }
            });
        }
    }

    public static class PreferenceDescriptor {
        private PreferenceType valueType = PreferenceType.TEXT;
        private String valueKey;
        private Object defaultValue;

        public PreferenceDescriptor(String valueKey, PreferenceType valueType) {
            this(valueKey, valueType, null);
        }

        public PreferenceDescriptor(String valueKey, PreferenceType valueType, Object defaultValue) {
            this.valueKey = valueKey;
            this.valueType = valueType;
            this.defaultValue = defaultValue;
        }

        PreferenceType getType() {
            return this.valueType;
        }

        String getValueKey() {
            return this.valueKey;
        }
    }

    public static enum PreferenceType {
        TEXT,
        BOOLEAN,
        COLOR;

    }
}

