/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.event.MouseInputAdapter;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.IconFactory;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;

public class ZoomSliderPanel
extends JPanel {
    static Color TICK_GRAY = new Color(90, 90, 90);
    static Color TICK_BLUE = new Color(25, 50, 200);
    public static ZoomSliderPanel theInstance;
    Image slider;
    Image zoomPlus;
    Image zoomMinus;
    Rectangle zoomPlusRect;
    Rectangle zoomMinusRect;
    Rectangle[] zoomLevelRects;
    int numZoomLevels = 25;
    private static final Color TRANSPARENT_GRAY;
    int toolZoom = -1;

    public ZoomSliderPanel() {
        theInstance = this;
        this.slider = IconFactory.getInstance().getIcon(IconFactory.IconID.SLIDER).getImage();
        this.zoomPlus = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_PLUS).getImage();
        this.zoomMinus = IconFactory.getInstance().getIcon(IconFactory.IconID.ZOOM_MINUS).getImage();
        this.zoomLevelRects = new Rectangle[this.numZoomLevels];
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.init();
    }

    private void updateTickCount() {
        int tmp = this.getViewContext().getMaxZoom() + 1;
        if (tmp != this.numZoomLevels) {
            this.numZoomLevels = tmp;
            this.zoomLevelRects = new Rectangle[this.numZoomLevels];
        }
    }

    @Override
    protected void paintComponent(Graphics g2) {
        super.paintComponent(g2);
        this.updateTickCount();
        this.paintHorizontal(g2);
    }

    protected void paintHorizontal(Graphics g2) {
        int zoom;
        Graphics2D transGraphics = (Graphics2D)g2.create();
        transGraphics.setColor(TRANSPARENT_GRAY);
        int buttonWidth = this.zoomPlus.getWidth(null);
        int buttonHeight = this.zoomPlus.getHeight(null);
        Insets insets = this.getInsets();
        int panelWidth = this.getWidth() - insets.left - insets.right;
        int panelHeight = this.getHeight() - insets.top - insets.bottom;
        boolean enabled = this.isEnabled();
        g2.setColor(enabled ? Color.BLACK : Color.LIGHT_GRAY);
        double x = insets.left;
        double xStep = (double)(panelWidth - 2 * buttonWidth - 10) / (double)this.numZoomLevels;
        int y = insets.top + (panelHeight - buttonHeight) / 2;
        g2.drawImage(this.zoomMinus, (int)x, y, null);
        this.zoomMinusRect = new Rectangle((int)x, y, buttonWidth, buttonHeight);
        if (!this.isEnabled()) {
            transGraphics.fill(this.zoomMinusRect);
        }
        int lastX = (int)((x += (double)(5 + buttonWidth)) - xStep);
        for (int i2 = 0; i2 < this.numZoomLevels; ++i2) {
            Rectangle zoomRect = new Rectangle((int)x, y, (int)(x - (double)lastX), buttonHeight);
            int xLine = (int)(x + xStep / 2.0);
            g2.drawLine(xLine, y + 3, xLine, y + buttonHeight - 4);
            this.zoomLevelRects[i2] = zoomRect;
            lastX = (int)x;
            x += xStep;
        }
        y = insets.top + panelHeight / 2 - 1;
        y = insets.top + (panelHeight - buttonHeight) / 2;
        g2.drawImage(this.zoomPlus, (int)(x += 5.0), y, null);
        this.zoomPlusRect = new Rectangle((int)x, y, buttonWidth, buttonWidth);
        if (!this.isEnabled()) {
            transGraphics.fill(this.zoomPlusRect);
        }
        int n2 = zoom = this.toolZoom >= 0 ? this.toolZoom : this.getViewContext().getAdjustedZoom();
        if (enabled && zoom >= 0 && zoom < this.zoomLevelRects.length) {
            Rectangle rect = this.zoomLevelRects[zoom];
            g2.setColor(TICK_BLUE);
            g2.fill3DRect((int)(rect.getX() + rect.getWidth() / 2.0) - 3, (int)rect.getY(), 6, (int)rect.getHeight(), true);
        }
        transGraphics.dispose();
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
    }

    void setZoom(MouseEvent e2) {
        if (this.zoomPlusRect.contains(e2.getX(), e2.getY())) {
            ++this.toolZoom;
        } else if (this.zoomMinusRect.contains(e2.getX(), e2.getY())) {
            --this.toolZoom;
        } else {
            for (int i2 = 0; i2 < this.zoomLevelRects.length; ++i2) {
                Rectangle rect = this.zoomLevelRects[i2];
                if (!rect.contains(e2.getX(), e2.getY())) continue;
                this.toolZoom = i2;
            }
        }
    }

    private ReferenceFrame getViewContext() {
        return FrameManager.getDefaultFrame();
    }

    private void init() {
        MouseInputAdapter mouseAdapter = new MouseInputAdapter(){
            int lastMousePressX = 0;

            @Override
            public void mouseExited(MouseEvent e2) {
            }

            @Override
            public void mouseClicked(MouseEvent e2) {
            }

            @Override
            public void mouseMoved(MouseEvent e2) {
            }

            @Override
            public void mousePressed(MouseEvent e2) {
                ZoomSliderPanel.this.toolZoom = Math.max(0, ZoomSliderPanel.this.getViewContext().getAdjustedZoom());
            }

            @Override
            public void mouseReleased(MouseEvent e2) {
                ZoomSliderPanel.this.setZoom(e2);
                ZoomSliderPanel.this.repaint();
                NamedRunnable runnable = new NamedRunnable(){

                    @Override
                    public void run() {
                        ZoomSliderPanel.this.getViewContext().zoomAndCenterAdjusted(ZoomSliderPanel.this.toolZoom);
                        ZoomSliderPanel.this.toolZoom = -1;
                    }

                    @Override
                    public String getName() {
                        return "Zoom to: " + ZoomSliderPanel.this.toolZoom;
                    }
                };
                LongRunningTask.submit(runnable);
            }

            @Override
            public void mouseDragged(MouseEvent e2) {
                ZoomSliderPanel.this.setZoom(e2);
                ZoomSliderPanel.this.repaint();
            }
        };
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseListener(mouseAdapter);
    }

    static {
        TRANSPARENT_GRAY = new Color(200, 200, 200, 150);
    }
}

