/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.AminoAcid;
import org.broad.igv.feature.AminoAcidSequence;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.Strand;
import org.broad.igv.renderer.FeatureRenderer;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.FontManager;
import org.broad.igv.util.ColorUtilities;
import org.broad.igv.vcf.VCFRenderer;

public class GenotypeRenderer
extends FeatureRenderer {
    static final Color AA_COLOR_1 = new Color(92, 92, 164);
    static final Color AA_COLOR_2 = new Color(12, 12, 120);
    static final Color DULL_BLUE = new Color(0, 0, 200);
    static final Color DULL_RED = new Color(200, 0, 0);
    public static final int NON_CODING_HEIGHT = 8;
    private static Logger log = Logger.getLogger(IGVFeatureRenderer.class);
    protected boolean drawBoundary = false;
    float viewLimitMin = Float.NaN;
    float viewLimitMax = Float.NaN;
    protected double lastFeatureLineMaxY = 0.0;
    protected double lastFeatureBoundsMaxY = 0.0;
    protected double lastRegionMaxY = 0.0;
    protected static final int NORMAL_STRAND_Y_OFFSET = 14;
    protected static final int ARROW_SPACING = 30;
    protected static final int NO_STRAND_THICKNESS = 2;
    protected static final int REGION_STRAND_THICKNESS = 4;
    final int BLOCK_HEIGHT = 14;
    final int THIN_BLOCK_HEIGHT = 6;
    private float[] colorComps = new float[3];

    @Override
    public void render(List<IGVFeature> featureList, RenderContext context, Rectangle trackRectangle, Track track) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        this.lastFeatureLineMaxY = 0.0;
        this.lastFeatureBoundsMaxY = 0.0;
        this.lastRegionMaxY = 0.0;
        if (featureList != null && featureList.size() > 0) {
            Font font = FontManager.getFont(track.getFontSize());
            Graphics2D fontGraphics = (Graphics2D)context.getGraphic2DForColor(Color.BLACK).create();
            fontGraphics.setFont(font);
            double trackRectangleX = trackRectangle.getX();
            double trackRectangleMaxX = trackRectangle.getMaxX();
            int lastFeatureEndedAtPixelX = -9999;
            int lastPixelEnd = -1;
            int occludedCount = 0;
            int maxOcclusions = 2;
            IGVFeature[] featureArray = featureList.toArray(new IGVFeature[featureList.size()]);
            for (int i2 = 0; i2 < featureArray.length; ++i2) {
                int pixelStart;
                IGVFeature feature = featureArray[i2];
                double virtualPixelStart = Math.round(((double)feature.getStart() - origin) / locScale);
                double virtualPixelEnd = Math.round(((double)feature.getEnd() - origin) / locScale);
                if (!(virtualPixelEnd >= trackRectangleX) || !(virtualPixelStart <= trackRectangleMaxX)) continue;
                int pixelEnd = (int)Math.min(trackRectangleMaxX, virtualPixelEnd);
                if (pixelEnd - (pixelStart = (int)Math.max(trackRectangleX, virtualPixelStart)) < 3) {
                    int dx = 3 - (pixelEnd - pixelStart);
                    pixelStart -= dx / 2;
                    pixelEnd += dx - dx / 2;
                }
                if (pixelEnd <= lastPixelEnd) {
                    if (occludedCount >= maxOcclusions) continue;
                    ++occludedCount;
                } else {
                    occludedCount = 0;
                    lastPixelEnd = pixelEnd;
                }
                Color color = feature.getName().equals("HET") ? VCFRenderer.colorHet : VCFRenderer.colorHomVar;
                Graphics2D g2D = context.getGraphic2DForColor(color);
                g2D.fillRect(pixelStart, trackRectangle.y, pixelEnd - pixelStart, trackRectangle.height);
            }
            if (this.drawBoundary) {
                Graphics2D g2D = context.getGraphic2DForColor(Color.LIGHT_GRAY);
                g2D.drawLine((int)trackRectangleX, trackRectangle.y + trackRectangle.height - 1, (int)trackRectangleMaxX, trackRectangle.y + trackRectangle.height - 1);
            }
        }
    }

    private final void drawFeatureBlock(int pixelStart, int pixelEnd, int pixelThickStart, int pixelThickEnd, Rectangle trackRectangle, Strand strand, boolean hasRegions, Graphics2D g2) {
        Graphics2D g2D = (Graphics2D)g2.create();
        if (!hasRegions) {
            int yOffset = trackRectangle.y + 7;
            if (pixelThickStart > pixelStart) {
                g2D.fillRect(pixelStart, yOffset - 3, Math.max(1, pixelThickStart - pixelStart), 6);
            }
            if (pixelThickEnd > 0 && pixelThickEnd < pixelEnd) {
                g2D.fillRect(pixelThickEnd, yOffset - 3, Math.max(1, pixelEnd - pixelThickEnd), 6);
            }
            g2D.fillRect(pixelThickStart, yOffset - 5, Math.max(1, pixelThickEnd - pixelThickStart), 10);
            this.lastFeatureLineMaxY = yOffset + 14 - 4;
        } else {
            int yOffset = trackRectangle.y + 7;
            float lineThickness = ((BasicStroke)g2.getStroke()).getLineWidth();
            if (strand == null) {
                BasicStroke stroke = new BasicStroke(lineThickness *= 2.0f);
                g2D.setStroke(stroke);
            }
            g2D.drawLine(pixelStart, yOffset, pixelEnd, yOffset);
            this.lastFeatureLineMaxY = (float)yOffset + lineThickness;
        }
        g2D.dispose();
    }

    private void drawVerticalFeatureBounds(int pixelStart, int pixelEnd, int yOffset, Graphics2D g2D) {
        if (pixelEnd == pixelStart) {
            int yStart = yOffset - 7;
            g2D.drawLine(pixelStart, yStart, pixelStart, yStart + 14);
        } else {
            g2D.fillRect(pixelStart, yOffset - 7, pixelEnd - pixelStart, 14);
        }
        this.lastFeatureBoundsMaxY = yOffset + 7;
    }

    protected void drawExons(IGVFeature gene, int yOffset, RenderContext context, Graphics2D g2D, Rectangle trackRectangle) {
        Graphics exonNumberGraphics = g2D.create();
        exonNumberGraphics.setColor(Color.BLACK);
        exonNumberGraphics.setFont(FontManager.getFont(1, 8));
        double theOrigin = context.getOrigin();
        double locationScale = context.getScale();
        Graphics2D fontGraphics = context.getGraphic2DForColor(Color.WHITE);
        for (Exon exon : gene.getExons()) {
            int pStart = this.getPixelFromChromosomeLocation(exon.getChr(), exon.getStart(), theOrigin, locationScale);
            int pEnd = this.getPixelFromChromosomeLocation(exon.getChr(), exon.getEnd(), theOrigin, locationScale);
            if ((double)pEnd >= trackRectangle.getX() && (double)pStart <= trackRectangle.getMaxX()) {
                int pClippedWidth;
                int pClippedEnd;
                int pCdStart = Math.min(pEnd, Math.max(pStart, this.getPixelFromChromosomeLocation(exon.getChr(), exon.getCdStart(), theOrigin, locationScale)));
                int pCdEnd = Math.max(pStart, Math.min(pEnd, this.getPixelFromChromosomeLocation(exon.getChr(), exon.getCdEnd(), theOrigin, locationScale)));
                if (exon.isUTR()) {
                    int pClippedStart = (int)Math.max((double)pStart, trackRectangle.getX());
                    pClippedEnd = (int)Math.min((double)pEnd, trackRectangle.getMaxX());
                    pClippedWidth = pClippedEnd - pClippedStart;
                    g2D.fillRect(pClippedStart, yOffset - 4, pClippedWidth, 8);
                } else {
                    if (pCdStart > pStart) {
                        int pClippedStart = (int)Math.max((double)pStart, trackRectangle.getX());
                        pClippedEnd = (int)Math.min((double)pCdStart, trackRectangle.getMaxX());
                        pClippedWidth = pClippedEnd - pClippedStart;
                        g2D.fillRect(pClippedStart, yOffset - 4, pClippedWidth, 8);
                        pStart = pCdStart;
                    }
                    if (pCdEnd < pEnd) {
                        int pClippedStart = (int)Math.max((double)pCdEnd, trackRectangle.getX());
                        pClippedEnd = (int)Math.min((double)pEnd, trackRectangle.getMaxX());
                        pClippedWidth = pClippedEnd - pClippedStart;
                        g2D.fillRect(pClippedStart, yOffset - 4, pClippedWidth, 8);
                        pEnd = pCdEnd;
                    }
                    if (exon.getCdStart() < exon.getEnd() && exon.getCdEnd() > exon.getStart()) {
                        int pClippedStart = (int)Math.max((double)pStart, trackRectangle.getX());
                        pClippedEnd = (int)Math.min((double)pEnd, trackRectangle.getMaxX());
                        pClippedWidth = Math.max(2, pClippedEnd - pClippedStart);
                        g2D.fillRect(pClippedStart, yOffset - 7, pClippedWidth, 14);
                    }
                }
                Graphics2D arrowGraphics = context.getGraphic2DForColor(Color.white);
                this.drawStrandArrows(gene, pStart + 15, pEnd, yOffset, arrowGraphics);
                if (locationScale < 0.25) {
                    this.labelAminoAcids(pStart, fontGraphics, theOrigin, context, gene, locationScale, yOffset, exon, trackRectangle);
                }
            }
            this.lastRegionMaxY = yOffset - 7 + 14;
        }
    }

    protected void drawStrandArrows(IGVFeature feature, int pixelStart, int pixelEnd, int yOffset, Graphics2D g2D) {
        block4: {
            int vEnd;
            int vStart;
            block3: {
                if (pixelEnd - pixelStart < 6) {
                    return;
                }
                vStart = 0;
                vEnd = 10000;
                if (!feature.getStrand().equals((Object)Strand.POSITIVE)) break block3;
                for (int i2 = pixelEnd; i2 > pixelStart && i2 >= vStart; i2 -= 30) {
                    if (i2 >= vEnd) continue;
                    g2D.drawLine(i2, yOffset, i2 - 3, yOffset + 3);
                    g2D.drawLine(i2, yOffset, i2 - 3, yOffset - 3);
                }
                break block4;
            }
            if (!feature.getStrand().equals((Object)Strand.NEGATIVE)) break block4;
            g2D.drawLine(pixelEnd, yOffset + 2, pixelEnd, yOffset - 2);
            for (int i3 = pixelStart; i3 < pixelEnd && i3 <= vEnd; i3 += 30) {
                if (i3 <= vStart || i3 >= vEnd) continue;
                g2D.drawLine(i3, yOffset, i3 + 3, yOffset + 3);
                g2D.drawLine(i3, yOffset, i3 + 3, yOffset - 3);
            }
        }
    }

    private final int drawFeatureName(IGVFeature feature, int pixelStart, int pixelEnd, int lastFeatureEndedAtPixelX, Graphics2D g2D, int textBaselineY) {
        String name = feature.getName();
        if (name == null) {
            return lastFeatureEndedAtPixelX;
        }
        FontMetrics fm = g2D.getFontMetrics();
        int fontSize = fm.getFont().getSize();
        int nameWidth = fm.stringWidth(name);
        int nameStart = (pixelStart + pixelEnd - nameWidth) / 2;
        if (nameStart > lastFeatureEndedAtPixelX + fontSize) {
            g2D.drawString(name, nameStart, textBaselineY);
            lastFeatureEndedAtPixelX = nameStart + nameWidth;
        }
        return lastFeatureEndedAtPixelX;
    }

    public void labelAminoAcids(int pStart, Graphics2D fontGraphics, double theOrigin, RenderContext context, IGVFeature gene, double locationScale, int yOffset, Exon exon, Rectangle trackRectangle) {
        AminoAcidSequence aaSequence = exon.getAminoAcidSequence();
        if (aaSequence != null && aaSequence.hasNonNullSequence()) {
            Graphics2D bgGraphics;
            boolean odd;
            Rectangle aaRect = new Rectangle(pStart, yOffset - 7, 1, 14);
            int aaSeqStartPosition = aaSequence.getStartPosition();
            int firstFullAcidIndex = (int)Math.floor((aaSeqStartPosition - exon.getReadingShift()) / 3);
            boolean bl = odd = firstFullAcidIndex % 2 == 1;
            if (aaSeqStartPosition > exon.getStart()) {
                int cdStart = Math.max(exon.getCdStart(), exon.getStart());
                aaRect.x = this.getPixelFromChromosomeLocation(exon.getChr(), cdStart, theOrigin, locationScale);
                aaRect.width = this.getPixelFromChromosomeLocation(exon.getChr(), aaSeqStartPosition, theOrigin, locationScale) - aaRect.x;
                if (trackRectangle.intersects(aaRect)) {
                    bgGraphics = context.getGraphic2DForColor(!odd ? AA_COLOR_1 : AA_COLOR_2);
                    bgGraphics.fill(aaRect);
                }
            }
            for (AminoAcid acid : aaSequence.getSequence()) {
                if (acid == null) continue;
                int px = this.getPixelFromChromosomeLocation(exon.getChr(), aaSeqStartPosition, theOrigin, locationScale);
                int px2 = this.getPixelFromChromosomeLocation(exon.getChr(), aaSeqStartPosition + 3, theOrigin, locationScale);
                if ((double)px <= trackRectangle.getMaxX() && (double)px2 >= trackRectangle.getX()) {
                    aaRect.x = px;
                    aaRect.width = px2 - px;
                    Graphics2D bgGraphics2 = context.getGraphic2DForColor(odd ? AA_COLOR_1 : AA_COLOR_2);
                    if (acid.getSymbol() == 'M' && (gene.getStrand() == Strand.POSITIVE && aaSeqStartPosition == exon.getCdStart() || gene.getStrand() == Strand.NEGATIVE && aaSeqStartPosition == exon.getCdEnd() - 3)) {
                        bgGraphics2 = context.getGraphic2DForColor(Color.green);
                    } else if (acid.getSymbol() == 'X') {
                        bgGraphics2 = context.getGraphic2DForColor(Color.RED);
                    }
                    bgGraphics2.fill(aaRect);
                    String tmp = new String(new char[]{acid.getSymbol()});
                    GraphicUtils.drawCenteredText(tmp, aaRect, fontGraphics);
                }
                odd = !odd;
                aaSeqStartPosition += 3;
            }
            if (aaSeqStartPosition < exon.getEnd()) {
                int cdEnd = Math.min(exon.getCdEnd(), exon.getEnd());
                aaRect.x = this.getPixelFromChromosomeLocation(exon.getChr(), aaSeqStartPosition, theOrigin, locationScale);
                aaRect.width = this.getPixelFromChromosomeLocation(exon.getChr(), cdEnd, theOrigin, locationScale) - aaRect.x;
                bgGraphics = context.getGraphic2DForColor(odd ? AA_COLOR_1 : AA_COLOR_2);
                odd = !odd;
                bgGraphics.fill(aaRect);
            }
        }
    }

    public String getDisplayName() {
        return "Basic Feature";
    }

    protected Color getFeatureColor(IGVFeature feature, Track track) {
        Color color = null;
        if (track.isItemRGB()) {
            color = feature.getColor();
        }
        if (color == null) {
            color = track.getTrackType() == TrackType.CNV ? (feature.getName().equals("gain") ? DULL_RED : DULL_BLUE) : track.getColor();
        }
        if (track.isUseScore()) {
            float min = this.getViewLimitMin(track);
            float max = this.getViewLimitMax(track);
            float score = feature.getScore();
            float alpha = Float.isNaN(score) ? 1.0f : this.getAlpha(min, max, feature.getScore());
            color.getColorComponents(this.colorComps);
            color = ColorUtilities.getCompositeColor(this.colorComps, alpha);
        }
        return color;
    }

    float getViewLimitMin(Track track) {
        if (Float.isNaN(this.viewLimitMin)) {
            this.viewLimitMin = Float.isNaN(track.getViewLimitMin()) ? 0.0f : track.getViewLimitMin();
        }
        return this.viewLimitMin;
    }

    float getViewLimitMax(Track track) {
        if (Float.isNaN(this.viewLimitMax)) {
            this.viewLimitMax = Float.isNaN(track.getViewLimitMax()) ? 1000.0f : track.getViewLimitMax();
        }
        return this.viewLimitMax;
    }

    private float getAlpha(float minRange, float maxRange, float value) {
        float binWidth = (maxRange - minRange) / 9.0f;
        int binNumber = (int)((value - minRange) / binWidth);
        return Math.min(1.0f, 0.2f + (float)binNumber * 0.8f / 9.0f);
    }

    private int getLastLargestMaxY() {
        double largestY = Math.max(this.lastFeatureLineMaxY, Math.max(this.lastFeatureBoundsMaxY, this.lastRegionMaxY));
        return (int)Math.ceil(largestY);
    }

    protected int getPixelFromChromosomeLocation(String chr, int chromosomeLocation, double origin, double locationScale) {
        return (int)Math.round(((double)chromosomeLocation - origin) / locationScale);
    }
}

