/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.util.HashMap;
import org.apache.log4j.Logger;
import org.broad.igv.data.AbstractDataSource;
import org.broad.igv.data.DataTile;
import org.broad.igv.data.Dataset;
import org.broad.igv.data.GenomeSummaryData;
import org.broad.igv.data.IGVDataset;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackType;

public class DatasetDataSource
extends AbstractDataSource {
    private Logger log = Logger.getLogger(DatasetDataSource.class);
    String trackId;
    Dataset dataset;
    GenomeSummaryData genomeSummaryData;

    public DatasetDataSource(String trackId, Dataset dataset, Genome genome) {
        super(genome);
        this.trackId = trackId;
        this.dataset = dataset;
        if (genome.getHomeChromosome().equals("All")) {
            if (dataset instanceof IGVDataset) {
                this.genomeSummaryData = ((IGVDataset)dataset).getGenomeSummary();
            } else {
                this.genomeSummaryData = new GenomeSummaryData(genome, new String[]{trackId});
                for (Chromosome chr : genome.getChromosomes()) {
                    int[] startLocations = dataset.getStartLocations(chr.getName());
                    if (chr.getName().equals("All") || startLocations == null || startLocations.length <= 0) continue;
                    HashMap<String, float[]> dMap = new HashMap<String, float[]>();
                    dMap.put(trackId, dataset.getData(trackId, chr.getName()));
                    this.genomeSummaryData.addData(chr.getName(), startLocations, dMap);
                }
            }
        }
    }

    @Override
    protected int getNumZoomLevels(String chr) {
        return 0;
    }

    @Override
    protected DataTile getRawData(String chr, int startLocation, int endLocation) {
        if (chr.equals("All") && this.genomeSummaryData != null) {
            int[] startLocs = this.genomeSummaryData.getLocations();
            int[] endLocs = null;
            float[] data = this.genomeSummaryData.getData(this.trackId);
            return new DataTile(startLocs, endLocs, data, null);
        }
        int[] startLocs = this.dataset.getStartLocations(chr);
        int[] endLocs = this.dataset.getEndLocations(chr);
        float[] data = this.dataset.getData(this.trackId, chr);
        String[] features = this.dataset.getFeatureNames(chr);
        if (startLocs == null || data == null || data.length == 0) {
            return null;
        }
        return new DataTile(startLocs, endLocs, data, features);
    }

    @Override
    public TrackType getTrackType() {
        try {
            return this.dataset.getType();
        }
        catch (Exception exception) {
            return TrackType.OTHER;
        }
    }

    @Override
    public boolean isLogNormalized() {
        return this.dataset.isLogNormalized();
    }

    @Override
    public double getDataMax() {
        return this.dataset.getDataMax();
    }

    @Override
    public double getDataMin() {
        return this.dataset.getDataMin();
    }

    @Override
    public int getLongestFeature(String chr) {
        return this.dataset.getLongestFeature(chr);
    }
}

