/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.FieldKey;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.ImmutableFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;

public class FieldDictionary {
    private transient Map keyedByFieldNameCache;
    private transient Map keyedByFieldKeyCache;
    private final FieldKeySorter sorter;
    static /* synthetic */ Class class$java$lang$Object;

    public FieldDictionary() {
        this(new ImmutableFieldKeySorter());
    }

    public FieldDictionary(FieldKeySorter sorter) {
        this.sorter = sorter;
        this.init();
    }

    private void init() {
        this.keyedByFieldNameCache = new WeakHashMap();
        this.keyedByFieldKeyCache = new WeakHashMap();
        this.keyedByFieldNameCache.put(class$java$lang$Object == null ? (class$java$lang$Object = FieldDictionary.class$("java.lang.Object")) : class$java$lang$Object, Collections.EMPTY_MAP);
        this.keyedByFieldKeyCache.put(class$java$lang$Object == null ? (class$java$lang$Object = FieldDictionary.class$("java.lang.Object")) : class$java$lang$Object, Collections.EMPTY_MAP);
    }

    public Iterator serializableFieldsFor(Class cls) {
        return this.fieldsFor(cls);
    }

    public Iterator fieldsFor(Class cls) {
        return this.buildMap(cls, true).values().iterator();
    }

    public Field field(Class cls, String name, Class definedIn) {
        Map fields = this.buildMap(cls, definedIn != null);
        Field field = (Field)fields.get(definedIn != null ? new FieldKey(name, definedIn, 0) : name);
        if (field == null) {
            throw new ObjectAccessException("No such field " + cls.getName() + "." + name);
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildMap(Class type, boolean tupleKeyed) {
        Class cls = type;
        FieldDictionary fieldDictionary = this;
        synchronized (fieldDictionary) {
            if (!this.keyedByFieldNameCache.containsKey(type)) {
                ArrayList<Class> superClasses = new ArrayList<Class>();
                while (!(class$java$lang$Object == null ? FieldDictionary.class$("java.lang.Object") : class$java$lang$Object).equals(cls)) {
                    superClasses.add(0, cls);
                    cls = cls.getSuperclass();
                }
                Map lastKeyedByFieldName = Collections.EMPTY_MAP;
                Map lastKeyedByFieldKey = Collections.EMPTY_MAP;
                Iterator iter = superClasses.iterator();
                while (iter.hasNext()) {
                    cls = (Class)iter.next();
                    if (!this.keyedByFieldNameCache.containsKey(cls)) {
                        int i2;
                        HashMap<String, Field> keyedByFieldName = new HashMap<String, Field>(lastKeyedByFieldName);
                        OrderRetainingMap keyedByFieldKey = new OrderRetainingMap(lastKeyedByFieldKey);
                        Field[] fields = cls.getDeclaredFields();
                        if (JVM.reverseFieldDefinition()) {
                            i2 = fields.length >> 1;
                            while (i2-- > 0) {
                                int idx = fields.length - i2 - 1;
                                Field field = fields[i2];
                                fields[i2] = fields[idx];
                                fields[idx] = field;
                            }
                        }
                        for (i2 = 0; i2 < fields.length; ++i2) {
                            Field field = fields[i2];
                            FieldKey fieldKey = new FieldKey(field.getName(), field.getDeclaringClass(), i2);
                            field.setAccessible(true);
                            Field existent = (Field)keyedByFieldName.get(field.getName());
                            if (existent == null || (existent.getModifiers() & 8) != 0 || existent != null && (field.getModifiers() & 8) == 0) {
                                keyedByFieldName.put(field.getName(), field);
                            }
                            keyedByFieldKey.put(fieldKey, field);
                        }
                        this.keyedByFieldNameCache.put(cls, keyedByFieldName);
                        this.keyedByFieldKeyCache.put(cls, this.sorter.sort(type, keyedByFieldKey));
                    }
                    lastKeyedByFieldName = (Map)this.keyedByFieldNameCache.get(cls);
                    lastKeyedByFieldKey = (Map)this.keyedByFieldKeyCache.get(cls);
                }
            }
        }
        return (Map)(tupleKeyed ? this.keyedByFieldKeyCache.get(type) : this.keyedByFieldNameCache.get(type));
    }

    protected Object readResolve() {
        this.init();
        return this;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

