/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.vcf;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import org.apache.log4j.Logger;
import org.broad.igv.vcf.VCFTrack;
import org.broad.tribble.util.variantcontext.VariantContext;

public class VariantInfoDialog
extends JDialog {
    private JPanel contentPane;
    private JButton okButton;
    private JButton cancelButton;
    private JTextArea variantText;
    private JLabel variantLabel;
    private static Logger logger = Logger.getLogger(VariantInfoDialog.class);
    VCFTrack track;
    VariantContext variant;

    public VariantInfoDialog(VCFTrack track, VariantContext variant) {
        this.setContentPane(this.contentPane);
        this.setModal(true);
        this.getRootPane().setDefaultButton(this.okButton);
        this.track = track;
        this.variant = variant;
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VariantInfoDialog.this.onOK();
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VariantInfoDialog.this.onCancel();
            }
        });
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e2) {
                VariantInfoDialog.this.onCancel();
            }
        });
        this.contentPane.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                VariantInfoDialog.this.onCancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 1);
        this.initComponents();
    }

    private void initComponents() {
        String variantInfo = this.track.getVariantInfo(this.variant);
        this.pack();
    }

    private void onOK() {
        this.dispose();
    }

    private void onCancel() {
        this.dispose();
    }
}

