/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.ftp;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.log4j.Logger;

public class FTPReply {
    private static Logger log = Logger.getLogger(FTPReply.class);
    String reply;
    int code;

    public FTPReply(BufferedReader inputStream) throws IOException {
        do {
            this.reply = inputStream.readLine();
            log.debug("RESPONSE:" + this.reply);
        } while (this.reply != null && (!Character.isDigit(this.reply.charAt(0)) || !Character.isDigit(this.reply.charAt(1)) || !Character.isDigit(this.reply.charAt(2)) || this.reply.charAt(3) != ' '));
        this.code = this.reply == null ? -1 : Integer.parseInt(this.reply.substring(0, 3));
    }

    int getCode() throws IOException {
        return this.code;
    }

    public String getReplyString() throws IOException {
        return this.reply;
    }

    public boolean isSuccess() {
        return this.isPositiveCompletion() || this.isPositiveIntermediate();
    }

    public boolean isPositiveCompletion() {
        return this.code >= 200 && this.code < 300;
    }

    public boolean isPositiveIntermediate() {
        return this.code >= 300 && this.code < 400;
    }
}

