/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.panel;

import java.text.NumberFormat;
import java.util.Locale;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.DragEventManager;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.RegionNavigatorDialog;
import org.broad.igv.ui.util.MessageUtils;

public class ReferenceFrame {
    private static Logger log = Logger.getLogger(ReferenceFrame.class);
    private static NumberFormat NUMBER_FORMAT = NumberFormat.getInstance(Locale.US);
    private static double minimumScale = Double.MAX_VALUE;
    String name;
    int pixelX;
    private int widthInPixels;
    public static int binsPerTile = 700;
    private String chrName = "chrAll";
    private int minZoom;
    private int zoom = this.minZoom = 0;
    public static int maxZoom = 23;
    private int nTiles = 1;
    private double maxPixel;
    private double origin = 0.0;
    private double locationScale;
    private double minScale = 0.07142857142857142;
    private boolean locationScaleValid = false;
    private Locus locus;
    int setEnd = 0;

    public ReferenceFrame(String name) {
        this.name = name;
        Genome genome = this.getGenome();
        this.chrName = genome == null ? "" : genome.getHomeChromosome();
    }

    public void setBounds(int x, int w) {
        this.pixelX = x;
        if (w != this.widthInPixels) {
            this.widthInPixels = w;
            this.computeLocationScale();
        }
    }

    public int getMidpoint() {
        return this.pixelX + this.widthInPixels / 2;
    }

    public void computeMaxZoom() {
        Genome genome = this.getGenome();
        if (genome != null && this.chrName != null && genome.getChromosome(this.chrName) != null) {
            if (this.chrName.equals("All")) {
                maxZoom = 0;
            } else {
                int chrLength = genome.getChromosome(this.chrName).getLength();
                maxZoom = (int)(Math.log((double)chrLength / 50.0) / Globals.log2) + 1;
            }
            if (this.zoom > maxZoom) {
                this.zoomTo(maxZoom);
            }
        }
    }

    private void zoomTo(int newZoom) {
        this.zoom = Math.min(maxZoom, newZoom);
        this.nTiles = (int)Math.pow(2.0, Math.max(this.minZoom, this.zoom));
        this.maxPixel = this.getTilesTimesBinsPerTile();
        this.invalidateLocationScale();
        if (IGV.hasInstance()) {
            IGV.getInstance().repaintStatusAndZoomSlider();
        }
    }

    public void setZoom(int z) {
        if (z > 0) {
            this.zoom = z;
        }
    }

    public void incrementZoom(int increment) {
        this.zoomByAndCenter(increment);
    }

    public void zoomAndCenterAdjusted(int newZoom) {
        double currentCenter = this.origin + (double)(this.widthInPixels / 2) * this.getScale();
        this.zoomTo(newZoom, currentCenter);
    }

    public void zoomByAndCenter(int zoomIncrement) {
        double currentCenter = this.origin + (double)(this.widthInPixels / 2) * this.getScale();
        this.zoomBy(zoomIncrement, currentCenter);
    }

    public void zoomBy(int zoomFactor, double newCenter) {
        if (FrameManager.isGeneListMode()) {
            double f2 = Math.pow(2.0, zoomFactor);
            this.locationScale = Math.max(this.minScale, this.locationScale / f2);
            double newOrigin = Math.round(newCenter - (double)(this.widthInPixels / 2) * this.locationScale);
            this.setOrigin(newOrigin);
            this.imputeZoom(this.origin, this.setEnd);
        } else {
            int newZoom = Math.max(0, this.zoom + zoomFactor);
            this.zoomTo(newZoom, newCenter);
        }
    }

    public void zoomTo(int newZoom, double newCenter) {
        if (this.chrName.equals("All")) {
            this.chrName = this.getGenome().getHomeChromosome();
        }
        if (this.chrName.equals("All")) {
            this.jumpToChromosomeForGenomeLocation(newCenter);
            IGV.getInstance().chromosomeChangeEvent(this.chrName);
        } else if (this.zoom != newZoom) {
            this.zoomTo(newZoom);
            this.computeLocationScale();
            double newLocationScale = this.getScale();
            double newOrigin = Math.round(newCenter - (double)(this.widthInPixels / 2) * newLocationScale);
            this.setOrigin(newOrigin);
        }
        this.recordHistory();
        DragEventManager.getInstance().dragStopped();
    }

    public void recordHistory() {
        IGV.getInstance().getSession().getHistory().push(this.getFormattedLocusString(), this.zoom);
    }

    private void jumpToChromosomeForGenomeLocation(double locationMB) {
        double startMB = 0.0;
        for (String chr : this.getGenome().getChromosomeNames()) {
            double endMB = startMB + (double)this.getGenome().getChromosome(chr).getLength() / 1000.0;
            if (locationMB > startMB && locationMB <= endMB) {
                this.setChromosomeName(chr);
                break;
            }
            startMB = endMB;
        }
    }

    public void shiftOriginPixels(double delta) {
        double shiftBP = delta * this.getScale();
        this.setOrigin(this.origin + shiftBP);
    }

    public void snapToGrid() {
        this.setOrigin(Math.round(this.origin));
    }

    public void centerOnLocation(String chr, double chrLocation) {
        if (!this.chrName.equals(chr)) {
            this.chrName = chr;
            this.computeMaxZoom();
            if (this.zoom > maxZoom) {
                this.zoomTo(maxZoom);
            }
        }
        double windowWidth = (double)this.widthInPixels * this.getScale() / 2.0;
        this.setOrigin(Math.round(chrLocation - windowWidth));
    }

    public void centerOnLocation(double chrLocation) {
        double windowWidth = (double)this.widthInPixels * this.getScale() / 2.0;
        this.setOrigin(Math.round(chrLocation - windowWidth));
        this.recordHistory();
    }

    public boolean windowAtEnd() {
        double windowLengthBP = (double)this.widthInPixels * this.getScale();
        return this.origin + windowLengthBP + 1.0 > (double)this.getChromosomeLength();
    }

    public void setOrigin(double position) {
        int windowLengthBP = (int)((double)this.widthInPixels * this.getScale());
        double newOrigin = this.origin;
        newOrigin = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_SOFT_CLIPPED") ? Math.max(-1000.0, Math.min(position, (double)(this.getChromosomeLength() + 1000 - windowLengthBP))) : Math.max(0.0, Math.min(position, (double)(this.getChromosomeLength() - windowLengthBP)));
        double delta = newOrigin - this.origin;
        this.origin = newOrigin;
        IGV.getInstance().repaintDataAndHeaderPanels();
        IGV.getInstance().repaintStatusAndZoomSlider();
    }

    public void jumpTo(String chr, int start, int end) {
        Chromosome chromosome;
        Genome genome = this.getGenome();
        if (chr != null) {
            if (genome.getChromosome(chr) == null && !chr.contains("All")) {
                MessageUtils.showMessage(chr + " is not a valid chromosome.");
                return;
            }
            this.setChromosomeName(chr);
        }
        Chromosome chromosome2 = chromosome = genome == null ? null : genome.getChromosome(chr);
        if (chromosome != null) {
            end = Math.min(chromosome.getLength(), end);
        }
        if (start >= 0) {
            this.imputeZoom(start, end);
            if (this.widthInPixels > 0) {
                this.setLocationScale((double)(end - start) / (double)this.widthInPixels);
            }
            this.origin = start;
        }
        if (log.isDebugEnabled()) {
            log.debug("Data panel width = " + this.widthInPixels);
            log.debug("New start = " + (int)this.origin);
            log.debug("New end = " + (int)this.getEnd());
            log.debug("New center = " + (int)this.getCenter());
            log.debug("Scale = " + this.locationScale);
        }
        IGV.getInstance().repaintDataAndHeaderPanels();
        IGV.getInstance().repaintStatusAndZoomSlider();
    }

    private void imputeZoom(double start, double end) {
        int z = (int)(Math.log((double)this.getChromosomeLength() / (end - start)) / Globals.log2) + 1;
        if (z != this.zoom) {
            this.zoom = Math.min(maxZoom, Math.max(this.minZoom, z));
            this.nTiles = (int)Math.pow(2.0, this.zoom);
            this.maxPixel = this.getTilesTimesBinsPerTile();
        }
    }

    private Genome getGenome() {
        return IGV.getInstance().getGenomeManager().getCurrentGenome();
    }

    public double getOrigin() {
        return this.origin;
    }

    public double getCenter() {
        return this.origin + this.getScale() * (double)this.widthInPixels / 2.0;
    }

    public double getEnd() {
        return this.origin + this.getScale() * (double)this.widthInPixels;
    }

    public int getZoom() {
        return this.zoom;
    }

    public int getMaxZoom() {
        return maxZoom;
    }

    public int getAdjustedZoom() {
        return this.zoom - this.minZoom;
    }

    public double getMaxPixel() {
        return this.maxPixel;
    }

    public void setChrName(String name) {
        this.setChromosomeName(name);
    }

    public void setChromosomeName(String name, boolean force) {
        if (this.chrName == null || !name.equals(this.chrName) || force) {
            this.chrName = name;
            this.origin = 0.0;
            this.zoomTo(0);
            this.computeMaxZoom();
            if (RegionNavigatorDialog.getActiveInstance() != null) {
                RegionNavigatorDialog.getActiveInstance().updateChromosomeDisplayed();
            }
        }
    }

    public void setChromosomeName(String name) {
        this.setChromosomeName(name, false);
    }

    public String getChrName() {
        return this.chrName;
    }

    public int getWidthInPixels() {
        return this.widthInPixels;
    }

    public double getScale() {
        if (this.locationScale == 0.0 || !this.locationScaleValid || this.locationScale < 0.0) {
            this.computeLocationScale();
        }
        return this.locationScale;
    }

    public void invalidateLocationScale() {
        this.locationScaleValid = false;
    }

    public void computeLocationScale() {
        Genome genome = this.getGenome();
        if (genome != null) {
            if (this.setEnd > 0) {
                this.locationScale = ((double)this.setEnd - this.origin) / (double)this.widthInPixels;
                this.locationScaleValid = true;
                this.imputeZoom(this.origin, this.setEnd);
            } else {
                this.computeMinZoom();
                double virtualPixelSize = this.getTilesTimesBinsPerTile();
                double nPixel = Math.max(virtualPixelSize, (double)this.widthInPixels);
                this.setLocationScale((double)this.getChromosomeLength() / nPixel);
            }
        }
    }

    private void computeMinZoom() {
        if (this.chrName.equals("All")) {
            this.minZoom = 0;
        } else {
            this.minZoom = Math.max(0, (int)(Math.log(this.widthInPixels / binsPerTile) / Globals.log2));
            if (this.zoom < this.minZoom) {
                this.zoom = this.minZoom;
                this.nTiles = (int)Math.pow(2.0, this.zoom);
                this.maxPixel = this.getTilesTimesBinsPerTile();
            }
        }
    }

    public double getChromosomePosition(int screenPosition) {
        return this.origin + this.getScale() * (double)screenPosition;
    }

    public int getScreenPosition(double chromosomePosition) {
        return (int)((chromosomePosition - this.origin) / this.getScale());
    }

    public Chromosome getChromosome() {
        Genome genome = this.getGenome();
        if (genome == null) {
            log.error("Genome not loaded!");
            return null;
        }
        return genome.getChromosome(this.chrName);
    }

    public int getChromosomeLength() {
        Genome genome = this.getGenome();
        if (genome == null) {
            return 1;
        }
        if (this.chrName.equals("All")) {
            return (int)(genome.getLength() / 1000L);
        }
        if (this.getChromosome() == null) {
            log.error("Null chromosome: " + this.chrName);
            if (genome == null) {
                return 1;
            }
            return genome.getChromosomes().iterator().next().getLength();
        }
        return this.getChromosome().getLength();
    }

    public double getTilesTimesBinsPerTile() {
        return (double)this.nTiles * (double)binsPerTile;
    }

    public String getFormattedLocusString() {
        if (this.zoom == 0) {
            return this.getChrName();
        }
        Range range = this.getCurrentRange();
        String startStr = NUMBER_FORMAT.format(range.getStart());
        String endStr = NUMBER_FORMAT.format(range.getEnd());
        String position = range.getChr() + ":" + startStr + "-" + endStr;
        return position;
    }

    public Range getCurrentRange() {
        int start = 0;
        int end = this.widthInPixels;
        int startLoc = (int)this.getChromosomePosition(start) + 1;
        int endLoc = (int)this.getChromosomePosition(end);
        Range range = new Range(this.getChrName(), startLoc, endLoc);
        return range;
    }

    private void setLocationScale(double locationScale) {
        if (log.isDebugEnabled()) {
            log.debug("Set location scale: " + locationScale + "  origin=" + this.origin);
        }
        this.locationScale = locationScale;
        this.locationScaleValid = true;
    }

    public void setInterval(Locus locus) {
        this.locus = locus;
        this.setInterval(locus.getChr(), locus.getStart(), locus.getEnd());
    }

    public void setInterval(String chr, int start, int end) {
        this.chrName = chr;
        this.origin = start;
        if (this.widthInPixels > 0) {
            this.locationScale = ((double)end - this.origin) / (double)this.widthInPixels;
            this.locationScaleValid = true;
            this.imputeZoom(this.origin, end);
        } else {
            this.setEnd = end;
        }
    }

    public void reset() {
        this.setInterval(FrameManager.getLocus(this.name));
        IGV.getInstance().repaintDataAndHeaderPanels();
    }

    public String getName() {
        return this.name;
    }

    public Locus getLocus() {
        return this.locus;
    }

    public static class Range {
        private String chr;
        private int start;
        private int end;

        public Range(String chr, int start, int end) {
            this.chr = chr;
            this.start = start;
            this.end = end;
        }

        public String getChr() {
            return this.chr;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public int getLength() {
            return this.end - this.start;
        }
    }
}

