/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackGroup;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.panel.DataPanelContainer;
import org.broad.igv.ui.panel.TrackPanelScrollPane;

public class FitDataToWindowMenuAction
extends MenuAction {
    static Logger log = Logger.getLogger(FitDataToWindowMenuAction.class);
    IGV mainFrame;

    public FitDataToWindowMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
        this.setToolTipText("Resizes all track heights in order to make all tracks visible in their display with no vertical scrolling");
    }

    @Override
    public void actionPerformed(ActionEvent e2) {
        for (TrackPanelScrollPane sp : IGV.getInstance().getTrackManager().getTrackPanelScrollPanes()) {
            this.fitTracksToPanel(sp.getDataPanel());
        }
        this.mainFrame.doRefresh();
    }

    private boolean fitTracksToPanel(DataPanelContainer dataPanel) {
        boolean success = true;
        int availableHeight = dataPanel.getVisibleHeight();
        int visibleTrackCount = 0;
        Collection<TrackGroup> groups = dataPanel.getTrackGroups();
        boolean expand = dataPanel.getHeight() > availableHeight;
        for (TrackGroup group : groups) {
            List<Track> tracks = group.getTracks();
            for (Track track : tracks) {
                if (!track.isVisible()) continue;
                ++visibleTrackCount;
            }
        }
        if (visibleTrackCount > 0) {
            int groupGapHeight = (groups.size() + 1) * 10;
            int adjustedAvailableHeight = Math.max(1, availableHeight - groupGapHeight);
            int delta = adjustedAvailableHeight / visibleTrackCount;
            if (delta < 1) {
                delta = 1;
            }
            boolean iTotal = false;
            float target = 0.0f;
            for (TrackGroup group : groups) {
                List<Track> tracks = group.getTracks();
                for (Track track : tracks) {
                    track.setHeight(delta);
                }
            }
        }
        return success;
    }
}

