/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.jidesoft.utils.Lm;
import jargs.gnu.CmdLineParser;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.broad.igv.Globals;
import org.broad.igv.ui.DefaultExceptionHandler;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.ShutdownThread;
import org.broad.igv.ui.event.GlobalKeyDispatcher;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;

public class Main {
    private static Logger log = Logger.getLogger(Main.class);

    public static void main(final String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        Main.initApplication();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JFrame frame = new JFrame();
                    frame.setDefaultCloseOperation(3);
                    Main.open(frame, args);
                }
                catch (Exception e2) {
                    log.error("Fatal application error!", e2);
                    MessageUtils.showMessage("<html>A fatal error was encountered on startup: <br>" + e2.toString() + "<br>" + "Please contact igv-help@broadinstitute.org");
                    System.exit(-1);
                }
            }
        });
    }

    private static void initApplication() {
        Main.initializeLog();
        log.info("Startup  " + Globals.applicationString());
        log.info("Default User Directory: " + Globals.getUserDirectory());
        System.setProperty("http.agent", Globals.applicationString());
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        ToolTipManager.sharedInstance().setEnabled(true);
        ToolTipManager.sharedInstance().setInitialDelay(50);
        ToolTipManager.sharedInstance().setReshowDelay(50);
        ToolTipManager.sharedInstance().setDismissDelay(60000);
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        IGVHttpUtils.updateProxySettings();
    }

    public static void open(Frame frame) {
        Main.open(frame, new String[0]);
    }

    public static void open(Frame frame, String[] args) {
        if (!(frame instanceof JFrame)) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getComponent().setVisible(false);
                }
            });
        }
        Main.initializeLookAndFeel();
        IGVHttpUtils.updateProxySettings();
        IGV.createInstance(frame).startUp(args);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new GlobalKeyDispatcher());
    }

    private static void initializeLookAndFeel() {
        Lm.verifyLicense("The Broad Institute, MIT", "Gene Pattern", "D.DQSR7z9m6fxL1IqWZ6svQFmE6vj3Q");
        try {
            String lnf = UIManager.getSystemLookAndFeelClassName();
            System.out.println("Installing look & feel:  " + lnf);
            UIManager.setLookAndFeel(lnf);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        if (Globals.IS_LINUX) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                UIManager.put("JideSplitPane.dividerSize", 5);
                UIManager.put("JideSplitPaneDivider.background", Color.darkGray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        LookAndFeelFactory.installJideExtension();
    }

    public static void initializeLog() {
        Logger logger = Logger.getRootLogger();
        PatternLayout layout = new PatternLayout();
        layout.setConversionPattern("%p [%d{ISO8601}] [%F:%L]  %m%n");
        RollingFileAppender appender = new RollingFileAppender();
        appender.setName("IGV_ROLLING_APPENDER");
        appender.setFile(Main.getLogFilePath());
        appender.setThreshold(Level.ALL);
        appender.setMaxFileSize("1000KB");
        appender.setMaxBackupIndex(1);
        appender.setLayout(layout);
        appender.setAppend(true);
        appender.activateOptions();
        logger.addAppender(appender);
    }

    public static String getLogFilePath() {
        StringBuffer logFilePath = new StringBuffer();
        logFilePath.append(Globals.getIgvDirectory());
        logFilePath.append(System.getProperties().getProperty("file.separator"));
        logFilePath.append("igv.log");
        File logFile = null;
        try {
            logFile = new File(logFilePath.toString().trim());
            if (!logFile.getParentFile().exists()) {
                logFile.getParentFile().mkdir();
            }
            if (!logFile.exists()) {
                logFile.createNewFile();
            }
        }
        catch (Exception e2) {
            System.out.println("Error creating log file: " + logFile.getAbsolutePath());
            e2.printStackTrace();
        }
        return logFilePath.toString().trim();
    }

    static class IGVArgs {
        private String batchFile = null;
        private String sessionFile = null;
        private String dataFileString = null;
        private String locusString = null;
        private String propertyFile = null;
        private String genomeId = null;
        private String port = null;
        private String dataServerURL = null;
        private String genomeServerURL = null;
        private String indexFile = null;

        IGVArgs(String[] args) {
            if (args != null) {
                this.parseArgs(args);
            }
        }

        private void parseArgs(String[] args) {
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option propertyFileOption = parser.addStringOption('p', "preferences");
            CmdLineParser.Option batchFileOption = parser.addStringOption('b', "batch");
            CmdLineParser.Option portOption = parser.addStringOption('p', "port");
            CmdLineParser.Option genomeOption = parser.addStringOption('g', "genome");
            CmdLineParser.Option dataServerOption = parser.addStringOption('d', "dataServerURL");
            CmdLineParser.Option genomeServerOption = parser.addStringOption('u', "genomeServerURL");
            CmdLineParser.Option indexFileOption = parser.addStringOption('i', "indexFileURL");
            try {
                parser.parse(args);
            }
            catch (CmdLineParser.IllegalOptionValueException e2) {
                e2.printStackTrace();
            }
            catch (CmdLineParser.UnknownOptionException e3) {
                e3.printStackTrace();
            }
            this.propertyFile = (String)parser.getOptionValue(propertyFileOption);
            this.batchFile = (String)parser.getOptionValue(batchFileOption);
            this.port = (String)parser.getOptionValue(portOption);
            this.genomeId = (String)parser.getOptionValue(genomeOption);
            this.dataServerURL = (String)parser.getOptionValue(dataServerOption);
            this.genomeServerURL = (String)parser.getOptionValue(genomeServerOption);
            this.indexFile = (String)parser.getOptionValue(indexFileOption);
            String[] nonOptionArgs = parser.getRemainingArgs();
            if (nonOptionArgs != null && nonOptionArgs.length > 0) {
                String firstArg = nonOptionArgs[0];
                if (!firstArg.equals("ignore")) {
                    if (firstArg.endsWith("xml")) {
                        this.sessionFile = firstArg;
                    } else {
                        this.dataFileString = firstArg;
                    }
                }
                if (nonOptionArgs.length > 1) {
                    this.locusString = nonOptionArgs[1];
                }
            }
        }

        public String getBatchFile() {
            return this.batchFile;
        }

        public String getSessionFile() {
            return this.sessionFile;
        }

        public String getDataFileString() {
            return this.dataFileString;
        }

        public String getLocusString() {
            return this.locusString;
        }

        public String getPropertyFile() {
            return this.propertyFile;
        }

        public String getGenomeId() {
            return this.genomeId;
        }

        public String getPort() {
            return this.port;
        }

        public String getDataServerURL() {
            return this.dataServerURL;
        }

        public String getGenomeServerURL() {
            return this.genomeServerURL;
        }

        public String getIndexFile() {
            return this.indexFile;
        }
    }
}

