/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.das.DASFeatureSource;
import org.broad.igv.data.DatasetDataSource;
import org.broad.igv.data.HDFDataManager;
import org.broad.igv.data.HDFDataManagerFactory;
import org.broad.igv.data.IGVDataset;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.data.WiggleParser;
import org.broad.igv.data.expression.GCTDataset;
import org.broad.igv.data.expression.GCTDatasetParser;
import org.broad.igv.data.rnai.RNAIDataSource;
import org.broad.igv.data.rnai.RNAIGCTDatasetParser;
import org.broad.igv.data.rnai.RNAIGeneScoreParser;
import org.broad.igv.data.rnai.RNAIHairpinParser;
import org.broad.igv.data.seg.FreqData;
import org.broad.igv.data.seg.SegmentedAsciiDataSet;
import org.broad.igv.data.seg.SegmentedBinaryDataSet;
import org.broad.igv.data.seg.SegmentedDataSource;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.GisticFileParser;
import org.broad.igv.feature.MutationParser;
import org.broad.igv.feature.PSLParser;
import org.broad.igv.feature.dranger.DRangerParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.FeatureFileHeader;
import org.broad.igv.goby.GobyAlignmentQueryReader;
import org.broad.igv.gwas.GWASData;
import org.broad.igv.gwas.GWASParser;
import org.broad.igv.gwas.GWASTrack;
import org.broad.igv.lists.VariantListManager;
import org.broad.igv.maf.MAFTrack;
import org.broad.igv.maf.conservation.OmegaDataSource;
import org.broad.igv.maf.conservation.OmegaTrack;
import org.broad.igv.peaks.PeakTrack;
import org.broad.igv.renderer.CosmicFeatureRenderer;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.renderer.MutationRenderer;
import org.broad.igv.renderer.ScatterplotRenderer;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.BedRenderer;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.EWigTrack;
import org.broad.igv.sam.reader.IndexNotFoundException;
import org.broad.igv.synteny.BlastMapping;
import org.broad.igv.synteny.BlastParser;
import org.broad.igv.tdf.TDFDataSource;
import org.broad.igv.tdf.TDFReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.CNFreqTrack;
import org.broad.igv.track.DataSourceTrack;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureDirSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.GisticTrack;
import org.broad.igv.track.HDFDataTrack;
import org.broad.igv.track.IndexedBEDFeatureSource;
import org.broad.igv.track.SpliceJunctionFinderTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackSet;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.TribbleFeatureSource;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.vcf.PedigreeUtils;
import org.broad.igv.vcf.VCFTrack;
import org.broad.tribble.Feature;

public class TrackLoader {
    private static Logger log = Logger.getLogger(TrackLoader.class);
    private IGV igv;

    public List<Track> load(ResourceLocator locator, IGV igv) {
        this.igv = igv;
        Genome genome = igv.getGenomeManager().getCurrentGenome();
        try {
            String typeString = locator.getType();
            if (typeString == null && !(typeString = locator.getPath().toLowerCase()).endsWith("_sorted.txt") && (typeString.endsWith(".txt") || typeString.endsWith(".xls") || typeString.endsWith(".gz"))) {
                typeString = typeString.substring(0, typeString.lastIndexOf("."));
            }
            if ((typeString = typeString.toLowerCase()).endsWith(".tbi")) {
                MessageUtils.showMessage("<html><b>Error:</b>File type '.tbi' is not recognized.  If this is a 'tabix' index <br> load the associated gzipped file, which should have an extension of '.gz'");
            }
            boolean hasIndex = false;
            if (locator.isLocal()) {
                File indexFile = new File(locator.getPath() + ".sai");
                hasIndex = indexFile.exists();
            }
            ArrayList<Track> newTracks = new ArrayList<Track>();
            if (typeString.equals("das")) {
                this.loadDASResource(locator, newTracks);
            } else if (TrackLoader.isIndexed(locator.getPath())) {
                this.loadIndexed(locator, newTracks);
            } else {
                if (typeString.endsWith(".vcf") || typeString.endsWith(".vcf4")) {
                    throw new IndexNotFoundException(locator.getPath());
                }
                if (typeString.endsWith(".trio")) {
                    this.loadTrioData(locator);
                } else if (typeString.endsWith("varlist")) {
                    VariantListManager.loadVariants(locator);
                } else if (typeString.endsWith("samplepathmap")) {
                    VariantListManager.loadSamplePathMap(locator);
                } else if (typeString.endsWith("h5") || typeString.endsWith("hbin")) {
                    this.loadH5File(locator, newTracks, genome);
                } else if (typeString.endsWith(".rnai.gct")) {
                    this.loadRnaiGctFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".gct") || typeString.endsWith("res") || typeString.endsWith("tab")) {
                    this.loadGctFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".cn") || typeString.endsWith(".xcn") || typeString.endsWith(".snp") || typeString.endsWith(".igv") || typeString.endsWith(".loh")) {
                    this.loadIGVFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".mut")) {
                    this.loadMutFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".cbs") || typeString.endsWith(".seg") || typeString.endsWith("glad") || typeString.endsWith("birdseye_canary_calls")) {
                    this.loadSegFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".seg.zip")) {
                    this.loadBinarySegFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".gistic")) {
                    this.loadGisticFile(locator, newTracks);
                } else if (typeString.endsWith(".gs")) {
                    this.loadRNAiGeneScoreFile(locator, newTracks, RNAIGeneScoreParser.Type.GENE_SCORE, genome);
                } else if (typeString.endsWith(".riger")) {
                    this.loadRNAiGeneScoreFile(locator, newTracks, RNAIGeneScoreParser.Type.POOLED, genome);
                } else if (typeString.endsWith(".hp")) {
                    this.loadRNAiHPScoreFile(locator);
                } else if (typeString.endsWith("gene")) {
                    this.loadGeneFile(locator, newTracks, genome);
                } else if (typeString.contains(".tabblastn") || typeString.endsWith(".orthologs")) {
                    this.loadSyntentyMapping(locator, newTracks);
                } else if (typeString.endsWith(".sam") || typeString.endsWith(".bam") || typeString.endsWith(".sam.list") || typeString.endsWith(".bam.list") || typeString.endsWith("_sorted.txt") || typeString.endsWith(".aligned") || typeString.endsWith(".sai") || typeString.endsWith(".bai")) {
                    this.loadAlignmentsTrack(locator, newTracks);
                } else if (typeString.endsWith(".bedz") || typeString.endsWith(".bed") && hasIndex) {
                    this.loadIndexdBedFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".omega")) {
                    this.loadOmegaTrack(locator, newTracks, genome);
                } else if (typeString.endsWith(".wig") || typeString.endsWith(".bedgraph") || typeString.endsWith("cpg.txt") || typeString.endsWith(".expr")) {
                    this.loadWigFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".list")) {
                    this.loadListFile(locator, newTracks, genome);
                } else if (typeString.contains(".dranger")) {
                    this.loadDRangerFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".ewig.tdf") || typeString.endsWith(".ewig.ibf")) {
                    this.loadEwigIBFFile(locator, newTracks);
                } else if (typeString.endsWith(".ibf") || typeString.endsWith(".tdf")) {
                    this.loadTDFFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".psl") || typeString.endsWith(".psl.gz") || typeString.endsWith(".pslx") || typeString.endsWith(".pslx.gz")) {
                    this.loadPslFile(locator, newTracks, genome);
                } else if (AbstractFeatureParser.getInstanceFor(locator, genome) != null) {
                    this.loadFeatureFile(locator, newTracks, genome);
                } else if (MutationParser.isMutationAnnotationFile(locator)) {
                    this.loadMutFile(locator, newTracks, genome);
                } else if (WiggleParser.isWiggle(locator)) {
                    this.loadWigFile(locator, newTracks, genome);
                } else if (locator.getPath().toLowerCase().contains(".maf")) {
                    this.loadMAFTrack(locator, newTracks);
                } else if (locator.getPath().toLowerCase().contains(".peak")) {
                    this.loadPeakTrack(locator, newTracks, genome);
                } else if ("mage-tab".equals(locator.getType()) || GCTDatasetParser.parsableMAGE_TAB(locator)) {
                    locator.setDescription("MAGE_TAB");
                    this.loadGctFile(locator, newTracks, genome);
                } else if (typeString.endsWith(".logistic") || typeString.endsWith(".linear") || typeString.endsWith(".assoc") || typeString.endsWith(".qassoc") || typeString.endsWith(".gwas")) {
                    this.loadGWASFile(locator, newTracks);
                } else if (GobyAlignmentQueryReader.supportsFileType(locator.getPath())) {
                    this.loadAlignmentsTrack(locator, newTracks);
                } else if (AttributeManager.isSampleInfoFile(locator)) {
                    AttributeManager.getInstance().loadSampleInfo(locator);
                } else {
                    MessageUtils.showMessage("<html>Unknown file type: " + locator.getPath() + "<br>Check file extenstion");
                }
            }
            TrackProperties tp = null;
            String trackLine = locator.getTrackLine();
            if (trackLine != null) {
                tp = new TrackProperties();
                ParsingUtils.parseTrackLine(trackLine, tp);
            }
            for (Track track : newTracks) {
                if (locator.getUrl() != null) {
                    track.setUrl(locator.getUrl());
                }
                if (tp != null) {
                    track.setProperties(tp);
                }
                if (locator.getColor() != null) {
                    track.setColor(locator.getColor());
                }
                if (locator.getSampleId() == null) continue;
                track.setSampleId(locator.getSampleId());
            }
            return newTracks;
        }
        catch (DataLoadException dle) {
            throw dle;
        }
        catch (Exception e2) {
            log.error(e2);
            throw new DataLoadException(e2.getMessage(), locator.getPath());
        }
    }

    private void loadIndexed(ResourceLocator locator, List<Track> newTracks) throws IOException {
        TribbleFeatureSource src = new TribbleFeatureSource(locator.getPath());
        String typeString = locator.getPath();
        if (typeString.endsWith("vcf") || typeString.endsWith("vcf.gz")) {
            VCFTrack t = new VCFTrack(locator, src);
            t.setMargin(0);
            newTracks.add(t);
        } else {
            FeatureTrack t = new FeatureTrack(locator, src);
            t.setName(locator.getTrackName());
            Object header = src.getHeader();
            if (header != null && header instanceof FeatureFileHeader) {
                FeatureFileHeader ffh = (FeatureFileHeader)header;
                if (ffh.getTrackType() != null) {
                    t.setTrackType(ffh.getTrackType());
                }
                if (ffh.getTrackProperties() != null) {
                    t.setProperties(ffh.getTrackProperties());
                }
                if (ffh.getTrackType() == TrackType.REPMASK) {
                    t.setHeight(15);
                    t.setPreferredHeight(15);
                }
            }
            newTracks.add(t);
        }
    }

    private void loadGeneFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        FeatureParser featureParser = AbstractFeatureParser.getInstanceFor(locator, genome);
        if (featureParser != null) {
            List<FeatureTrack> tracks = featureParser.loadTracks(locator, genome);
            newTracks.addAll(tracks);
        }
    }

    private void loadSyntentyMapping(ResourceLocator locator, List<Track> newTracks) {
        List<BlastMapping> mappings = new BlastParser().parse(locator.getPath());
        ArrayList<Feature> features = new ArrayList<Feature>(mappings.size());
        features.addAll(mappings);
        Genome genome = this.igv.getGenomeManager().getCurrentGenome();
        FeatureTrack track = new FeatureTrack(locator, new FeatureCollectionSource(features, genome));
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadDRangerFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        DRangerParser parser = new DRangerParser();
        newTracks.addAll(parser.loadTracks(locator, genome));
    }

    private void loadPslFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        PSLParser featureParser = new PSLParser(genome);
        List<FeatureTrack> tracks = featureParser.loadTracks(locator, genome);
        newTracks.addAll(tracks);
        for (FeatureTrack t : tracks) {
            t.setMinimumHeight(10);
            t.setHeight(30);
            t.setPreferredHeight(30);
            t.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
    }

    private void loadFeatureFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        if (locator.isLocal() && (locator.getPath().endsWith(".bed") || locator.getPath().endsWith(".bed.txt") || locator.getPath().endsWith(".bed.gz")) && !this.checkSize(locator.getPath())) {
            return;
        }
        FeatureParser featureParser = AbstractFeatureParser.getInstanceFor(locator, genome);
        if (featureParser != null) {
            List<FeatureTrack> tracks = featureParser.loadTracks(locator, genome);
            newTracks.addAll(tracks);
        } else if (MutationParser.isMutationAnnotationFile(locator)) {
            this.loadMutFile(locator, newTracks, genome);
        } else if (WiggleParser.isWiggle(locator)) {
            this.loadWigFile(locator, newTracks, genome);
        } else if (locator.getPath().toLowerCase().contains(".maf")) {
            this.loadMAFTrack(locator, newTracks);
        }
    }

    private void loadIndexdBedFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        File featureFile = new File(locator.getPath());
        File indexFile = new File(locator.getPath() + ".sai");
        IndexedBEDFeatureSource src = new IndexedBEDFeatureSource(featureFile, indexFile, genome);
        FeatureTrack t = new FeatureTrack(locator, src);
        newTracks.add(t);
    }

    private void loadGWASFile(ResourceLocator locator, List<Track> newTracks) throws IOException {
        GWASParser gwasParser = new GWASParser(locator);
        GWASData gwasData = gwasParser.parse();
        GWASTrack gwasTrack = new GWASTrack(locator, locator.getPath(), locator.getFileName(), gwasData, gwasParser);
        newTracks.add(gwasTrack);
    }

    private void loadRnaiGctFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        RNAIGCTDatasetParser parser = new RNAIGCTDatasetParser(locator, genome);
        Collection<RNAIDataSource> dataSources = parser.parse();
        if (dataSources != null) {
            String path = locator.getPath();
            for (RNAIDataSource ds : dataSources) {
                String trackId = path + "_" + ds.getName();
                DataSourceTrack track = new DataSourceTrack(locator, trackId, ds.getName(), ds, genome);
                track.setAttributeValue("SCREEN", ds.getScreen());
                track.setHeight(80);
                track.setPreferredHeight(80);
                newTracks.add(track);
            }
        }
    }

    private void loadGctFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        if (locator.isLocal() && !this.checkSize(locator.getPath())) {
            return;
        }
        GCTDatasetParser parser = null;
        GCTDataset ds = null;
        String fName = locator.getTrackName();
        try {
            parser = new GCTDatasetParser(locator, null, this.igv.getGenomeManager().getCurrentGenome());
        }
        catch (IOException e2) {
            log.error("Error creating GCT parser.", e2);
            throw new DataLoadException("Error creating GCT parser: " + e2, locator.getPath());
        }
        ds = parser.createDataset();
        ds.setName(fName);
        ds.setNormalized(true);
        ds.setLogValues(true);
        TrackProperties trackProperties = ds.getTrackProperties();
        String path = locator.getPath();
        for (String trackName : ds.getTrackNames()) {
            Genome currentGenome = this.igv.getGenomeManager().getCurrentGenome();
            DatasetDataSource dataSource = new DatasetDataSource(trackName, ds, currentGenome);
            String trackId = path + "_" + trackName;
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource, genome);
            track.setRendererClass(HeatmapRenderer.class);
            track.setProperties(trackProperties);
            newTracks.add(track);
        }
    }

    private void loadIGVFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        if (locator.isLocal() && !this.checkSize(locator.getPath())) {
            return;
        }
        String dsName = locator.getTrackName();
        IGVDataset ds = new IGVDataset(locator, genome, this.igv);
        ds.setName(dsName);
        TrackProperties trackProperties = ds.getTrackProperties();
        String path = locator.getPath();
        TrackType type = ds.getType();
        for (String trackName : ds.getTrackNames()) {
            DatasetDataSource dataSource = new DatasetDataSource(trackName, ds, genome);
            String trackId = path + "_" + trackName;
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource, genome);
            track.setTrackType(ds.getType());
            track.setProperties(trackProperties);
            if (type == TrackType.ALLELE_FREQUENCY) {
                track.setRendererClass(ScatterplotRenderer.class);
                track.setHeight(40);
                track.setPreferredHeight(40);
            }
            newTracks.add(track);
        }
    }

    private boolean checkSize(String file) {
        if (!PreferenceManager.getInstance().getAsBoolean("SHOW_SIZE_WARNING")) {
            return true;
        }
        File f2 = new File(file);
        String tmp = file;
        if (f2.exists()) {
            long size = f2.length();
            if (file.endsWith(".gz")) {
                size *= 3L;
                tmp = file.substring(0, file.length() - 3);
            }
            if (size > 50000000L) {
                String message = "";
                message = tmp.endsWith(".bed") || tmp.endsWith(".bed.txt") ? "The file " + file + " is large (" + size / 1000000L + " mb).  It is recommended " + "that large files be indexed using IGVTools or Tabix. Loading un-indexed " + "ascii fies of this size can lead to poor performance or unresponsiveness (freezing).  " + "<br><br>IGVTools can be launched from the <b>Tools</b> menu or separately as a command line program.  " + "See the user guide for more details.<br><br>Click <b>Continue</b> to continue loading, or <b>Cancel</b>" + " to skip this file." : "The file " + file + " is large (" + size / 1000000L + " mb).  It is recommended " + "that large files be converted to the binary <i>.tdf</i> format using the IGVTools " + "<b>tile</b> command. Loading  unconverted ascii fies of this size can lead to poor " + "performance or unresponsiveness (freezing).  " + "<br><br>IGVTools can be launched from the <b>Tools</b> menu or separately as a " + "command line program. See the user guide for more details.<br><br>Click <b>Continue</b> " + "to continue loading, or <b>Cancel</b> to skip this file.";
                return ConfirmDialog.optionallyShowConfirmDialog(message, "SHOW_SIZE_WARNING", true);
            }
        }
        return true;
    }

    private void loadDOTFile(ResourceLocator locator, List<Track> newTracks) {
    }

    private void loadWigFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        if (locator.isLocal() && !this.checkSize(locator.getPath())) {
            return;
        }
        WiggleDataset ds = new WiggleParser(locator, genome).parse();
        TrackProperties props = ds.getTrackProperties();
        String name = props == null ? null : props.getName();
        String label = locator.getName();
        if (name == null) {
            name = locator.getFileName();
        } else if (label != null) {
            props.setName(label);
        }
        String path = locator.getPath();
        boolean multiTrack = ds.getTrackNames().length > 1;
        for (String heading : ds.getTrackNames()) {
            String trackId = multiTrack ? path + "_" + heading : path;
            String trackName = multiTrack ? heading : name;
            Genome currentGenome = IGV.getInstance().getGenomeManager().getCurrentGenome();
            DatasetDataSource dataSource = new DatasetDataSource(trackId, ds, genome);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource, genome);
            String displayName = label == null || multiTrack ? heading : label;
            track.setName(displayName);
            track.setProperties(props);
            track.setTrackType(ds.getType());
            if (ds.getType() == TrackType.EXPR) {
                track.setWindowFunction(WindowFunction.none);
            }
            newTracks.add(track);
        }
    }

    private void loadTDFFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        String name;
        if (log.isDebugEnabled()) {
            log.debug("Loading TDFFile: " + locator.toString());
        }
        TDFReader reader = TDFReader.getReader(locator.getPath());
        TrackType type = reader.getTrackType();
        if (log.isDebugEnabled()) {
            log.debug("Parsing track line ");
        }
        TrackProperties props = null;
        String trackLine = reader.getTrackLine();
        if (trackLine != null && trackLine.length() > 0) {
            props = new TrackProperties();
            ParsingUtils.parseTrackLine(trackLine, props);
        }
        if ((name = locator.getName()) != null && props != null) {
            props.setName(name);
        }
        if (name == null) {
            name = props == null ? locator.getTrackName() : props.getName();
        }
        int trackNumber = 0;
        String path = locator.getPath();
        boolean multiTrack = reader.getTrackNames().length > 1;
        for (String heading : reader.getTrackNames()) {
            String trackId = multiTrack ? path + "_" + heading : path;
            String trackName = multiTrack ? heading : name;
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, new TDFDataSource(reader, trackNumber, heading), genome);
            String displayName = name == null || multiTrack ? heading : name;
            track.setName(displayName);
            track.setTrackType(type);
            if (props != null) {
                track.setProperties(props);
            }
            newTracks.add(track);
            ++trackNumber;
        }
    }

    private void loadEwigIBFFile(ResourceLocator locator, List<Track> newTracks) {
        TDFReader reader = TDFReader.getReader(locator.getPath());
        TrackProperties props = null;
        String trackLine = reader.getTrackLine();
        if (trackLine != null && trackLine.length() > 0) {
            props = new TrackProperties();
            ParsingUtils.parseTrackLine(trackLine, props);
        }
        EWigTrack track = new EWigTrack(locator);
        if (props != null) {
            track.setProperties(props);
        }
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadListFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        try {
            FeatureDirSource source = new FeatureDirSource(locator, genome);
            FeatureTrack track = new FeatureTrack(locator, source);
            track.setName(locator.getTrackName());
            track.setVisibilityWindow(0);
            newTracks.add(track);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void loadGisticFile(ResourceLocator locator, List<Track> newTracks) {
        GisticTrack track = GisticFileParser.loadData(locator);
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadRNAiGeneScoreFile(ResourceLocator locator, List<Track> newTracks, RNAIGeneScoreParser.Type type, Genome genome) {
        RNAIGeneScoreParser parser = new RNAIGeneScoreParser(locator.getPath(), type, genome);
        Collection<RNAIDataSource> dataSources = parser.parse();
        String path = locator.getPath();
        for (RNAIDataSource ds : dataSources) {
            String name = ds.getName();
            String trackId = path + "_" + name;
            DataSourceTrack track = new DataSourceTrack(locator, trackId, name, ds, genome);
            track.setAttributeValue("SCREEN", ds.getScreen());
            if (ds.getCondition() != null && ds.getCondition().length() > 0) {
                track.setAttributeValue("CONDITION", ds.getCondition());
            }
            track.setHeight(80);
            track.setPreferredHeight(80);
            newTracks.add(track);
        }
    }

    private void loadRNAiHPScoreFile(ResourceLocator locator) {
        new RNAIHairpinParser(locator.getPath()).parse();
    }

    private void loadMAFTrack(ResourceLocator locator, List<Track> newTracks) {
        MAFTrack t = new MAFTrack(locator);
        t.setName("Multiple Alignments");
        newTracks.add(t);
    }

    private void loadPeakTrack(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        PeakTrack t = new PeakTrack(locator, genome);
        newTracks.add(t);
    }

    private void loadOmegaTrack(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        OmegaDataSource ds = new OmegaDataSource(genome);
        OmegaTrack track = new OmegaTrack(locator, ds, genome);
        track.setName("Conservation (Omega)");
        track.setHeight(40);
        track.setPreferredHeight(40);
        newTracks.add(track);
    }

    private void loadAlignmentsTrack(ResourceLocator locator, List<Track> newTracks) throws IOException {
        try {
            boolean showSpliceJunctionTrack;
            String covPath;
            boolean isBed;
            String dsName = locator.getTrackName();
            String fn = locator.getPath().toLowerCase();
            boolean bl = isBed = fn.endsWith(".bedz") || fn.endsWith(".bed") || fn.endsWith(".bed.gz");
            if (locator.getPath().endsWith(".sai") || locator.getPath().endsWith(".bai")) {
                MessageUtils.showMessage("<html><b>ERROR:</b> Loading SAM/BAM index files are not supported:  " + locator.getPath() + "<br>Load the SAM or BAM file directly. ");
                return;
            }
            AlignmentDataManager dataManager = new AlignmentDataManager(locator);
            if (locator.getPath().toLowerCase().endsWith(".bam") && !dataManager.hasIndex()) {
                MessageUtils.showMessage("<html>Could not load index file for: " + locator.getPath() + "<br>  An index file is required for SAM & BAM files.");
                return;
            }
            AlignmentTrack alignmentTrack = new AlignmentTrack(locator, dataManager);
            alignmentTrack.setName(dsName);
            if (isBed) {
                alignmentTrack.setRenderer(new BedRenderer());
                alignmentTrack.setPreferredHeight(40);
                alignmentTrack.setHeight(40);
            }
            CoverageTrack covTrack = new CoverageTrack(locator.getPath() + "_coverage", alignmentTrack.getName() + " Coverage");
            covTrack.setVisible(PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_COV_TRACK"));
            newTracks.add(covTrack);
            alignmentTrack.setCoverageTrack(covTrack);
            if (!isBed) {
                covTrack.setDataManager(dataManager);
                dataManager.setCoverageTrack(covTrack);
            }
            if ((covPath = locator.getCoverage()) == null) {
                String path = locator.getPath();
                covPath = path + ".tdf";
            }
            if (covPath != null) {
                try {
                    if (new File(covPath).exists() || IGVHttpUtils.isURL(covPath) && IGVHttpUtils.resourceAvailable(new URL(covPath))) {
                        TDFReader reader = TDFReader.getReader(covPath);
                        TDFDataSource ds = new TDFDataSource(reader, 0, alignmentTrack.getName() + " coverage");
                        covTrack.setDataSource(ds);
                    }
                }
                catch (MalformedURLException e2) {
                    // empty catch block
                }
            }
            if (showSpliceJunctionTrack = PreferenceManager.getInstance().getAsBoolean("SAM.SHOW_JUNCTION_TRACK")) {
                SpliceJunctionFinderTrack spliceJunctionTrack = new SpliceJunctionFinderTrack(locator.getPath() + "_junctions", alignmentTrack.getName() + " Junctions", dataManager);
                spliceJunctionTrack.setHeight(60);
                spliceJunctionTrack.setPreferredHeight(60);
                spliceJunctionTrack.setVisible(showSpliceJunctionTrack);
                newTracks.add(spliceJunctionTrack);
                alignmentTrack.setSpliceJunctionTrack(spliceJunctionTrack);
            }
            newTracks.add(alignmentTrack);
        }
        catch (IndexNotFoundException e3) {
            MessageUtils.showMessage("<html>Could not find the index file for  <br><br>&nbsp;&nbsp;" + e3.getSamFile() + "<br><br>Note: The index file can be created using igvtools and must be in the same directory as the .sam file.");
        }
    }

    private void loadMutFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        MutationParser parser = new MutationParser();
        List<FeatureTrack> mutationTracks = parser.loadMutationTracks(locator, genome);
        for (FeatureTrack track : mutationTracks) {
            track.setTrackType(TrackType.MUTATION);
            track.setRendererClass(MutationRenderer.class);
            newTracks.add(track);
        }
    }

    private void loadSegFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        SegmentedAsciiDataSet ds = new SegmentedAsciiDataSet(locator, genome);
        String path = locator.getPath();
        TrackProperties props = ds.getTrackProperties();
        if (ds.getSampleNames().size() > 1) {
            FreqData fd = new FreqData(ds, genome);
            String freqTrackId = path;
            String freqTrackName = new File(path).getName();
            CNFreqTrack freqTrack = new CNFreqTrack(locator, freqTrackId, freqTrackName, fd);
            newTracks.add(freqTrack);
        }
        for (String trackName : ds.getDataHeadings()) {
            String trackId = path + "_" + trackName;
            SegmentedDataSource dataSource = new SegmentedDataSource(trackName, ds);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource, genome);
            track.setRendererClass(HeatmapRenderer.class);
            track.setTrackType(ds.getType());
            if (props != null) {
                track.setProperties(props);
            }
            newTracks.add(track);
        }
    }

    private void loadBinarySegFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        SegmentedBinaryDataSet ds = new SegmentedBinaryDataSet(locator);
        String path = locator.getPath();
        FreqData fd = new FreqData(ds, genome);
        String freqTrackId = path;
        String freqTrackName = new File(path).getName();
        CNFreqTrack freqTrack = new CNFreqTrack(locator, freqTrackId, freqTrackName, fd);
        newTracks.add(freqTrack);
        for (String trackName : ds.getSampleNames()) {
            String trackId = path + "_" + trackName;
            SegmentedDataSource dataSource = new SegmentedDataSource(trackName, ds);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource, genome);
            track.setRendererClass(HeatmapRenderer.class);
            track.setTrackType(ds.getType());
            newTracks.add(track);
        }
    }

    private void loadH5File(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        TrackSet trackSet = null;
        String fName = locator.getTrackName();
        HDFDataManager dataManager = HDFDataManagerFactory.getDataManager(locator);
        TrackProperties trackProperties = dataManager.getTrackProperties();
        String[] trackNames = dataManager.getTrackNames();
        ArrayList<Track> tracks = new ArrayList<Track>();
        for (int trackNumber = 0; trackNumber < trackNames.length; ++trackNumber) {
            String name = trackNames.length == 1 ? fName : trackNames[trackNumber];
            HDFDataTrack track = null;
            try {
                track = new HDFDataTrack(dataManager, locator, name, trackNumber, genome);
            }
            catch (FileNotFoundException fe) {
                throw new RuntimeException(fe);
            }
            if (trackProperties != null) {
                track.setProperties(trackProperties);
            }
            tracks.add(track);
        }
        trackSet = new TrackSet(tracks);
        if (trackSet.isEmpty()) {
            throw new RuntimeException("No data found in file");
        }
        newTracks.addAll(trackSet.getTracks());
    }

    private void loadDASResource(ResourceLocator locator, List<Track> currentTracks) {
        DASFeatureSource featureSource = null;
        try {
            featureSource = new DASFeatureSource(locator);
        }
        catch (MalformedURLException e2) {
            log.error("Malformed URL", e2);
            throw new DataLoadException("Error: Malformed URL ", locator.getPath());
        }
        FeatureTrack track = new FeatureTrack(locator, featureSource);
        String name = locator.getPath();
        name = locator.getPath().contains("genome.ucsc.edu") ? featureSource.getType() : featureSource.getPath().replace("/das/", "").replace("/features", "");
        track.setName(name);
        if (locator.getPath().contains("cosmic")) {
            track.setRendererClass(CosmicFeatureRenderer.class);
            track.setMinimumHeight(2);
            track.setHeight(20);
            track.setPreferredHeight(20);
            track.setDisplayMode(Track.DisplayMode.EXPANDED);
        } else {
            track.setRendererClass(IGVFeatureRenderer.class);
            track.setMinimumHeight(35);
            track.setHeight(45);
            track.setPreferredHeight(45);
        }
        currentTracks.add(track);
    }

    private void loadTrioData(ResourceLocator locator) throws IOException {
        PedigreeUtils.parseTrioFile(locator.getPath());
    }

    public static boolean isIndexed(String path) {
        String indexExtension = path.endsWith("gz") ? ".tbi" : ".idx";
        String indexPath = path + indexExtension;
        try {
            if (IGVHttpUtils.isURL(path)) {
                return IGVHttpUtils.resourceAvailable(new URL(indexPath));
            }
            File f2 = new File(path + indexExtension);
            return f2.exists();
        }
        catch (IOException e2) {
            return false;
        }
    }
}

