/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.lists.GeneList;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionReader;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterElement;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SessionWriter {
    static Logger log = Logger.getLogger(SessionWriter.class);
    Session session;
    private static int CURRENT_VERSION = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSession(Session session, File outputFile) throws IOException {
        RuntimeException e2;
        if (session == null) {
            e2 = new RuntimeException("No session found to save!");
            log.error("Session Management Error", e2);
        }
        this.session = session;
        if (outputFile == null) {
            e2 = new RuntimeException("Can't save session file: " + outputFile);
            log.error("Session Management Error", e2);
        }
        String xmlString = this.createXmlFromSession(session, outputFile);
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(outputFile);
            fileWriter.write(xmlString);
        }
        finally {
            if (fileWriter != null) {
                fileWriter.close();
            }
        }
    }

    public String createXmlFromSession(Session session, File outputFile) throws RuntimeException {
        String xmlString = null;
        try {
            String groupBy;
            String locus;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            document.setStrictErrorChecking(true);
            Element globalElement = document.createElement(SessionReader.SessionElement.SESSION.getText());
            globalElement.setAttribute(SessionReader.SessionAttribute.VERSION.getText(), String.valueOf(CURRENT_VERSION));
            String genome = IGV.getInstance().getGenomeManager().getGenomeId();
            if (genome != null) {
                globalElement.setAttribute(SessionReader.SessionAttribute.GENOME.getText(), genome);
            }
            if ((locus = session.getLocusString()) != null && !FrameManager.isGeneListMode()) {
                globalElement.setAttribute(SessionReader.SessionAttribute.LOCUS.getText(), locus);
            }
            if ((groupBy = IGV.getInstance().getTrackManager().getGroupByAttribute()) != null) {
                globalElement.setAttribute(SessionReader.SessionAttribute.GROUP_TRACKS_BY.getText(), groupBy);
            }
            if (session.isRemoveEmptyTracks()) {
                globalElement.setAttribute("removeEmptyTracks", "true");
            }
            this.writeResources(outputFile, globalElement, document);
            this.writePanels(globalElement, document);
            this.writePanelLayout(globalElement, document);
            this.writeRegionsOfInterest(globalElement, document);
            this.writeFilters(session, globalElement, document);
            if (FrameManager.isGeneListMode()) {
                this.writeGeneList(globalElement, document);
            }
            if (session.getHiddenAttributes() != null && session.getHiddenAttributes().size() > 0) {
                this.writeHiddenAttributes(session, globalElement, document);
            }
            document.appendChild(globalElement);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            StreamResult streamResult = new StreamResult(new StringWriter());
            DOMSource source = new DOMSource(document);
            transformer.transform(source, streamResult);
            xmlString = streamResult.getWriter().toString();
        }
        catch (Exception e2) {
            String message = "An error has occurred while trying to create the session!";
            log.error(message, e2);
            JOptionPane.showMessageDialog(IGV.getMainFrame(), message);
            throw new RuntimeException(e2);
        }
        return xmlString;
    }

    private void writeFilters(Session session, Element globalElement, Document document) {
        TrackFilter trackFilter = session.getFilter();
        if (trackFilter != null) {
            Element filter = document.createElement(SessionReader.SessionElement.FILTER.getText());
            filter.setAttribute(SessionReader.SessionAttribute.NAME.getText(), trackFilter.getName());
            if (IGV.getInstance().isFilterMatchAll()) {
                filter.setAttribute(SessionReader.SessionAttribute.FILTER_MATCH.getText(), "all");
            } else if (!IGV.getInstance().isFilterMatchAll()) {
                filter.setAttribute(SessionReader.SessionAttribute.FILTER_MATCH.getText(), "any");
            } else {
                filter.setAttribute(SessionReader.SessionAttribute.FILTER_MATCH.getText(), "all");
            }
            if (IGV.getInstance().isFilterShowAllTracks()) {
                filter.setAttribute(SessionReader.SessionAttribute.FILTER_SHOW_ALL_TRACKS.getText(), "true");
            } else {
                filter.setAttribute(SessionReader.SessionAttribute.FILTER_SHOW_ALL_TRACKS.getText(), "false");
            }
            globalElement.appendChild(filter);
            Iterator iterator = session.getFilter().getFilterElements();
            while (iterator.hasNext()) {
                TrackFilterElement trackFilterElement = (TrackFilterElement)iterator.next();
                Element filterElementElement = document.createElement(SessionReader.SessionElement.FILTER_ELEMENT.getText());
                filterElementElement.setAttribute(SessionReader.SessionAttribute.ITEM.getText(), trackFilterElement.getSelectedItem());
                filterElementElement.setAttribute(SessionReader.SessionAttribute.OPERATOR.getText(), trackFilterElement.getComparisonOperator().getValue());
                filterElementElement.setAttribute(SessionReader.SessionAttribute.VALUE.getText(), trackFilterElement.getValue());
                filterElementElement.setAttribute(SessionReader.SessionAttribute.BOOLEAN_OPERATOR.getText(), trackFilterElement.getBooleanOperator().getValue());
                filter.appendChild(filterElementElement);
            }
        }
    }

    private void writeRegionsOfInterest(Element globalElement, Document document) {
        Collection<RegionOfInterest> regions = this.session.getAllRegionsOfInterest();
        if (regions != null && !regions.isEmpty()) {
            Element regionsElement = document.createElement(SessionReader.SessionElement.REGIONS.getText());
            for (RegionOfInterest region : regions) {
                Element regionElement = document.createElement(SessionReader.SessionElement.REGION.getText());
                regionElement.setAttribute(SessionReader.SessionAttribute.CHROMOSOME.getText(), region.getChr());
                regionElement.setAttribute(SessionReader.SessionAttribute.START_INDEX.getText(), String.valueOf(region.getStart()));
                regionElement.setAttribute(SessionReader.SessionAttribute.END_INDEX.getText(), String.valueOf(region.getEnd()));
                if (region.getDescription() != null) {
                    regionElement.setAttribute(SessionReader.SessionAttribute.DESCRIPTION.getText(), region.getDescription());
                }
                regionsElement.appendChild(regionElement);
            }
            globalElement.appendChild(regionsElement);
        }
    }

    private void writeHiddenAttributes(Session session, Element globalElement, Document document) {
        Element hiddenAttributes = document.createElement(SessionReader.SessionElement.HIDDEN_ATTRIBUTES.getText());
        for (String attribute : session.getHiddenAttributes()) {
            Element regionElement = document.createElement(SessionReader.SessionElement.ATTRIBUTE.getText());
            regionElement.setAttribute(SessionReader.SessionAttribute.NAME.getText(), attribute);
            hiddenAttributes.appendChild(regionElement);
        }
        globalElement.appendChild(hiddenAttributes);
    }

    private void writeGeneList(Element globalElement, Document document) {
        GeneList geneList = this.session.getCurrentGeneList();
        if (geneList != null) {
            Element geneListElement = document.createElement(SessionReader.SessionElement.GENE_LIST.getText());
            geneListElement.setAttribute(SessionReader.SessionAttribute.NAME.getText(), geneList.getName());
            StringBuffer genes = new StringBuffer();
            for (String gene : geneList.getLoci()) {
                genes.append(gene);
                genes.append("\n");
            }
            geneListElement.setTextContent(genes.toString());
            globalElement.appendChild(geneListElement);
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                Element frameElement = document.createElement(SessionReader.SessionElement.FRAME.getText());
                frameElement.setAttribute(SessionReader.SessionAttribute.NAME.getText(), frame.getName());
                frameElement.setAttribute(SessionReader.SessionAttribute.CHR.getText(), frame.getChrName());
                frameElement.setAttribute(SessionReader.SessionAttribute.START.getText(), String.valueOf(frame.getOrigin()));
                frameElement.setAttribute(SessionReader.SessionAttribute.END.getText(), String.valueOf(frame.getEnd()));
                geneListElement.appendChild(frameElement);
            }
        }
    }

    private void writeResources(File outputFile, Element globalElement, Document document) {
        Collection<ResourceLocator> resourceLocators = this.getResourceLocatorSet();
        if (resourceLocators != null && !resourceLocators.isEmpty()) {
            Element filesElement = document.createElement(SessionReader.SessionElement.RESOURCES.getText());
            String isRelativeDataFile = "false";
            String filepath = null;
            for (ResourceLocator resourceLocator : resourceLocators) {
                if (!resourceLocator.exists() && resourceLocator.getPath() == null) continue;
                Element dataFileElement = document.createElement(SessionReader.SessionElement.RESOURCE.getText());
                if (resourceLocator.isLocal() && !(filepath = FileUtils.getRelativePath(outputFile.getParentFile(), resourceLocator.getPath())).equals(resourceLocator.getPath())) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.RELATIVE_PATH.getText(), isRelativeDataFile);
                }
                dataFileElement.setAttribute(SessionReader.SessionAttribute.PATH.getText(), resourceLocator.getPath());
                if (resourceLocator.getName() != null) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.NAME.getText(), resourceLocator.getName());
                }
                if (resourceLocator.getServerURL() != null) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.SERVER_URL.getText(), resourceLocator.getServerURL());
                }
                if (resourceLocator.getInfolink() != null) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.HYPERLINK.getText(), resourceLocator.getInfolink());
                }
                if (resourceLocator.getUrl() != null) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.FEATURE_URL.getText(), resourceLocator.getUrl());
                }
                if (resourceLocator.getDescription() != null) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.DESCRIPTION.getText(), resourceLocator.getDescription());
                }
                if (resourceLocator.getType() != null) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.TYPE.getText(), resourceLocator.getType());
                }
                if (resourceLocator.getCoverage() != null) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.COVERAGE.getText(), resourceLocator.getCoverage());
                }
                if (resourceLocator.getTrackLine() != null) {
                    dataFileElement.setAttribute(SessionReader.SessionAttribute.TRACK_LINE.getText(), resourceLocator.getTrackLine());
                }
                filesElement.appendChild(dataFileElement);
            }
            globalElement.appendChild(filesElement);
        }
    }

    private void writePanels(Element globalElement, Document document) throws DOMException {
        for (TrackPanel trackPanel : IGV.getInstance().getTrackPanels()) {
            List<Track> tracks = trackPanel.getTracks();
            if (tracks == null || tracks.isEmpty()) continue;
            Element panelElement = document.createElement(SessionReader.SessionElement.PANEL.getText());
            panelElement.setAttribute("name", trackPanel.getName());
            panelElement.setAttribute("height", String.valueOf(trackPanel.getHeight()));
            panelElement.setAttribute("width", String.valueOf(trackPanel.getWidth()));
            for (Track track : tracks) {
                DataRange dr;
                Element trackElement = document.createElement(SessionReader.SessionElement.TRACK.getText());
                trackElement.setAttribute(SessionReader.SessionAttribute.ID.getText(), track.getId());
                trackElement.setAttribute(SessionReader.SessionAttribute.NAME.getText(), track.getName());
                for (Map.Entry<String, String> attrValue : track.getPersistentState().entrySet()) {
                    trackElement.setAttribute(attrValue.getKey(), attrValue.getValue());
                }
                if (track.hasDataRange() && (dr = track.getDataRange()) != null) {
                    Element drElement = document.createElement(SessionReader.SessionElement.DATA_RANGE.getText());
                    for (Map.Entry<String, String> attrValue : dr.getPersistentState().entrySet()) {
                        drElement.setAttribute(attrValue.getKey(), attrValue.getValue());
                    }
                    trackElement.appendChild(drElement);
                }
                panelElement.appendChild(trackElement);
            }
            globalElement.appendChild(panelElement);
        }
    }

    private void writePanelLayout(Element globalElement, Document document) {
        double[] dividerFractions = IGV.getInstance().getMainPanel().getDividerFractions();
        if (dividerFractions.length > 0) {
            Element panelLayout = document.createElement(SessionReader.SessionElement.PANEL_LAYOUT.getText());
            globalElement.appendChild(panelLayout);
            StringBuffer locString = new StringBuffer();
            locString.append(String.valueOf(dividerFractions[0]));
            for (int i2 = 1; i2 < dividerFractions.length; ++i2) {
                locString.append("," + dividerFractions[i2]);
            }
            panelLayout.setAttribute("dividerFractions", locString.toString());
        }
    }

    public Collection<ResourceLocator> getResourceLocatorSet() {
        Set<ResourceLocator> loadedAttributeResources;
        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
        Set<ResourceLocator> currentTrackFileLocators = IGV.getInstance().getTrackManager().getDataResourceLocators();
        if (currentTrackFileLocators != null) {
            for (ResourceLocator locator : currentTrackFileLocators) {
                locators.add(locator);
            }
        }
        if ((loadedAttributeResources = AttributeManager.getInstance().getLoadedResources()) != null) {
            for (ResourceLocator attributeLocator : loadedAttributeResources) {
                locators.add(attributeLocator);
            }
        }
        return locators;
    }
}

