/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.peaks;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.peaks.Peak;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.ParsingUtils;

public class PeakParser {
    private int nTimePoints;
    private String[] timePointHeadings;
    String[] timeSignalPaths;
    private TrackProperties trackProperties;
    private String signalPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Peak> loadPeaks(String path) throws IOException {
        ArrayList<Peak> peaks = new ArrayList<Peak>(25000);
        BufferedReader reader = null;
        try {
            String[] tokens;
            String nextLine;
            reader = ParsingUtils.openBufferedReader(path);
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("#")) {
                    if (nextLine.startsWith("#signals")) {
                        tokens = nextLine.split("=");
                        if (tokens.length <= 1) continue;
                        this.signalPath = tokens[1];
                        continue;
                    }
                    if (nextLine.startsWith("#timeSignals")) {
                        tokens = nextLine.split("=");
                        if (tokens.length <= 1) continue;
                        this.timeSignalPaths = tokens[1].split(",");
                        continue;
                    }
                    if (!nextLine.startsWith("#track")) continue;
                    this.trackProperties = new TrackProperties();
                    ParsingUtils.parseTrackLine(nextLine, this.trackProperties);
                    continue;
                }
                tokens = nextLine.split("\t");
                if (tokens.length < 7) {
                    throw new RuntimeException("Not enough columns for peak file. At least 2 time points are required");
                }
                this.nTimePoints = tokens.length - 5;
                this.timePointHeadings = new String[this.nTimePoints];
                break;
            }
            while ((nextLine = reader.readLine()) != null) {
                tokens = nextLine.split("\t");
                String chr = tokens[0];
                int start = Integer.parseInt(tokens[1]);
                int end = Integer.parseInt(tokens[2]);
                String name = tokens[3];
                float combinedScore = Float.parseFloat(tokens[4]);
                float[] timePointScores = new float[this.nTimePoints];
                for (int i2 = 0; i2 < this.nTimePoints; ++i2) {
                    timePointScores[i2] = Float.parseFloat(tokens[5 + i2]);
                }
                peaks.add(new Peak(chr, start, end, name, combinedScore, timePointScores));
            }
            ArrayList<Peak> arrayList = peaks;
            return arrayList;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public int getnTimePoints() {
        return this.nTimePoints;
    }

    public String[] getTimePointHeadings() {
        return this.timePointHeadings;
    }

    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public String getSignalPath() {
        return this.signalPath;
    }
}

