/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.feature.genome.GenomeResourceDescriptor;
import org.broad.igv.feature.genome.GenomeServerException;
import org.broad.igv.feature.genome.GenomeZipDescriptor;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.IGVHttpUtils;
import org.broad.igv.util.Utilities;

public class GenomeManager {
    public static final String SEQUENCE_FILE_EXTENSION = ".txt";
    private static Logger log = Logger.getLogger(GenomeManager.class);
    private Map<String, GenomeDescriptor> genomeDescriptorMap = new HashMap<String, GenomeDescriptor>();
    public static final String USER_DEFINED_GENOME_LIST_FILE = "user-defined-genomes.txt";
    private static GenomeDescriptor DEFAULT_GENOME;
    public Genome currentGenome;
    private List<GenomeListItem> userDefinedGenomeArchiveList;
    private List<GenomeListItem> cachedGenomeArchiveList;
    private List<GenomeListItem> serverGenomeArchiveList;
    IGV igv;
    boolean serverGenomeListUnreachable = false;

    public GenomeManager(IGV igv) {
        this.igv = igv;
    }

    public GenomeManager() {
        this.igv = null;
    }

    public Genome getGenome(String id) {
        if (this.currentGenome == null || !this.currentGenome.getId().equals(id)) {
            GenomeDescriptor genomeDescriptor = this.genomeDescriptorMap.get(id);
            if (genomeDescriptor == null) {
                return null;
            }
            this.loadGenome(genomeDescriptor);
        }
        return this.currentGenome;
    }

    private Genome loadGenome(GenomeDescriptor genomeDescriptor) {
        InputStream is = null;
        try {
            BufferedReader reader;
            InputStream inputStream = genomeDescriptor.getCytoBandStream();
            if (inputStream == null) {
                Genome genome = null;
                return genome;
            }
            if (genomeDescriptor.isCytoBandFileGZipFormat()) {
                is = new GZIPInputStream(inputStream);
                reader = new BufferedReader(new InputStreamReader(is));
            } else {
                is = new BufferedInputStream(inputStream);
                reader = new BufferedReader(new InputStreamReader(is));
            }
            this.currentGenome = new Genome(genomeDescriptor);
            LinkedHashMap<String, Chromosome> chromMap = CytoBandFileParser.loadData(reader);
            this.currentGenome.setChromosomeMap(chromMap, genomeDescriptor.isChromosomesAreOrdered());
            this.currentGenome.setAnnotationURL(genomeDescriptor.getUrl());
            InputStream aliasStream = genomeDescriptor.getChrAliasStream();
            if (aliasStream != null) {
                try {
                    reader = new BufferedReader(new InputStreamReader(aliasStream));
                    this.currentGenome.loadChrAliases(reader);
                }
                catch (Exception e2) {
                    log.error("Error loading chromosome alias table");
                }
            }
            this.currentGenome.loadUserDefinedAliases();
            Genome genome = this.currentGenome;
            return genome;
        }
        catch (IOException ex) {
            log.warn("Error loading the genome!", ex);
            throw new RuntimeException("Error loading genome: " + genomeDescriptor.getName());
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing zip stream!", ex);
            }
        }
    }

    public GenomeListItem loadGenomeFromLocalFile(File zipFile) {
        GenomeListItem genomeListItem = null;
        try {
            boolean isUserDefined = false;
            File parentFolder = zipFile.getParentFile();
            if (parentFolder == null || !parentFolder.equals(Globals.getGenomeCacheDirectory())) {
                isUserDefined = true;
            }
            GenomeDescriptor genomeDescriptor = this.createGenomeDescriptor(zipFile, isUserDefined);
            this.loadGenome(genomeDescriptor);
            this.genomeDescriptorMap.put(genomeDescriptor.getId(), genomeDescriptor);
            genomeListItem = new GenomeListItem(genomeDescriptor.getName(), genomeDescriptor.getSequenceLocation(), genomeDescriptor.getId(), genomeDescriptor.getVersion(), isUserDefined);
        }
        catch (Exception e2) {
            log.warn("Error loading genome archive: " + zipFile, e2);
        }
        return genomeListItem;
    }

    public void loadGenomeByID(String genome) throws IOException {
        LinkedHashSet<GenomeListItem> genomes = this.getAllGenomeArchives();
        for (GenomeListItem item : genomes) {
            if (!item.getId().equalsIgnoreCase(genome)) continue;
            String url = item.getLocation();
            this.loadGenome(url, item.isUserDefined(), null);
        }
    }

    public GenomeListItem loadGenome(String genomeArchiveFileLocation, boolean isUserDefined, ProgressMonitor monitor) throws FileNotFoundException {
        if (log.isDebugEnabled()) {
            log.debug("Enter loadGenome");
        }
        GenomeListItem genomeListItem = null;
        if (genomeArchiveFileLocation == null) {
            this.loadGenome(this.getDefaultGenomeDescriptor());
            return this.getDefaultGenomeListItem();
        }
        if (!genomeArchiveFileLocation.trim().endsWith(".genome")) {
            throw new RuntimeException("The extension of archive [" + genomeArchiveFileLocation + "] is not an IGV genome archive extension");
        }
        try {
            File archiveFile;
            if (!isUserDefined) {
                if (!Globals.getGenomeCacheDirectory().exists()) {
                    Globals.getGenomeCacheDirectory().mkdir();
                }
                if (IGVHttpUtils.isURL(genomeArchiveFileLocation.toLowerCase())) {
                    URL genomeArchiveURL = new URL(genomeArchiveFileLocation);
                    String fileName = Utilities.getFileNameFromURL(URLDecoder.decode(new URL(genomeArchiveFileLocation).getFile(), "UTF-8"));
                    archiveFile = new File(Globals.getGenomeCacheDirectory(), fileName);
                    this.refreshCache(archiveFile, genomeArchiveURL);
                } else {
                    archiveFile = new File(genomeArchiveFileLocation);
                }
                if (!archiveFile.exists()) {
                    throw new FileNotFoundException(genomeArchiveFileLocation);
                }
            } else {
                String record;
                archiveFile = new File(genomeArchiveFileLocation);
                if (!archiveFile.exists()) {
                    throw new FileNotFoundException(genomeArchiveFileLocation);
                }
                File userDefinedListFile = new File(Globals.getGenomeCacheDirectory(), USER_DEFINED_GENOME_LIST_FILE);
                Properties listProperties = GenomeManager.retrieveUserDefinedGenomeListFromFile(userDefinedListFile);
                if (listProperties == null) {
                    listProperties = new Properties();
                }
                if ((record = this.buildClientSideGenomeListRecord(archiveFile, isUserDefined)) != null) {
                    int version = 0;
                    String[] fields = record.split("\t");
                    listProperties.setProperty(fields[2], record);
                    GenomeImporter.storeUserDefinedGenomeListToFile(userDefinedListFile, listProperties);
                    genomeListItem = new GenomeListItem(fields[0], fields[1], fields[2], version, isUserDefined);
                }
            }
            if (monitor != null) {
                monitor.fireProgressChange(25);
            }
            this.loadGenomeFromLocalFile(archiveFile);
            if (monitor != null) {
                monitor.fireProgressChange(25);
            }
        }
        catch (MalformedURLException e2) {
            log.warn("Error Importing Genome!", e2);
        }
        catch (FileNotFoundException e3) {
            throw e3;
        }
        catch (SocketException e4) {
            throw new GenomeServerException("Server connection error", e4);
        }
        catch (IOException e5) {
            log.warn("Error Importing Genome!", e5);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit loadGenome");
        }
        return genomeListItem;
    }

    private void refreshCache(File archiveFile, URL genomeArchiveURL) {
        try {
            if (archiveFile.exists()) {
                boolean forceUpdate;
                long fileLength = archiveFile.length();
                long contentLength = IGVHttpUtils.getContentLength(genomeArchiveURL);
                if (contentLength <= 0L) {
                    log.info("Skipping genome update of " + archiveFile.getName() + " due to unknown content length");
                }
                boolean bl = forceUpdate = contentLength != fileLength && PreferenceManager.getInstance().getAsBoolean("AUTO_UPDATE_GENOMES");
                if (forceUpdate) {
                    log.info("Refreshing genome: " + genomeArchiveURL.toString());
                    File tmpFile = new File(archiveFile.getAbsolutePath() + ".tmp");
                    if (IGVHttpUtils.downloadFile(genomeArchiveURL, tmpFile)) {
                        FileUtils.copyFile(tmpFile, archiveFile);
                        tmpFile.deleteOnExit();
                    }
                }
            } else {
                IGVHttpUtils.downloadFile(genomeArchiveURL, archiveFile);
            }
        }
        catch (Exception e2) {
            log.error("Error refreshing genome cache. ", e2);
            MessageUtils.showMessage("An error was encountered refreshing the genome cache: " + e2.getMessage() + "<br> If this problem persists please contact igv-help@broadinstitute.org");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenomeDescriptor createGenomeDescriptor(File f2, boolean userDefined) throws IOException {
        String zipFilePath = f2.getAbsolutePath();
        if (!f2.exists()) {
            log.error("Genome file: " + f2.getAbsolutePath() + " does not exist.");
            return null;
        }
        GenomeZipDescriptor genomeDescriptor = null;
        HashMap<String, ZipEntry> zipEntries = new HashMap<String, ZipEntry>();
        ZipFile zipFile = new ZipFile(zipFilePath);
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(f2));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                zipEntries.put(zipEntryName, zipEntry);
                if (zipEntryName.equalsIgnoreCase("property.txt")) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String cytobandZipEntryName = properties.getProperty("cytobandFile");
                    String geneFileName = properties.getProperty("geneFile");
                    String chrAliasFileName = properties.getProperty("chrAliasFile");
                    String sequenceLocation = properties.getProperty("sequenceLocation");
                    if (sequenceLocation != null && !IGVHttpUtils.isURL(sequenceLocation)) {
                        File sequenceFolder = null;
                        if (sequenceLocation.startsWith("/") || sequenceLocation.startsWith("\\")) {
                            sequenceFolder = new File(sequenceLocation);
                        } else {
                            File tempZipFile = new File(zipFilePath);
                            sequenceFolder = new File(tempZipFile.getParent(), sequenceLocation);
                        }
                        sequenceLocation = sequenceFolder.getCanonicalPath();
                        sequenceLocation.replace('\\', '/');
                    }
                    int version = 0;
                    String versionString = properties.getProperty("version");
                    if (versionString != null) {
                        try {
                            version = Integer.parseInt(versionString);
                        }
                        catch (Exception e2) {
                            log.error("Error parsing version string: " + versionString);
                        }
                    }
                    boolean chrNamesAltered = false;
                    String chrNamesAlteredString = properties.getProperty("filenamesAltered");
                    if (chrNamesAlteredString != null) {
                        try {
                            chrNamesAltered = Boolean.parseBoolean(chrNamesAlteredString);
                        }
                        catch (Exception e3) {
                            log.error("Error parsing version string: " + versionString);
                        }
                    }
                    boolean chromosomesAreOrdered = false;
                    String tmp = properties.getProperty("ordered");
                    if (tmp != null) {
                        try {
                            chromosomesAreOrdered = Boolean.parseBoolean(tmp);
                        }
                        catch (Exception e4) {
                            log.error("Error parsing ordered string: " + tmp);
                        }
                    }
                    String url = properties.getProperty("url");
                    genomeDescriptor = new GenomeZipDescriptor(properties.getProperty("name"), version, chrNamesAltered, properties.getProperty("id"), cytobandZipEntryName, geneFileName, chrAliasFileName, properties.getProperty("geneTrackName", "Gene"), sequenceLocation, zipFile, zipEntries, userDefined, chromosomesAreOrdered);
                    if (url != null) {
                        genomeDescriptor.setUrl(url);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing imported genome zip stream!", ex);
            }
        }
        return genomeDescriptor;
    }

    public GenomeDescriptor getGenomeDescriptor(String id) {
        if (this.genomeDescriptorMap.containsKey(id)) {
            return this.genomeDescriptorMap.get(id);
        }
        return this.getDefaultGenomeDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenomeListItem> getServerGenomeArchiveList(Set excludedArchivesUrls) throws IOException {
        if (this.serverGenomeListUnreachable) {
            return null;
        }
        if (this.serverGenomeArchiveList == null) {
            this.serverGenomeArchiveList = new LinkedList<GenomeListItem>();
            BufferedReader dataReader = null;
            InputStream inputStream = null;
            String genomeListURLString = "";
            try {
                String genomeRecord;
                genomeListURLString = PreferenceManager.getInstance().getGenomeListURL();
                URL serverGenomeURL = new URL(genomeListURLString);
                if (IGVHttpUtils.isURL(genomeListURLString)) {
                    inputStream = IGVHttpUtils.openConnectionStream(serverGenomeURL);
                } else {
                    File file = new File(genomeListURLString.startsWith("file:") ? serverGenomeURL.getFile() : genomeListURLString);
                    inputStream = new FileInputStream(file);
                }
                dataReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((genomeRecord = dataReader.readLine()) != null) {
                    if (genomeRecord.startsWith("<") || genomeRecord.startsWith("(#") || genomeRecord == null) continue;
                    String[] fields = (genomeRecord = genomeRecord.trim()).split("\t");
                    if (fields != null && fields.length >= 3) {
                        if (excludedArchivesUrls != null && excludedArchivesUrls.contains(fields[1])) continue;
                        int version = 0;
                        if (fields.length > 3) {
                            try {
                                version = Integer.parseInt(fields[3]);
                            }
                            catch (Exception e2) {
                                log.error("Error parsing genome version: " + fields[0], e2);
                            }
                        }
                        String name = fields[0];
                        String url = fields[1];
                        String id = fields[2];
                        boolean valid = true;
                        if (url.length() == 0) {
                            log.error("Genome entry : " + name + " has an empty URL string.  Check for extra tabs in the definition file: " + PreferenceManager.getInstance().getGenomeListURL());
                            valid = false;
                        }
                        if (!valid) continue;
                        try {
                            GenomeListItem item = new GenomeListItem(fields[0], fields[1], fields[2], version, false);
                            this.serverGenomeArchiveList.add(item);
                        }
                        catch (Exception e3) {
                            log.error("Error reading a line from server genome list line was: [" + genomeRecord + "]", e3);
                        }
                        continue;
                    }
                    log.error("Found invalid server genome list record: " + genomeRecord);
                }
            }
            catch (Exception e4) {
                this.serverGenomeListUnreachable = true;
                log.error("Error fetching genome list: ", e4);
                ConfirmDialog.optionallyShowInfoDialog("Warning: could not connect to the genome server (" + genomeListURLString + ").    Only locally defined genomes will be available.", "SHOW_GENOME_SERVER_WARNING");
            }
            finally {
                if (dataReader != null) {
                    dataReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.serverGenomeArchiveList;
    }

    public List<GenomeListItem> getUserDefinedGenomeArchiveList() throws IOException {
        if (this.userDefinedGenomeArchiveList == null) {
            boolean updateClientGenomeListFile = false;
            this.userDefinedGenomeArchiveList = new LinkedList<GenomeListItem>();
            File listFile = new File(Globals.getGenomeCacheDirectory(), USER_DEFINED_GENOME_LIST_FILE);
            Properties listProperties = GenomeManager.retrieveUserDefinedGenomeListFromFile(listFile);
            if (listProperties != null) {
                Collection<Object> records = listProperties.values();
                for (Object value : records) {
                    String[] fields;
                    File file;
                    String record = (String)value;
                    if (record.trim().equals("") || (file = new File((fields = record.split("\t"))[1])).isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
                    if (!file.exists()) {
                        updateClientGenomeListFile = true;
                        continue;
                    }
                    GenomeListItem item = new GenomeListItem(fields[0], file.getAbsolutePath(), fields[2], 0, true);
                    this.userDefinedGenomeArchiveList.add(item);
                }
            }
            if (updateClientGenomeListFile) {
                this.updateImportedGenomePropertyFile();
            }
        }
        return this.userDefinedGenomeArchiveList;
    }

    public void clearGenomeCache() {
        File[] files;
        for (File file : files = Globals.getGenomeCacheDirectory().listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".genome")) continue;
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenomeListItem> getCachedGenomeArchiveList() throws IOException {
        if (this.cachedGenomeArchiveList == null) {
            File[] files;
            this.cachedGenomeArchiveList = new LinkedList<GenomeListItem>();
            if (!Globals.getGenomeCacheDirectory().exists()) {
                return this.cachedGenomeArchiveList;
            }
            for (File file : files = Globals.getGenomeCacheDirectory().listFiles()) {
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
                URL zipUrl = file.toURI().toURL();
                ZipFile zipFile = null;
                FileInputStream fis = null;
                ZipInputStream zipInputStream = null;
                try {
                    zipFile = new ZipFile(file);
                    fis = new FileInputStream(file);
                    zipInputStream = new ZipInputStream(new BufferedInputStream(fis));
                    ZipEntry zipEntry = zipFile.getEntry("property.txt");
                    if (zipEntry == null) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    int version = 0;
                    if (properties.containsKey("version")) {
                        try {
                            version = Integer.parseInt(properties.getProperty("version"));
                        }
                        catch (Exception e2) {
                            log.error("Error parsing genome version: " + version, e2);
                        }
                    }
                    GenomeListItem item = new GenomeListItem(properties.getProperty("name"), file.getAbsolutePath(), properties.getProperty("id"), version, false);
                    this.cachedGenomeArchiveList.add(item);
                }
                catch (ZipException ex) {
                    log.error("\nZip error unzipping cached genome.", ex);
                    try {
                        file.delete();
                        zipInputStream.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                catch (IOException ex) {
                    log.warn("\nIO error unzipping cached genome.", ex);
                    try {
                        file.delete();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException ex) {
                        log.warn("Error closing genome zip stream!", ex);
                    }
                }
            }
        }
        return this.cachedGenomeArchiveList;
    }

    public LinkedHashSet<GenomeListItem> getAllGenomeArchives() throws IOException {
        LinkedHashSet<GenomeListItem> genomeListItems = new LinkedHashSet<GenomeListItem>();
        List<GenomeListItem> userDefinedItemList = this.getUserDefinedGenomeArchiveList();
        if (userDefinedItemList != null) {
            genomeListItems.addAll(userDefinedItemList);
        }
        List<GenomeListItem> serverSideItemList = null;
        try {
            serverSideItemList = this.getServerGenomeArchiveList(null);
        }
        catch (UnknownHostException e2) {
            log.error("The Genome server is currently inaccessible.", e2);
        }
        catch (SocketException e3) {
            log.error("The Genome server is currently inaccessible.", e3);
        }
        if (serverSideItemList == null || serverSideItemList.isEmpty()) {
            serverSideItemList = this.getCachedGenomeArchiveList();
        }
        if (serverSideItemList != null) {
            genomeListItems.addAll(serverSideItemList);
        }
        if (genomeListItems.isEmpty()) {
            GenomeDescriptor defaultDes = this.getDefaultGenomeDescriptor();
            GenomeListItem defaultItem = new GenomeListItem(defaultDes.getName(), null, defaultDes.getId(), 0, false);
            genomeListItems.add(defaultItem);
            this.genomeDescriptorMap.put(defaultDes.getId(), defaultDes);
        }
        return genomeListItems;
    }

    public void updateImportedGenomePropertyFile() throws IOException {
        if (this.userDefinedGenomeArchiveList == null) {
            return;
        }
        File listFile = new File(Globals.getGenomeCacheDirectory(), USER_DEFINED_GENOME_LIST_FILE);
        if (!listFile.exists()) {
            listFile.createNewFile();
        }
        StringBuffer buffer = new StringBuffer();
        Properties listProperties = new Properties();
        for (GenomeListItem genomeListItem : this.userDefinedGenomeArchiveList) {
            buffer.append(genomeListItem.getDisplayableName());
            buffer.append("\t");
            buffer.append(genomeListItem.getLocation());
            buffer.append("\t");
            buffer.append(genomeListItem.getId());
            listProperties.setProperty(genomeListItem.getId(), buffer.toString());
            buffer.delete(0, buffer.length());
        }
        GenomeImporter.storeUserDefinedGenomeListToFile(listFile, listProperties);
    }

    public String buildClientSideGenomeListRecord(File genomeArchive, boolean userDefined) throws IOException {
        GenomeDescriptor genomeDescriptor = this.createGenomeDescriptor(genomeArchive, userDefined);
        StringBuffer buffer = new StringBuffer();
        buffer.append(genomeDescriptor.getName());
        buffer.append("\t");
        buffer.append(genomeArchive.getAbsoluteFile());
        buffer.append("\t");
        buffer.append(genomeDescriptor.getId());
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties retrieveUserDefinedGenomeListFromFile(File file) {
        Properties properties = new Properties();
        if (file != null && file.exists()) {
            FileInputStream input = null;
            try {
                input = new FileInputStream(file);
                properties.load(input);
            }
            catch (FileNotFoundException e2) {
                log.error("Property file for user-defined genomes was not found!", e2);
            }
            catch (IOException e3) {
                log.error("Error readin property file for user-defined genomes!", e3);
            }
            finally {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e4) {
                        log.error("Error closing property file for user-defined genomes!", e4);
                    }
                }
            }
        }
        return properties;
    }

    public GenomeListItem defineGenome(String genomeZipLocation, String cytobandFileName, String refFlatFileName, String fastaFileName, String chrAliasFileName, String relativeSequenceLocation, String genomeDisplayName, String genomeId, String genomeFileName, ProgressMonitor monitor, String sequenceOutputLocationOverride) throws IOException {
        File zipFileLocation = null;
        File fastaInputFile = null;
        File refFlatFile = null;
        File cytobandFile = null;
        File chrAliasFile = null;
        if (genomeZipLocation != null && genomeZipLocation.trim().length() != 0) {
            zipFileLocation = new File(genomeZipLocation);
            PreferenceManager.getInstance().setLastGenomeImportDirectory(zipFileLocation);
        }
        if (cytobandFileName != null && cytobandFileName.trim().length() != 0) {
            cytobandFile = new File(cytobandFileName);
        }
        if (refFlatFileName != null && refFlatFileName.trim().length() != 0) {
            refFlatFile = new File(refFlatFileName);
        }
        if (chrAliasFileName != null && chrAliasFileName.trim().length() != 0) {
            chrAliasFile = new File(chrAliasFileName);
        }
        if (fastaFileName != null && fastaFileName.trim().length() != 0) {
            File sequenceLocation;
            fastaInputFile = new File(fastaFileName);
            if (relativeSequenceLocation != null && relativeSequenceLocation.trim().length() != 0 && !(sequenceLocation = new File(genomeZipLocation, relativeSequenceLocation)).exists()) {
                sequenceLocation.mkdir();
            }
        }
        if (monitor != null) {
            monitor.fireProgressChange(25);
        }
        File archiveFile = new GenomeImporter().createGenomeArchive(zipFileLocation, genomeFileName, genomeId, genomeDisplayName, relativeSequenceLocation, fastaInputFile, refFlatFile, cytobandFile, chrAliasFile, sequenceOutputLocationOverride, monitor);
        if (monitor != null) {
            monitor.fireProgressChange(75);
        }
        if (log.isDebugEnabled()) {
            log.debug("Call loadGenome");
        }
        GenomeListItem newItem = this.loadGenome(archiveFile.getAbsolutePath(), true, null);
        this.userDefinedGenomeArchiveList.add(0, newItem);
        this.updateImportedGenomePropertyFile();
        return newItem;
    }

    public GenomeDescriptor getDefaultGenomeDescriptor() {
        if (DEFAULT_GENOME == null) {
            DEFAULT_GENOME = new GenomeResourceDescriptor("Human hg18", 0, "hg18", "/resources/hg18_cytoBand.txt", null, null, null, "http://www.broadinstitute.org/igv/sequence/hg18", false);
        }
        return DEFAULT_GENOME;
    }

    public GenomeListItem getDefaultGenomeListItem() {
        GenomeDescriptor desc = this.getDefaultGenomeDescriptor();
        return new GenomeListItem(desc.getName(), null, desc.getId(), 0, false);
    }

    public String getGenomeId() {
        return this.currentGenome == null ? null : this.currentGenome.getId();
    }

    public Genome getCurrentGenome() {
        return this.currentGenome;
    }

    public static class GenomeListItem {
        private int version;
        private String displayableName;
        private String location;
        private String id;
        private boolean isUserDefined = false;

        public GenomeListItem(String displayableName, String url, String id, int version, boolean isUserDefined) {
            this.displayableName = displayableName;
            this.location = url;
            this.id = id;
            this.version = version;
            this.isUserDefined = isUserDefined;
        }

        public String getDisplayableName() {
            return this.displayableName;
        }

        public String getId() {
            return this.id;
        }

        public String getLocation() {
            return this.location;
        }

        public boolean isUserDefined() {
            return this.isUserDefined;
        }

        public String toString() {
            return this.getDisplayableName();
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + (this.displayableName == null ? 0 : this.displayableName.trim().hashCode());
            hash = hash * 13 + (this.id == null ? 0 : this.id.trim().hashCode());
            return hash;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GenomeListItem)) {
                return false;
            }
            GenomeListItem item = (GenomeListItem)object;
            return this.getId().equals(item.getId());
        }
    }
}

