/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.expression;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.data.expression.GCTDataConsumer;
import org.broad.igv.data.expression.GCTDataset;
import org.broad.igv.data.expression.GeneToLocusHelper;
import org.broad.igv.exceptions.ParserException;
import org.broad.igv.exceptions.ProbeMappingException;
import org.broad.igv.feature.Locus;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.tools.StatusMonitor;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MagetabSignalDialog;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.collections.IntArrayList;
import org.broad.tribble.readers.AsciiLineReader;

public class GCTDatasetParser {
    private static Logger log = Logger.getLogger(GCTDatasetParser.class);
    ResourceLocator dataFileLocator;
    FileType type;
    int dataStartColumn;
    int probeColumn;
    int descriptionColumn;
    Genome genome;
    Map<String, Integer> longestProbeMap;
    private Map<String, Integer> headingIndexMap = new HashMap<String, Integer>();
    Map<String, List<Row>> rowMap = new HashMap<String, List<Row>>();
    StatusMonitor statusMonitor;
    GeneToLocusHelper locusHelper;

    public GCTDatasetParser(ResourceLocator resFile, String probeFile, Genome genome) throws IOException {
        this.dataFileLocator = resFile;
        this.genome = genome;
        this.longestProbeMap = new HashMap<String, Integer>();
        this.locusHelper = new GeneToLocusHelper(probeFile, genome);
    }

    public GCTDatasetParser(File resFile, String probeFile, Genome genome) throws IOException {
        this(new ResourceLocator(resFile.getAbsolutePath()), probeFile, genome);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean parsableMAGE_TAB(ResourceLocator file) throws IOException {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(file);
            String nextLine = null;
            reader.readLine();
            nextLine = reader.readLine();
            if (nextLine != null && (nextLine.contains("Reporter REF") || nextLine.contains("Composite Element REF") || nextLine.contains("Term Source REF") || nextLine.contains("CompositeElement REF") || nextLine.contains("TermSource REF") || nextLine.contains("Coordinates REF"))) {
                for (int count = 0; (nextLine = reader.readLine()) != null && count < 5; ++count) {
                    if (!(nextLine = nextLine.trim()).startsWith("SNP_A") && !nextLine.startsWith("CN_")) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return false;
    }

    public GCTDataset createDataset() {
        GCTDataset dataset = new GCTDataset(this.genome);
        this.parse(dataset);
        return dataset;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse(GCTDataset dataset) {
        String[] tokens = new String[100000];
        String fn = this.dataFileLocator.getPath().toLowerCase();
        if (fn.endsWith(".txt") || fn.endsWith(".tab") || fn.endsWith(".xls") || fn.endsWith(".gz")) {
            fn = fn.substring(0, fn.lastIndexOf("."));
        }
        this.descriptionColumn = -1;
        if (fn.endsWith("res")) {
            this.type = FileType.RES;
            this.dataStartColumn = 2;
            this.probeColumn = 1;
            this.descriptionColumn = 0;
        } else if (fn.endsWith("gct")) {
            this.type = FileType.GCT;
            this.dataStartColumn = 2;
            this.probeColumn = 0;
            this.descriptionColumn = 1;
        } else if (fn.endsWith("mapped")) {
            this.type = FileType.MAPPED;
            this.dataStartColumn = 4;
            this.probeColumn = 0;
        } else if (fn.endsWith("met")) {
            this.type = FileType.MET;
            this.dataStartColumn = 4;
            this.probeColumn = 0;
        } else if (fn.endsWith("dchip")) {
            this.type = FileType.DCHIP;
            this.dataStartColumn = 1;
            this.probeColumn = 0;
            this.descriptionColumn = -1;
        } else if (this.dataFileLocator.getDescription() != null && this.dataFileLocator.getDescription().equals("MAGE_TAB")) {
            this.type = FileType.MAGE_TAB;
            this.descriptionColumn = -1;
            this.dataStartColumn = -1;
            this.probeColumn = 0;
        } else {
            this.type = FileType.TAB;
            this.dataStartColumn = 1;
            this.probeColumn = 0;
        }
        boolean hasCalls = this.type == FileType.RES;
        boolean hasDescription = this.descriptionColumn >= 0;
        dataset.setType(TrackType.GENE_EXPRESSION);
        AsciiLineReader reader = null;
        String nextLine = null;
        String[] columnHeadings = null;
        try {
            reader = ParsingUtils.openAsciiReader(this.dataFileLocator);
            String headerLine = null;
            if (this.type == FileType.GCT) {
                nextLine = reader.readLine();
                if (nextLine.startsWith("#")) {
                    this.parseComment(nextLine, dataset);
                }
                if ((nextLine = reader.readLine()).startsWith("#")) {
                    this.parseComment(nextLine, dataset);
                }
                headerLine = reader.readLine();
            } else if (this.type != FileType.MAGE_TAB) {
                while ((nextLine = reader.readLine()).startsWith("#") && nextLine != null) {
                    this.parseComment(nextLine, dataset);
                }
                headerLine = nextLine;
            } else {
                headerLine = reader.readLine();
            }
            int skip = hasCalls ? 2 : 1;
            int nTokens = ParsingUtils.split(headerLine, tokens, '\t');
            if (this.type == FileType.MAGE_TAB) {
                for (int count = 1; this.dataStartColumn == -1 && count < nTokens; ++count) {
                    if (tokens[count] == null || tokens[count].trim().equals("")) continue;
                    this.dataStartColumn = count;
                }
                if (this.dataStartColumn == -1) {
                    throw new Exception("Could not find column index of first sample.");
                }
            }
            int nColumns = (nTokens - this.dataStartColumn) / skip;
            ArrayList<String> columnHeadingsObj = new ArrayList<String>();
            for (int i2 = 0; i2 < nColumns; ++i2) {
                String heading = tokens[this.dataStartColumn + i2 * skip].replace('\"', ' ').trim();
                if (this.type == FileType.MAGE_TAB) {
                    if (columnHeadingsObj.contains(heading)) continue;
                    columnHeadingsObj.add(heading);
                    this.headingIndexMap.put(heading, columnHeadingsObj.size() - 1);
                    continue;
                }
                columnHeadingsObj.add(heading);
                this.headingIndexMap.put(heading, i2);
            }
            columnHeadings = columnHeadingsObj.toArray(new String[0]);
            dataset.setColumnHeadings(columnHeadings);
            nColumns = columnHeadings.length;
            IntArrayList valuesIndices = new IntArrayList(nColumns);
            if (this.type == FileType.MAGE_TAB) {
                nextLine = reader.readLine();
                nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                List<String> headingColumns = Arrays.asList(tokens);
                String qCol = null;
                if (headingColumns.contains("Beta_Value")) {
                    qCol = "Beta_Value";
                } else if (headingColumns.contains("Beta value")) {
                    qCol = "Beta value";
                } else if (headingColumns.contains("log2 Signal")) {
                    qCol = "log2 Signal";
                } else if (headingColumns.contains("Signal")) {
                    qCol = "Signal";
                } else if (headingColumns.contains("signal")) {
                    qCol = "signal";
                } else {
                    HashSet<String> quantitations = new HashSet<String>();
                    for (int i3 = this.dataStartColumn; i3 < nTokens; ++i3) {
                        quantitations.add(tokens[i3]);
                    }
                    if (quantitations == null || quantitations.size() == 0) {
                        throw new Exception("Could not find any signal columns in the MAGE-TAB file");
                    }
                    ArrayList qColumns = new ArrayList(quantitations);
                    if (qColumns.size() > 1) {
                        Collections.sort(qColumns);
                        MagetabSignalDialog msDialog = new MagetabSignalDialog(IGV.getMainFrame(), qColumns.toArray(new String[0]));
                        msDialog.setVisible(true);
                        if (msDialog.isCanceled()) throw new InterruptedException();
                        qCol = msDialog.getQuantitationColumn();
                    } else {
                        qCol = (String)qColumns.get(0);
                    }
                }
                for (int i4 = this.dataStartColumn; i4 < nTokens; ++i4) {
                    String heading = tokens[i4].replace('\"', ' ').trim();
                    if (!heading.contains(qCol)) continue;
                    valuesIndices.add(i4);
                }
                if (nColumns != valuesIndices.size()) {
                    // empty if block
                }
            }
            if (this.type == FileType.RES) {
                reader.readLine();
                reader.readLine();
            }
            int lineCount = 0;
            while ((nextLine = reader.readLine()) != null) {
                String description;
                nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                String probeId = new String(tokens[this.probeColumn]);
                float[] values = new float[nColumns];
                char[] calls = hasCalls ? new char[nColumns] : (char[])null;
                String string = description = hasDescription && nTokens > this.descriptionColumn ? tokens[this.descriptionColumn] : null;
                if (this.type == FileType.MAGE_TAB && probeId.startsWith("cg")) {
                    dataset.setType(TrackType.DNA_METHYLATION);
                }
                for (int i5 = 0; i5 < nColumns; ++i5) {
                    try {
                        int dataIndex = -1;
                        dataIndex = this.type == FileType.MAGE_TAB ? valuesIndices.get(i5) : this.dataStartColumn + i5 * skip;
                        values[i5] = dataIndex >= nTokens || tokens[dataIndex].length() == 0 ? Float.NaN : Float.parseFloat(tokens[dataIndex]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        values[i5] = Float.NaN;
                    }
                    if (!hasCalls) continue;
                    calls[i5] = tokens[3 + i5 * skip].charAt(0);
                }
                this.addRow(probeId, description, values, calls);
                if (++lineCount != 1000) continue;
                this.checkForInterrupt();
                lineCount = 0;
                if (this.statusMonitor == null) continue;
                this.statusMonitor.incrementPercentComplete(1.0);
            }
        }
        catch (FileNotFoundException ex) {
            throw new RuntimeException(ex);
        }
        catch (InterruptedException e2) {
            throw new RuntimeException("Operation cancelled");
        }
        catch (Exception e3) {
            e3.printStackTrace();
            if (nextLine == null || reader.getCurrentLineNumber() == 0L) throw new RuntimeException(e3);
            throw new ParserException(e3.getMessage(), (Throwable)e3, reader.getCurrentLineNumber(), nextLine);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        this.sortRows();
        for (String chr : this.rowMap.keySet()) {
            dataset.setStartLocations(chr, this.getStartLocations(chr));
            dataset.setEndLocations(chr, this.getEndLocations(chr));
            dataset.setFeatureNames(chr, this.getProbes(chr));
            for (String heading : columnHeadings) {
                dataset.setData(heading, chr, this.getData(heading, chr));
            }
        }
        dataset.setLongestFeatureMap(this.longestProbeMap);
        if (dataset != null && !dataset.isEmpty()) return;
        String genomeId = this.genome == null ? "" : this.genome.getId();
        throw new ProbeMappingException(fn, genomeId);
    }

    public void addRow(String probeId, String description, float[] values, char[] calls) {
        List<Locus> loci = this.locusHelper.getLoci(probeId, description);
        if (loci != null) {
            for (Locus locus : loci) {
                if (locus == null || !locus.isValid()) continue;
                this.addRow(probeId, locus, values);
            }
        }
    }

    private void addRow(String probeId, Locus locus, float[] values) {
        List<Row> rows = this.rowMap.get(locus.getChr());
        if (rows == null) {
            rows = new ArrayList<Row>();
            this.rowMap.put(locus.getChr(), rows);
        }
        String chr = locus.getChr();
        int length = locus.getEnd() - locus.getStart();
        if (this.longestProbeMap.containsKey(chr)) {
            this.longestProbeMap.put(chr, Math.max(this.longestProbeMap.get(chr), length));
        } else {
            this.longestProbeMap.put(chr, length);
        }
        rows.add(new Row(probeId, locus.getChr(), locus.getStart(), locus.getEnd(), values));
    }

    private void sortRows() {
        Comparator<Row> c2 = new Comparator<Row>(){

            @Override
            public int compare(Row arg0, Row arg1) {
                return arg0.start - arg1.start;
            }
        };
        for (List<Row> rows : this.rowMap.values()) {
            Collections.sort(rows, c2);
        }
    }

    public String[] getProbes(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        String[] labels = new String[rows.size()];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            labels[i2] = rows.get((int)i2).feature;
        }
        return labels;
    }

    public int[] getStartLocations(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        int[] startLocations = new int[rows.size()];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            startLocations[i2] = rows.get((int)i2).start;
        }
        return startLocations;
    }

    public int[] getEndLocations(String chr) {
        List<Row> rows = this.rowMap.get(chr);
        int[] endLocations = new int[rows.size()];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            endLocations[i2] = rows.get((int)i2).end;
        }
        return endLocations;
    }

    public float[] getData(String heading, String chr) {
        int columnIndex = this.headingIndexMap.get(heading);
        List<Row> rows = this.rowMap.get(chr);
        float[] data = new float[rows.size()];
        for (int i2 = 0; i2 < rows.size(); ++i2) {
            data[i2] = rows.get((int)i2).values[columnIndex];
        }
        return data;
    }

    private void parseComment(String comment, GCTDataConsumer dataset) {
        String tmp = comment.substring(1, comment.length());
        if (tmp.startsWith("track")) {
            dataset.setTrackLine(tmp);
        } else {
            String[] tokens = tmp.split("=");
            if (tokens.length != 2) {
                return;
            }
            String key = tokens[0].trim().toLowerCase();
            if (key.equals("name")) {
                dataset.setName(tokens[1].trim());
            } else if (key.equals("type")) {
                try {
                    dataset.setType(TrackType.valueOf(tokens[1].trim().toUpperCase()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void checkForInterrupt() throws InterruptedException {
        Thread.sleep(1L);
    }

    class Row {
        String feature;
        String chr;
        int start;
        int end;
        float[] values;

        Row(String feature, String chr, int start, int end, float[] values) {
            this.feature = feature;
            this.chr = chr;
            this.start = start;
            this.end = end;
            this.values = values;
        }
    }

    static enum FileType {
        RES,
        GCT,
        MAPPED,
        TAB,
        MET,
        DCHIP,
        MAGE_TAB;

    }
}

