/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;

public class AbstractXmlFriendlyMapper
extends MapperWrapper {
    private char dollarReplacementInClass = (char)45;
    private String dollarReplacementInField = "_DOLLAR_";
    private String underscoreReplacementInField = "__";
    private String noPackagePrefix = "default";

    protected AbstractXmlFriendlyMapper(Mapper wrapped) {
        super(wrapped);
    }

    protected String escapeClassName(String className) {
        if ((className = className.replace('$', this.dollarReplacementInClass)).charAt(0) == this.dollarReplacementInClass) {
            className = this.noPackagePrefix + className;
        }
        return className;
    }

    protected String unescapeClassName(String className) {
        if (className.startsWith(this.noPackagePrefix + this.dollarReplacementInClass)) {
            className = className.substring(this.noPackagePrefix.length());
        }
        className = className.replace(this.dollarReplacementInClass, '$');
        return className;
    }

    protected String escapeFieldName(String fieldName) {
        StringBuffer result = new StringBuffer();
        int length = fieldName.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = fieldName.charAt(i2);
            if (c2 == '$') {
                result.append(this.dollarReplacementInField);
                continue;
            }
            if (c2 == '_') {
                result.append(this.underscoreReplacementInField);
                continue;
            }
            result.append(c2);
        }
        return result.toString();
    }

    protected String unescapeFieldName(String xmlName) {
        StringBuffer result = new StringBuffer();
        int length = xmlName.length();
        for (int i2 = 0; i2 < length; ++i2) {
            char c2 = xmlName.charAt(i2);
            if (this.stringFoundAt(xmlName, i2, this.underscoreReplacementInField)) {
                i2 += this.underscoreReplacementInField.length() - 1;
                result.append('_');
                continue;
            }
            if (this.stringFoundAt(xmlName, i2, this.dollarReplacementInField)) {
                i2 += this.dollarReplacementInField.length() - 1;
                result.append('$');
                continue;
            }
            result.append(c2);
        }
        return result.toString();
    }

    private boolean stringFoundAt(String name, int i2, String replacement) {
        return name.length() >= i2 + replacement.length() && name.substring(i2, i2 + replacement.length()).equals(replacement);
    }
}

