/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.path;

import com.thoughtworks.xstream.core.util.FastStack;
import java.util.ArrayList;

public class Path {
    private final String[] chunks;
    private transient String pathAsString;
    private static final Path DOT = new Path(new String[]{"."});

    public Path(String pathAsString) {
        int nextSeperator;
        ArrayList<String> result = new ArrayList<String>();
        int currentIndex = 0;
        while ((nextSeperator = pathAsString.indexOf(47, currentIndex)) != -1) {
            result.add(pathAsString.substring(currentIndex, nextSeperator));
            currentIndex = nextSeperator + 1;
        }
        result.add(pathAsString.substring(currentIndex));
        String[] arr = new String[result.size()];
        result.toArray(arr);
        this.chunks = arr;
        this.pathAsString = pathAsString;
    }

    public Path(String[] chunks) {
        this.chunks = chunks;
    }

    public String toString() {
        if (this.pathAsString == null) {
            StringBuffer buffer = new StringBuffer();
            for (int i2 = 0; i2 < this.chunks.length; ++i2) {
                if (i2 > 0) {
                    buffer.append('/');
                }
                buffer.append(this.chunks[i2]);
            }
            this.pathAsString = buffer.toString();
        }
        return this.pathAsString;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (!(o2 instanceof Path)) {
            return false;
        }
        Path other = (Path)o2;
        if (this.chunks.length != other.chunks.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            if (this.chunks[i2].equals(other.chunks[i2])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 543645643;
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            result = 29 * result + this.chunks[i2].hashCode();
        }
        return result;
    }

    public Path relativeTo(Path that) {
        int depthOfPathDivergence = this.depthOfPathDivergence(this.chunks, that.chunks);
        String[] result = new String[this.chunks.length + that.chunks.length - 2 * depthOfPathDivergence];
        int count = 0;
        for (int i2 = depthOfPathDivergence; i2 < this.chunks.length; ++i2) {
            result[count++] = "..";
        }
        for (int j2 = depthOfPathDivergence; j2 < that.chunks.length; ++j2) {
            result[count++] = that.chunks[j2];
        }
        if (count == 0) {
            return DOT;
        }
        return new Path(result);
    }

    private int depthOfPathDivergence(String[] path1, String[] path2) {
        int minLength = Math.min(path1.length, path2.length);
        for (int i2 = 0; i2 < minLength; ++i2) {
            if (path1[i2].equals(path2[i2])) continue;
            return i2;
        }
        return minLength;
    }

    public Path apply(Path relativePath) {
        int i2;
        FastStack absoluteStack = new FastStack(16);
        for (i2 = 0; i2 < this.chunks.length; ++i2) {
            absoluteStack.push(this.chunks[i2]);
        }
        for (i2 = 0; i2 < relativePath.chunks.length; ++i2) {
            String relativeChunk = relativePath.chunks[i2];
            if (relativeChunk.equals("..")) {
                absoluteStack.pop();
                continue;
            }
            if (relativeChunk.equals(".")) continue;
            absoluteStack.push(relativeChunk);
        }
        String[] result = new String[absoluteStack.size()];
        for (int i3 = 0; i3 < result.length; ++i3) {
            result[i3] = (String)absoluteStack.get(i3);
        }
        return new Path(result);
    }

    public boolean isAncestor(Path child) {
        if (child == null || child.chunks.length < this.chunks.length) {
            return false;
        }
        for (int i2 = 0; i2 < this.chunks.length; ++i2) {
            if (this.chunks[i2].equals(child.chunks[i2])) continue;
            return false;
        }
        return true;
    }
}

