/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.util.Comparator;
import java.util.List;

public class ArrayHeapObjectSorter<T> {
    private List<T> a;
    private int n;
    Comparator<T> c;

    public void sort(List<T> a0, Comparator<T> c2) {
        this.a = a0;
        this.n = this.a.size();
        this.c = c2;
        this.heapsort();
    }

    private void heapsort() {
        this.buildheap();
        while (this.n > 1) {
            --this.n;
            this.exchange(0, this.n);
            this.downheap(0);
        }
    }

    private void buildheap() {
        for (int v = this.n / 2 - 1; v >= 0; --v) {
            this.downheap(v);
        }
    }

    private void downheap(int v) {
        int w = 2 * v + 1;
        while (w < this.n) {
            if (w + 1 < this.n && this.c.compare(this.a.get(w + 1), this.a.get(w)) > 0) {
                ++w;
            }
            if (this.c.compare(this.a.get(v), this.a.get(w)) >= 0) {
                return;
            }
            this.exchange(v, w);
            v = w;
            w = 2 * v + 1;
        }
    }

    private void exchange(int i2, int j2) {
        T t = this.a.get(i2);
        this.a.set(i2, this.a.get(j2));
        this.a.set(j2, t);
    }
}

