/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs.atm;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.broad.igv.gs.atm.FileParameter;
import org.broad.igv.gs.atm.GSDataFormat;
import org.broad.igv.gs.atm.SubToolDescriptor;
import org.broad.igv.gs.atm.WebToolDescriptor;
import org.broad.igv.util.IGVHttpClientUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class GSATMUtils {
    static final String BASE_URL = "https://atmtest.genomespace.org:8443/atm/webtools";

    public static void main(String[] args) throws IOException, JSONException {
        String url = GSATMUtils.getWebtoolLaunchURL("Cytoscape");
        System.out.println(url);
        List<WebToolDescriptor> webTools = GSATMUtils.getWebTools(new URL(BASE_URL));
        for (WebToolDescriptor wt : webTools) {
            wt.print();
        }
        System.exit(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<WebToolDescriptor> getWebTools(URL url) throws IOException, JSONException {
        StringBuffer buf = new StringBuffer();
        InputStream is = null;
        try {
            List<WebToolDescriptor> webTools;
            int b2;
            is = IGVHttpClientUtils.openConnectionStream(url);
            BufferedInputStream bis = new BufferedInputStream(is);
            while ((b2 = bis.read()) >= 0) {
                buf.append((char)b2);
            }
            JSONTokener tk = new JSONTokener(buf.toString());
            JSONArray array = new JSONArray(tk);
            JSONArray webDescArray = (JSONArray)array.get(1);
            List<WebToolDescriptor> list = webTools = GSATMUtils.parseWebtools(webDescArray);
            return list;
        }
        finally {
            is.close();
        }
    }

    private static List<WebToolDescriptor> parseWebtools(JSONArray webDescArray) throws JSONException {
        int count = webDescArray.length();
        ArrayList<WebToolDescriptor> webTools = new ArrayList<WebToolDescriptor>();
        for (int i2 = 0; i2 < count; ++i2) {
            JSONArray ar = webDescArray.getJSONArray(i2);
            JSONObject obj = ar.getJSONObject(1);
            String name = obj.get("name").toString();
            String id = obj.get("id").toString();
            String version = obj.get("version").toString();
            String author = obj.get("author").toString();
            String description = obj.get("description").toString();
            String help = obj.get("help").toString();
            String baseUrl = obj.get("baseUrl").toString();
            JSONArray fileParamArray = obj.getJSONArray("fileParameters").getJSONArray(1);
            List<FileParameter> fileParams = GSATMUtils.parseFileParameters(fileParamArray);
            JSONArray subToolsArray = obj.getJSONArray("subTools").getJSONArray(1);
            List<SubToolDescriptor> subTools = GSATMUtils.parseSubtools(subToolsArray);
            webTools.add(new WebToolDescriptor(name, id, version, author, description, help, baseUrl, fileParams, subTools));
        }
        return webTools;
    }

    private static List<SubToolDescriptor> parseSubtools(JSONArray subToolsArray) throws JSONException {
        ArrayList<SubToolDescriptor> subtoolDescriptors = new ArrayList<SubToolDescriptor>();
        if (subToolsArray.length() > 0) {
            int nTools = subToolsArray.length();
            for (int n2 = 0; n2 < nTools; ++n2) {
                JSONObject stObj = subToolsArray.getJSONArray(n2).getJSONObject(1);
                String stName = stObj.get("name").toString();
                String stId = stObj.get("id").toString();
                String stVersion = stObj.get("version").toString();
                String stAuthor = stObj.get("author").toString();
                String stDescription = stObj.get("description").toString();
                String stHelp = stObj.get("help").toString();
                String stUrlModifier = stObj.get("urlModifier").toString();
                JSONArray stFileParams = stObj.getJSONArray("fileParameters").getJSONArray(1);
                List<FileParameter> fileParams = GSATMUtils.parseFileParameters(stFileParams);
                subtoolDescriptors.add(new SubToolDescriptor(stName, stId, stVersion, stAuthor, stDescription, stHelp, stUrlModifier, fileParams));
            }
        }
        return subtoolDescriptors;
    }

    private static List<FileParameter> parseFileParameters(JSONArray fileParamsArray) throws JSONException {
        ArrayList<FileParameter> fileParameters = new ArrayList<FileParameter>();
        if (fileParamsArray.length() > 0) {
            int nFileParams = fileParamsArray.length();
            for (int n2 = 0; n2 < nFileParams; ++n2) {
                JSONObject fObj = fileParamsArray.getJSONArray(n2).getJSONObject(1);
                String fpName = fObj.get("name").toString();
                String fpDescription = fObj.get("description").toString();
                String fpRequired = fObj.get("required").toString();
                String fpCompositeFilename = fObj.get("compositeFilename").toString();
                String fpNameDelimiters = fObj.get("nameDelimiters").toString();
                JSONArray formats = fObj.getJSONArray("formats");
                ArrayList<GSDataFormat> dataFormats = new ArrayList<GSDataFormat>();
                if (formats.length() > 0) {
                    JSONArray formatsArray = formats.getJSONArray(1);
                    int nFormats = formatsArray.length();
                    for (int f2 = 0; f2 < nFormats; ++f2) {
                        JSONObject format = formatsArray.getJSONArray(f2).getJSONObject(1);
                        String fName = format.get("name").toString();
                        String fVersion = format.get("version").toString();
                        String fUrl = format.get("url").toString();
                        dataFormats.add(new GSDataFormat(fName, fVersion, fUrl));
                    }
                }
                fileParameters.add(new FileParameter(fpName, fpDescription, fpRequired, fpCompositeFilename, fpNameDelimiters, dataFormats));
            }
        }
        return fileParameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getWebtoolLaunchURL(String webtoolname) throws IOException, JSONException {
        URL url = new URL("https://atmtest.genomespace.org:8443/atm/webtools/" + webtoolname);
        StringBuffer buf = new StringBuffer();
        InputStream is = null;
        try {
            int b2;
            is = IGVHttpClientUtils.openConnectionStream(url);
            BufferedInputStream bis = new BufferedInputStream(is);
            while ((b2 = bis.read()) >= 0) {
                buf.append((char)b2);
            }
            String string = buf.toString();
            return string;
        }
        finally {
            is.close();
        }
    }
}

