/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.gs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.broad.igv.gs.dm.GSDMUtils;
import org.broad.igv.gs.dm.GSDirectoryListing;
import org.broad.igv.gs.dm.GSFileMetadata;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;
import org.json.JSONException;

public class GSFileBrowser
extends JDialog {
    private static Logger log = Logger.getLogger(GSFileBrowser.class);
    static ImageIcon folderIcon;
    static ImageIcon fileIcon;
    String userRootUrl = null;
    private JPanel dialogPane;
    private JPanel buttonBar;
    private JButton cancelButton;
    private JButton openButton;
    private JPanel splitPane1;
    private JScrollPane scrollPane1;
    private JList fileList;
    private JLabel label1;

    public static void main(String[] args) throws IOException, JSONException {
        new GSFileBrowser(null).setVisible(true);
    }

    public GSFileBrowser(Frame owner) throws IOException, JSONException {
        super(owner);
        this.initComponents();
        this.init();
    }

    void init() throws JSONException, IOException {
        if (folderIcon == null) {
            folderIcon = new ImageIcon(this.getClass().getResource("/images/Folder-icon.png"));
            fileIcon = new ImageIcon(this.getClass().getResource("/images/file-document.png"));
        }
        this.fileList.setCellRenderer(new CellRenderer());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e2) {
                if (e2.getClickCount() == 2) {
                    int index = GSFileBrowser.this.fileList.locationToIndex(e2.getPoint());
                    GSFileMetadata md = (GSFileMetadata)GSFileBrowser.this.fileList.getModel().getElementAt(index);
                    if (md.isDirectory()) {
                        try {
                            GSFileBrowser.this.fetchContents(new URL(md.getUrl()));
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                        catch (JSONException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        GSFileBrowser.this.load(Arrays.asList(new ResourceLocator(md.getUrl())));
                    }
                }
            }
        };
        this.fileList.addMouseListener(mouseListener);
        URL defaultURL = new URL(GSDMUtils.baseUrl + "defaultdirectory");
        this.fetchContents(defaultURL);
    }

    private void fetchContents(URL url) throws IOException, JSONException {
        GSDirectoryListing dirListing = GSDMUtils.getDirectoryListing(url);
        String dirUrlString = dirListing.getDirectory();
        this.setTitle(dirUrlString);
        if (this.userRootUrl == null) {
            this.userRootUrl = dirUrlString;
        }
        this.setTitle(dirUrlString);
        if (this.userRootUrl == null) {
            this.userRootUrl = dirUrlString;
        }
        List<GSFileMetadata> elements = dirListing.getContents();
        if (!dirUrlString.equals(this.userRootUrl)) {
            int lastSlashIdx = dirUrlString.lastIndexOf("/");
            String parentURL = dirUrlString.substring(0, lastSlashIdx);
            elements.add(0, new GSFileMetadata("Parent Directory", parentURL, "", "", true));
        }
        ListModel model = new ListModel(dirListing.getContents());
        this.fileList.setModel(model);
    }

    private void cancelButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
        this.dispose();
    }

    private void loadButtonActionPerformed(ActionEvent e2) {
        try {
            GSFileMetadata md;
            Object[] selections = this.fileList.getSelectedValues();
            if (selections.length == 1 && (md = (GSFileMetadata)selections[0]).isDirectory()) {
                this.fetchContents(new URL(md.getUrl()));
                return;
            }
            ArrayList<ResourceLocator> toLoad = new ArrayList<ResourceLocator>(selections.length);
            for (Object obj : selections) {
                GSFileMetadata md2;
                if (!(obj instanceof GSFileMetadata) || (md2 = (GSFileMetadata)obj).isDirectory()) continue;
                toLoad.add(new ResourceLocator(md2.getUrl()));
            }
            if (toLoad.size() > 0) {
                this.load(toLoad);
            }
        }
        catch (Exception e1) {
            log.error("Error loading GS files", e1);
            MessageUtils.showMessage("Error: " + e1.toString());
        }
    }

    private void load(final List<ResourceLocator> toLoad) {
        this.setVisible(false);
        this.dispose();
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public void run() {
                IGV.getInstance().loadTracks(toLoad);
            }

            @Override
            public String getName() {
                return "GS Load";
            }
        };
        LongRunningTask.submit(runnable);
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.buttonBar = new JPanel();
        this.cancelButton = new JButton();
        this.openButton = new JButton();
        this.splitPane1 = new JPanel();
        this.scrollPane1 = new JScrollPane();
        this.fileList = new JList();
        this.label1 = new JLabel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 85, 0};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0, 0.0};
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSFileBrowser.this.cancelButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                GSFileBrowser.this.loadButtonActionPerformed(e2);
            }
        });
        this.buttonBar.add((Component)this.openButton, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        this.splitPane1.setLayout(new BoxLayout(this.splitPane1, 1));
        this.scrollPane1.setViewportView(this.fileList);
        this.splitPane1.add(this.scrollPane1);
        this.label1.setHorizontalAlignment(0);
        this.label1.setIcon(new ImageIcon(this.getClass().getResource("/images/genomespacelogo.png")));
        this.splitPane1.add(this.label1);
        this.dialogPane.add((Component)this.splitPane1, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(490, 530);
        this.setLocationRelativeTo(this.getOwner());
    }

    static class CellRenderer
    extends JLabel
    implements ListCellRenderer {
        CellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            GSFileMetadata fileElement = (GSFileMetadata)value;
            String s = value.toString();
            this.setText(s);
            this.setIcon(fileElement.isDirectory() ? folderIcon : fileIcon);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    static class ListModel
    extends AbstractListModel {
        List<GSFileMetadata> elements;

        ListModel(List<GSFileMetadata> elements) {
            this.elements = elements;
        }

        @Override
        public int getSize() {
            return this.elements.size();
        }

        @Override
        public Object getElementAt(int i2) {
            return this.elements.get(i2);
        }
    }
}

