/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Color;
import org.broad.igv.feature.Strand;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.sam.AlignmentRenderer;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.track.WindowFunction;

public abstract class AbstractAlignment
implements Alignment {
    String chr;
    int inferredInsertSize;
    int mappingQuality = 255;
    ReadMate mate;
    String readName;
    AlignmentBlock[] alignmentBlocks;
    AlignmentBlock[] insertions;
    char[] gapTypes;
    private boolean negativeStrand;

    public AbstractAlignment() {
    }

    public AbstractAlignment(AbstractAlignment alignment) {
        this.chr = alignment.chr;
        this.inferredInsertSize = alignment.inferredInsertSize;
        this.mappingQuality = alignment.mappingQuality;
        this.mate = alignment.mate;
        this.readName = alignment.readName;
        this.negativeStrand = alignment.negativeStrand;
        this.alignmentBlocks = alignment.alignmentBlocks;
        this.insertions = alignment.insertions;
    }

    @Override
    public String getChromosome() {
        return this.getChr();
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    public String getDescription() {
        return this.getReadName();
    }

    @Override
    public ReadMate getMate() {
        return this.mate;
    }

    public String getMateSequence() {
        return null;
    }

    @Override
    public String getReadName() {
        return this.readName;
    }

    @Override
    public int getMappingQuality() {
        return this.mappingQuality;
    }

    @Override
    public int getInferredInsertSize() {
        return this.inferredInsertSize;
    }

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return this.alignmentBlocks;
    }

    @Override
    public AlignmentBlock[] getInsertions() {
        return this.insertions;
    }

    @Override
    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    public void setNegativeStrand(boolean negativeStrand) {
        this.negativeStrand = negativeStrand;
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public byte getBase(double position) {
        int basePosition = (int)position;
        for (AlignmentBlock block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte base = block.getBases()[offset];
            return base;
        }
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        int basePosition = (int)position;
        for (AlignmentBlock block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte qual = block.qualities[offset];
            return qual;
        }
        return 0;
    }

    @Override
    public String getValueString(double position, WindowFunction windowFunction) {
        if (this.insertions != null) {
            for (AlignmentBlock block : this.insertions) {
                double insertionLeft = (double)block.getStart() + 0.75;
                double insertionRight = (double)block.getStart() + 1.25;
                if (!(position > insertionLeft) || !(position < insertionRight)) continue;
                return "Insertion: " + new String(block.getBases());
            }
        }
        StringBuffer buf = new StringBuffer();
        String sample = this.getSample();
        if (sample != null) {
            buf.append("Sample = " + sample + "<br>");
        }
        String readGroup = this.getReadGroup();
        if (sample != null) {
            buf.append("Read group = " + readGroup + "<br>");
        }
        buf.append("----------------------<br>");
        int basePosition = (int)position - 1;
        buf.append("Read name = " + this.getReadName() + "<br>");
        buf.append("Alignment start = " + (this.getAlignmentStart() + 1) + " (" + (this.isNegativeStrand() ? "-" : "+") + ")<br>");
        buf.append("Cigar = " + this.getCigarString() + "<br>");
        buf.append("Mapped = " + (this.isMapped() ? "yes" : "no") + "<br>");
        buf.append("Mapping quality = " + this.getMappingQuality() + "<br>");
        buf.append("----------------------<br>");
        for (AlignmentBlock block : this.alignmentBlocks) {
            if (!block.contains(basePosition)) continue;
            int offset = basePosition - block.getStart();
            byte base = block.getBases()[offset];
            byte quality = block.getQuality(offset);
            buf.append("Base = " + (char)base + "<br>");
            buf.append("Base phred quality = " + quality + "<br>");
        }
        if (this.isPaired()) {
            buf.append("----------------------<br>");
            buf.append("Pair start = " + this.getMate().positionString() + "<br>");
            buf.append("Pair is mapped = " + (this.getMate().isMapped() ? "yes" : "no") + "<br>");
            if (this.getChr().equals(this.getMate().getChr())) {
                buf.append("Insert size = " + this.getInferredInsertSize() + "<br>");
            }
            if (this.getPairOrientation().length() > 0) {
                buf.append("Pair orientation = " + this.getPairOrientation() + "<br>");
            }
        }
        buf.append("----------------------");
        return buf.toString();
    }

    @Override
    public abstract String getCigarString();

    @Override
    public abstract boolean isMapped();

    @Override
    public abstract boolean isPaired();

    @Override
    public abstract boolean isProperPair();

    @Override
    public boolean isSmallInsert() {
        int absISize = Math.abs(this.getInferredInsertSize());
        return absISize > 0 && absISize <= this.getReadSequence().length();
    }

    @Override
    public float getScore() {
        return this.getMappingQuality();
    }

    public void setMappingQuality(int mappingQuality) {
        this.mappingQuality = mappingQuality;
    }

    public void setInferredInsertSize(int inferredInsertSize) {
        this.inferredInsertSize = inferredInsertSize;
    }

    public void setMate(ReadMate mate) {
        this.mate = mate;
    }

    @Override
    public String getReadGroup() {
        return null;
    }

    @Override
    public String getLibrary() {
        return null;
    }

    @Override
    public String getClipboardString(double location) {
        return this.getValueString(location, null);
    }

    @Override
    public char[] getGapTypes() {
        return null;
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    public Strand getFragmentStrand() {
        return Strand.NONE;
    }

    @Override
    public void setMateSequence(String sequence) {
    }

    @Override
    public String getPairOrientation() {
        return "";
    }

    @Override
    public boolean isVendorFailedRead() {
        return false;
    }

    @Override
    public Color getDefaultColor() {
        return AlignmentRenderer.grey1;
    }
}

