/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.MaximumContigGenomeException;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.IGVHttpClientUtils;
import org.broad.igv.util.Utilities;
import org.broad.igv.util.ZipArchiveWrapper;
import org.broad.tribble.readers.AsciiLineReader;

public class GenomeImporter {
    public static final int MAX_CONTIGS = 1000000;
    static Logger log = Logger.getLogger(GenomeImporter.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createGenomeArchive(File archiveOutputLocation, String genomeFileName, String genomeId, String genomeDisplayName, String sequenceLocation, File sequenceInputFile, File refFlatFile, File cytobandFile, File chrAliasFile, String sequenceOutputLocationOverride, ProgressMonitor monitor) throws IOException {
        if (archiveOutputLocation == null || genomeFileName == null || genomeId == null || genomeDisplayName == null) {
            log.error("Invalid input for genome creation: ");
            log.error("\tGenome Output Location=" + archiveOutputLocation);
            log.error("\tGenome filename=" + genomeFileName);
            log.error("\tGenome Id=" + genomeId);
            log.error("\tGenome Name" + genomeDisplayName);
            return null;
        }
        File tmpdir = new File(Globals.getGenomeCacheDirectory(), genomeFileName + "_tmp");
        if (tmpdir.exists()) {
            tmpdir.delete();
        }
        tmpdir.mkdir();
        boolean autoGeneratedCytobandFile = cytobandFile == null;
        boolean singleFasta = false;
        boolean chromsSorted = false;
        boolean altererdChrFilenames = false;
        File archive = null;
        OutputStreamWriter propertyFileWriter = null;
        try {
            if (sequenceInputFile != null) {
                LinkedHashMap<String, Integer> chromSizes = new LinkedHashMap<String, Integer>();
                File sequenceOutputFolder = new File(archiveOutputLocation, sequenceLocation);
                if (!sequenceOutputFolder.exists()) {
                    sequenceOutputFolder.mkdir();
                }
                if (sequenceInputFile.isDirectory()) {
                    List<File> files = this.getSequenceFiles(sequenceInputFile);
                    int progressIncrement = files.size() > 0 ? 50 / files.size() : 50;
                    for (File file : files) {
                        if (file.getName().startsWith(".")) continue;
                        altererdChrFilenames = this.createSequenceFiles(file, sequenceOutputFolder, genomeId, chromSizes, monitor);
                        if (monitor == null) continue;
                        monitor.fireProgressChange(progressIncrement);
                    }
                } else if (sequenceInputFile.getName().toLowerCase().endsWith(".zip")) {
                    ZipArchiveWrapper zip = new ZipArchiveWrapper(sequenceInputFile);
                    ZipArchiveWrapper.ZipIterator iterator = null;
                    ZipInputStream inputStream = null;
                    try {
                        int entryCount = zip.getEntryCount();
                        int progressIncrement = entryCount > 0 ? 50 / entryCount : 50;
                        iterator = zip.iterator();
                        inputStream = iterator.getZipInputStream();
                        while (iterator.hasNext()) {
                            iterator.next();
                            altererdChrFilenames = this.createSequenceFiles(inputStream, sequenceOutputFolder, genomeId, chromSizes, monitor);
                            if (monitor == null) continue;
                            monitor.fireProgressChange(progressIncrement);
                        }
                        iterator.close();
                    }
                    finally {
                        if (iterator != null) {
                            iterator.close();
                        }
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                } else {
                    altererdChrFilenames = this.createSequenceFiles(sequenceInputFile, sequenceOutputFolder, genomeId, chromSizes, monitor);
                    singleFasta = true;
                }
                if (autoGeneratedCytobandFile) {
                    String cytobandFileName = genomeId + "_cytoband.txt";
                    cytobandFile = new File(tmpdir, cytobandFileName);
                    cytobandFile.deleteOnExit();
                    this.generateCytobandFile(chromSizes, cytobandFile, singleFasta);
                    chromsSorted = true;
                }
            }
            if (sequenceOutputLocationOverride != null && sequenceOutputLocationOverride.length() > 0) {
                sequenceLocation = sequenceOutputLocationOverride;
            }
            File propertyFile = this.createGenomePropertyFile(genomeId, genomeDisplayName, sequenceLocation, refFlatFile, cytobandFile, chrAliasFile, chromsSorted, altererdChrFilenames, tmpdir);
            propertyFile.deleteOnExit();
            archive = new File(archiveOutputLocation, genomeFileName);
            File[] inputFiles = new File[]{refFlatFile, cytobandFile, propertyFile, chrAliasFile};
            Utilities.createZipFile(archive, inputFiles);
            propertyFile.delete();
            cytobandFile.delete();
            tmpdir.delete();
        }
        finally {
            if (propertyFileWriter != null) {
                try {
                    propertyFileWriter.close();
                }
                catch (IOException ex) {
                    log.error("Failed to close genome archive: +" + archive.getAbsolutePath(), ex);
                }
            }
            if (autoGeneratedCytobandFile && cytobandFile != null && cytobandFile.exists()) {
                cytobandFile.deleteOnExit();
            }
        }
        return archive;
    }

    private List<File> getSequenceFiles(File sequenceDir) {
        ArrayList<File> files = new ArrayList<File>();
        for (File f2 : sequenceDir.listFiles()) {
            if (f2.isDirectory()) {
                files.addAll(this.getSequenceFiles(f2));
                continue;
            }
            files.add(f2);
        }
        return files;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCytobandFile(Map<String, Integer> chromSizes, File cytobandFile, boolean singleFasta) throws IOException {
        PrintWriter cytobandFileWriter = null;
        try {
            if (!cytobandFile.exists()) {
                cytobandFile.createNewFile();
            }
            cytobandFileWriter = new PrintWriter(new FileWriter(cytobandFile, true));
            ArrayList<String> chrNames = new ArrayList<String>(chromSizes.keySet());
            if (!singleFasta) {
                Collections.sort(chrNames, new Genome.ChromosomeComparator());
            }
            for (String chrName : chrNames) {
                int chrLength = chromSizes.get(chrName);
                cytobandFileWriter.println(chrName + "\t0\t" + chrLength);
            }
        }
        finally {
            if (cytobandFileWriter != null) {
                cytobandFileWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File createGenomePropertyFile(String genomeId, String genomeDisplayName, String relativeSequenceLocation, File refFlatFile, File cytobandFile, File chrAliasFile, boolean chromsSorted, boolean alteredChrFilenames, File tmpdir) throws IOException {
        PrintWriter propertyFileWriter = null;
        try {
            File propertyFile = new File(tmpdir, "property.txt");
            propertyFile.createNewFile();
            propertyFileWriter = new PrintWriter(new FileWriter(propertyFile));
            if (alteredChrFilenames) {
                propertyFileWriter.println("filenamesAltered=true");
            }
            propertyFileWriter.println("ordered=" + String.valueOf(chromsSorted));
            if (genomeId != null) {
                propertyFileWriter.println("id=" + genomeId);
            }
            if (genomeDisplayName != null) {
                propertyFileWriter.println("name=" + genomeDisplayName);
            }
            if (cytobandFile != null) {
                propertyFileWriter.println("cytobandFile=" + cytobandFile.getName());
            }
            if (refFlatFile != null) {
                propertyFileWriter.println("geneFile=" + refFlatFile.getName());
            }
            if (chrAliasFile != null) {
                propertyFileWriter.println("chrAliasFile=" + chrAliasFile.getName());
            }
            if (relativeSequenceLocation != null) {
                if (!IGVHttpClientUtils.isURL(relativeSequenceLocation)) {
                    relativeSequenceLocation = relativeSequenceLocation.replace('\\', '/');
                }
                propertyFileWriter.println("sequenceLocation=" + relativeSequenceLocation);
            }
            File file = propertyFile;
            return file;
        }
        finally {
            if (propertyFileWriter != null) {
                propertyFileWriter.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeUserDefinedGenomeListToFile(File outputFile, Properties properties) throws IOException {
        if (properties != null && outputFile != null) {
            if (!outputFile.exists()) {
                File genomeDir = outputFile.getParentFile();
                if (!genomeDir.exists()) {
                    genomeDir.mkdir();
                }
                outputFile.createNewFile();
            }
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(outputFile);
                properties.store(out, "");
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e2) {
                        log.error("Error closing property file for imported genomes!", e2);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSequenceFiles(File sequenceInputFile, File genomeSequenceFolder, String genomeId, LinkedHashMap<String, Integer> chromSizes, ProgressMonitor monitor) throws IOException {
        if (sequenceInputFile == null) {
            log.error("Invalid input for sequence creation: ");
            log.error("\tSequence Filename =" + sequenceInputFile);
            log.error("\tSequence Location =" + genomeSequenceFolder);
            log.error("\tGenome Id =" + genomeId);
            return false;
        }
        InputStream inputStream = null;
        try {
            inputStream = sequenceInputFile.getName().toLowerCase().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(sequenceInputFile)) : new FileInputStream(sequenceInputFile);
            boolean bl = this.createSequenceFiles(inputStream, genomeSequenceFolder, genomeId, chromSizes, monitor);
            return bl;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createSequenceFiles(InputStream sequenceInputStream, File genomeSequenceFolder, String genomeId, LinkedHashMap<String, Integer> chromSizes, ProgressMonitor monitor) throws IOException {
        boolean alteredChrFilenames = false;
        if (sequenceInputStream == null) {
            log.error("Invalid input for sequence creation: ");
            log.error("\tInput Stream =" + sequenceInputStream);
            log.error("\tSequence Location =" + genomeSequenceFolder);
            log.error("\tGenome Id =" + genomeId);
            return alteredChrFilenames;
        }
        int contigCounter = 0;
        BufferedWriter chromosomeFileWriter = null;
        AsciiLineReader dataReader = null;
        try {
            if (!genomeSequenceFolder.exists()) {
                genomeSequenceFolder.mkdir();
            }
            dataReader = new AsciiLineReader(sequenceInputStream);
            String fastaDataLine = null;
            String chr = null;
            int chrSize = 0;
            while ((fastaDataLine = dataReader.readLine()) != null) {
                if (contigCounter > 1000000) {
                    throw new MaximumContigGenomeException("Maximum number of contigs exceeded (1000000)");
                }
                if ((fastaDataLine = fastaDataLine.trim()).startsWith(">")) {
                    String legalFileName;
                    if (chr != null) {
                        chromSizes.put(chr, chrSize);
                    }
                    ++contigCounter;
                    String[] tokens = fastaDataLine.split("\\s+");
                    chr = tokens[0].substring(1);
                    chrSize = 0;
                    String chrFileName = chr + ".txt";
                    if (!chrFileName.equals(legalFileName = FileUtils.legalFileName(chrFileName))) {
                        alteredChrFilenames = true;
                    }
                    File chromosomeSequenceFile = new File(genomeSequenceFolder, legalFileName);
                    chromosomeSequenceFile.createNewFile();
                    if (chromosomeFileWriter != null) {
                        chromosomeFileWriter.close();
                        chromosomeFileWriter = null;
                    }
                    chromosomeFileWriter = new BufferedWriter(new FileWriter(chromosomeSequenceFile));
                    continue;
                }
                if (chromosomeFileWriter == null) continue;
                chrSize += fastaDataLine.length();
                chromosomeFileWriter.write(fastaDataLine.toUpperCase());
            }
            if (chr != null) {
                chromSizes.put(chr, chrSize);
            }
            boolean bl = alteredChrFilenames;
            return bl;
        }
        finally {
            if (chromosomeFileWriter != null) {
                chromosomeFileWriter.close();
            }
            if (dataReader != null) {
                dataReader.close();
            }
        }
    }
}

