/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.variantcontext;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.sf.picard.reference.ReferenceSequenceFile;
import net.sf.samtools.util.StringUtil;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;
import org.broad.tribble.util.popgen.HardyWeinbergCalculation;
import org.broadinstitute.sting.utils.BaseUtils;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocParser;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.codecs.vcf.AbstractVCFCodec;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;
import org.broadinstitute.sting.utils.variantcontext.JEXLMap;
import org.broadinstitute.sting.utils.variantcontext.MutableGenotype;
import org.broadinstitute.sting.utils.variantcontext.MutableVariantContext;
import org.broadinstitute.sting.utils.variantcontext.VariantContext;

public class VariantContextUtils {
    public static final JexlEngine engine = new JexlEngine();

    public static VariantContext toVC(String name, GenomeLoc loc, Collection<Allele> alleles, Collection<Genotype> genotypes, double negLog10PError, Set<String> filters, Map<String, ?> attributes) {
        return new VariantContext(name, loc.getContig(), (long)loc.getStart(), (long)loc.getStop(), alleles, genotypes != null ? VariantContext.genotypeCollectionToMap(new TreeMap<String, Genotype>(), genotypes) : null, negLog10PError, filters, attributes);
    }

    public static VariantContext toVC(String name, GenomeLoc loc, Collection<Allele> alleles) {
        return new VariantContext(name, loc.getContig(), (long)loc.getStart(), (long)loc.getStop(), alleles, VariantContext.NO_GENOTYPES, -1.0, null, null);
    }

    public static VariantContext toVC(String name, GenomeLoc loc, Collection<Allele> alleles, Collection<Genotype> genotypes) {
        return new VariantContext(name, loc.getContig(), (long)loc.getStart(), (long)loc.getStop(), alleles, genotypes, -1.0, null, null);
    }

    public static VariantContext toVC(VariantContext other) {
        return new VariantContext(other.getSource(), other.getChr(), (long)other.getStart(), (long)other.getEnd(), other.getAlleles(), other.getGenotypes(), other.getNegLog10PError(), other.getFilters(), other.getAttributes());
    }

    public static void calculateChromosomeCounts(VariantContext vc, Map<String, Object> attributes, boolean removeStaleValues) {
        if (vc.getChromosomeCount() == 0 && removeStaleValues) {
            if (attributes.containsKey("AC")) {
                attributes.remove("AC");
            }
            if (attributes.containsKey("AF")) {
                attributes.remove("AF");
            }
            if (attributes.containsKey("AN")) {
                attributes.remove("AN");
            }
            return;
        }
        if (vc.hasGenotypes()) {
            attributes.put("AN", vc.getChromosomeCount());
            if (vc.getAlternateAlleles().size() > 0) {
                ArrayList<String> alleleFreqs = new ArrayList<String>();
                ArrayList<Integer> alleleCounts = new ArrayList<Integer>();
                double totalChromosomes = vc.getChromosomeCount();
                for (Allele allele : vc.getAlternateAlleles()) {
                    int altChromosomes = vc.getChromosomeCount(allele);
                    alleleCounts.add(altChromosomes);
                    String freq = String.format(VariantContextUtils.makePrecisionFormatStringFromDenominatorValue(totalChromosomes), (double)altChromosomes / totalChromosomes);
                    alleleFreqs.add(freq);
                }
                attributes.put("AC", alleleCounts.size() == 1 ? (Serializable)alleleCounts.get(0) : alleleCounts);
                attributes.put("AF", alleleFreqs.size() == 1 ? (Serializable)alleleFreqs.get(0) : alleleFreqs);
            } else {
                attributes.put("AC", 0);
                attributes.put("AF", 0.0);
            }
        }
    }

    private static String makePrecisionFormatStringFromDenominatorValue(double maxValue) {
        int precision = 1;
        while (maxValue > 1.0) {
            ++precision;
            maxValue /= 10.0;
        }
        return "%." + precision + "f";
    }

    public static List<JexlVCMatchExp> initializeMatchExps(String[] names, String[] exps) {
        if (names == null || exps == null) {
            throw new ReviewedStingException("BUG: neither names nor exps can be null: names " + Arrays.toString(names) + " exps=" + Arrays.toString(exps));
        }
        if (names.length != exps.length) {
            throw new UserException("Inconsistent number of provided filter names and expressions: names=" + Arrays.toString(names) + " exps=" + Arrays.toString(exps));
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i2 = 0; i2 < names.length; ++i2) {
            map.put(names[i2], exps[i2]);
        }
        return VariantContextUtils.initializeMatchExps(map);
    }

    public static List<JexlVCMatchExp> initializeMatchExps(ArrayList<String> names, ArrayList<String> exps) {
        String[] nameArray = new String[names.size()];
        String[] expArray = new String[exps.size()];
        return VariantContextUtils.initializeMatchExps(names.toArray(nameArray), exps.toArray(expArray));
    }

    public static List<JexlVCMatchExp> initializeMatchExps(Map<String, String> names_and_exps) {
        ArrayList<JexlVCMatchExp> exps = new ArrayList<JexlVCMatchExp>();
        for (Map.Entry<String, String> elt : names_and_exps.entrySet()) {
            String name = elt.getKey();
            String expStr = elt.getValue();
            if (name == null || expStr == null) {
                throw new IllegalArgumentException("Cannot create null expressions : " + name + " " + expStr);
            }
            try {
                Expression exp = engine.createExpression(expStr);
                exps.add(new JexlVCMatchExp(name, exp));
            }
            catch (Exception e2) {
                throw new UserException.BadArgumentValue(name, "Invalid expression used (" + expStr + "). Please see the JEXL docs for correct syntax.");
            }
        }
        return exps;
    }

    public static boolean match(VariantContext vc, JexlVCMatchExp exp) {
        return VariantContextUtils.match(vc, Arrays.asList(exp)).get(exp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext vc, Collection<JexlVCMatchExp> exps) {
        return new JEXLMap(exps, vc);
    }

    public static boolean match(VariantContext vc, Genotype g2, JexlVCMatchExp exp) {
        return VariantContextUtils.match(vc, g2, Arrays.asList(exp)).get(exp);
    }

    public static Map<JexlVCMatchExp, Boolean> match(VariantContext vc, Genotype g2, Collection<JexlVCMatchExp> exps) {
        return new JEXLMap(exps, vc, g2);
    }

    public static double computeHardyWeinbergPvalue(VariantContext vc) {
        if (vc.getChromosomeCount() == 0) {
            return 0.0;
        }
        return HardyWeinbergCalculation.hwCalculate(vc.getHomRefCount(), vc.getHetCount(), vc.getHomVarCount());
    }

    @Requires(value={"vc != null"})
    @Ensures(value={"result != null"})
    public static VariantContext sitesOnlyVariantContext(VariantContext vc) {
        return new VariantContext(vc.getSource(), vc.getChr(), vc.getStart(), vc.getEnd(), vc.getAlleles(), vc.getNegLog10PError(), vc.filtersWereApplied() ? vc.getFilters() : null, vc.getAttributes());
    }

    @Requires(value={"vcs != null"})
    @Ensures(value={"result != null"})
    public static Collection<VariantContext> sitesOnlyVariantContexts(Collection<VariantContext> vcs) {
        ArrayList<VariantContext> r = new ArrayList<VariantContext>();
        for (VariantContext vc : vcs) {
            r.add(VariantContextUtils.sitesOnlyVariantContext(vc));
        }
        return r;
    }

    public static VariantContext pruneVariantContext(VariantContext vc) {
        return VariantContextUtils.pruneVariantContext(vc, null);
    }

    public static VariantContext pruneVariantContext(VariantContext vc, Collection<String> keysToPreserve) {
        MutableVariantContext mvc = new MutableVariantContext(vc);
        if (keysToPreserve == null || keysToPreserve.size() == 0) {
            mvc.clearAttributes();
        } else {
            Map<String, Object> d2 = mvc.getAttributes();
            mvc.clearAttributes();
            for (String key : keysToPreserve) {
                if (!d2.containsKey(key)) continue;
                mvc.putAttribute(key, d2.get(key));
            }
        }
        Collection<Genotype> gs = mvc.getGenotypes().values();
        mvc.clearGenotypes();
        for (Genotype g2 : gs) {
            MutableGenotype mg = new MutableGenotype(g2);
            mg.clearAttributes();
            if (keysToPreserve != null) {
                for (String key : keysToPreserve) {
                    if (!g2.hasAttribute(key)) continue;
                    mg.putAttribute(key, g2.getAttribute(key));
                }
            }
            mvc.addGenotype(mg);
        }
        return mvc;
    }

    public static VariantContext masterMerge(Collection<VariantContext> unsortedVCs, String masterName) {
        VariantContext master = VariantContextUtils.findMaster(unsortedVCs, masterName);
        Map<String, Genotype> genotypes = master.getGenotypes();
        for (Genotype g2 : genotypes.values()) {
            genotypes.put(g2.getSampleName(), new MutableGenotype(g2));
        }
        HashMap<String, Object> masterAttributes = new HashMap<String, Object>(master.getAttributes());
        for (VariantContext vc : unsortedVCs) {
            if (vc.getSource().equals(masterName)) continue;
            for (Genotype genotype : vc.getGenotypes().values()) {
                MutableGenotype masterG = (MutableGenotype)genotypes.get(genotype.getSampleName());
                for (Map.Entry<String, Object> attr : genotype.getAttributes().entrySet()) {
                    if (masterG.hasAttribute(attr.getKey())) continue;
                    masterG.putAttribute(attr.getKey(), attr.getValue());
                }
                if (masterG.isPhased() == genotype.isPhased() || !masterG.sameGenotype(genotype)) continue;
                masterG.setAlleles(genotype.getAlleles());
                masterG.setPhase(genotype.isPhased());
            }
            for (Map.Entry entry : vc.getAttributes().entrySet()) {
                if (masterAttributes.containsKey(entry.getKey())) continue;
                masterAttributes.put((String)entry.getKey(), entry.getValue());
            }
        }
        return new VariantContext(master.getSource(), master.getChr(), (long)master.getStart(), (long)master.getEnd(), master.getAlleles(), genotypes, master.getNegLog10PError(), master.getFilters(), masterAttributes);
    }

    private static VariantContext findMaster(Collection<VariantContext> unsortedVCs, String masterName) {
        for (VariantContext vc : unsortedVCs) {
            if (!vc.getSource().equals(masterName)) continue;
            return vc;
        }
        throw new ReviewedStingException(String.format("Couldn't find master VCF %s at %s", masterName, unsortedVCs.iterator().next()));
    }

    public static VariantContext simpleMerge(GenomeLocParser genomeLocParser, Collection<VariantContext> unsortedVCs, byte refBase) {
        return VariantContextUtils.simpleMerge(genomeLocParser, unsortedVCs, null, FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED, GenotypeMergeType.UNSORTED, false, false, refBase);
    }

    public static VariantContext simpleMerge(GenomeLocParser genomeLocParser, Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, FilteredRecordMergeType filteredRecordMergeType, GenotypeMergeType genotypeMergeOptions, boolean annotateOrigin, boolean printMessages, byte inputRefBase) {
        return VariantContextUtils.simpleMerge(genomeLocParser, unsortedVCs, priorityListOfVCs, filteredRecordMergeType, genotypeMergeOptions, annotateOrigin, printMessages, inputRefBase, "set", false, false);
    }

    public static VariantContext simpleMerge(GenomeLocParser genomeLocParser, Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, FilteredRecordMergeType filteredRecordMergeType, GenotypeMergeType genotypeMergeOptions, boolean annotateOrigin, boolean printMessages, byte inputRefBase, String setKey, boolean filteredAreUncalled, boolean mergeInfoWithMaxAC) {
        if (unsortedVCs == null || unsortedVCs.size() == 0) {
            return null;
        }
        if (annotateOrigin && priorityListOfVCs == null) {
            throw new IllegalArgumentException("Cannot merge calls and annotate their origins without a complete priority list of VariantContexts");
        }
        if (genotypeMergeOptions == GenotypeMergeType.REQUIRE_UNIQUE) {
            VariantContextUtils.verifyUniqueSampleNames(unsortedVCs);
        }
        List<VariantContext> prepaddedVCs = VariantContextUtils.sortVariantContextsByPriority(unsortedVCs, priorityListOfVCs, genotypeMergeOptions);
        ArrayList<VariantContext> VCs = new ArrayList<VariantContext>();
        for (VariantContext vc : prepaddedVCs) {
            if (filteredAreUncalled && !vc.isNotFiltered()) continue;
            VCs.add(VariantContext.createVariantContextWithPaddedAlleles(vc, inputRefBase, false));
        }
        if (VCs.size() == 0) {
            return null;
        }
        VariantContext first = (VariantContext)VCs.get(0);
        String name = first.getSource();
        GenomeLoc loc = VariantContextUtils.getLocation(genomeLocParser, first);
        TreeSet<Allele> alleles = new TreeSet<Allele>();
        TreeMap<String, Genotype> genotypes = new TreeMap<String, Genotype>();
        double negLog10PError = -1.0;
        TreeSet<String> filters = new TreeSet<String>();
        TreeMap<String, Object> attributes = new TreeMap<String, Object>();
        HashSet<String> inconsistentAttributes = new HashSet<String>();
        String rsID = null;
        int depth = 0;
        int maxAC = -1;
        TreeMap<String, Object> attributesWithMaxAC = new TreeMap<String, Object>();
        VariantContext vcWithMaxAC = null;
        int nFiltered = 0;
        int nVariant = 0;
        Allele refAllele = VariantContextUtils.determineReferenceAllele(VCs);
        boolean remapped = false;
        for (VariantContext vc : VCs) {
            if (loc.getStart() != vc.getStart()) {
                throw new ReviewedStingException("BUG: attempting to merge VariantContexts with different start sites: first=" + first.toString() + " second=" + vc.toString());
            }
            if (VariantContextUtils.getLocation(genomeLocParser, vc).size() > loc.size()) {
                loc = VariantContextUtils.getLocation(genomeLocParser, vc);
            }
            nFiltered += vc.isFiltered() ? 1 : 0;
            nVariant += vc.isVariant() ? 1 : 0;
            AlleleMapper alleleMapping = VariantContextUtils.resolveIncompatibleAlleles(refAllele, vc, alleles);
            remapped = remapped || alleleMapping.needsRemapping();
            alleles.addAll(alleleMapping.values());
            VariantContextUtils.mergeGenotypes(genotypes, vc, alleleMapping, genotypeMergeOptions == GenotypeMergeType.UNIQUIFY);
            negLog10PError = Math.max(negLog10PError, vc.isVariant() ? vc.getNegLog10PError() : -1.0);
            filters.addAll(vc.getFilters());
            if (vc.hasAttribute("DP")) {
                depth += Integer.valueOf(vc.getAttributeAsString("DP")).intValue();
            }
            if (rsID == null && vc.hasID()) {
                rsID = vc.getID();
            }
            if (mergeInfoWithMaxAC && vc.hasAttribute("AC")) {
                String rawAlleleCounts = vc.getAttributeAsString("AC");
                if (rawAlleleCounts.contains(",")) {
                    List<String> alleleCountArray = Arrays.asList(rawAlleleCounts.substring(1, rawAlleleCounts.length() - 1).split(","));
                    for (String alleleCount : alleleCountArray) {
                        int ac = Integer.valueOf(alleleCount.trim());
                        if (ac <= maxAC) continue;
                        maxAC = ac;
                        vcWithMaxAC = vc;
                    }
                } else {
                    int ac = Integer.valueOf(rawAlleleCounts);
                    if (ac > maxAC) {
                        maxAC = ac;
                        vcWithMaxAC = vc;
                    }
                }
            }
            for (Map.Entry<String, Object> p2 : vc.getAttributes().entrySet()) {
                boolean boundIsMissingValue;
                String key = p2.getKey();
                if (inconsistentAttributes.contains(key)) continue;
                boolean alreadyFound = attributes.containsKey(key);
                Object boundValue = attributes.get(key);
                boolean bl = boundIsMissingValue = alreadyFound && boundValue.equals(".");
                if (alreadyFound && !boundValue.equals(p2.getValue()) && !boundIsMissingValue) {
                    inconsistentAttributes.add(key);
                    attributes.remove(key);
                    continue;
                }
                if (alreadyFound && !boundIsMissingValue) continue;
                attributes.put(key, p2.getValue());
            }
        }
        if (mergeInfoWithMaxAC && vcWithMaxAC != null) {
            attributesWithMaxAC.putAll(vcWithMaxAC.getAttributes());
        }
        if (filteredRecordMergeType == FilteredRecordMergeType.KEEP_IF_ANY_UNFILTERED && nFiltered != VCs.size()) {
            filters.clear();
        }
        if (annotateOrigin) {
            String setValue;
            if (nFiltered == 0 && nVariant == priorityListOfVCs.size()) {
                setValue = "Intersection";
            } else if (nFiltered == VCs.size()) {
                setValue = "FilteredInAll";
            } else if (nVariant == 0) {
                setValue = "ReferenceInAll";
            } else {
                ArrayList<String> s = new ArrayList<String>();
                for (VariantContext vc : VCs) {
                    if (!vc.isVariant()) continue;
                    s.add(vc.isFiltered() ? "filterIn" + vc.getSource() : vc.getSource());
                }
                setValue = Utils.join((String)"-", s);
            }
            if (setKey != null) {
                attributes.put(setKey, setValue);
                if (mergeInfoWithMaxAC && vcWithMaxAC != null) {
                    attributesWithMaxAC.put(setKey, vcWithMaxAC.getSource());
                }
            }
        }
        if (depth > 0) {
            attributes.put("DP", String.valueOf(depth));
        }
        if (rsID != null) {
            attributes.put("ID", rsID);
        }
        VariantContext merged = new VariantContext(name, loc.getContig(), (long)loc.getStart(), (long)loc.getStop(), alleles, genotypes, negLog10PError, filters, mergeInfoWithMaxAC ? attributesWithMaxAC : attributes);
        merged = AbstractVCFCodec.createVariantContextWithTrimmedAlleles(merged);
        if (printMessages && remapped) {
            System.out.printf("Remapped => %s%n", merged);
        }
        return merged;
    }

    private static void verifyUniqueSampleNames(Collection<VariantContext> unsortedVCs) {
        HashSet<String> names = new HashSet<String>();
        for (VariantContext vc : unsortedVCs) {
            for (String name : vc.getSampleNames()) {
                if (!names.contains(name)) continue;
                throw new UserException("REQUIRE_UNIQUE sample names is true but duplicate names were discovered " + name);
            }
            names.addAll(vc.getSampleNames());
        }
    }

    private static Allele determineReferenceAllele(List<VariantContext> VCs) {
        Allele ref = null;
        for (VariantContext vc : VCs) {
            Allele myRef = vc.getReference();
            if (ref == null || ref.length() < myRef.length()) {
                ref = myRef;
                continue;
            }
            if (ref.length() != myRef.length() || ref.equals(myRef)) continue;
            throw new UserException.BadInput(String.format("The provided variant file(s) have inconsistent references for the same position(s) at %s:%d, %s vs. %s", vc.getChr(), vc.getStart(), ref, myRef));
        }
        return ref;
    }

    private static AlleleMapper resolveIncompatibleAlleles(Allele refAllele, VariantContext vc, Set<Allele> allAlleles) {
        if (refAllele.equals(vc.getReference())) {
            return new AlleleMapper(vc);
        }
        Allele myRef = vc.getReference();
        if (refAllele.length() <= myRef.length()) {
            throw new ReviewedStingException("BUG: myRef=" + myRef + " is longer than refAllele=" + refAllele);
        }
        byte[] extraBases = Arrays.copyOfRange(refAllele.getBases(), myRef.length(), refAllele.length());
        HashMap<Allele, Allele> map = new HashMap<Allele, Allele>();
        for (Allele a2 : vc.getAlleles()) {
            if (a2.isReference()) {
                map.put(a2, refAllele);
                continue;
            }
            Allele extended = Allele.extend(a2, extraBases);
            for (Allele b2 : allAlleles) {
                if (!extended.equals(b2)) continue;
                extended = b2;
            }
            map.put(a2, extended);
        }
        return new AlleleMapper(map);
    }

    public static List<VariantContext> sortVariantContextsByPriority(Collection<VariantContext> unsortedVCs, List<String> priorityListOfVCs, GenotypeMergeType mergeOption) {
        if (mergeOption == GenotypeMergeType.PRIORITIZE && priorityListOfVCs == null) {
            throw new IllegalArgumentException("Cannot merge calls by priority with a null priority list");
        }
        if (priorityListOfVCs == null || mergeOption == GenotypeMergeType.UNSORTED) {
            return new ArrayList<VariantContext>(unsortedVCs);
        }
        ArrayList<VariantContext> sorted = new ArrayList<VariantContext>(unsortedVCs);
        Collections.sort(sorted, new CompareByPriority(priorityListOfVCs));
        return sorted;
    }

    private static void mergeGenotypes(Map<String, Genotype> mergedGenotypes, VariantContext oneVC, AlleleMapper alleleMapping, boolean uniqifySamples) {
        for (Genotype g2 : oneVC.getGenotypes().values()) {
            String name = VariantContextUtils.mergedSampleName(oneVC.getSource(), g2.getSampleName(), uniqifySamples);
            if (mergedGenotypes.containsKey(name)) continue;
            Genotype newG = g2;
            if (uniqifySamples || alleleMapping.needsRemapping()) {
                MutableGenotype mutG = new MutableGenotype(name, g2);
                if (alleleMapping.needsRemapping()) {
                    mutG.setAlleles(alleleMapping.remap(g2.getAlleles()));
                }
                newG = mutG;
            }
            mergedGenotypes.put(name, newG);
        }
    }

    public static String mergedSampleName(String trackName, String sampleName, boolean uniqify) {
        return uniqify ? sampleName + "." + trackName : sampleName;
    }

    public static VariantContext reverseComplement(VariantContext vc) {
        HashMap<Allele, Allele> alleleMap = new HashMap<Allele, Allele>(vc.getAlleles().size());
        for (Allele originalAllele : vc.getAlleles()) {
            Allele newAllele = originalAllele.isNoCall() || originalAllele.isNull() ? originalAllele : Allele.create(BaseUtils.simpleReverseComplement((byte[])originalAllele.getBases()), originalAllele.isReference());
            alleleMap.put(originalAllele, newAllele);
        }
        HashMap<String, Genotype> newGenotypes = new HashMap<String, Genotype>(vc.getNSamples());
        for (Map.Entry<String, Genotype> genotype : vc.getGenotypes().entrySet()) {
            ArrayList<Allele> newAlleles = new ArrayList<Allele>();
            for (Allele allele : genotype.getValue().getAlleles()) {
                Allele newAllele = (Allele)alleleMap.get(allele);
                if (newAllele == null) {
                    newAllele = Allele.NO_CALL;
                }
                newAlleles.add(newAllele);
            }
            newGenotypes.put(genotype.getKey(), Genotype.modifyAlleles(genotype.getValue(), newAlleles));
        }
        return new VariantContext(vc.getSource(), vc.getChr(), (long)vc.getStart(), (long)vc.getEnd(), alleleMap.values(), newGenotypes, vc.getNegLog10PError(), vc.filtersWereApplied() ? vc.getFilters() : null, vc.getAttributes());
    }

    public static VariantContext purgeUnallowedGenotypeAttributes(VariantContext vc, Set<String> allowedAttributes) {
        if (allowedAttributes == null) {
            return vc;
        }
        HashMap<String, Genotype> newGenotypes = new HashMap<String, Genotype>(vc.getNSamples());
        for (Map.Entry<String, Genotype> genotype : vc.getGenotypes().entrySet()) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            for (Map.Entry<String, Object> attr : genotype.getValue().getAttributes().entrySet()) {
                if (!allowedAttributes.contains(attr.getKey())) continue;
                attrs.put(attr.getKey(), attr.getValue());
            }
            newGenotypes.put(genotype.getKey(), Genotype.modifyAttributes(genotype.getValue(), attrs));
        }
        return VariantContext.modifyGenotypes(vc, newGenotypes);
    }

    public static BaseUtils.BaseSubstitutionType getSNPSubstitutionType(VariantContext context) {
        if (!context.isSNP() || !context.isBiallelic()) {
            throw new IllegalStateException("Requested SNP substitution type for bialleic non-SNP " + context);
        }
        return BaseUtils.SNPSubstitutionType((byte)context.getReference().getBases()[0], (byte)context.getAlternateAllele(0).getBases()[0]);
    }

    public static boolean isTransition(VariantContext context) {
        return VariantContextUtils.getSNPSubstitutionType(context) == BaseUtils.BaseSubstitutionType.TRANSITION;
    }

    public static boolean isTransversion(VariantContext context) {
        return VariantContextUtils.getSNPSubstitutionType(context) == BaseUtils.BaseSubstitutionType.TRANSVERSION;
    }

    public static final GenomeLoc getLocation(GenomeLocParser genomeLocParser, VariantContext vc) {
        return genomeLocParser.createGenomeLoc(vc.getChr(), vc.getStart(), vc.getEnd(), true);
    }

    public static VariantContext mergeIntoMNP(GenomeLocParser genomeLocParser, VariantContext vc1, VariantContext vc2, ReferenceSequenceFile referenceFile, AlleleMergeRule alleleMergeRule) {
        if (!VariantContextUtils.mergeIntoMNPvalidationCheck(genomeLocParser, vc1, vc2)) {
            return null;
        }
        if (!VariantContextUtils.allSamplesAreMergeable(vc1, vc2)) {
            return null;
        }
        if (!alleleMergeRule.allelesShouldBeMerged(vc1, vc2)) {
            return null;
        }
        return VariantContextUtils.reallyMergeIntoMNP(vc1, vc2, referenceFile);
    }

    private static VariantContext reallyMergeIntoMNP(VariantContext vc1, VariantContext vc2, ReferenceSequenceFile referenceFile) {
        int startInter = vc1.getEnd() + 1;
        int endInter = vc2.getStart() - 1;
        byte[] intermediateBases = null;
        if (startInter <= endInter) {
            intermediateBases = referenceFile.getSubsequenceAt(vc1.getChr(), (long)startInter, (long)endInter).getBases();
            StringUtil.toUpperCase(intermediateBases);
        }
        MergedAllelesData mergeData = new MergedAllelesData(intermediateBases, vc1, vc2);
        HashMap<String, Genotype> mergedGenotypes = new HashMap<String, Genotype>();
        for (Map.Entry<String, Genotype> gt1Entry : vc1.getGenotypes().entrySet()) {
            String sample = gt1Entry.getKey();
            Genotype gt1 = gt1Entry.getValue();
            Genotype gt2 = vc2.getGenotype(sample);
            List<Allele> site1Alleles = gt1.getAlleles();
            List<Allele> site2Alleles = gt2.getAlleles();
            LinkedList<Allele> mergedAllelesForSample = new LinkedList<Allele>();
            Iterator<Allele> all2It = site2Alleles.iterator();
            for (Allele all1 : site1Alleles) {
                Allele all2 = all2It.next();
                Allele mergedAllele = mergeData.ensureMergedAllele(all1, all2);
                mergedAllelesForSample.add(mergedAllele);
            }
            double mergedGQ = Math.max(gt1.getNegLog10PError(), gt2.getNegLog10PError());
            HashSet<String> mergedGtFilters = new HashSet<String>();
            HashMap<String, Double> mergedGtAttribs = new HashMap<String, Double>();
            PhaseAndQuality phaseQual = VariantContextUtils.calcPhaseForMergedGenotypes(gt1, gt2);
            if (phaseQual.PQ != null) {
                mergedGtAttribs.put("PQ", phaseQual.PQ);
            }
            Genotype mergedGt = new Genotype(sample, mergedAllelesForSample, mergedGQ, mergedGtFilters, mergedGtAttribs, phaseQual.isPhased);
            mergedGenotypes.put(sample, mergedGt);
        }
        String mergedName = VariantContextUtils.mergeVariantContextNames(vc1.getSource(), vc2.getSource());
        double mergedNegLog10PError = Math.max(vc1.getNegLog10PError(), vc2.getNegLog10PError());
        HashSet<String> mergedFilters = new HashSet<String>();
        Map<String, Object> mergedAttribs = VariantContextUtils.mergeVariantContextAttributes(vc1, vc2);
        VariantContext mergedVc = new VariantContext(mergedName, vc1.getChr(), (long)vc1.getStart(), (long)vc2.getEnd(), mergeData.getAllMergedAlleles(), mergedGenotypes, mergedNegLog10PError, mergedFilters, mergedAttribs);
        mergedAttribs = new HashMap<String, Object>(mergedVc.getAttributes());
        VariantContextUtils.calculateChromosomeCounts(mergedVc, mergedAttribs, true);
        mergedVc = VariantContext.modifyAttributes(mergedVc, mergedAttribs);
        return mergedVc;
    }

    private static String mergeVariantContextNames(String name1, String name2) {
        return name1 + "_" + name2;
    }

    private static Map<String, Object> mergeVariantContextAttributes(VariantContext vc1, VariantContext vc2) {
        String[] MERGE_OR_ATTRIBS;
        HashMap<String, Object> mergedAttribs = new HashMap<String, Object>();
        LinkedList<VariantContext> vcList = new LinkedList<VariantContext>();
        vcList.add(vc1);
        vcList.add(vc2);
        for (String orAttrib : MERGE_OR_ATTRIBS = new String[]{"DB"}) {
            boolean attribVal = false;
            for (VariantContext vc : vcList) {
                Boolean val = vc.getAttributeAsBooleanNoException(orAttrib);
                if (val != null) {
                    boolean bl = attribVal = attribVal || val != false;
                }
                if (!attribVal) continue;
                break;
            }
            mergedAttribs.put(orAttrib, attribVal);
        }
        String iDVal = null;
        for (VariantContext vc : vcList) {
            String val = vc.getAttributeAsStringNoException("ID");
            if (val == null || val.equals(".")) continue;
            if (iDVal == null) {
                iDVal = val;
                continue;
            }
            iDVal = iDVal + ";" + val;
        }
        if (iDVal != null) {
            mergedAttribs.put("ID", iDVal);
        }
        return mergedAttribs;
    }

    private static boolean mergeIntoMNPvalidationCheck(GenomeLocParser genomeLocParser, VariantContext vc1, VariantContext vc2) {
        GenomeLoc loc2;
        GenomeLoc loc1 = VariantContextUtils.getLocation(genomeLocParser, vc1);
        if (!loc1.onSameContig(loc2 = VariantContextUtils.getLocation(genomeLocParser, vc2))) {
            throw new ReviewedStingException("Can only merge vc1, vc2 if on the same chromosome");
        }
        if (!loc1.isBefore(loc2)) {
            throw new ReviewedStingException("Can only merge if vc1 is BEFORE vc2");
        }
        if (vc1.isFiltered() || vc2.isFiltered()) {
            return false;
        }
        if (!((Object)vc1.getSampleNames()).equals(vc2.getSampleNames())) {
            return false;
        }
        return VariantContextUtils.allGenotypesAreUnfilteredAndCalled(vc1) && VariantContextUtils.allGenotypesAreUnfilteredAndCalled(vc2);
    }

    private static boolean allGenotypesAreUnfilteredAndCalled(VariantContext vc) {
        for (Map.Entry<String, Genotype> gtEntry : vc.getGenotypes().entrySet()) {
            Genotype gt = gtEntry.getValue();
            if (!gt.isNoCall() && !gt.isFiltered()) continue;
            return false;
        }
        return true;
    }

    private static boolean allSamplesAreMergeable(VariantContext vc1, VariantContext vc2) {
        for (Map.Entry<String, Genotype> gt1Entry : vc1.getGenotypes().entrySet()) {
            Genotype gt2;
            String sample = gt1Entry.getKey();
            Genotype gt1 = gt1Entry.getValue();
            if (VariantContextUtils.alleleSegregationIsKnown(gt1, gt2 = vc2.getGenotype(sample))) continue;
            return false;
        }
        return true;
    }

    public static boolean alleleSegregationIsKnown(Genotype gt1, Genotype gt2) {
        if (gt1.getPloidy() != gt2.getPloidy()) {
            return false;
        }
        return gt2.isPhased() || gt2.isHom() || gt1.isHom();
    }

    private static PhaseAndQuality calcPhaseForMergedGenotypes(Genotype gt1, Genotype gt2) {
        if (gt2.isPhased() || gt2.isHom()) {
            return new PhaseAndQuality(gt1);
        }
        if (!gt1.isHom()) {
            throw new ReviewedStingException("alleleSegregationIsKnown(gt1, gt2) implies: gt2.genotypesArePhased() || gt2.isHom() || gt1.isHom()");
        }
        return new PhaseAndQuality(gt2);
    }

    public static boolean someSampleHasDoubleNonReferenceAllele(VariantContext vc1, VariantContext vc2) {
        for (Map.Entry<String, Genotype> gt1Entry : vc1.getGenotypes().entrySet()) {
            String sample = gt1Entry.getKey();
            Genotype gt1 = gt1Entry.getValue();
            Genotype gt2 = vc2.getGenotype(sample);
            List<Allele> site1Alleles = gt1.getAlleles();
            List<Allele> site2Alleles = gt2.getAlleles();
            Iterator<Allele> all2It = site2Alleles.iterator();
            for (Allele all1 : site1Alleles) {
                Allele all2 = all2It.next();
                if (!all1.isNonReference() || !all2.isNonReference()) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean doubleAllelesSegregatePerfectlyAmongSamples(VariantContext vc1, VariantContext vc2) {
        HashMap<Allele, Allele> allele1ToAllele2 = new HashMap<Allele, Allele>();
        HashMap<Allele, Allele> allele2ToAllele1 = new HashMap<Allele, Allele>();
        allele1ToAllele2.put(vc1.getReference(), vc2.getReference());
        allele2ToAllele1.put(vc2.getReference(), vc1.getReference());
        for (Map.Entry<String, Genotype> gt1Entry : vc1.getGenotypes().entrySet()) {
            String sample = gt1Entry.getKey();
            Genotype gt1 = gt1Entry.getValue();
            Genotype gt2 = vc2.getGenotype(sample);
            List<Allele> site1Alleles = gt1.getAlleles();
            List<Allele> site2Alleles = gt2.getAlleles();
            Iterator<Allele> all2It = site2Alleles.iterator();
            for (Allele all1 : site1Alleles) {
                Allele all2 = all2It.next();
                Allele all1To2 = (Allele)allele1ToAllele2.get(all1);
                if (all1To2 == null) {
                    allele1ToAllele2.put(all1, all2);
                } else if (!all1To2.equals(all2)) {
                    return false;
                }
                Allele all2To1 = (Allele)allele2ToAllele1.get(all2);
                if (all2To1 == null) {
                    allele2ToAllele1.put(all2, all1);
                    continue;
                }
                if (all2To1.equals(all1)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        engine.setSilent(false);
        engine.setLenient(false);
    }

    private static class PhaseAndQuality {
        public boolean isPhased;
        public Double PQ = null;

        public PhaseAndQuality(Genotype gt) {
            this.isPhased = gt.isPhased();
            if (this.isPhased) {
                this.PQ = gt.getAttributeAsDoubleNoException("PQ");
            }
        }
    }

    private static class MergedAllelesData {
        private Map<AlleleOneAndTwo, Allele> mergedAlleles = new HashMap<AlleleOneAndTwo, Allele>();
        private byte[] intermediateBases;
        private int intermediateLength;

        public MergedAllelesData(byte[] intermediateBases, VariantContext vc1, VariantContext vc2) {
            this.intermediateBases = intermediateBases;
            this.intermediateLength = this.intermediateBases != null ? this.intermediateBases.length : 0;
            this.ensureMergedAllele(vc1.getReference(), vc2.getReference(), true);
        }

        public Allele ensureMergedAllele(Allele all1, Allele all2) {
            return this.ensureMergedAllele(all1, all2, false);
        }

        private Allele ensureMergedAllele(Allele all1, Allele all2, boolean creatingReferenceForFirstTime) {
            AlleleOneAndTwo all12 = new AlleleOneAndTwo(all1, all2);
            Allele mergedAllele = this.mergedAlleles.get(all12);
            if (mergedAllele == null) {
                byte[] bases1 = all1.getBases();
                byte[] bases2 = all2.getBases();
                byte[] mergedBases = new byte[bases1.length + this.intermediateLength + bases2.length];
                System.arraycopy(bases1, 0, mergedBases, 0, bases1.length);
                if (this.intermediateBases != null) {
                    System.arraycopy(this.intermediateBases, 0, mergedBases, bases1.length, this.intermediateLength);
                }
                System.arraycopy(bases2, 0, mergedBases, bases1.length + this.intermediateLength, bases2.length);
                mergedAllele = Allele.create(mergedBases, creatingReferenceForFirstTime);
                this.mergedAlleles.put(all12, mergedAllele);
            }
            return mergedAllele;
        }

        public Set<Allele> getAllMergedAlleles() {
            return new HashSet<Allele>(this.mergedAlleles.values());
        }
    }

    private static class AlleleOneAndTwo {
        private Allele all1;
        private Allele all2;

        public AlleleOneAndTwo(Allele all1, Allele all2) {
            this.all1 = all1;
            this.all2 = all2;
        }

        public int hashCode() {
            return this.all1.hashCode() + this.all2.hashCode();
        }

        public boolean equals(Object other) {
            if (!(other instanceof AlleleOneAndTwo)) {
                return false;
            }
            AlleleOneAndTwo otherAot = (AlleleOneAndTwo)other;
            return this.all1.equals(otherAot.all1) && this.all2.equals(otherAot.all2);
        }
    }

    public static abstract class AlleleMergeRule {
        public abstract boolean allelesShouldBeMerged(VariantContext var1, VariantContext var2);

        public String toString() {
            return "all samples are mergeable";
        }
    }

    static class CompareByPriority
    implements Comparator<VariantContext>,
    Serializable {
        List<String> priorityListOfVCs;

        public CompareByPriority(List<String> priorityListOfVCs) {
            this.priorityListOfVCs = priorityListOfVCs;
        }

        private int getIndex(VariantContext vc) {
            int i2 = this.priorityListOfVCs.indexOf(vc.getSource());
            if (i2 == -1) {
                throw new UserException.BadArgumentValue(Utils.join((String)",", this.priorityListOfVCs), "Priority list " + this.priorityListOfVCs + " doesn't contain variant context " + vc.getSource());
            }
            return i2;
        }

        @Override
        public int compare(VariantContext vc1, VariantContext vc2) {
            return Integer.valueOf(this.getIndex(vc1)).compareTo(this.getIndex(vc2));
        }
    }

    private static class AlleleMapper {
        private VariantContext vc = null;
        private Map<Allele, Allele> map = null;

        public AlleleMapper(VariantContext vc) {
            this.vc = vc;
        }

        public AlleleMapper(Map<Allele, Allele> map) {
            this.map = map;
        }

        public boolean needsRemapping() {
            return this.map != null;
        }

        public Collection<Allele> values() {
            return this.map != null ? this.map.values() : this.vc.getAlleles();
        }

        public Allele remap(Allele a2) {
            return this.map != null && this.map.containsKey(a2) ? this.map.get(a2) : a2;
        }

        public List<Allele> remap(List<Allele> as) {
            ArrayList<Allele> newAs = new ArrayList<Allele>();
            for (Allele a2 : as) {
                newAs.add(this.remap(a2));
            }
            return newAs;
        }
    }

    public static enum FilteredRecordMergeType {
        KEEP_IF_ANY_UNFILTERED,
        KEEP_IF_ALL_UNFILTERED;

    }

    public static enum GenotypeMergeType {
        UNIQUIFY,
        PRIORITIZE,
        UNSORTED,
        REQUIRE_UNIQUE;

    }

    public static class JexlVCMatchExp {
        public String name;
        public Expression exp;

        public JexlVCMatchExp(String name, Expression exp) {
            this.name = name;
            this.exp = exp;
        }
    }
}

