/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.PreferenceManager;
import org.broad.igv.exceptions.DataLoadException;
import org.broad.igv.feature.AbstractFeatureParser;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.SequenceTrack;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackLoader;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.MessageCollection;
import org.broad.igv.ui.panel.DragEventManager;
import org.broad.igv.ui.panel.DragListener;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.ui.panel.TrackPanelScrollPane;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.LongRunningTask;
import org.broad.igv.util.NamedRunnable;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.vcf.VCFTrack;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.AsciiLineReader;

public class TrackManager {
    private static Logger log = Logger.getLogger(TrackManager.class);
    IGV igv;
    private TrackLoader loader;
    private final Map<String, TrackPanelScrollPane> trackPanelScrollPanes = new Hashtable<String, TrackPanelScrollPane>();
    private String groupByAttribute = null;
    private Track geneTrack;
    private SequenceTrack sequenceTrack;
    private Map<String, List<Track>> overlayTracksMap = new HashMap<String, List<Track>>();
    private Set<Track> overlaidTracks = new HashSet<Track>();
    public static final String DATA_PANEL_NAME = "DataPanel";
    public static final String FEATURE_PANEL_NAME = "FeaturePanel";

    public TrackManager(IGV igv) {
        this.igv = igv;
        this.loader = new TrackLoader();
    }

    public Track getGeneTrack() {
        return this.geneTrack;
    }

    public SequenceTrack getSequenceTrack() {
        return this.sequenceTrack;
    }

    public Set<TrackType> getLoadedTypes() {
        HashSet<TrackType> types = new HashSet<TrackType>();
        for (Track t : this.getAllTracks(false)) {
            TrackType type = t.getTrackType();
            if (t == null) continue;
            types.add(type);
        }
        return types;
    }

    public void putScrollPane(String name, TrackPanelScrollPane sp) {
        this.trackPanelScrollPanes.put(name, sp);
    }

    public TrackPanelScrollPane getScrollPane(String name) {
        return this.trackPanelScrollPanes.get(name);
    }

    public Collection<TrackPanelScrollPane> getTrackPanelScrollPanes() {
        return this.trackPanelScrollPanes.values();
    }

    public void removeScrollPane(String name) {
        this.trackPanelScrollPanes.remove(name);
    }

    public void clearScrollPanes() {
        this.trackPanelScrollPanes.clear();
    }

    public void setGroupByAttribute(String attributeName) {
        this.groupByAttribute = attributeName;
        this.groupTracksByAttribute();
        this.refreshData();
    }

    public void reset() {
        this.groupByAttribute = "";
        TrackPanelScrollPane tsp = this.trackPanelScrollPanes.get(DATA_PANEL_NAME);
        if (tsp != null) {
            tsp.getTrackPanel().reset();
        }
    }

    public void groupTracksByAttribute() {
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel trackPanel = tsp.getTrackPanel();
            trackPanel.groupTracksByAttribute(this.groupByAttribute);
        }
    }

    public void reloadSAMTracks() {
        for (Track t : this.getAllTracks(false)) {
            if (!(t instanceof AlignmentTrack)) continue;
            ((AlignmentTrack)t).clearCaches();
        }
        IGV.getInstance().repaintDataPanels();
    }

    public void sortAlignmentTracks(AlignmentTrack.SortOption option) {
        for (Track t : this.getAllTracks(false)) {
            if (!(t instanceof AlignmentTrack)) continue;
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                ((AlignmentTrack)t).sortRows(option, frame);
            }
        }
    }

    public void sortAlignmentTracks(AlignmentTrack.SortOption option, double location) {
        for (Track t : this.getAllTracks(false)) {
            if (!(t instanceof AlignmentTrack)) continue;
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                ((AlignmentTrack)t).sortRows(option, frame, location);
            }
        }
    }

    public void packAlignmentTracks() {
        for (Track t : this.getAllTracks(false)) {
            if (!(t instanceof AlignmentTrack)) continue;
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                ((AlignmentTrack)t).packAlignments(frame);
            }
        }
    }

    public void collapseTracks() {
        for (Track t : this.getAllTracks(true)) {
            t.setDisplayMode(Track.DisplayMode.COLLAPSED);
        }
    }

    public void expandTracks() {
        for (Track t : this.getAllTracks(true)) {
            t.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
    }

    public void collapseTrack(String trackName) {
        for (Track t : this.getAllTracks(true)) {
            if (!t.getName().equals(trackName)) continue;
            t.setDisplayMode(Track.DisplayMode.COLLAPSED);
        }
    }

    public void expandTrack(String trackName) {
        for (Track t : this.getAllTracks(true)) {
            if (!t.getName().equals(trackName)) continue;
            t.setDisplayMode(Track.DisplayMode.EXPANDED);
        }
    }

    public void loadResources(Collection<ResourceLocator> locators) {
        log.info("Loading" + locators.size() + " resources.");
        MessageCollection messages = new MessageCollection();
        for (ResourceLocator locator : locators) {
            File trackSetFile;
            if (locator.isLocal() && !(trackSetFile = new File(locator.getPath())).exists()) {
                messages.append("File not found: " + locator.getPath() + "\n");
                continue;
            }
            try {
                Track t;
                List<Track> tracks = this.load(locator);
                if (tracks.size() <= 0) continue;
                String path = locator.getPath();
                TrackPanel panel = this.getPanelFor(locator);
                if ((path.endsWith(".vcf") || path.endsWith(".vcf.gz") || path.endsWith(".vcf4") || path.endsWith(".vcf4.gz")) && (t = tracks.get(0)) instanceof VCFTrack && ((VCFTrack)t).getAllSamples().size() > 10) {
                    String newPanelName = "Panel" + System.currentTimeMillis();
                    panel = this.igv.addDataPanel(newPanelName).getTrackPanel();
                }
                panel.addTracks(tracks);
            }
            catch (Throwable e2) {
                log.error("Error loading tracks", e2);
                messages.append(e2.getMessage());
            }
        }
        this.groupTracksByAttribute();
        this.resetOverlayTracks();
        if (!messages.isEmpty()) {
            for (String message : messages.getMessages()) {
                MessageUtils.showMessage(message);
            }
        }
    }

    public List<Track> load(ResourceLocator locator) {
        try {
            List<Track> newTracks = this.loader.load(locator, this.igv);
            if (newTracks.size() > 0) {
                for (Track track : newTracks) {
                    String fn = locator.getPath();
                    int lastSlashIdx = fn.lastIndexOf("/");
                    if (lastSlashIdx < 0) {
                        lastSlashIdx = fn.lastIndexOf("\\");
                    }
                    if (lastSlashIdx > 0) {
                        fn = fn.substring(lastSlashIdx);
                    }
                    track.setAttributeValue("NAME", track.getName());
                    track.setAttributeValue("DATA FILE", fn);
                    track.setAttributeValue("DATA TYPE", track.getTrackType().toString());
                }
            }
            return newTracks;
        }
        catch (DataLoadException dle) {
            throw dle;
        }
        catch (Exception e2) {
            log.error(e2);
            throw new DataLoadException(e2.getMessage(), locator.getPath());
        }
    }

    public void load(File file, TrackPanel panel) {
        ResourceLocator locator = new ResourceLocator(file.getAbsolutePath());
        List<Track> tracks = this.load(locator);
        panel.addTracks(tracks);
        IGV.getInstance().doRefresh();
    }

    public void resetOverlayTracks() {
        this.overlayTracksMap.clear();
        this.overlaidTracks.clear();
        if (PreferenceManager.getInstance().getAsBoolean("OVERLAY_TRACKS_KEY")) {
            String overlayAttribute = IGV.getInstance().getSession().getOverlayAttribute();
            if (overlayAttribute != null) {
                for (Track track : this.getAllTracks(false)) {
                    String value;
                    if (track == null || track.getTrackType() != TrackType.MUTATION || (value = track.getAttributeValue(overlayAttribute)) == null) continue;
                    List<Track> trackList = this.overlayTracksMap.get(value);
                    if (trackList == null) {
                        trackList = new ArrayList<Track>();
                        this.overlayTracksMap.put(value, trackList);
                    }
                    trackList.add(track);
                }
            }
            for (Track track : this.getAllTracks(false)) {
                List<Track> trackList;
                if (track == null || track.getTrackType() == TrackType.MUTATION || (trackList = this.getOverlayTracks(track)) == null) continue;
                this.overlaidTracks.addAll(trackList);
            }
            boolean displayOverlays = IGV.getInstance().getSession().getOverlayMutationTracks();
            for (Track track : this.getAllTracks(false)) {
                if (track == null || track.getTrackType() != TrackType.MUTATION) continue;
                track.setOverlayed(displayOverlays && this.overlaidTracks.contains(track));
            }
        }
    }

    public Set<Track> getOverlaidTracks() {
        return this.overlaidTracks;
    }

    public int getVisibleTrackCount() {
        int count = 0;
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            count += tsv.getVisibleTrackCount();
        }
        return count;
    }

    public List<Track> getAllTracks(boolean includeGeneTrack) {
        ArrayList<Track> allTracks = new ArrayList<Track>();
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            allTracks.addAll(tsv.getTracks());
        }
        if (this.geneTrack != null && !includeGeneTrack) {
            allTracks.remove(this.geneTrack);
        }
        if (this.sequenceTrack != null && !includeGeneTrack) {
            allTracks.remove(this.sequenceTrack);
        }
        return allTracks;
    }

    public void clearSelections() {
        for (Track t : this.getAllTracks(true)) {
            if (t == null) continue;
            t.setSelected(false);
        }
    }

    public void setTrackSelections(Set<Track> selectedTracks) {
        for (Track t : this.getAllTracks(true)) {
            if (!selectedTracks.contains(t)) continue;
            t.setSelected(true);
        }
    }

    public void shiftSelectTracks(Track track) {
        int clickedTrackIndex;
        List<Track> allTracks = this.getAllTracks(true);
        int otherIndex = clickedTrackIndex = allTracks.indexOf(track);
        for (int i2 = 0; i2 < allTracks.size(); ++i2) {
            if (!allTracks.get(i2).isSelected() || i2 == clickedTrackIndex) continue;
            otherIndex = i2;
            break;
        }
        int left = Math.min(otherIndex, clickedTrackIndex);
        int right = Math.max(otherIndex, clickedTrackIndex);
        for (int i3 = left; i3 <= right; ++i3) {
            allTracks.get(i3).setSelected(true);
        }
    }

    public void toggleTrackSelections(Set<Track> selectedTracks) {
        for (Track t : this.getAllTracks(true)) {
            if (!selectedTracks.contains(t)) continue;
            t.setSelected(!t.isSelected());
        }
    }

    public Collection<Track> getSelectedTracks() {
        HashSet<Track> selectedTracks = new HashSet<Track>();
        for (Track t : this.getAllTracks(true)) {
            if (t == null || !t.isSelected()) continue;
            selectedTracks.add(t);
        }
        return selectedTracks;
    }

    public Set<ResourceLocator> getDataResourceLocators() {
        HashSet<ResourceLocator> locators = new HashSet<ResourceLocator>();
        for (Track track : this.getAllTracks(false)) {
            ResourceLocator locator = track.getResourceLocator();
            if (locator == null) continue;
            locators.add(locator);
        }
        return locators;
    }

    public void setAllTrackHeights(int newHeight) {
        for (Track track : this.getAllTracks(false)) {
            track.setHeight(newHeight);
        }
    }

    public void removeTracks(Collection<Track> tracksToRemove) {
        ArrayList<TrackPanelScrollPane> panes = new ArrayList<TrackPanelScrollPane>(this.getTrackPanelScrollPanes());
        for (TrackPanelScrollPane tsp : panes) {
            TrackPanel trackPanel = tsp.getTrackPanel();
            trackPanel.removeTracks(tracksToRemove);
            if (trackPanel.hasTracks()) continue;
            this.igv.removeDataPanel(tsp.getTrackPanelName());
        }
        for (Track t : tracksToRemove) {
            if (!(t instanceof DragListener)) continue;
            DragEventManager.getInstance().removeDragListener((DragListener)((Object)t));
        }
    }

    public void refreshData() {
        long t0 = System.currentTimeMillis();
        for (Track track : this.getAllTracks(false)) {
            track.refreshData(t0);
        }
    }

    public void sortAllTracksByAttributes(String[] attributeNames, boolean[] ascending) {
        assert (attributeNames.length == ascending.length);
        for (TrackPanelScrollPane tsp : this.getTrackPanelScrollPanes()) {
            TrackPanel tsv = tsp.getTrackPanel();
            tsv.sortTracksByAttributes(attributeNames, ascending);
        }
    }

    public TrackPanel getPanelFor(ResourceLocator locator) {
        String path = locator.getPath().toLowerCase();
        if (PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane")) {
            return this.igv.getDataPanel(DATA_PANEL_NAME);
        }
        if (path.endsWith(".sam") || path.endsWith(".bam") || path.endsWith(".sam.list") || path.endsWith(".bam.list") || path.endsWith(".aligned") || path.endsWith(".sorted.txt")) {
            String newPanelName = "Panel" + System.currentTimeMillis();
            return this.igv.addDataPanel(newPanelName).getTrackPanel();
        }
        return this.getDefaultPanel(locator);
    }

    private TrackPanel getDefaultPanel(ResourceLocator locator) {
        if (locator.getType() != null && locator.getType().equalsIgnoreCase("das")) {
            return this.igv.getDataPanel(FEATURE_PANEL_NAME);
        }
        String filename = locator.getPath().toLowerCase();
        if (filename.endsWith(".txt") || filename.endsWith(".tab") || filename.endsWith(".xls") || filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.lastIndexOf("."));
        }
        if (filename.contains("refflat") || filename.contains("ucscgene") || filename.contains("genepred") || filename.contains("ensgene") || filename.contains("refgene") || filename.endsWith("gff") || filename.endsWith("gtf") || filename.endsWith("gff3") || filename.endsWith("embl") || filename.endsWith("bed") || filename.endsWith("gistic") || filename.endsWith("bedz") || filename.endsWith("repmask") || filename.contains("dranger")) {
            return this.igv.getDataPanel(FEATURE_PANEL_NAME);
        }
        return this.igv.getDataPanel(DATA_PANEL_NAME);
    }

    public void sortByRegionScore(RegionOfInterest region, final RegionScoreType type, final ReferenceFrame frame) {
        final RegionOfInterest r = region == null ? new RegionOfInterest(frame.getChrName(), (int)frame.getOrigin(), (int)frame.getEnd() + 1, frame.getName()) : region;
        NamedRunnable runnable = new NamedRunnable(){

            @Override
            public String getName() {
                return "Sort";
            }

            @Override
            public void run() {
                for (TrackPanelScrollPane tsp : TrackManager.this.getTrackPanelScrollPanes()) {
                    TrackPanel tsv = tsp.getTrackPanel();
                    tsv.sortByRegionsScore(r, type, frame);
                }
                IGV.getMainFrame().repaint();
            }
        };
        LongRunningTask.submit(runnable);
    }

    public String getGroupByAttribute() {
        return this.groupByAttribute;
    }

    public List<Track> getOverlayTracks(Track track) {
        String overlayAttribute = IGV.getInstance().getSession().getOverlayAttribute();
        String value = track.getAttributeValue(overlayAttribute);
        return this.overlayTracksMap.get(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createGeneTrack(Genome genome) {
        FeatureTrack geneFeatureTrack = null;
        String genomeId = genome.getId();
        GenomeDescriptor genomeDescriptor = IGV.getInstance().getGenomeManager().getGenomeDescriptor(genomeId);
        AsciiLineReader reader = TrackManager.getGeneReader(genomeDescriptor);
        if (reader != null) {
            try {
                String geneFilename = genomeDescriptor.getGeneFileName();
                FeatureParser parser = AbstractFeatureParser.getInstanceFor(new ResourceLocator(geneFilename), genome);
                if (parser == null) {
                    MessageUtils.showMessage("ERROR: Unrecognized annotation file format: " + geneFilename + "<br>Annotations for genome: " + genomeId + " will not be loaded.");
                } else {
                    List<Feature> genes = parser.loadFeatures(reader);
                    String name = genomeDescriptor.getGeneTrackName();
                    if (name == null) {
                        name = "Genes";
                    }
                    String id = genome.getId() + "_genes";
                    geneFeatureTrack = new FeatureTrack(id, name, (FeatureSource)new FeatureCollectionSource(genes, genome));
                    geneFeatureTrack.setMinimumHeight(5);
                    geneFeatureTrack.setHeight(35);
                    geneFeatureTrack.setPreferredHeight(35);
                    geneFeatureTrack.setRendererClass(IGVFeatureRenderer.class);
                    geneFeatureTrack.setColor(Color.BLUE.darker());
                    TrackProperties props = parser.getTrackProperties();
                    if (props != null) {
                        geneFeatureTrack.setProperties(parser.getTrackProperties());
                    }
                    geneFeatureTrack.setUrl(genome.getAnnotationURL());
                }
            }
            catch (Exception e2) {
                log.error("Error loading geneManager", e2);
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        SequenceTrack seqTrack = new SequenceTrack("Reference sequence");
        if (geneFeatureTrack != null) {
            this.setGenomeTracks(geneFeatureTrack, seqTrack);
        } else {
            this.setGenomeTracks(null, seqTrack);
        }
    }

    private void setGenomeTracks(Track newGeneTrack, SequenceTrack newSeqTrack) {
        TrackPanelScrollPane tsp;
        TrackPanel tsv;
        TrackPanelScrollPane tsp2;
        TrackPanel tsv2;
        boolean foundSeqTrack = false;
        Iterator<TrackPanelScrollPane> i$ = this.getTrackPanelScrollPanes().iterator();
        while (i$.hasNext() && !(foundSeqTrack = (tsv2 = (tsp2 = i$.next()).getTrackPanel()).replaceTrack(this.sequenceTrack, newSeqTrack))) {
        }
        boolean foundGeneTrack = false;
        Iterator<TrackPanelScrollPane> i$2 = this.getTrackPanelScrollPanes().iterator();
        while (i$2.hasNext() && !(foundGeneTrack = (tsv = (tsp = i$2.next()).getTrackPanel()).replaceTrack(this.geneTrack, newGeneTrack))) {
        }
        if (!foundGeneTrack || !foundSeqTrack) {
            TrackPanel panel;
            TrackPanel trackPanel = panel = PreferenceManager.getInstance().getAsBoolean("IGV.single.track.pane") ? this.igv.getDataPanel(DATA_PANEL_NAME) : this.igv.getDataPanel(FEATURE_PANEL_NAME);
            if (!foundSeqTrack) {
                panel.addTrack(newSeqTrack);
            }
            if (!foundGeneTrack && newGeneTrack != null) {
                panel.addTrack(newGeneTrack);
            }
        }
        this.geneTrack = newGeneTrack;
        this.sequenceTrack = newSeqTrack;
    }

    public static AsciiLineReader getGeneReader(GenomeDescriptor genomeDescriptor) {
        FilterInputStream is = null;
        try {
            InputStream inputStream = genomeDescriptor.getGeneStream();
            if (inputStream == null) {
                return null;
            }
            AsciiLineReader reader = null;
            if (genomeDescriptor.isGeneFileGZipFormat()) {
                is = new GZIPInputStream(inputStream);
                reader = new AsciiLineReader(is);
            } else {
                is = new BufferedInputStream(inputStream);
                reader = new AsciiLineReader(is);
            }
            return reader;
        }
        catch (IOException ex) {
            log.warn("Error loading the genome!", ex);
            return null;
        }
    }
}

