/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import org.apache.log4j.Logger;
import org.broad.igv.feature.SequenceManager;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.sam.Alignment;
import org.broad.igv.sam.AlignmentBlock;
import org.broad.igv.ui.IGV;

public class AlignmentCounts {
    private static Logger log = Logger.getLogger(AlignmentCounts.class);
    String genomeId;
    int start;
    int end;
    byte[] reference;
    int[] posA;
    int[] posT;
    int[] posC;
    int[] posG;
    int[] posN;
    int[] negA;
    int[] negT;
    int[] negC;
    int[] negG;
    int[] negN;
    int[] qA;
    int[] qT;
    int[] qC;
    int[] qG;
    int[] qN;
    int[] posTotal;
    int[] negTotal;
    private int[] totalQ;
    private int maxCount = 0;

    public AlignmentCounts(String chr, int start, int end) {
        Genome genome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        this.genomeId = genome.getId();
        String chrAlias = genome.getChromosomeAlias(chr);
        this.start = start;
        this.end = end;
        this.reference = SequenceManager.readSequence(this.genomeId, chrAlias, start, end);
        int nPts = end - start;
        this.posA = new int[nPts];
        this.posT = new int[nPts];
        this.posC = new int[nPts];
        this.posG = new int[nPts];
        this.posN = new int[nPts];
        this.posTotal = new int[nPts];
        this.negA = new int[nPts];
        this.negT = new int[nPts];
        this.negC = new int[nPts];
        this.negG = new int[nPts];
        this.negN = new int[nPts];
        this.negTotal = new int[nPts];
        this.qA = new int[nPts];
        this.qT = new int[nPts];
        this.qC = new int[nPts];
        this.qG = new int[nPts];
        this.qN = new int[nPts];
        this.totalQ = new int[nPts];
    }

    public int getTotalCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.posTotal[offset] + this.negTotal[offset];
    }

    public int getNegTotal(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.negTotal[offset];
    }

    public int getPosTotal(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.posTotal[offset];
    }

    public int getTotalQuality(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.totalQ[offset];
    }

    public int getAvgQuality(int pos) {
        int count = this.getTotalCount(pos);
        return count == 0 ? 0 : this.getTotalQuality(pos) / count;
    }

    public byte getReference(int pos) {
        if (this.reference == null) {
            return 0;
        }
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.reference.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.reference[offset];
    }

    public int getCount(int pos, byte b2) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        switch (b2) {
            case 65: 
            case 97: {
                return this.posA[offset] + this.negA[offset];
            }
            case 84: 
            case 116: {
                return this.posT[offset] + this.negT[offset];
            }
            case 67: 
            case 99: {
                return this.posC[offset] + this.negC[offset];
            }
            case 71: 
            case 103: {
                return this.posG[offset] + this.negG[offset];
            }
            case 78: 
            case 110: {
                return this.posN[offset] + this.negN[offset];
            }
        }
        log.debug("Unknown nucleotide: " + b2);
        return 0;
    }

    public int getNegCount(int pos, byte b2) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        switch (b2) {
            case 65: 
            case 97: {
                return this.negA[offset];
            }
            case 84: 
            case 116: {
                return this.negT[offset];
            }
            case 67: 
            case 99: {
                return this.negC[offset];
            }
            case 71: 
            case 103: {
                return this.negG[offset];
            }
            case 78: 
            case 110: {
                return this.negN[offset];
            }
        }
        log.error("Unknown nucleotide: " + b2);
        return 0;
    }

    public int getPosCount(int pos, byte b2) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        switch (b2) {
            case 65: 
            case 97: {
                return this.posA[offset];
            }
            case 84: 
            case 116: {
                return this.posT[offset];
            }
            case 67: 
            case 99: {
                return this.posC[offset];
            }
            case 71: 
            case 103: {
                return this.posG[offset];
            }
            case 78: 
            case 110: {
                return this.posN[offset];
            }
        }
        log.error("Unknown nucleotide: " + b2);
        return 0;
    }

    public int getQuality(int pos, byte b2) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.posA.length) {
            log.error("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            return 0;
        }
        switch (b2) {
            case 65: 
            case 97: {
                return this.qA[offset];
            }
            case 84: 
            case 116: {
                return this.qT[offset];
            }
            case 67: 
            case 99: {
                return this.qC[offset];
            }
            case 71: 
            case 103: {
                return this.qG[offset];
            }
            case 78: 
            case 110: {
                return this.qN[offset];
            }
        }
        log.error("Unknown nucleotide: " + this.posN);
        return 0;
    }

    public int getAvgQuality(int pos, byte b2) {
        int count = this.getCount(pos, b2);
        return count == 0 ? 0 : this.getQuality(pos, b2) / count;
    }

    void incCounts(Alignment alignment) {
        int start = alignment.getAlignmentStart();
        int end = alignment.getAlignmentEnd();
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        if (blocks != null) {
            for (AlignmentBlock b2 : blocks) {
                if (b2.isSoftClipped()) continue;
                this.incCounts(b2, alignment.isNegativeStrand());
            }
        } else {
            for (int pos = start; pos < end; ++pos) {
                byte q = 0;
                this.incCount(pos, (byte)110, q, alignment.isNegativeStrand());
            }
        }
    }

    private void incCounts(AlignmentBlock block, boolean isNegativeStrand) {
        int start = block.getStart();
        byte[] bases = block.getBases();
        if (bases != null) {
            for (int i2 = 0; i2 < bases.length; ++i2) {
                int pos = start + i2;
                byte q = block.qualities[i2];
                byte n2 = bases[i2];
                this.incCount(pos, n2, q, isNegativeStrand);
            }
        }
    }

    private void incCount(int pos, byte b2, byte q, boolean isNegativeStrand) {
        int offset = pos - this.start;
        if (offset >= 0 && offset < this.posA.length) {
            switch (b2) {
                case 65: 
                case 97: {
                    if (isNegativeStrand) {
                        this.negA[offset] = this.negA[offset] + 1;
                    } else {
                        this.posA[offset] = this.posA[offset] + 1;
                    }
                    this.qA[offset] = this.qA[offset] + q;
                    break;
                }
                case 84: 
                case 116: {
                    if (isNegativeStrand) {
                        this.negT[offset] = this.negT[offset] + 1;
                    } else {
                        this.posT[offset] = this.posT[offset] + 1;
                    }
                    this.qT[offset] = this.qT[offset] + q;
                    break;
                }
                case 67: 
                case 99: {
                    if (isNegativeStrand) {
                        this.negC[offset] = this.negC[offset] + 1;
                    } else {
                        this.posC[offset] = this.posC[offset] + 1;
                    }
                    this.qC[offset] = this.qC[offset] + q;
                    break;
                }
                case 71: 
                case 103: {
                    if (isNegativeStrand) {
                        this.negG[offset] = this.negG[offset] + 1;
                    } else {
                        this.posG[offset] = this.posG[offset] + 1;
                    }
                    this.qG[offset] = this.qG[offset] + q;
                    break;
                }
                case 78: 
                case 110: {
                    if (isNegativeStrand) {
                        this.negN[offset] = this.negN[offset] + 1;
                    } else {
                        this.posN[offset] = this.posN[offset] + 1;
                    }
                    this.qN[offset] = this.qN[offset] + q;
                }
            }
            if (isNegativeStrand) {
                this.negTotal[offset] = this.negTotal[offset] + 1;
            } else {
                this.posTotal[offset] = this.posTotal[offset] + 1;
            }
            this.totalQ[offset] = this.totalQ[offset] + q;
            this.maxCount = Math.max(this.posTotal[offset] + this.negTotal[offset], this.maxCount);
        }
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int[] getTotalQ() {
        return this.totalQ;
    }

    public int getMaxCount() {
        return this.maxCount;
    }
}

