/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.BasicFeature;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.FeatureDB;
import org.broad.igv.feature.FeatureParser;
import org.broad.igv.feature.Strand;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.GeneTrackRenderer;
import org.broad.igv.renderer.IGVFeatureRenderer;
import org.broad.igv.track.FeatureCollectionSource;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.tribble.Feature;
import org.broad.tribble.readers.AsciiLineReader;

public class EmblFeatureTableParser
implements FeatureParser {
    static HashSet<String> geneParts = new HashSet();

    @Override
    public boolean isFeatureFile(ResourceLocator locator) {
        return true;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FeatureTrack> loadTracks(ResourceLocator locator, Genome genome) {
        AsciiLineReader reader = null;
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            List<Feature> features = this.loadFeatures(reader);
            if (features.isEmpty()) {
                List<FeatureTrack> list = null;
                return list;
            }
            FeatureTrack track = new FeatureTrack(locator, new FeatureCollectionSource(features, genome));
            track.setName(locator.getTrackName());
            track.setRendererClass(IGVFeatureRenderer.class);
            track.setMinimumHeight(35);
            track.setHeight(45);
            track.setRendererClass(GeneTrackRenderer.class);
            ArrayList<FeatureTrack> newTracks = new ArrayList<FeatureTrack>();
            newTracks.add(track);
            FeatureDB.addFeatures(features);
            ArrayList<FeatureTrack> arrayList = newTracks;
            return arrayList;
        }
        catch (IOException ex) {
            ex.printStackTrace();
            List<FeatureTrack> list = null;
            return list;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    @Override
    public List<Feature> loadFeatures(AsciiLineReader reader) {
        ArrayList<BasicFeature> features = new ArrayList<BasicFeature>();
        String nextLine = null;
        String chromosome = null;
        EmblRecord currentRecord = null;
        try {
            while ((nextLine = reader.readLine()) != null) {
                if (nextLine.startsWith("ID")) {
                    String chr = EmblFeatureTableParser.getFirstWord(nextLine.substring(2));
                    chromosome = chr.replace("chromosome", "chr").replace("_", "");
                    continue;
                }
                if (!nextLine.startsWith("FT")) continue;
                String featureKey = nextLine.substring(5, 19).trim();
                if (featureKey.length() == 0) {
                    if (currentRecord == null) continue;
                    currentRecord.append(nextLine);
                    continue;
                }
                if (currentRecord != null) {
                    features.add(EmblFeatureTableParser.createFeature(currentRecord));
                }
                String temp = nextLine.substring(21);
                boolean isNegative = temp.contains("complement");
                String lociString = EmblFeatureTableParser.parseJoinString(temp, reader).replace("<", "").replace(">", "").trim();
                currentRecord = new EmblRecord(featureKey.trim(), chromosome, lociString, isNegative);
            }
            return EmblFeatureTableParser.combineGeneParts(features);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    static BasicFeature createFeature(EmblRecord emblRecord) {
        BasicFeature feature = new BasicFeature(emblRecord.getChromosome(), emblRecord.getStart(), emblRecord.getEnd());
        feature.setType(emblRecord.getType());
        feature.setIdentifier(emblRecord.getIdentifier());
        feature.setName(emblRecord.getIdentifier());
        feature.setStrand(emblRecord.getStrand());
        feature.setDescription(emblRecord.getDescription());
        if (emblRecord.getAlias() != null) {
            feature.setName(emblRecord.getAlias());
        }
        for (Exon exon : emblRecord.getExons()) {
            feature.addExon(exon);
        }
        return feature;
    }

    static List<Feature> combineGeneParts(List<BasicFeature> features) {
        Exon exon;
        BasicFeature gene;
        ArrayList<Feature> newFeatureList = new ArrayList<Feature>(features.size());
        HashMap<String, BasicFeature> genes = new HashMap<String, BasicFeature>();
        for (BasicFeature feature : features) {
            if (!feature.getType().equals("CDS")) continue;
            String geneId = feature.getIdentifier();
            gene = (BasicFeature)genes.get(geneId);
            if (gene == null) {
                gene = feature.copy();
                gene.setType("transcript");
                newFeatureList.add(gene);
                genes.put(geneId, gene);
            }
            exon = new Exon(feature.getChr(), feature.getStart(), feature.getEnd(), feature.getStrand());
            gene.addExon(exon);
        }
        for (BasicFeature feature : features) {
            String type = feature.getType();
            if (type.equals("CDS")) continue;
            if (type.equals("3'UTR") || type.equals("5'UTR")) {
                gene = (BasicFeature)genes.get(feature.getIdentifier());
                if (gene == null) continue;
                exon = new Exon(feature.getChr(), feature.getStart(), feature.getEnd(), feature.getStrand());
                exon.setUTR(true);
                gene.addExon(exon);
                continue;
            }
            newFeatureList.add(feature);
        }
        for (BasicFeature gene2 : genes.values()) {
            ParsingUtils.computeReadingShifts(gene2);
        }
        return newFeatureList;
    }

    public static String parseJoinString(String joinString, AsciiLineReader reader) throws IOException {
        if (joinString.startsWith("join") || joinString.startsWith("complement")) {
            int leftParenCount = EmblFeatureTableParser.countChar(joinString, '(');
            int rightParenCount = EmblFeatureTableParser.countChar(joinString, ')');
            while (leftParenCount != rightParenCount) {
                joinString = joinString + reader.readLine().replace("FT", "").trim();
                leftParenCount = EmblFeatureTableParser.countChar(joinString, '(');
                rightParenCount = EmblFeatureTableParser.countChar(joinString, ')');
            }
            joinString = joinString.replace("join", "");
            joinString = joinString.replace("complement", "");
            joinString = joinString.replace("(", "");
            joinString = joinString.replace(")", "");
            joinString = joinString.replace('<', ' ');
            return joinString;
        }
        return joinString;
    }

    static int countChar(String string, char c2) {
        int cnt = 0;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (c2 != string.charAt(i2)) continue;
            ++cnt;
        }
        return cnt;
    }

    static void combineFeatureTables(File[] emblFiles, String outputFile) throws IOException {
        PrintWriter pw = new PrintWriter(new FileWriter(outputFile));
        for (File ifile : emblFiles) {
            BufferedReader br = new BufferedReader(new FileReader(ifile));
            String nextLine = null;
            while ((nextLine = br.readLine()) != null) {
                if (!nextLine.startsWith("ID") && !nextLine.startsWith("FT")) continue;
                pw.println(nextLine);
            }
            br.close();
        }
        pw.close();
    }

    static void splitByType(String emblFile, String outputDirectory) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(emblFile));
        HashSet<String> codes = new HashSet<String>();
        while ((nextLine = br.readLine()) != null) {
            String code;
            if (!nextLine.startsWith("FT") || nextLine.length() <= 19 || (code = nextLine.substring(5, 19).trim()).length() <= 0) continue;
            codes.add(code);
        }
        br.close();
        HashMap<String, PrintWriter> writers = new HashMap<String, PrintWriter>();
        for (String code : codes) {
            writers.put(code, new PrintWriter(new FileWriter(new File(outputDirectory, code + ".embl"))));
        }
        br = new BufferedReader(new FileReader(emblFile));
        PrintWriter currentWriter = null;
        while ((nextLine = br.readLine()) != null) {
            if (nextLine.startsWith("ID")) {
                for (PrintWriter pw : writers.values()) {
                    pw.println(nextLine);
                }
                continue;
            }
            if (nextLine.startsWith("FT")) {
                String code;
                code = nextLine.substring(5, 19).trim();
                if (code.length() > 0) {
                    currentWriter = (PrintWriter)writers.get(code);
                }
                if (currentWriter == null) continue;
                currentWriter.println(nextLine);
                continue;
            }
            currentWriter = null;
        }
        br.close();
        for (PrintWriter pw : writers.values()) {
            pw.close();
        }
    }

    static void extractGenes(String emblFile, String outputFile) throws IOException {
        String nextLine;
        BufferedReader br = new BufferedReader(new FileReader(emblFile));
        br = new BufferedReader(new FileReader(emblFile));
        PrintWriter geneWriter = new PrintWriter(new FileWriter(outputFile));
        PrintWriter currentWriter = null;
        while ((nextLine = br.readLine()) != null) {
            if (nextLine.startsWith("ID")) {
                geneWriter.println(nextLine);
                continue;
            }
            if (nextLine.startsWith("FT")) {
                String code = nextLine.substring(5, 19).trim();
                if (code.equals("CDS") || code.equals("3'UTR") || code.equals("5'UTR")) {
                    currentWriter = geneWriter;
                } else if (code.length() > 0) {
                    currentWriter = null;
                }
                if (currentWriter == null) continue;
                currentWriter.println(nextLine);
                continue;
            }
            currentWriter = null;
        }
        br.close();
        geneWriter.close();
    }

    private static String getFirstWord(String string) {
        String trimmedString = string.trim();
        char[] chars = trimmedString.toCharArray();
        int whitespaceIndex = 0;
        for (whitespaceIndex = 0; whitespaceIndex < chars.length && !Character.isSpaceChar(chars[whitespaceIndex]); ++whitespaceIndex) {
        }
        return trimmedString.substring(0, whitespaceIndex).trim();
    }

    public static void main(String[] args) throws IOException {
        EmblFeatureTableParser.splitByType("/Users/jrobinso/plasmodium/v2.1/Embl/MAL.embl", "/Users/jrobinso/plasmodium/v2.1/Embl");
    }

    static {
        geneParts.add("CDS");
        geneParts.add("5'UTR");
        geneParts.add("3'UTR");
        geneParts.add("intron");
    }

    static class EmblRecord {
        private static Logger log = Logger.getLogger(EmblRecord.class);
        boolean isNegative;
        private String type;
        private String chromosome;
        private String identifier;
        private String alias;
        private String description;
        private int start = Integer.MAX_VALUE;
        private int end;
        List<Exon> exons;

        EmblRecord(String type, String chromosome, String lociString, boolean isNegative) {
            this.isNegative = isNegative;
            this.type = type;
            this.chromosome = chromosome;
            this.createExons(lociString, isNegative);
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }

        public boolean isGenePart() {
            return this.type.equals("CDS") || this.type.equals("3'UTR") || this.type.equals("5'UTR");
        }

        public Strand getStrand() {
            return this.isNegative ? Strand.NEGATIVE : Strand.POSITIVE;
        }

        public String getType() {
            return this.type;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        public String getAlias() {
            return this.alias;
        }

        public void setAlias(String alias) {
            this.alias = alias;
        }

        public List<Exon> getExons() {
            return this.exons;
        }

        public void append(String nextLine) {
            String attrString = nextLine.substring(21);
            if (attrString.startsWith("/gene=")) {
                String[] kv = attrString.split("=");
                String geneName = kv[1].replace("\"", "");
                if (geneName.startsWith("SP")) {
                    if (this.getIdentifier() == null) {
                        this.setIdentifier(geneName);
                    }
                } else {
                    this.setAlias(geneName);
                }
            } else if (attrString.startsWith("/systematic_id=")) {
                String[] kv = attrString.split("=");
                String id = kv[1].replace("\"", "");
                this.setIdentifier(id);
                this.setAlias(id);
            } else {
                this.appendToDescription(nextLine.substring(22).trim());
            }
        }

        public void appendToDescription(String note) {
            this.description = this.description == null ? note : this.description + "<br>" + note;
        }

        public String getDescription() {
            return this.description;
        }

        void createExons(String joinString, boolean isNegative) {
            String[] lociArray = joinString.split(",");
            this.exons = new ArrayList<Exon>(lociArray.length);
            for (String loci : lociArray) {
                try {
                    String[] tmp = loci.split("\\.\\.");
                    int exonStart = Integer.parseInt(tmp[0]) - 1;
                    int exonEnd = exonStart + 1;
                    if (tmp.length > 1) {
                        exonEnd = Integer.parseInt(tmp[1]);
                    }
                    Strand strand = isNegative ? Strand.NEGATIVE : Strand.POSITIVE;
                    Exon r = new Exon(this.chromosome, exonStart, exonEnd, strand);
                    this.start = Math.min(this.start, exonStart);
                    this.end = Math.max(this.end, exonEnd);
                    this.exons.add(r);
                }
                catch (NumberFormatException e2) {
                    log.error("Error parsing exon number; " + joinString, e2);
                }
            }
        }

        public String getChromosome() {
            return this.chromosome;
        }
    }
}

