/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.apache.log4j.Logger;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.Cytoband;
import org.broad.tribble.readers.AsciiLineReader;

public class CytoBandFileParser {
    private static Logger logger = Logger.getLogger(CytoBandFileParser.class);

    public static boolean isValid(AsciiLineReader reader, String filename) {
        if (reader == null) {
            return false;
        }
        try {
            String nextLine = null;
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = nextLine.split("\t");
                String chr = tokens[0].trim();
                Cytoband cytoData = new Cytoband(chr);
                CytoBandFileParser.parseData(tokens, cytoData);
            }
            return true;
        }
        catch (Exception e2) {
            logger.error("Invalid Cytoband file data : file=" + filename, e2);
            return false;
        }
    }

    public static LinkedHashMap<String, Chromosome> loadData(BufferedReader reader) {
        LinkedHashMap<String, Chromosome> dataMap = new LinkedHashMap<String, Chromosome>();
        try {
            String nextLine;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                String[] data = nextLine.split("\t");
                String chr = data[0].trim();
                Chromosome chromosome = dataMap.get(chr);
                if (chromosome == null) {
                    chromosome = new Chromosome(chr);
                    dataMap.put(chr, chromosome);
                }
                Cytoband cytoData = new Cytoband(chr);
                CytoBandFileParser.parseData(data, cytoData);
                chromosome.addCytoband(cytoData);
            }
            reader.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return dataMap;
    }

    private static void parseData(String[] tokens, Cytoband cytoData) {
        cytoData.setStart(Integer.parseInt(tokens[1].trim()));
        cytoData.setEnd(Integer.parseInt(tokens[2].trim()));
        if (tokens.length > 3) {
            cytoData.setName(tokens[3]);
        }
        if (tokens.length > 4) {
            if (tokens[4].equals("acen")) {
                cytoData.setType('c');
            } else {
                cytoData.setType(tokens[4].charAt(1));
                if (cytoData.getType() == 'p') {
                    cytoData.setStain(Short.parseShort(tokens[4].substring(4).trim()));
                }
            }
        }
    }

    private static String parseChromosome(String[] data) {
        String chr = data[0].substring(3);
        int underscore = chr.indexOf(95);
        if (underscore > 0) {
            chr = chr.substring(0, underscore);
        }
        return chr;
    }
}

