/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bbfile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.broad.igv.bbfile.BPTree;
import org.broad.igv.bbfile.BedFeature;
import org.broad.igv.bbfile.BigBedDataBlock;
import org.broad.igv.bbfile.RPChromosomeRegion;
import org.broad.igv.bbfile.RPTree;
import org.broad.igv.bbfile.RPTreeLeafNodeItem;
import org.broad.tribble.util.SeekableStream;

public class BigBedIterator
implements Iterator<BedFeature> {
    private static Logger log = Logger.getLogger(BigBedIterator.class);
    private RPChromosomeRegion mSelectionRegion;
    private boolean mIsContained;
    private RPChromosomeRegion mHitRegion;
    private SeekableStream mBBFis;
    private BPTree mChromIDTree;
    private RPTree mChromDataTree;
    private ArrayList<RPTreeLeafNodeItem> mLeafHitList;
    private HashMap<Integer, String> mChromosomeMap;
    private int mLeafItemIndex;
    RPTreeLeafNodeItem mLeafHitItem;
    private BigBedDataBlock mBedDataBlock;
    private boolean mDataBlockRead;
    private ArrayList<BedFeature> mBedFeatureList;
    private int mBedFeatureIndex;
    private boolean empty = false;

    public BigBedIterator(SeekableStream fis, BPTree chromIDTree, RPTree chromDataTree, RPChromosomeRegion selectionRegion, boolean contained) {
        if (selectionRegion == null) {
            throw new RuntimeException("Error: BigBedIterator selection region is null\n");
        }
        this.mBBFis = fis;
        this.mChromIDTree = chromIDTree;
        this.mChromDataTree = chromDataTree;
        this.mSelectionRegion = selectionRegion;
        this.mIsContained = contained;
        int hitCount = this.getHitRegion(selectionRegion, contained);
        if (hitCount == 0) {
            this.empty = true;
        }
    }

    public BigBedIterator() {
        this.empty = true;
    }

    @Override
    public boolean hasNext() {
        if (this.empty) {
            return false;
        }
        if (this.mBedFeatureIndex < this.mBedFeatureList.size()) {
            return true;
        }
        return this.mLeafItemIndex < this.mLeafHitList.size();
    }

    @Override
    public BedFeature next() {
        if (this.mBedFeatureIndex < this.mBedFeatureList.size()) {
            return this.mBedFeatureList.get(this.mBedFeatureIndex++);
        }
        int nHits = this.getHitRegion(this.mSelectionRegion, this.mIsContained);
        if (nHits > 0) {
            return this.mBedFeatureList.get(this.mBedFeatureIndex++);
        }
        String result = String.format("Failed to find data for bed region (%d,%d,%d,%d)\n", this.mHitRegion.getStartChromID(), this.mHitRegion.getStartBase(), this.mHitRegion.getEndChromID(), this.mHitRegion.getEndBase());
        log.error(result);
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove iterator item is not supported yet.");
    }

    public RPChromosomeRegion getSelectionRegion() {
        return this.mSelectionRegion;
    }

    public int setSelectionRegion(RPChromosomeRegion selectionRegion, boolean contained) {
        this.mSelectionRegion = selectionRegion;
        this.mIsContained = contained;
        this.mLeafHitList = null;
        int hitCount = this.getHitRegion(selectionRegion, contained);
        if (hitCount == 0) {
            throw new RuntimeException("No wig data found in the selection region");
        }
        return hitCount;
    }

    public boolean isContained() {
        return this.mIsContained;
    }

    public SeekableStream getBBFis() {
        return this.mBBFis;
    }

    public BPTree getChromosomeIDTree() {
        return this.mChromIDTree;
    }

    public RPTree getChromosomeDataTree() {
        return this.mChromDataTree;
    }

    public ArrayList<RPTreeLeafNodeItem> getLeafItems() {
        return this.mLeafHitList;
    }

    private int getHitRegion(RPChromosomeRegion hitRegion, boolean contained) {
        int hitCount = 0;
        if (this.mLeafHitList == null ? (hitCount = this.getHitList(hitRegion, contained)) == 0 : (hitCount = this.mLeafHitList.size() - this.mLeafItemIndex) == 0) {
            return 0;
        }
        this.mDataBlockRead = this.getDataBlock(this.mLeafItemIndex++);
        if (!this.mDataBlockRead) {
            hitCount = this.getHitRegion(hitRegion, contained);
        }
        return hitCount;
    }

    private int getHitList(RPChromosomeRegion hitRegion, boolean contained) {
        this.mLeafHitList = this.mChromDataTree.getChromosomeDataHits(hitRegion, contained);
        int nHits = this.mLeafHitList.size();
        if (nHits == 0) {
            return 0;
        }
        this.mLeafItemIndex = 0;
        int startChromID = this.mLeafHitList.get(0).getChromosomeBounds().getStartChromID();
        int startBase = this.mLeafHitList.get(0).getChromosomeBounds().getStartBase();
        int endChromID = this.mLeafHitList.get(nHits - 1).getChromosomeBounds().getEndChromID();
        int endBase = this.mLeafHitList.get(nHits - 1).getChromosomeBounds().getEndBase();
        this.mHitRegion = new RPChromosomeRegion(startChromID, startBase, endChromID, endBase);
        return nHits;
    }

    private boolean getDataBlock(int leafItemIndex) {
        if (leafItemIndex >= this.mLeafHitList.size()) {
            return false;
        }
        this.mLeafHitItem = this.mLeafHitList.get(leafItemIndex);
        int startChromID = this.mLeafHitItem.getChromosomeBounds().getStartChromID();
        int endChromID = this.mLeafHitItem.getChromosomeBounds().getEndChromID();
        this.mChromosomeMap = this.mChromIDTree.getChromosomeIDMap(startChromID, endChromID);
        boolean isLowToHigh = this.mChromDataTree.isIsLowToHigh();
        int uncompressBufSize = this.mChromDataTree.getUncompressBuffSize();
        this.mBedDataBlock = new BigBedDataBlock(this.mBBFis, this.mLeafHitItem, this.mChromosomeMap, isLowToHigh, uncompressBufSize);
        this.mBedFeatureList = this.mBedDataBlock.getBedData(this.mSelectionRegion, this.mIsContained);
        this.mBedFeatureIndex = 0;
        return this.mBedFeatureList.size() > 0;
    }
}

