/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ChiSquaredDistribution;
import org.apache.commons.math.distribution.DistributionFactory;
import org.apache.commons.math.distribution.GammaDistribution;

public class ChiSquaredDistributionImpl
extends AbstractContinuousDistribution
implements ChiSquaredDistribution,
Serializable {
    private static final long serialVersionUID = -8352658048349159782L;
    private GammaDistribution gamma;

    public ChiSquaredDistributionImpl(double degreesOfFreedom) {
        this.setGamma(DistributionFactory.newInstance().createGammaDistribution(degreesOfFreedom / 2.0, 2.0));
    }

    public void setDegreesOfFreedom(double degreesOfFreedom) {
        this.getGamma().setAlpha(degreesOfFreedom / 2.0);
    }

    public double getDegreesOfFreedom() {
        return this.getGamma().getAlpha() * 2.0;
    }

    public double cumulativeProbability(double x) throws MathException {
        return this.getGamma().cumulativeProbability(x);
    }

    public double inverseCumulativeProbability(double p2) throws MathException {
        if (p2 == 0.0) {
            return 0.0;
        }
        if (p2 == 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        return super.inverseCumulativeProbability(p2);
    }

    protected double getDomainLowerBound(double p2) {
        return Double.MIN_VALUE * this.getGamma().getBeta();
    }

    protected double getDomainUpperBound(double p2) {
        double ret = p2 < 0.5 ? this.getDegreesOfFreedom() : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p2) {
        double ret = p2 < 0.5 ? this.getDegreesOfFreedom() * 0.5 : this.getDegreesOfFreedom();
        return ret;
    }

    private void setGamma(GammaDistribution gamma) {
        this.gamma = gamma;
    }

    private GammaDistribution getGamma() {
        return this.gamma;
    }
}

