/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLine;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineTranslator;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderLineType;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.codecs.vcf.VCFNamedHeaderLine;

public abstract class VCFCompoundHeaderLine
extends VCFHeaderLine
implements VCFNamedHeaderLine {
    private String name;
    private int count;
    private String description;
    private VCFHeaderLineType type;
    private final SupportedHeaderLineType lineType;
    public static final int UNBOUNDED = -1;

    @Override
    public String getName() {
        return this.name;
    }

    public int getCount() {
        return this.count;
    }

    public String getDescription() {
        return this.description;
    }

    public VCFHeaderLineType getType() {
        return this.type;
    }

    public void setNumberToUnbounded() {
        this.count = -1;
    }

    protected VCFCompoundHeaderLine(String name, int count, VCFHeaderLineType type, String description, SupportedHeaderLineType lineType) {
        super(lineType.toString(), "");
        this.name = name;
        this.count = count;
        this.type = type;
        this.description = description;
        this.lineType = lineType;
        this.validate();
    }

    protected VCFCompoundHeaderLine(String line, VCFHeaderVersion version, SupportedHeaderLineType lineType) {
        super(lineType.toString(), "");
        Map<String, String> mapping = VCFHeaderLineTranslator.parseLine(version, line, Arrays.asList("ID", "Number", "Type", "Description"));
        this.name = mapping.get("ID");
        this.count = version == VCFHeaderVersion.VCF4_0 || version == VCFHeaderVersion.VCF4_1 ? (mapping.get("Number").equals(".") ? -1 : Integer.valueOf(mapping.get("Number"))) : (mapping.get("Number").equals("-1") ? -1 : Integer.valueOf(mapping.get("Number")));
        this.type = VCFHeaderLineType.valueOf(mapping.get("Type"));
        if (this.type == VCFHeaderLineType.Flag && !this.allowFlagValues()) {
            throw new IllegalArgumentException("Flag is an unsupported type for this kind of field");
        }
        this.description = mapping.get("Description");
        if (this.description == null && ALLOW_UNBOUND_DESCRIPTIONS) {
            this.description = UNBOUND_DESCRIPTION;
        }
        this.lineType = lineType;
        this.validate();
    }

    private void validate() {
        if (this.name == null || this.type == null || this.description == null || this.lineType == null) {
            throw new IllegalArgumentException(String.format("Invalid VCFCompoundHeaderLine: key=%s name=%s type=%s desc=%s lineType=%s", new Object[]{super.getKey(), this.name, this.type, this.description, this.lineType}));
        }
    }

    @Override
    protected String toStringEncoding() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("ID", this.name);
        map.put("Number", this.count == -1 ? "." : Integer.valueOf(this.count));
        map.put("Type", (Object)this.type);
        map.put("Description", this.description);
        return this.lineType.toString() + "=" + VCFHeaderLine.toStringEncoding(map);
    }

    @Override
    public boolean equals(Object o2) {
        if (!(o2 instanceof VCFCompoundHeaderLine)) {
            return false;
        }
        VCFCompoundHeaderLine other = (VCFCompoundHeaderLine)o2;
        return this.name.equals(other.name) && this.count == other.count && this.description.equals(other.description) && this.type == other.type && this.lineType == other.lineType;
    }

    public boolean equalsExcludingDescription(VCFCompoundHeaderLine other) {
        return this.count == other.count && this.type == other.type && this.lineType == other.lineType && this.name.equals(other.name);
    }

    public boolean sameLineTypeAndName(VCFCompoundHeaderLine other) {
        return this.lineType == other.lineType && this.name.equals(other.name);
    }

    abstract boolean allowFlagValues();

    public static enum SupportedHeaderLineType {
        INFO(true),
        FORMAT(false);

        public final boolean allowFlagValues;

        private SupportedHeaderLineType(boolean flagValues) {
            this.allowFlagValues = flagValues;
        }
    }
}

