/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.codecs.vcf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broad.tribble.TribbleException;
import org.broad.tribble.readers.LineReader;
import org.broad.tribble.util.ParsingUtils;
import org.broadinstitute.sting.utils.codecs.vcf.AbstractVCFCodec;
import org.broadinstitute.sting.utils.codecs.vcf.VCFHeaderVersion;
import org.broadinstitute.sting.utils.variantcontext.Allele;
import org.broadinstitute.sting.utils.variantcontext.Genotype;

public class VCFCodec
extends AbstractVCFCodec {
    @Override
    public Object readHeader(LineReader reader) {
        ArrayList<String> headerStrings = new ArrayList<String>();
        try {
            String line;
            boolean foundHeaderVersion = false;
            while ((line = reader.readLine()) != null) {
                ++this.lineNo;
                if (line.startsWith("##")) {
                    String[] lineFields = line.substring(2).split("=");
                    if (lineFields.length == 2 && VCFHeaderVersion.isFormatString(lineFields[0])) {
                        if (!VCFHeaderVersion.isVersionString(lineFields[1])) {
                            throw new TribbleException.InvalidHeader(lineFields[1] + " is not a supported version");
                        }
                        foundHeaderVersion = true;
                        this.version = VCFHeaderVersion.toHeaderVersion(lineFields[1]);
                        if (this.version == VCFHeaderVersion.VCF3_3 || this.version == VCFHeaderVersion.VCF3_2) {
                            throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4; please use the VCF3 codec for " + lineFields[1]);
                        }
                        if (this.version != VCFHeaderVersion.VCF4_0 && this.version != VCFHeaderVersion.VCF4_1) {
                            throw new TribbleException.InvalidHeader("This codec is strictly for VCFv4 and does not support " + lineFields[1]);
                        }
                    }
                    headerStrings.add(line);
                    continue;
                }
                if (line.startsWith("#")) {
                    if (!foundHeaderVersion) {
                        throw new TribbleException.InvalidHeader("We never saw a header line specifying VCF version");
                    }
                    return this.createHeader(headerStrings, line);
                }
                throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
            }
        }
        catch (IOException e2) {
            throw new RuntimeException("IO Exception ", e2);
        }
        throw new TribbleException.InvalidHeader("We never saw the required CHROM header line (starting with one #) for the input VCF file");
    }

    @Override
    protected Set<String> parseFilters(String filterString) {
        if (filterString.equals(".")) {
            return null;
        }
        LinkedHashSet<String> fFields = new LinkedHashSet<String>();
        if (filterString.equals("PASS")) {
            return fFields;
        }
        if (filterString.equals("0")) {
            this.generateException("0 is an invalid filter name in vcf4");
        }
        if (filterString.length() == 0) {
            this.generateException("The VCF specification requires a valid filter status");
        }
        if (this.filterHash.containsKey(filterString)) {
            return (Set)this.filterHash.get(filterString);
        }
        if (filterString.indexOf(";") == -1) {
            fFields.add(filterString);
        } else {
            fFields.addAll(Arrays.asList(filterString.split(";")));
        }
        this.filterHash.put(filterString, fFields);
        return fFields;
    }

    @Override
    public Map<String, Genotype> createGenotypeMap(String str, List<Allele> alleles, String chr, int pos) {
        if (this.genotypeParts == null) {
            this.genotypeParts = new String[this.header.getColumnCount() - 8];
        }
        int nParts = ParsingUtils.split(str, this.genotypeParts, '\t');
        LinkedHashMap<String, Genotype> genotypes = new LinkedHashMap<String, Genotype>(nParts);
        int nGTKeys = ParsingUtils.split(this.genotypeParts[0], this.genotypeKeyArray, ':');
        Iterator<String> sampleNameIterator = this.header.getGenotypeSamples().iterator();
        this.alleleMap.clear();
        for (int genotypeOffset = 1; genotypeOffset < nParts; ++genotypeOffset) {
            int GTValueSplitSize = ParsingUtils.split(this.genotypeParts[genotypeOffset], this.GTValueArray, ':');
            double GTQual = -1.0;
            Set<String> genotypeFilters = null;
            HashMap<String, String> gtAttributes = null;
            String sampleName = sampleNameIterator.next();
            if (nGTKeys < GTValueSplitSize) {
                this.generateException("There are too many keys for the sample " + sampleName + ", keys = " + this.parts[8] + ", values = " + this.parts[genotypeOffset]);
            }
            int genotypeAlleleLocation = -1;
            if (nGTKeys >= 1) {
                gtAttributes = new HashMap<String, String>(nGTKeys - 1);
                for (int i2 = 0; i2 < nGTKeys; ++i2) {
                    boolean missing;
                    String gtKey = new String(this.genotypeKeyArray[i2]);
                    boolean bl = missing = i2 >= GTValueSplitSize;
                    if (gtKey.equals("GT")) {
                        if (i2 != 0) {
                            this.generateException("Saw GT at position " + i2 + ", but it must be at the first position for genotypes");
                        }
                        genotypeAlleleLocation = i2;
                        continue;
                    }
                    if (gtKey.equals("GQ")) {
                        GTQual = missing ? VCFCodec.parseQual(".") : VCFCodec.parseQual(this.GTValueArray[i2]);
                        continue;
                    }
                    if (gtKey.equals("FT")) {
                        genotypeFilters = missing ? this.parseFilters(".") : this.parseFilters(this.getCachedString(this.GTValueArray[i2]));
                        continue;
                    }
                    if (missing) {
                        gtAttributes.put(gtKey, ".");
                        continue;
                    }
                    gtAttributes.put(gtKey, new String(this.GTValueArray[i2]));
                }
            }
            if (genotypeAlleleLocation < 0) {
                this.generateException("Unable to find required field GT for the record; we don't yet support a missing GT field");
            }
            boolean phased = this.GTValueArray[genotypeAlleleLocation].length() > 1 && this.GTValueArray[genotypeAlleleLocation].charAt(1) == '|';
            try {
                genotypes.put(sampleName, new Genotype(sampleName, VCFCodec.parseGenotypeAlleles(this.GTValueArray[genotypeAlleleLocation], alleles, this.alleleMap), GTQual, genotypeFilters, gtAttributes, phased));
                continue;
            }
            catch (TribbleException e2) {
                throw new TribbleException.InternalCodecException(e2.getMessage() + ", at position " + chr + ":" + pos);
            }
        }
        return genotypes;
    }
}

