/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MiscTests {
    public static void main(String[] args) throws FileNotFoundException, IOException {
        String file = "/Volumes/xchip_tcga/gbm/analysis/Barbara/Affy128_cnLOH/chr10.FALLS_p_TCGAaffxB4_1_GenomeWideSNP_6_A10_190536.cn.bin";
        MiscTests.dumpFloats(file);
    }

    public static void canonicalPath() {
        try {
            File f2 = new File("/Volumes/bob/sue/../../foo.txt");
            System.out.println(f2.getCanonicalPath());
        }
        catch (IOException ex) {
            Logger.getLogger(MiscTests.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void printOS() {
        System.out.println(System.getProperty("os.name"));
        System.out.println(System.getProperty("os.arch"));
    }

    public static void compareFloats(File file1, File file2) throws FileNotFoundException, IOException {
        DataInputStream dis1 = new DataInputStream(new BufferedInputStream(new FileInputStream(file1)));
        DataInputStream dis2 = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
        assert (file1.length() == file2.length());
        int nFloats = (int)(file1.length() / 4L);
        for (int i2 = 0; i2 < nFloats; ++i2) {
            float f1 = dis1.readFloat();
            float f2 = dis2.readFloat();
            if (f1 < 0.0f) {
                if (Float.isNaN(f2)) continue;
                System.out.println("Difference! i=" + i2 + " f1= " + f1 + "  f2= " + f2);
                return;
            }
            if (f1 == f2) continue;
            System.out.println("Difference! i=" + i2 + " f1= " + f1 + "  f2= " + f2);
            return;
        }
    }

    public static void fixNaN(File inputDirectory, File outputDirectory) throws FileNotFoundException, IOException {
        if (!outputDirectory.exists()) {
            outputDirectory.mkdir();
        }
        for (File f2 : inputDirectory.listFiles()) {
            String fn = f2.getName();
            if (fn.contains("snplocation") || fn.contains("snipid")) continue;
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(f2)));
            int nFloats = (int)(f2.length() / 4L);
            File outputFile = new File(outputDirectory, f2.getName());
            DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile)));
            for (int i2 = 0; i2 < nFloats; ++i2) {
                float f1 = dis.readFloat();
                if (f1 < 0.0f) {
                    f1 = Float.NaN;
                }
                dos.writeFloat(f1);
            }
            dis.close();
            dos.close();
        }
    }

    public static void dumpLongs(String file) throws FileNotFoundException, IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        for (int i2 = 0; i2 < 100; ++i2) {
            System.out.println(dis.readLong());
        }
        dis.close();
    }

    public static void dumpFloats(String file) throws FileNotFoundException, IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        for (int i2 = 0; i2 < 100; ++i2) {
            System.out.println(dis.readFloat());
        }
        dis.close();
    }

    public static void tailLongs(String file) throws FileNotFoundException, IOException {
        long len = new File(file).length();
        long pos = len - 256L;
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        dis.skip(pos);
        try {
            while (true) {
                System.out.println(dis.readLong());
            }
        }
        catch (EOFException eOFException) {
            dis.close();
            return;
        }
    }

    public static void moreLongs(String file) throws FileNotFoundException, IOException {
        long len = new File(file).length();
        DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            for (int i2 = 0; i2 < 10; ++i2) {
                System.out.println(dis.readLong());
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        dis.close();
    }
}

