/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGV;

public class MessageUtils {
    private static Logger log = Logger.getLogger(MessageUtils.class);

    public static synchronized void showMessage(final String message) {
        if (Globals.isHeadless() || Globals.isSuppressMessages()) {
            log.info(message);
        } else {
            Frame parent;
            Frame frame = parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
            if (SwingUtilities.isEventDispatchThread()) {
                JOptionPane.showMessageDialog(parent, message);
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        JOptionPane.showMessageDialog(parent, message);
                    }
                };
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (InterruptedException e2) {
                    log.error("Error in showMessage", e2);
                    throw new RuntimeException(e2);
                }
                catch (InvocationTargetException e3) {
                    log.error("Error in showMessage", e3);
                    throw new RuntimeException(e3.getCause());
                }
            }
        }
    }

    public static synchronized boolean confirm(String message) {
        Frame parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
        return MessageUtils.confirm(parent, message);
    }

    public static synchronized boolean confirm(final Component component, final String message) {
        if (SwingUtilities.isEventDispatchThread()) {
            int opt = JOptionPane.showConfirmDialog(component, message, "Confirm", 0);
            return opt == 0;
        }
        final ValueHolder returnValue = new ValueHolder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                int opt = JOptionPane.showConfirmDialog(component, message, "Confirm", 0);
                returnValue.value = opt == 0;
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e2) {
            log.error("Error in showMessage", e2);
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            log.error("Error in showMessage", e3);
            throw new RuntimeException(e3.getCause());
        }
        return (Boolean)returnValue.value;
    }

    public static String showInputDialog(final String message, final String defaultValue) {
        Frame parent;
        Frame frame = parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
        if (SwingUtilities.isEventDispatchThread()) {
            String val = JOptionPane.showInputDialog(parent, message, defaultValue);
            return val;
        }
        final ValueHolder returnValue = new ValueHolder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String val = JOptionPane.showInputDialog(parent, message, defaultValue);
                returnValue.value = val;
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e2) {
            log.error("Error in showMessage", e2);
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            log.error("Error in showMessage", e3);
            throw new RuntimeException(e3.getCause());
        }
        return (String)returnValue.value;
    }

    public static String showInputDialog(final String message) {
        Frame parent;
        Frame frame = parent = IGV.hasInstance() ? IGV.getMainFrame() : null;
        if (SwingUtilities.isEventDispatchThread()) {
            String val = JOptionPane.showInputDialog(parent, (Object)message);
            return val;
        }
        final ValueHolder returnValue = new ValueHolder();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String val = JOptionPane.showInputDialog(parent, (Object)message);
                returnValue.value = val;
            }
        };
        try {
            SwingUtilities.invokeAndWait(runnable);
        }
        catch (InterruptedException e2) {
            log.error("Error in showMessage", e2);
            throw new RuntimeException(e2);
        }
        catch (InvocationTargetException e3) {
            log.error("Error in showMessage", e3);
            throw new RuntimeException(e3.getCause());
        }
        return (String)returnValue.value;
    }

    public static void main(String[] args) throws Exception {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                MessageUtils.showMessage("showMessage");
                MessageUtils.confirm("confirm");
                MessageUtils.confirm(null, "confirm with parent");
                MessageUtils.showInputDialog("showInputDialog", "default");
                MessageUtils.showInputDialog("showInputDialog");
            }
        };
        runnable.run();
        SwingUtilities.invokeLater(runnable);
    }

    static class ValueHolder {
        Object value;

        ValueHolder() {
        }
    }
}

