/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic.data;

import org.broad.igv.hic.MainWindow;
import org.broad.igv.hic.data.MatrixZoomData;

public class Matrix {
    public int chr1;
    public int chr2;
    public MatrixZoomData[] zoomData;

    public Matrix(int chr1, int chr2) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.zoomData = new MatrixZoomData[MainWindow.zoomBinSizes.length];
        for (int i2 = 0; i2 < MainWindow.zoomBinSizes.length; ++i2) {
            int binSize = MainWindow.zoomBinSizes[i2];
            int nBlocks = (int)Math.pow(Math.pow(2.0, i2), 0.25);
            this.zoomData[i2] = new MatrixZoomData(chr1, chr2, binSize, nBlocks, i2);
        }
    }

    public Matrix(int chr1, int chr2, int binSize) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.zoomData = new MatrixZoomData[1];
        int nBlocks = 1;
        this.zoomData[0] = new MatrixZoomData(chr1, chr2, binSize, nBlocks, 0);
    }

    public Matrix(int chr1, int chr2, MatrixZoomData[] zoomData) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        this.zoomData = zoomData;
    }

    public static String generateKey(int chr1, int chr2) {
        return "" + chr1 + "_" + chr2;
    }

    public String getKey() {
        return Matrix.generateKey(this.chr1, this.chr2);
    }

    public MatrixZoomData getZoomData(int zoomIndex) {
        return this.zoomData[zoomIndex];
    }

    public void incrementCount(int pos1, int pos2) {
        for (int i2 = 0; i2 < this.zoomData.length; ++i2) {
            this.zoomData[i2].incrementCount(pos1, pos2);
        }
    }

    public void parsingComplete() {
        for (MatrixZoomData zd : this.zoomData) {
            zd.parsingComplete();
        }
    }
}

