/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.hic;

import java.awt.Color;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.JComponent;
import org.broad.igv.hic.ColorScale;

public class ColorScalePanel
extends JComponent
implements Serializable {
    ColorScale colorScale;

    public ColorScalePanel() {
    }

    public ColorScalePanel(ColorScale colorScale) {
        this.colorScale = colorScale;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.colorScale != null) {
            int nSteps = this.getWidth() - 1;
            if (nSteps <= 0) {
                return;
            }
            float delta = this.colorScale.maxCount / nSteps;
            int xLast = 0;
            for (int n2 = 1; n2 < nSteps; ++n2) {
                int x = n2;
                int dx = x - xLast;
                xLast = x;
                float v = delta * (float)n2;
                Color c2 = this.colorScale.getColor(v);
                graphics.setColor(c2);
                graphics.fillRect(x, 0, dx, this.getHeight());
            }
        }
    }
}

