/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.broad.igv.feature.genome.GenomeDescriptor;

public class GenomeZipDescriptor
extends GenomeDescriptor {
    private Map<String, ZipEntry> zipEntries;
    private ZipFile genomeZipFile;

    public GenomeZipDescriptor(String name, int version, boolean chrNamesAltered, String id, String cytoBandFileName, String geneFileName, String chrAliasFileName, String geneTrackName, String sequenceLocation, ZipFile genomeZipFile, Map<String, ZipEntry> zipEntries, boolean chromosomesAreOrdered, boolean fasta) {
        super(name, version, chrNamesAltered, id, cytoBandFileName, geneFileName, chrAliasFileName, geneTrackName, sequenceLocation, chromosomesAreOrdered, fasta);
        this.zipEntries = zipEntries;
        this.genomeZipFile = genomeZipFile;
    }

    @Override
    public InputStream getCytoBandStream() throws IOException {
        String fileName = this.cytoBandFileName;
        if (fileName == null) {
            return null;
        }
        boolean isGZipped = fileName.toLowerCase().endsWith(".gz");
        InputStream is = this.genomeZipFile.getInputStream(this.zipEntries.get(fileName));
        return isGZipped ? new GZIPInputStream(is) : is;
    }

    @Override
    public InputStream getGeneStream() throws IOException {
        if (this.geneFileName == null) {
            return null;
        }
        InputStream is = this.genomeZipFile.getInputStream(this.zipEntries.get(this.geneFileName));
        return this.geneFileName.endsWith(".gz") ? new GZIPInputStream(is) : is;
    }

    @Override
    public InputStream getChrAliasStream() throws IOException {
        String fileName = this.chrAliasFileName;
        if (fileName == null || !this.zipEntries.containsKey(fileName)) {
            return null;
        }
        return this.genomeZipFile.getInputStream(this.zipEntries.get(fileName));
    }
}

