/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.SocketException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.PreferenceManager;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.CytoBandFileParser;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeDescriptor;
import org.broad.igv.feature.genome.GenomeImporter;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeServerException;
import org.broad.igv.feature.genome.GenomeZipDescriptor;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.ConfirmDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.Utilities;
import org.broad.tribble.readers.AsciiLineReader;

public class GenomeManager {
    private static Logger log = Logger.getLogger(GenomeManager.class);
    public static final String USER_DEFINED_GENOME_LIST_FILE = "user-defined-genomes.txt";
    private static GenomeDescriptor DEFAULT_GENOME;
    public Genome currentGenome;
    private List<GenomeListItem> userDefinedGenomeArchiveList;
    private List<GenomeListItem> cachedGenomeArchiveList;
    private List<GenomeListItem> serverGenomeArchiveList;
    IGV igv;
    boolean serverGenomeListUnreachable = false;

    public GenomeManager(IGV igv) {
        this.igv = igv;
    }

    public GenomeManager() {
        this.igv = null;
    }

    public Genome loadGenome(String genomePath, ProgressMonitor monitor) throws IOException {
        try {
            GenomeDescriptor genomeDescriptor = null;
            if (monitor != null) {
                monitor.fireProgressChange(25);
            }
            if (genomePath.endsWith(".genome")) {
                File archiveFile;
                HttpUtils.getInstance();
                if (HttpUtils.isURL(genomePath.toLowerCase())) {
                    URL genomeArchiveURL = new URL(genomePath);
                    String cachedFilename = Utilities.getFileNameFromURL(URLDecoder.decode(new URL(genomePath).getFile(), "UTF-8"));
                    if (!Globals.getGenomeCacheDirectory().exists()) {
                        Globals.getGenomeCacheDirectory().mkdir();
                    }
                    archiveFile = new File(Globals.getGenomeCacheDirectory(), cachedFilename);
                    this.refreshCache(archiveFile, genomeArchiveURL);
                } else {
                    archiveFile = new File(genomePath);
                }
                genomeDescriptor = this.parseGenomeArchiveFile(archiveFile);
                LinkedHashMap<String, Chromosome> chromMap = this.loadCytobandFile(genomeDescriptor);
                Map<String, String> aliases = this.loadAliasFile(genomeDescriptor);
                String id = genomeDescriptor.getId();
                String displayName = genomeDescriptor.getName();
                boolean isFasta = genomeDescriptor.isFasta();
                this.currentGenome = new Genome(id, displayName, genomeDescriptor.getSequenceLocation(), isFasta);
                this.currentGenome.setChromosomeMap(chromMap, genomeDescriptor.isChromosomesAreOrdered());
                if (aliases != null) {
                    this.currentGenome.addChrAliases(aliases);
                }
                if (!Globals.isHeadless()) {
                    this.updateGeneTrack(genomeDescriptor);
                }
            } else {
                String fastaPath = null;
                String fastaIndexPath = null;
                if (genomePath.endsWith(".fai")) {
                    fastaPath = genomePath.substring(0, genomePath.length() - 4);
                    fastaIndexPath = genomePath;
                } else {
                    fastaPath = genomePath;
                    fastaIndexPath = genomePath + ".fai";
                }
                if (!FileUtils.resourceExists(fastaIndexPath)) {
                    throw new RuntimeException("<html>No index found, fasta files must be indexed.<br>Indexes can be created with samtools (http://samtools.sourceforge.net/)<br>or Picard(http://picard.sourceforge.net/).");
                }
                String id = fastaPath;
                String name = new File(fastaPath).getName();
                this.currentGenome = new Genome(id, name, fastaPath, true);
                IGV.getInstance().getTrackManager().createGeneTrack(this.currentGenome, null, null, null, null);
            }
            if (monitor != null) {
                monitor.fireProgressChange(25);
            }
            this.currentGenome.loadUserDefinedAliases();
            return this.currentGenome;
        }
        catch (SocketException e2) {
            throw new GenomeServerException("Server connection error", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGeneTrack(GenomeDescriptor genomeDescriptor) throws IOException {
        InputStream geneStream = null;
        try {
            geneStream = genomeDescriptor.getGeneStream();
            AsciiLineReader reader = geneStream == null ? null : new AsciiLineReader(geneStream);
            IGV.getInstance().getTrackManager().createGeneTrack(this.currentGenome, reader, genomeDescriptor.getGeneFileName(), genomeDescriptor.getGeneTrackName(), genomeDescriptor.getUrl());
        }
        finally {
            if (geneStream != null) {
                geneStream.close();
            }
        }
    }

    private LinkedHashMap<String, Chromosome> loadCytobandFile(GenomeDescriptor genomeDescriptor) {
        InputStream is = null;
        try {
            is = genomeDescriptor.getCytoBandStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            LinkedHashMap<String, Chromosome> linkedHashMap = CytoBandFileParser.loadData(reader);
            return linkedHashMap;
        }
        catch (IOException ex) {
            log.warn("Error loading cytoband file", ex);
            throw new RuntimeException("Error loading cytoband file" + genomeDescriptor.cytoBandFileName);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing zip stream!", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> loadAliasFile(GenomeDescriptor genomeDescriptor) {
        InputStream aliasStream = null;
        try {
            aliasStream = genomeDescriptor.getChrAliasStream();
            if (aliasStream != null) {
                HashMap<String, String> chrAliasTable = new HashMap<String, String>();
                BufferedReader reader = new BufferedReader(new InputStreamReader(aliasStream));
                String nextLine = "";
                while ((nextLine = reader.readLine()) != null) {
                    String[] kv = nextLine.split("\t");
                    if (kv.length <= 1) continue;
                    chrAliasTable.put(kv[0], kv[1]);
                }
                HashMap<String, String> hashMap = chrAliasTable;
                return hashMap;
            }
            Map<String, String> chrAliasTable = null;
            return chrAliasTable;
        }
        catch (Exception e2) {
            log.error("Error loading chromosome alias table");
            Map<String, String> map = null;
            return map;
        }
        finally {
            try {
                if (aliasStream != null) {
                    aliasStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing zip stream!", ex);
            }
        }
    }

    private void refreshCache(File archiveFile, URL genomeArchiveURL) {
        try {
            if (archiveFile.exists()) {
                boolean forceUpdate;
                long fileLength = archiveFile.length();
                long contentLength = HttpUtils.getInstance().getContentLength(genomeArchiveURL);
                if (contentLength <= 0L) {
                    log.info("Skipping genome update of " + archiveFile.getName() + " due to unknown content length");
                }
                boolean bl = forceUpdate = contentLength != fileLength && PreferenceManager.getInstance().getAsBoolean("AUTO_UPDATE_GENOMES");
                if (forceUpdate) {
                    log.info("Refreshing genome: " + genomeArchiveURL.toString());
                    File tmpFile = new File(archiveFile.getAbsolutePath() + ".tmp");
                    if (HttpUtils.getInstance().downloadFile(genomeArchiveURL.toExternalForm(), tmpFile)) {
                        FileUtils.copyFile(tmpFile, archiveFile);
                        tmpFile.deleteOnExit();
                    }
                }
            } else {
                HttpUtils.getInstance().downloadFile(genomeArchiveURL.toExternalForm(), archiveFile);
            }
        }
        catch (Exception e2) {
            log.error("Error refreshing genome cache. ", e2);
            MessageUtils.showMessage("An error was encountered refreshing the genome cache: " + e2.getMessage() + "<br> If this problem persists please contact igv-help@broadinstitute.org");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenomeDescriptor parseGenomeArchiveFile(File f2) throws IOException {
        String zipFilePath = f2.getAbsolutePath();
        if (!f2.exists()) {
            log.error("Genome file: " + f2.getAbsolutePath() + " does not exist.");
            return null;
        }
        GenomeZipDescriptor genomeDescriptor = null;
        HashMap<String, ZipEntry> zipEntries = new HashMap<String, ZipEntry>();
        ZipFile zipFile = new ZipFile(zipFilePath);
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(new FileInputStream(f2));
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                String zipEntryName = zipEntry.getName();
                zipEntries.put(zipEntryName, zipEntry);
                if (zipEntryName.equalsIgnoreCase("property.txt")) {
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    String cytobandZipEntryName = properties.getProperty("cytobandFile");
                    String geneFileName = properties.getProperty("geneFile");
                    String chrAliasFileName = properties.getProperty("chrAliasFile");
                    String sequenceLocation = properties.getProperty("sequenceLocation");
                    if (sequenceLocation != null) {
                        HttpUtils.getInstance();
                        if (!HttpUtils.isURL(sequenceLocation)) {
                            File sequenceFolder = null;
                            if (sequenceLocation.startsWith("/") || sequenceLocation.startsWith("\\")) {
                                sequenceFolder = new File(sequenceLocation);
                            } else {
                                File tempZipFile = new File(zipFilePath);
                                sequenceFolder = new File(tempZipFile.getParent(), sequenceLocation);
                            }
                            sequenceLocation = sequenceFolder.getCanonicalPath();
                            sequenceLocation.replace('\\', '/');
                        }
                    }
                    int version = 0;
                    String versionString = properties.getProperty("version");
                    if (versionString != null) {
                        try {
                            version = Integer.parseInt(versionString);
                        }
                        catch (Exception e2) {
                            log.error("Error parsing version string: " + versionString);
                        }
                    }
                    boolean chrNamesAltered = false;
                    String chrNamesAlteredString = properties.getProperty("filenamesAltered");
                    if (chrNamesAlteredString != null) {
                        try {
                            chrNamesAltered = Boolean.parseBoolean(chrNamesAlteredString);
                        }
                        catch (Exception e3) {
                            log.error("Error parsing version string: " + versionString);
                        }
                    }
                    boolean chromosomesAreOrdered = false;
                    String tmp = properties.getProperty("ordered");
                    if (tmp != null) {
                        try {
                            chromosomesAreOrdered = Boolean.parseBoolean(tmp);
                        }
                        catch (Exception e4) {
                            log.error("Error parsing ordered string: " + tmp);
                        }
                    }
                    boolean fasta = false;
                    String fastaString = properties.getProperty("fasta");
                    if (fastaString != null) {
                        try {
                            fasta = Boolean.parseBoolean(fastaString);
                        }
                        catch (Exception e5) {
                            log.error("Error parsing version string: " + versionString);
                        }
                    }
                    String url = properties.getProperty("url");
                    genomeDescriptor = new GenomeZipDescriptor(properties.getProperty("name"), version, chrNamesAltered, properties.getProperty("id"), cytobandZipEntryName, geneFileName, chrAliasFileName, properties.getProperty("geneTrackName", "Gene"), sequenceLocation, zipFile, zipEntries, chromosomesAreOrdered, fasta);
                    if (url != null) {
                        genomeDescriptor.setUrl(url);
                    }
                }
                zipEntry = zipInputStream.getNextEntry();
            }
        }
        finally {
            try {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
            catch (IOException ex) {
                log.warn("Error closing imported genome zip stream!", ex);
            }
        }
        return genomeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenomeListItem> getServerGenomeArchiveList(Set excludedArchivesUrls) throws IOException {
        if (this.serverGenomeListUnreachable) {
            return null;
        }
        if (this.serverGenomeArchiveList == null) {
            this.serverGenomeArchiveList = new LinkedList<GenomeListItem>();
            BufferedReader dataReader = null;
            InputStream inputStream = null;
            String genomeListURLString = "";
            try {
                String genomeRecord;
                genomeListURLString = PreferenceManager.getInstance().getGenomeListURL();
                URL serverGenomeURL = new URL(genomeListURLString);
                HttpUtils.getInstance();
                if (HttpUtils.isURL(genomeListURLString)) {
                    inputStream = HttpUtils.getInstance().openConnectionStream(serverGenomeURL);
                } else {
                    File file = new File(genomeListURLString.startsWith("file:") ? serverGenomeURL.getFile() : genomeListURLString);
                    inputStream = new FileInputStream(file);
                }
                dataReader = new BufferedReader(new InputStreamReader(inputStream));
                while ((genomeRecord = dataReader.readLine()) != null) {
                    if (genomeRecord.startsWith("<") || genomeRecord.startsWith("(#") || genomeRecord == null) continue;
                    String[] fields = (genomeRecord = genomeRecord.trim()).split("\t");
                    if (fields != null && fields.length >= 3) {
                        if (excludedArchivesUrls != null && excludedArchivesUrls.contains(fields[1])) continue;
                        int version = 0;
                        if (fields.length > 3) {
                            try {
                                version = Integer.parseInt(fields[3]);
                            }
                            catch (Exception e2) {
                                log.error("Error parsing genome version: " + fields[0], e2);
                            }
                        }
                        String name = fields[0];
                        String url = fields[1];
                        String id = fields[2];
                        boolean valid = true;
                        if (url.length() == 0) {
                            log.error("Genome entry : " + name + " has an empty URL string.  Check for extra tabs in the definition file: " + PreferenceManager.getInstance().getGenomeListURL());
                            valid = false;
                        }
                        if (!valid) continue;
                        try {
                            GenomeListItem item = new GenomeListItem(fields[0], fields[1], fields[2], false);
                            this.serverGenomeArchiveList.add(item);
                        }
                        catch (Exception e3) {
                            log.error("Error reading a line from server genome list line was: [" + genomeRecord + "]", e3);
                        }
                        continue;
                    }
                    log.error("Found invalid server genome list record: " + genomeRecord);
                }
            }
            catch (Exception e4) {
                this.serverGenomeListUnreachable = true;
                log.error("Error fetching genome list: ", e4);
                ConfirmDialog.optionallyShowInfoDialog("Warning: could not connect to the genome server (" + genomeListURLString + ").    Only locally defined genomes will be available.", "SHOW_GENOME_SERVER_WARNING");
            }
            finally {
                if (dataReader != null) {
                    dataReader.close();
                }
                if (inputStream != null) {
                    inputStream.close();
                }
            }
        }
        return this.serverGenomeArchiveList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenomeListItem> getUserDefinedGenomeArchiveList() throws IOException {
        if (this.userDefinedGenomeArchiveList == null) {
            boolean updateClientGenomeListFile = false;
            this.userDefinedGenomeArchiveList = new LinkedList<GenomeListItem>();
            File listFile = new File(Globals.getGenomeCacheDirectory(), USER_DEFINED_GENOME_LIST_FILE);
            BufferedReader reader = null;
            boolean mightBeProperties = false;
            try {
                String nextLine;
                reader = new BufferedReader(new FileReader(listFile));
                while ((nextLine = reader.readLine()) != null) {
                    String file;
                    if (nextLine.startsWith("#") || nextLine.trim().length() == 0) {
                        mightBeProperties = true;
                        continue;
                    }
                    String[] fields = nextLine.split("\t");
                    if (fields.length < 3 && mightBeProperties && fields[0].contains("=")) {
                        fields = nextLine.split("\\\\t");
                        if (fields.length < 3) continue;
                        int idx = fields[0].indexOf("=");
                        fields[0] = fields[0].substring(idx + 1);
                    }
                    if (!FileUtils.resourceExists(file = fields[1])) {
                        updateClientGenomeListFile = true;
                        continue;
                    }
                    GenomeListItem item = new GenomeListItem(fields[0], file, fields[2], true);
                    this.userDefinedGenomeArchiveList.add(item);
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            if (updateClientGenomeListFile) {
                this.updateImportedGenomePropertyFile();
            }
        }
        return this.userDefinedGenomeArchiveList;
    }

    public void clearGenomeCache() {
        File[] files;
        for (File file : files = Globals.getGenomeCacheDirectory().listFiles()) {
            if (!file.getName().toLowerCase().endsWith(".genome")) continue;
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<GenomeListItem> getCachedGenomeArchiveList() throws IOException {
        if (this.cachedGenomeArchiveList == null) {
            File[] files;
            this.cachedGenomeArchiveList = new LinkedList<GenomeListItem>();
            if (!Globals.getGenomeCacheDirectory().exists()) {
                return this.cachedGenomeArchiveList;
            }
            for (File file : files = Globals.getGenomeCacheDirectory().listFiles()) {
                if (file.isDirectory() || !file.getName().toLowerCase().endsWith(".genome")) continue;
                ZipFile zipFile = null;
                FileInputStream fis = null;
                ZipInputStream zipInputStream = null;
                try {
                    zipFile = new ZipFile(file);
                    fis = new FileInputStream(file);
                    zipInputStream = new ZipInputStream(new BufferedInputStream(fis));
                    ZipEntry zipEntry = zipFile.getEntry("property.txt");
                    if (zipEntry == null) continue;
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Properties properties = new Properties();
                    properties.load(inputStream);
                    int version = 0;
                    if (properties.containsKey("version")) {
                        try {
                            version = Integer.parseInt(properties.getProperty("version"));
                        }
                        catch (Exception e2) {
                            log.error("Error parsing genome version: " + version, e2);
                        }
                    }
                    GenomeListItem item = new GenomeListItem(properties.getProperty("name"), file.getAbsolutePath(), properties.getProperty("id"), false);
                    this.cachedGenomeArchiveList.add(item);
                }
                catch (ZipException ex) {
                    log.error("\nZip error unzipping cached genome.", ex);
                    try {
                        file.delete();
                        zipInputStream.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                catch (IOException ex) {
                    log.warn("\nIO error unzipping cached genome.", ex);
                    try {
                        file.delete();
                    }
                    catch (Exception e4) {
                        // empty catch block
                    }
                }
                finally {
                    try {
                        if (zipInputStream != null) {
                            zipInputStream.close();
                        }
                        if (zipFile != null) {
                            zipFile.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                    }
                    catch (IOException ex) {
                        log.warn("Error closing genome zip stream!", ex);
                    }
                }
            }
        }
        return this.cachedGenomeArchiveList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateImportedGenomePropertyFile() {
        if (this.userDefinedGenomeArchiveList == null) {
            return;
        }
        File listFile = new File(Globals.getGenomeCacheDirectory(), USER_DEFINED_GENOME_LIST_FILE);
        File backup = null;
        if (listFile.exists()) {
            backup = new File(listFile.getAbsolutePath() + ".bak");
            try {
                FileUtils.copyFile(listFile, backup);
            }
            catch (IOException e2) {
                log.error("Error backing up user-defined genome list file", e2);
                backup = null;
            }
        }
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(listFile)));
            for (GenomeListItem genomeListItem : this.userDefinedGenomeArchiveList) {
                writer.print(genomeListItem.getDisplayableName());
                writer.print("\t");
                writer.print(genomeListItem.getLocation());
                writer.print("\t");
                writer.println(genomeListItem.getId());
            }
        }
        catch (Exception e3) {
            if (backup != null) {
                try {
                    FileUtils.copyFile(backup, listFile);
                }
                catch (IOException e1) {
                    log.error("Error restoring genome-list file from backup");
                }
            }
            log.error("Error updating genome property file", e3);
            MessageUtils.showMessage("Error updating user-defined genome list " + e3.getMessage());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
            if (backup != null) {
                backup.delete();
            }
        }
    }

    public GenomeListItem defineGenome(String genomeZipLocation, String cytobandFileName, String refFlatFileName, String fastaFileName, String chrAliasFileName, String relativeSequenceLocation, String genomeDisplayName, String genomeId, String genomeFileName, ProgressMonitor monitor, String sequenceOutputLocationOverride) throws IOException {
        File zipFileLocation = null;
        File fastaInputFile = null;
        File refFlatFile = null;
        File cytobandFile = null;
        File chrAliasFile = null;
        if (genomeZipLocation != null && genomeZipLocation.trim().length() != 0) {
            zipFileLocation = new File(genomeZipLocation);
            PreferenceManager.getInstance().setLastGenomeImportDirectory(zipFileLocation);
        }
        if (cytobandFileName != null && cytobandFileName.trim().length() != 0) {
            cytobandFile = new File(cytobandFileName);
        }
        if (refFlatFileName != null && refFlatFileName.trim().length() != 0) {
            refFlatFile = new File(refFlatFileName);
        }
        if (chrAliasFileName != null && chrAliasFileName.trim().length() != 0) {
            chrAliasFile = new File(chrAliasFileName);
        }
        if (fastaFileName != null && fastaFileName.trim().length() != 0) {
            File sequenceLocation;
            fastaInputFile = new File(fastaFileName);
            if (relativeSequenceLocation != null && relativeSequenceLocation.trim().length() != 0 && !(sequenceLocation = new File(genomeZipLocation, relativeSequenceLocation)).exists()) {
                sequenceLocation.mkdir();
            }
        }
        if (monitor != null) {
            monitor.fireProgressChange(25);
        }
        File archiveFile = new GenomeImporter().createGenomeArchive(zipFileLocation, genomeFileName, genomeId, genomeDisplayName, relativeSequenceLocation, fastaInputFile, refFlatFile, cytobandFile, chrAliasFile, sequenceOutputLocationOverride, monitor);
        if (monitor != null) {
            monitor.fireProgressChange(75);
        }
        if (archiveFile == null) {
            return null;
        }
        GenomeListItem newItem = new GenomeListItem(genomeDisplayName, archiveFile.getAbsolutePath(), genomeId, true);
        this.addUserDefineGenomeItem(newItem);
        return newItem;
    }

    public String getGenomeId() {
        return this.currentGenome == null ? null : this.currentGenome.getId();
    }

    public Genome getCurrentGenome() {
        return this.currentGenome;
    }

    public void addUserDefineGenomeItem(GenomeListItem genomeListItem) {
        this.userDefinedGenomeArchiveList.add(0, genomeListItem);
        this.updateImportedGenomePropertyFile();
    }
}

