/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.util.Hashtable;
import org.apache.log4j.Logger;
import org.broad.igv.feature.genome.IGVSequence;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.feature.genome.ServletSequence;
import org.broad.igv.util.ObjectCache;

public class SequenceHelper {
    private static Logger log = Logger.getLogger(SequenceHelper.class);
    private static boolean cacheSequences = true;
    private static int tileSize = 30000;
    Sequence sequence;
    private ObjectCache<String, SequenceTile> sequenceCache = new ObjectCache(50);
    private static Hashtable<String, String> sequenceUrlCache = new Hashtable();

    public SequenceHelper(String seqpath) {
        if (seqpath != null) {
            this.sequence = (seqpath = SequenceHelper.convertSequenceURL(seqpath)).startsWith("http://www.broadinstitute.org/igv/SequenceServlet") || seqpath.startsWith("http://www.broadinstitute.org/igv/sequence") ? new ServletSequence(seqpath) : new IGVSequence(seqpath);
        }
    }

    public SequenceHelper(Sequence sequence) {
        this.sequence = sequence;
    }

    public byte[] readCSSequence(String genome, String chr, int start, int end) {
        int i2;
        int c1;
        int csStart = start == 0 ? 0 : start - 1;
        byte[] baseSequence = this.sequence.readSequence(chr, csStart, end);
        if (baseSequence == null || baseSequence.length == 0) {
            return baseSequence;
        }
        byte[] csSequence = new byte[end - start];
        int n2 = c1 = start == 0 ? 0 : SequenceHelper.baseToCS(baseSequence[i2++]);
        for (i2 = 0; i2 < baseSequence.length; ++i2) {
            int c2 = SequenceHelper.baseToCS(baseSequence[i2]);
            csSequence[i2] = (byte)(c1 ^ c2);
        }
        return csSequence;
    }

    private static int baseToCS(byte base) {
        switch (base) {
            case 65: 
            case 97: {
                return 0;
            }
            case 67: 
            case 99: {
                return 1;
            }
            case 84: 
            case 116: {
                return 2;
            }
            case 71: 
            case 103: {
                return 3;
            }
        }
        return -1;
    }

    public byte[] getSequence(String chr, int start, int end, int max) {
        if (cacheSequences) {
            byte[] seqbytes = new byte[end - start];
            int startTile = start / tileSize;
            int endTile = end / tileSize;
            SequenceTile tile = this.getSequenceTile(chr, startTile, max);
            if (tile == null) {
                return null;
            }
            byte[] tileBytes = tile.getBytes();
            if (tileBytes == null) {
                return null;
            }
            int fromOffset = start - tile.getStart();
            int toOffset = 0;
            if (fromOffset < 0) {
                toOffset = -fromOffset;
                fromOffset = 0;
            }
            int nBytes = Math.min(tileBytes.length - Math.abs(fromOffset), seqbytes.length - Math.abs(toOffset));
            System.arraycopy(tileBytes, fromOffset, seqbytes, toOffset, nBytes);
            for (int t = startTile + 1; t <= endTile && (tile = this.getSequenceTile(chr, t, max)) != null; ++t) {
                int nNext = Math.min(seqbytes.length - nBytes, tile.getSize());
                System.arraycopy(tile.getBytes(), 0, seqbytes, nBytes, nNext);
                nBytes += nNext;
            }
            return seqbytes;
        }
        return this.sequence.readSequence(chr, start, end);
    }

    private SequenceTile getSequenceTile(String chr, int tileNo, int maxEnd) {
        String key = SequenceHelper.getKey(chr, tileNo);
        SequenceTile tile = this.sequenceCache.get(key);
        if (tile == null) {
            int start = tileNo * tileSize;
            int end = Math.min(start + tileSize, maxEnd);
            if (end <= start) {
                return null;
            }
            byte[] seq = this.sequence.readSequence(chr, start, end);
            tile = new SequenceTile(start, seq);
            this.sequenceCache.put(key, tile);
        }
        return tile;
    }

    static String getKey(String chr, int tileNo) {
        return chr + tileNo;
    }

    static void setTileSize(int aChunkSize) {
        tileSize = aChunkSize;
    }

    static void setCacheSequences(boolean aCacheSequences) {
        cacheSequences = aCacheSequences;
    }

    public void clearCache() {
        this.sequenceCache.clear();
    }

    public static String convertSequenceURL(String url) {
        String key = url;
        String convertedURL = sequenceUrlCache.get(key);
        if (convertedURL == null) {
            convertedURL = url;
            convertedURL = convertedURL.replace("broad.mit.edu", "broadinstitute.org");
            if (!url.equals(convertedURL = convertedURL.replace("http://www.broadinstitute.org/igv/SequenceServlet", "http://igvdata.broadinstitute.org/genomes/seq"))) {
                log.info("Converting sequence URL: " + url + " -> " + convertedURL);
            }
            sequenceUrlCache.put(key, convertedURL);
        }
        return convertedURL;
    }

    static class SequenceTile {
        private int start;
        private byte[] bytes;

        SequenceTile(int start, byte[] bytes) {
            this.start = start;
            this.bytes = bytes;
        }

        public int getStart() {
            return this.start;
        }

        public int getSize() {
            return this.bytes == null ? 0 : this.bytes.length;
        }

        public byte[] getBytes() {
            return this.bytes;
        }
    }
}

