/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.CSSUtilities;
import org.apache.batik.bridge.DocumentBridge;
import org.apache.batik.bridge.GenericBridge;
import org.apache.batik.bridge.GraphicsNodeBridge;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.util.HaltingThread;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class GVTBuilder
implements SVGConstants {
    public GraphicsNode build(BridgeContext ctx, Document document) {
        ctx.setDocument(document);
        ctx.initializeDocument(document);
        ctx.setGVTBuilder(this);
        DocumentBridge dBridge = ctx.getDocumentBridge();
        RootGraphicsNode rootNode = null;
        try {
            rootNode = dBridge.createGraphicsNode(ctx, document);
            Element svgElement = document.getDocumentElement();
            GraphicsNode topNode = null;
            Bridge bridge = ctx.getBridge(svgElement);
            if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
                return null;
            }
            GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
            topNode = gnBridge.createGraphicsNode(ctx, svgElement);
            if (topNode == null) {
                return null;
            }
            rootNode.getChildren().add(topNode);
            this.buildComposite(ctx, svgElement, (CompositeGraphicsNode)topNode);
            gnBridge.buildGraphicsNode(ctx, svgElement, topNode);
            dBridge.buildGraphicsNode(ctx, document, rootNode);
        }
        catch (BridgeException ex) {
            ex.setGraphicsNode(rootNode);
            throw ex;
        }
        if (ctx.isInteractive()) {
            ctx.addUIEventListeners(document);
            ctx.addGVTListener(document);
        }
        if (ctx.isDynamic()) {
            ctx.addDOMListeners();
        }
        return rootNode;
    }

    public GraphicsNode build(BridgeContext ctx, Element e2) {
        Bridge bridge = ctx.getBridge(e2);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(ctx, e2);
            this.handleGenericBridges(ctx, e2);
            return null;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            this.handleGenericBridges(ctx, e2);
            return null;
        }
        GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
        if (!gnBridge.getDisplay(e2)) {
            this.handleGenericBridges(ctx, e2);
            return null;
        }
        GraphicsNode gn = gnBridge.createGraphicsNode(ctx, e2);
        if (gn != null) {
            if (gnBridge.isComposite()) {
                this.buildComposite(ctx, e2, (CompositeGraphicsNode)gn);
            } else {
                this.handleGenericBridges(ctx, e2);
            }
            gnBridge.buildGraphicsNode(ctx, e2, gn);
        }
        if (ctx.isDynamic()) {
            // empty if block
        }
        return gn;
    }

    protected void buildComposite(BridgeContext ctx, Element e2, CompositeGraphicsNode parentNode) {
        Node n2 = e2.getFirstChild();
        while (n2 != null) {
            if (n2.getNodeType() == 1) {
                this.buildGraphicsNode(ctx, (Element)n2, parentNode);
            }
            n2 = n2.getNextSibling();
        }
    }

    protected void buildGraphicsNode(BridgeContext ctx, Element e2, CompositeGraphicsNode parentNode) {
        if (HaltingThread.hasBeenHalted()) {
            throw new InterruptedBridgeException();
        }
        Bridge bridge = ctx.getBridge(e2);
        if (bridge instanceof GenericBridge) {
            ((GenericBridge)bridge).handleElement(ctx, e2);
            this.handleGenericBridges(ctx, e2);
            return;
        }
        if (bridge == null || !(bridge instanceof GraphicsNodeBridge)) {
            this.handleGenericBridges(ctx, e2);
            return;
        }
        if (!CSSUtilities.convertDisplay(e2)) {
            this.handleGenericBridges(ctx, e2);
            return;
        }
        GraphicsNodeBridge gnBridge = (GraphicsNodeBridge)bridge;
        try {
            GraphicsNode gn = gnBridge.createGraphicsNode(ctx, e2);
            if (gn != null) {
                parentNode.getChildren().add(gn);
                if (gnBridge.isComposite()) {
                    this.buildComposite(ctx, e2, (CompositeGraphicsNode)gn);
                } else {
                    this.handleGenericBridges(ctx, e2);
                }
                gnBridge.buildGraphicsNode(ctx, e2, gn);
            } else {
                this.handleGenericBridges(ctx, e2);
            }
        }
        catch (BridgeException ex) {
            GraphicsNode errNode = ex.getGraphicsNode();
            if (errNode != null) {
                parentNode.getChildren().add(errNode);
                gnBridge.buildGraphicsNode(ctx, e2, errNode);
                ex.setGraphicsNode(null);
            }
            throw ex;
        }
    }

    protected void handleGenericBridges(BridgeContext ctx, Element e2) {
        Node n2 = e2.getFirstChild();
        while (n2 != null) {
            if (n2 instanceof Element) {
                Element e22 = (Element)n2;
                Bridge b2 = ctx.getBridge(e22);
                if (b2 instanceof GenericBridge) {
                    ((GenericBridge)b2).handleElement(ctx, e22);
                }
                this.handleGenericBridges(ctx, e22);
            }
            n2 = n2.getNextSibling();
        }
    }
}

