/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import org.broad.igv.ui.panel.DataPanel;
import org.broad.igv.ui.panel.ReferenceFrame;

public class RenderContext {
    private String genomeId;
    private Graphics2D graphics;
    private Map<Color, Graphics2D> graphicCacheByColor;
    private ReferenceFrame referenceFrame;
    private DataPanel panel;
    private Rectangle visibleRect;

    public RenderContext(String genomeId, DataPanel panel, Graphics2D graphics, ReferenceFrame referenceFrame, Rectangle visibleRect) {
        this.genomeId = genomeId;
        this.graphics = graphics;
        this.panel = panel;
        this.graphicCacheByColor = new HashMap<Color, Graphics2D>();
        this.referenceFrame = referenceFrame;
        this.visibleRect = visibleRect;
    }

    public Graphics2D getGraphic2DForColor(Color color) {
        Graphics2D g2 = this.graphicCacheByColor.get(color);
        if (g2 == null) {
            g2 = (Graphics2D)this.graphics.create();
            this.graphicCacheByColor.put(color, g2);
            g2.setColor(color);
        }
        return g2;
    }

    public Color getBackgroundColor() {
        return this.panel.getBackground();
    }

    public String getChr() {
        return this.referenceFrame.getChrName();
    }

    public double getOrigin() {
        return this.referenceFrame.getOrigin();
    }

    public double getEndLocation() {
        return this.referenceFrame.getEnd();
    }

    public double getScale() {
        return this.referenceFrame.getScale();
    }

    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    public DataPanel getPanel() {
        return this.panel;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public int getZoom() {
        return this.referenceFrame.getZoom();
    }

    public String getGenomeId() {
        return this.genomeId;
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        for (Graphics2D g2 : this.graphicCacheByColor.values()) {
            g2.dispose();
        }
        this.graphicCacheByColor.clear();
    }
}

