/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.feature.Exon;
import org.broad.igv.feature.IGVFeature;
import org.broad.igv.feature.NamedFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.ui.IGV;
import org.broad.tribble.Feature;

public class FeatureDB {
    private static Logger log = Logger.getLogger(FeatureDB.class);
    private static Map<String, NamedFeature> featureMap = Collections.synchronizedMap(new HashMap(10000));

    public static void addFeature(NamedFeature feature) {
        if (Globals.isHeadless()) {
            return;
        }
        String name = feature.getName();
        if (name != null && name.length() > 0) {
            FeatureDB.put(name, feature);
        }
        if (feature instanceof IGVFeature) {
            IGVFeature igvFeature = (IGVFeature)feature;
            String id = igvFeature.getIdentifier();
            if (id != null && id.length() > 0) {
                FeatureDB.put(id, feature);
            }
            FeatureDB.addByAttributes(igvFeature);
            List<Exon> exons = igvFeature.getExons();
            if (exons != null) {
                for (Exon exon : exons) {
                    FeatureDB.addByAttributes(exon);
                }
            }
        }
    }

    private static void addByAttributes(IGVFeature igvFeature) {
        Map<String, String> attributes = igvFeature.getAttributes();
        if (attributes != null) {
            for (String value : attributes.values()) {
                if (value.length() >= 20) continue;
                FeatureDB.put(value, igvFeature);
            }
        }
    }

    public static void put(String name, NamedFeature feature) {
        String key = name.toUpperCase();
        Genome currentGenome = IGV.getInstance().getGenomeManager().getCurrentGenome();
        if (currentGenome == null || currentGenome.getChromosome(feature.getChr()) != null) {
            NamedFeature currentFeature = featureMap.get(key);
            if (currentFeature == null) {
                featureMap.put(key, feature);
            } else {
                String featureChr = feature.getChr().toLowerCase();
                String currentFeatureChr = currentFeature.getChr();
                if (featureChr.contains("random") || featureChr.contains("chrun") || featureChr.contains("hap")) {
                    return;
                }
                if (currentFeatureChr.contains("random") || currentFeatureChr.contains("chrun") || currentFeatureChr.contains("hap")) {
                    featureMap.put(key, feature);
                    return;
                }
                int w1 = currentFeature.getEnd() - currentFeature.getStart();
                int w2 = feature.getEnd() - feature.getStart();
                if (w2 > w1) {
                    featureMap.put(key, feature);
                }
            }
        }
    }

    public static void addFeature(String name, NamedFeature feature) {
        if (Globals.isHeadless()) {
            return;
        }
        featureMap.put(name.toUpperCase(), feature);
    }

    private FeatureDB() {
    }

    public static void addFeatures(List<Feature> features) {
        for (Feature feature : features) {
            if (!(feature instanceof IGVFeature)) continue;
            FeatureDB.addFeature((IGVFeature)feature);
        }
    }

    public static void clearFeatures() {
        featureMap.clear();
    }

    public static NamedFeature getFeature(String nm) {
        String name = nm.trim().toUpperCase();
        return featureMap.get(name);
    }
}

