/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.util;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.MathException;

public abstract class ContinuedFraction
implements Serializable {
    private static final long serialVersionUID = 1768555336266158242L;
    private static final double DEFAULT_EPSILON = 1.0E-8;

    protected ContinuedFraction() {
    }

    protected abstract double getA(int var1, double var2);

    protected abstract double getB(int var1, double var2);

    public double evaluate(double x) throws MathException {
        return this.evaluate(x, 1.0E-8, Integer.MAX_VALUE);
    }

    public double evaluate(double x, double epsilon) throws MathException {
        return this.evaluate(x, epsilon, Integer.MAX_VALUE);
    }

    public double evaluate(double x, int maxIterations) throws MathException {
        return this.evaluate(x, 1.0E-8, maxIterations);
    }

    public double evaluate(double x, double epsilon, int maxIterations) throws MathException {
        double p0 = 1.0;
        double p1 = this.getA(0, x);
        double q0 = 0.0;
        double q1 = 1.0;
        double c2 = p1 / q1;
        int n2 = 0;
        double relativeError = Double.MAX_VALUE;
        while (n2 < maxIterations && relativeError > epsilon) {
            double a2 = this.getA(++n2, x);
            double b2 = this.getB(n2, x);
            double p2 = a2 * p1 + b2 * p0;
            double q2 = a2 * q1 + b2 * q0;
            if (Double.isInfinite(p2) || Double.isInfinite(q2)) {
                if (a2 != 0.0) {
                    p2 = p1 + b2 / a2 * p0;
                    q2 = q1 + b2 / a2 * q0;
                } else if (b2 != 0.0) {
                    p2 = a2 / b2 * p1 + p0;
                    q2 = a2 / b2 * q1 + q0;
                } else {
                    throw new ConvergenceException("Continued fraction convergents diverged to +/- infinity.");
                }
            }
            double r = p2 / q2;
            relativeError = Math.abs(r / c2 - 1.0);
            c2 = p2 / q2;
            p0 = p1;
            p1 = p2;
            q0 = q1;
            q1 = q2;
        }
        if (n2 >= maxIterations) {
            throw new ConvergenceException("Continued fraction convergents failed to converge.");
        }
        return c2;
    }
}

