/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ConcurrentHashMap
extends AbstractMap
implements Map,
Cloneable,
Serializable {
    protected transient Entry[] table;
    protected static final int CONCURRENCY_LEVEL = 32;
    protected static final int SEGMENT_MASK = 31;
    protected final Segment[] segments = new Segment[32];
    public static int DEFAULT_INITIAL_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 32;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    public static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected final float loadFactor;
    protected int threshold;
    protected volatile transient int votesForResize;
    protected transient Set keySet = null;
    protected transient Set entrySet = null;
    protected transient Collection values = null;

    protected static int bitcount(int n2) {
        n2 -= (0xAAAAAAAA & n2) >>> 1;
        n2 = (n2 & 0x33333333) + (n2 >>> 2 & 0x33333333);
        n2 = n2 + (n2 >>> 4) & 0xF0F0F0F;
        n2 += n2 >>> 8;
        n2 += n2 >>> 16;
        return n2 & 0xFF;
    }

    private int p2capacity(int n2) {
        int n3;
        int n4 = n2;
        if (n4 > 0x40000000 || n4 < 0) {
            n3 = 0x40000000;
        } else {
            for (n3 = 32; n3 < n4; n3 <<= 1) {
            }
        }
        return n3;
    }

    protected static int hash(Object object) {
        int n2 = object.hashCode();
        return (n2 << 7) - n2 + (n2 >>> 9) + (n2 >>> 17);
    }

    protected boolean eq(Object object, Object object2) {
        return object == object2 || object.equals(object2);
    }

    protected Entry[] newTable(int n2) {
        this.threshold = (int)((float)n2 * this.loadFactor / 32.0f) + 1;
        return new Entry[n2];
    }

    public ConcurrentHashMap(int n2, float f2) {
        int n3;
        if (!(f2 > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load factor: " + f2);
        }
        this.loadFactor = f2;
        for (n3 = 0; n3 < this.segments.length; ++n3) {
            this.segments[n3] = new Segment();
        }
        n3 = this.p2capacity(n2);
        this.table = this.newTable(n3);
    }

    public ConcurrentHashMap(int n2) {
        this(n2, 0.75f);
    }

    public ConcurrentHashMap() {
        this(DEFAULT_INITIAL_CAPACITY, 0.75f);
    }

    public ConcurrentHashMap(Map map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 32), 0.75f);
        this.putAll(map);
    }

    public int size() {
        int n2 = 0;
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            n2 += this.segments[i2].getCount();
        }
        return n2;
    }

    public boolean isEmpty() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            if (this.segments[i2].getCount() == 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object object) {
        Object object2;
        Entry entry;
        int n2 = ConcurrentHashMap.hash(object);
        Entry[] entryArray = this.table;
        int n3 = n2 & entryArray.length - 1;
        Entry entry2 = entry = entryArray[n3];
        while (entry2 != null) {
            if (entry2.hash == n2 && this.eq(object, entry2.key)) {
                object2 = entry2.value;
                if (object2 == null) break;
                return object2;
            }
            entry2 = entry2.next;
        }
        object2 = this.segments[n2 & 0x1F];
        Segment segment = object2;
        synchronized (segment) {
            entryArray = this.table;
            n3 = n2 & entryArray.length - 1;
            Entry entry3 = entryArray[n3];
            if (entry2 != null || entry != entry3) {
                entry2 = entry3;
                while (entry2 != null) {
                    if (entry2.hash == n2 && this.eq(object, entry2.key)) {
                        return entry2.value;
                    }
                    entry2 = entry2.next;
                }
            }
            return null;
        }
    }

    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object put(Object object, Object object2) {
        int n2;
        int n3;
        Entry[] entryArray;
        Segment segment;
        if (object2 == null) {
            throw new NullPointerException();
        }
        int n4 = ConcurrentHashMap.hash(object);
        Segment segment2 = segment = this.segments[n4 & 0x1F];
        synchronized (segment2) {
            Entry entry;
            entryArray = this.table;
            int n5 = n4 & entryArray.length - 1;
            Entry entry2 = entry = entryArray[n5];
            while (entry2 != null) {
                if (entry2.hash == n4 && this.eq(object, entry2.key)) {
                    Object object3 = entry2.value;
                    entry2.value = object2;
                    return object3;
                }
                entry2 = entry2.next;
            }
            entryArray[n5] = entry2 = new Entry(n4, object, object2, entry);
            n3 = ++segment.count;
            if (segment.count < this.threshold) {
                return null;
            }
            n2 = this.votesForResize;
            int n6 = 1 << (n4 & 0x1F);
            if ((n2 & n6) == 0) {
                n2 = this.votesForResize |= n6;
            }
        }
        if (ConcurrentHashMap.bitcount(n2) >= 8 || n3 > this.threshold * 32) {
            this.resize(0, entryArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resize(int n2, Entry[] entryArray) {
        Segment segment;
        Segment segment2 = segment = this.segments[n2];
        synchronized (segment2) {
            if (entryArray == this.table) {
                int n3 = n2 + 1;
                if (n3 < this.segments.length) {
                    this.resize(n3, entryArray);
                } else {
                    this.rehash();
                }
            }
        }
    }

    protected void rehash() {
        this.votesForResize = 0;
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 >= 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        int n3 = n2 << 1;
        Entry[] entryArray2 = this.newTable(n3);
        int n4 = n3 - 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n5;
            Entry entry = entryArray[i2];
            if (entry == null) continue;
            int n6 = entry.hash & n4;
            Entry entry2 = entry.next;
            if (entry2 == null) {
                entryArray2[n6] = entry;
                continue;
            }
            Entry entry3 = entry;
            int n7 = n6;
            Entry entry4 = entry2;
            while (entry4 != null) {
                n5 = entry4.hash & n4;
                if (n5 != n7) {
                    n7 = n5;
                    entry3 = entry4;
                }
                entry4 = entry4.next;
            }
            entryArray2[n7] = entry3;
            entry4 = entry;
            while (entry4 != entry3) {
                n5 = entry4.hash & n4;
                entryArray2[n5] = new Entry(entry4.hash, entry4.key, entry4.value, entryArray2[n5]);
                entry4 = entry4.next;
            }
        }
        this.table = entryArray2;
    }

    public Object remove(Object object) {
        return this.remove(object, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object remove(Object object, Object object2) {
        Segment segment;
        int n2 = ConcurrentHashMap.hash(object);
        Segment segment2 = segment = this.segments[n2 & 0x1F];
        synchronized (segment2) {
            Entry entry;
            Entry[] entryArray = this.table;
            int n3 = n2 & entryArray.length - 1;
            Entry entry2 = entry = entryArray[n3];
            while (true) {
                if (entry2 == null) {
                    return null;
                }
                if (entry2.hash == n2 && this.eq(object, entry2.key)) break;
                entry2 = entry2.next;
            }
            Object object3 = entry2.value;
            if (object2 != null && !object2.equals(object3)) {
                return null;
            }
            entry2.value = null;
            Entry entry3 = entry2.next;
            Entry entry4 = entry;
            while (entry4 != entry2) {
                entry3 = new Entry(entry4.hash, entry4.key, entry4.value, entry3);
                entry4 = entry4.next;
            }
            entryArray[n3] = entry3;
            --segment.count;
            return object3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsValue(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Entry[] entryArray;
            Segment segment;
            Segment segment2 = segment = this.segments[i2];
            synchronized (segment2) {
                entryArray = this.table;
            }
            for (int i3 = i2; i3 < entryArray.length; i3 += this.segments.length) {
                Entry entry = entryArray[i3];
                while (entry != null) {
                    if (object.equals(entry.value)) {
                        return true;
                    }
                    entry = entry.next;
                }
            }
        }
        return false;
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putAll(Map map) {
        Object object;
        int n2 = map.size();
        if (n2 == 0) {
            return;
        }
        while (true) {
            int n3;
            Segment segment = this.segments[0];
            synchronized (segment) {
                object = this.table;
                n3 = this.threshold * 32;
            }
            if (n2 < n3) break;
            this.resize(0, (Entry[])object);
        }
        object = map.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry entry = (Map.Entry)object.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Segment segment;
            Segment segment2 = segment = this.segments[i2];
            synchronized (segment2) {
                Entry[] entryArray = this.table;
                for (int i3 = i2; i3 < entryArray.length; i3 += this.segments.length) {
                    Entry entry = entryArray[i3];
                    while (entry != null) {
                        entry.value = null;
                        entry = entry.next;
                    }
                    entryArray[i3] = null;
                    segment.count = 0;
                }
                continue;
            }
        }
    }

    public Object clone() {
        return new ConcurrentHashMap(this);
    }

    public Set keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet());
    }

    public Collection values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values());
    }

    public Set entrySet() {
        Set set = this.entrySet;
        return set != null ? set : (this.entrySet = new EntrySet());
    }

    public Enumeration keys() {
        return new KeyIterator();
    }

    public Enumeration elements() {
        return new ValueIterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n2;
        objectOutputStream.defaultWriteObject();
        Segment segment = this.segments[0];
        synchronized (segment) {
            n2 = this.table.length;
        }
        objectOutputStream.writeInt(n2);
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            Entry[] entryArray;
            Segment segment2;
            Segment segment3 = segment2 = this.segments[i2];
            synchronized (segment3) {
                entryArray = this.table;
            }
            for (int i3 = i2; i3 < entryArray.length; i3 += this.segments.length) {
                Entry entry = entryArray[i3];
                while (entry != null) {
                    objectOutputStream.writeObject(entry.key);
                    objectOutputStream.writeObject(entry.value);
                    entry = entry.next;
                }
            }
        }
        objectOutputStream.writeObject(null);
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n2 = objectInputStream.readInt();
        this.table = this.newTable(n2);
        for (int i2 = 0; i2 < this.segments.length; ++i2) {
            this.segments[i2] = new Segment();
        }
        while (true) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            if (object == null) break;
            this.put(object, object2);
        }
    }

    protected class ValueIterator
    extends HashIterator {
        protected ValueIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentValue;
        }
    }

    protected class KeyIterator
    extends HashIterator {
        protected KeyIterator() {
        }

        protected Object returnValueOfNext() {
            return this.currentKey;
        }
    }

    protected class HashIterator
    implements Iterator,
    Enumeration {
        protected final Entry[] tab;
        protected int index;
        protected Entry entry = null;
        protected Object currentKey;
        protected Object currentValue;
        protected Entry lastReturned = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected HashIterator() {
            Segment segment = ConcurrentHashMap.this.segments[0];
            synchronized (segment) {
                this.tab = ConcurrentHashMap.this.table;
            }
            for (int i2 = 1; i2 < ConcurrentHashMap.this.segments.length; ++i2) {
                ConcurrentHashMap.this.segments[i2].synch();
            }
            this.index = this.tab.length - 1;
        }

        public boolean hasMoreElements() {
            return this.hasNext();
        }

        public Object nextElement() {
            return this.next();
        }

        public boolean hasNext() {
            do {
                if (this.entry != null) {
                    Object object = this.entry.value;
                    if (object != null) {
                        this.currentKey = this.entry.key;
                        this.currentValue = object;
                        return true;
                    }
                    this.entry = this.entry.next;
                }
                while (this.entry == null && this.index >= 0) {
                    this.entry = this.tab[this.index--];
                }
            } while (this.entry != null);
            this.currentValue = null;
            this.currentKey = null;
            return false;
        }

        protected Object returnValueOfNext() {
            return this.entry;
        }

        public Object next() {
            if (this.currentKey == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            Object object = this.returnValueOfNext();
            this.lastReturned = this.entry;
            this.currentValue = null;
            this.currentKey = null;
            this.entry = this.entry.next;
            return object;
        }

        public void remove() {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            ConcurrentHashMap.this.remove(this.lastReturned.key);
            this.lastReturned = null;
        }
    }

    protected static class Entry
    implements Map.Entry {
        protected final Object key;
        protected volatile Object value;
        protected final int hash;
        protected final Entry next;

        Entry(int n2, Object object, Object object2, Entry entry) {
            this.value = object2;
            this.hash = n2;
            this.key = object;
            this.next = entry;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return this.key.equals(entry.getKey()) && this.value.equals(entry.getValue());
        }

        public int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        public Iterator iterator() {
            return new HashIterator();
        }

        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            Object object2 = ConcurrentHashMap.this.get(entry.getKey());
            return object2 != null && object2.equals(entry.getValue());
        }

        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return ConcurrentHashMap.this.remove(entry.getKey(), entry.getValue()) != null;
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private class Values
    extends AbstractCollection {
        private Values() {
        }

        public Iterator iterator() {
            return new ValueIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsValue(object);
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    private class KeySet
    extends AbstractSet {
        private KeySet() {
        }

        public Iterator iterator() {
            return new KeyIterator();
        }

        public int size() {
            return ConcurrentHashMap.this.size();
        }

        public boolean contains(Object object) {
            return ConcurrentHashMap.this.containsKey(object);
        }

        public boolean remove(Object object) {
            return ConcurrentHashMap.this.remove(object) != null;
        }

        public void clear() {
            ConcurrentHashMap.this.clear();
        }
    }

    protected static final class Segment
    implements Serializable {
        protected int count;

        protected Segment() {
        }

        protected synchronized int getCount() {
            return this.count;
        }

        protected synchronized void synch() {
        }
    }
}

