/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util;

import java.awt.FileDialog;
import java.io.File;
import javax.swing.JFileChooser;
import org.broad.igv.Globals;
import org.broad.igv.ui.IGV;

public class FileDialogUtils {
    public static int LOAD = 0;
    public static int SAVE = 1;

    public static File chooseFile(String title, File initialDirectory, int mode) {
        return FileDialogUtils.chooseFile(title, initialDirectory, null, mode);
    }

    public static File chooseFile(String title) {
        return FileDialogUtils.chooseFile(title, Globals.getUserDirectory(), null, 0);
    }

    public static File chooseFile(String title, File initialDirectory, File initialFile, int mode) {
        if (initialDirectory == null && initialFile != null) {
            initialDirectory = initialFile.getParentFile();
        }
        if (initialFile != null) {
            initialFile = new File(initialFile.getName());
        }
        if (Globals.IS_MAC) {
            return FileDialogUtils.chooseNative(title, initialDirectory, initialFile, false, mode);
        }
        return FileDialogUtils.chooseSwing(title, initialDirectory, initialFile, false, mode);
    }

    public static File chooseDirectory(String title, File initialDirectory) {
        if (Globals.IS_MAC) {
            return FileDialogUtils.chooseNative(title, initialDirectory, null, true, LOAD);
        }
        return FileDialogUtils.chooseSwing(title, initialDirectory, null, true, LOAD);
    }

    private static File chooseNative(String title, File initialDirectory, File initialFile, boolean directories, int mode) {
        System.setProperty("apple.awt.fileDialogForDirectories", String.valueOf(directories));
        FileDialog fd = new FileDialog(IGV.getMainFrame(), title);
        if (initialDirectory != null) {
            fd.setDirectory(initialDirectory.getAbsolutePath());
        }
        if (initialFile != null) {
            fd.setFile(initialFile.getName());
        }
        fd.setModal(true);
        fd.setMode(mode);
        fd.setVisible(true);
        String file = fd.getFile();
        String directory = fd.getDirectory();
        if (file != null && directory != null) {
            return new File(directory, file);
        }
        return null;
    }

    private static File chooseSwing(String title, File initialDirectory, File initialFile, boolean directories, int mode) {
        JFileChooser fileChooser = new JFileChooser();
        if (initialDirectory != null) {
            fileChooser.setCurrentDirectory(initialDirectory);
        }
        if (initialFile != null) {
            fileChooser.setSelectedFile(initialFile);
        }
        fileChooser.setDialogTitle(title);
        fileChooser.setFileSelectionMode(directories ? 1 : 0);
        boolean approve = false;
        if (mode == LOAD) {
            approve = fileChooser.showOpenDialog(IGV.getMainFrame()) == 0;
        } else {
            boolean bl = approve = fileChooser.showSaveDialog(IGV.getMainFrame()) == 0;
        }
        if (approve) {
            return fileChooser.getSelectedFile();
        }
        return null;
    }
}

