/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.batik.svggen.font.table.DirectoryEntry;
import org.apache.batik.svggen.font.table.NameRecord;
import org.apache.batik.svggen.font.table.Table;

public class NameTable
implements Table {
    private short formatSelector;
    private short numberOfNameRecords;
    private short stringStorageOffset;
    private NameRecord[] records;

    protected NameTable(DirectoryEntry de, RandomAccessFile raf) throws IOException {
        raf.seek(de.getOffset());
        this.formatSelector = raf.readShort();
        this.numberOfNameRecords = raf.readShort();
        this.stringStorageOffset = raf.readShort();
        this.records = new NameRecord[this.numberOfNameRecords];
        int i2 = 0;
        while (i2 < this.numberOfNameRecords) {
            this.records[i2] = new NameRecord(raf);
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.numberOfNameRecords) {
            this.records[i3].loadString(raf, de.getOffset() + this.stringStorageOffset);
            ++i3;
        }
    }

    public String getRecord(short nameId) {
        int i2 = 0;
        while (i2 < this.numberOfNameRecords) {
            if (this.records[i2].getNameId() == nameId) {
                return this.records[i2].getRecordString();
            }
            ++i2;
        }
        return "";
    }

    public int getType() {
        return 1851878757;
    }
}

