/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import EDU.oswego.cs.dl.util.concurrent.BrokenBarrierException;
import EDU.oswego.cs.dl.util.concurrent.Channel;
import EDU.oswego.cs.dl.util.concurrent.ClockDaemon;
import EDU.oswego.cs.dl.util.concurrent.CyclicBarrier;
import EDU.oswego.cs.dl.util.concurrent.DefaultChannelCapacity;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedRef;
import EDU.oswego.cs.dl.util.concurrent.WaitableInt;
import EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.DelegatedRNG;
import EDU.oswego.cs.dl.util.concurrent.misc.Fraction;
import EDU.oswego.cs.dl.util.concurrent.misc.PCTestLoop;
import EDU.oswego.cs.dl.util.concurrent.misc.RNG;
import EDU.oswego.cs.dl.util.concurrent.misc.TestLoop;
import EDU.oswego.cs.dl.util.concurrent.misc.Threads;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;

public class SynchronizationTimer {
    static final int[] nthreadsChoices = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
    static final int BLOCK_MODE = 0;
    static final int TIMEOUT_MODE = 1;
    static final int[] syncModes = new int[]{0, 1};
    static final int PRECISION = 10;
    final ThreadInfo[] threadInfo = new ThreadInfo[nthreadsChoices.length];
    static final int headerRows = 1;
    static final int classColumn = 0;
    static final int headerColumns = 1;
    final int tableRows = TestedClass.classes.length + 1;
    final int tableColumns = nthreadsChoices.length + 1;
    final JComponent[][] resultTable_ = new JComponent[this.tableRows][this.tableColumns];
    final SynchronizedInt nextClassIdx_ = new SynchronizedInt(0);
    final SynchronizedInt nextThreadIdx_ = new SynchronizedInt(0);
    ClockDaemon timeDaemon = new ClockDaemon();
    private final SynchronizedRef contention_ = new SynchronizedRef(null);
    private final SynchronizedInt loopsPerTest_ = new SynchronizedInt(0);
    private final SynchronizedBoolean echoToSystemOut = new SynchronizedBoolean(false);
    private final JButton startstop_ = new JButton("Start");
    private WaitableInt testNumber_ = new WaitableInt(1);
    private SynchronizedBoolean running_ = new SynchronizedBoolean(false);
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$Slot;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG;
    static /* synthetic */ Class class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG;

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Times per call in microseconds");
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.getContentPane().add(new SynchronizationTimer().mainPanel());
        jFrame.pack();
        jFrame.setVisible(true);
    }

    static String modeToString(int n2) {
        String string = n2 == 0 ? "block" : (n2 == 1 ? "timeout" : "No such mode");
        return string;
    }

    static String biasToString(int n2) {
        String string = n2 < 0 ? "slower producer" : (n2 == 0 ? "balanced prod/cons rate" : (n2 > 0 ? "slower consumer" : "No such bias"));
        return string;
    }

    static String p2ToString(int n2) {
        String string = "";
        if (n2 >= 1024) {
            string = "K";
            if ((n2 /= 1024) >= 1024) {
                n2 /= 1024;
                string = "M";
            }
        }
        return n2 + string;
    }

    static String formatTime(long l2, boolean bl) {
        long l3 = l2 / 10L;
        long l4 = l2 % 10L;
        if (!bl) {
            if (l4 >= 5L) {
                ++l3;
            }
            return Long.toString(l3);
        }
        String string = Long.toString(l3);
        String string2 = Long.toString(l4);
        if (l4 == 0L) {
            for (int i2 = 10; i2 > 10; i2 /= 10) {
                string2 = "0" + string2;
            }
        }
        String string3 = string + "." + string2;
        return string3;
    }

    boolean threadEnabled(int n2) {
        return this.threadInfo[n2].getEnabled();
    }

    JPanel resultPanel() {
        JCheckBox jCheckBox;
        int n2;
        int n3;
        JPanel[] jPanelArray = new JPanel[this.tableColumns];
        for (int i2 = 0; i2 < this.tableColumns; ++i2) {
            jPanelArray[i2] = new JPanel();
            jPanelArray[i2].setLayout(new GridLayout(this.tableRows, 1));
            if (i2 == 0) continue;
            jPanelArray[i2].setBackground(Color.white);
        }
        Color color = jPanelArray[0].getBackground();
        LineBorder lineBorder = new LineBorder(color);
        Font font = new Font("Dialog", 0, 12);
        Dimension dimension = new Dimension(40, 16);
        Dimension dimension2 = new Dimension(154, 16);
        JLabel jLabel = new JLabel(" Classes      \\      Threads");
        jLabel.setMinimumSize(dimension2);
        jLabel.setPreferredSize(dimension2);
        jLabel.setFont(font);
        this.resultTable_[0][0] = jLabel;
        jPanelArray[0].add(jLabel);
        for (n3 = 1; n3 < this.tableColumns; ++n3) {
            n2 = n3 - 1;
            jCheckBox = new JCheckBox(this.threadInfo[n2].name, true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SynchronizationTimer.this.threadInfo[n2].toggleEnabled();
                }
            });
            jCheckBox.setMinimumSize(dimension);
            jCheckBox.setPreferredSize(dimension);
            jCheckBox.setFont(font);
            jCheckBox.setBackground(color);
            this.resultTable_[0][n3] = jCheckBox;
            jPanelArray[n3].add(jCheckBox);
        }
        for (n3 = 1; n3 < this.tableRows; ++n3) {
            n2 = n3 - 1;
            jCheckBox = new JCheckBox(TestedClass.classes[n2].name, true);
            jCheckBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TestedClass.classes[n2].toggleEnabled();
                }
            });
            this.resultTable_[n3][0] = jCheckBox;
            jCheckBox.setMinimumSize(dimension2);
            jCheckBox.setPreferredSize(dimension2);
            jCheckBox.setFont(font);
            jPanelArray[0].add(jCheckBox);
            for (int i3 = 1; i3 < this.tableColumns; ++i3) {
                int n4 = i3 - 1;
                JLabel jLabel2 = new JLabel("");
                this.resultTable_[n3][i3] = jLabel2;
                jLabel2.setMinimumSize(dimension);
                jLabel2.setPreferredSize(dimension);
                jLabel2.setBorder(lineBorder);
                jLabel2.setFont(font);
                jLabel2.setBackground(Color.white);
                jLabel2.setForeground(Color.black);
                jLabel2.setHorizontalAlignment(4);
                jPanelArray[i3].add(jLabel2);
            }
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        for (n2 = 0; n2 < this.tableColumns; ++n2) {
            jPanel.add(jPanelArray[n2]);
        }
        return jPanel;
    }

    void setTime(final long l2, int n2, int n3) {
        int n4 = n2 + 1;
        int n5 = n3 + 1;
        final JLabel jLabel = (JLabel)this.resultTable_[n4][n5];
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                jLabel.setText(SynchronizationTimer.formatTime(l2, true));
            }
        });
    }

    void clearTable() {
        for (int i2 = 1; i2 < this.tableRows; ++i2) {
            for (int i3 = 1; i3 < this.tableColumns; ++i3) {
                ((JLabel)this.resultTable_[i2][i3]).setText("");
            }
        }
    }

    void setChecks(boolean bl) {
        for (int i2 = 0; i2 < TestedClass.classes.length; ++i2) {
            TestedClass.classes[i2].setEnabled(new Boolean(bl));
            ((JCheckBox)this.resultTable_[i2 + 1][0]).setSelected(bl);
        }
    }

    public SynchronizationTimer() {
        for (int i2 = 0; i2 < this.threadInfo.length; ++i2) {
            this.threadInfo[i2] = new ThreadInfo(nthreadsChoices[i2]);
        }
    }

    JPanel mainPanel() {
        new PrintStart();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(5, 3));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 3));
        this.startstop_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (SynchronizationTimer.this.running_.get()) {
                    SynchronizationTimer.this.cancel();
                } else {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries());
                    }
                    catch (InterruptedException interruptedException) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        jPanel.add(this.startstop_);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 2));
        JButton jButton = new JButton("Continue");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!SynchronizationTimer.this.running_.get()) {
                    try {
                        SynchronizationTimer.this.startTestSeries(new TestSeries(SynchronizationTimer.this.nextClassIdx_.get(), SynchronizationTimer.this.nextThreadIdx_.get()));
                    }
                    catch (InterruptedException interruptedException) {
                        SynchronizationTimer.this.endTestSeries();
                    }
                }
            }
        });
        jPanel3.add(jButton);
        JButton jButton2 = new JButton("Clear cells");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.clearTable();
            }
        });
        jPanel3.add(jButton2);
        jPanel.add(jPanel3);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new GridLayout(1, 2));
        JButton jButton3 = new JButton("All classes");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.setChecks(true);
            }
        });
        jPanel4.add(jButton3);
        JButton jButton4 = new JButton("No classes");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SynchronizationTimer.this.setChecks(false);
            }
        });
        jPanel4.add(jButton4);
        jPanel.add(jPanel4);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        JCheckBox jCheckBox = new JCheckBox("Console echo");
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                SynchronizationTimer.this.echoToSystemOut.complement();
            }
        });
        JLabel jLabel = new JLabel("Active threads:      0");
        jPanel5.add(jLabel);
        jPanel5.add(jCheckBox);
        jPanel.add(jPanel5);
        jPanel.add(this.contentionBox());
        jPanel.add(this.itersBox());
        jPanel.add(this.cloopBox());
        jPanel.add(this.barrierBox());
        jPanel.add(this.exchangeBox());
        jPanel.add(this.biasBox());
        jPanel.add(this.capacityBox());
        jPanel.add(this.timeoutBox());
        jPanel.add(this.syncModePanel());
        jPanel.add(this.producerSyncModePanel());
        jPanel.add(this.consumerSyncModePanel());
        this.startPoolStatus(jLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        JPanel jPanel7 = this.resultPanel();
        jPanel6.add(jPanel7);
        jPanel6.add(jPanel);
        return jPanel6;
    }

    JComboBox syncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < syncModes.length; ++i2) {
            String string = "Locks: " + SynchronizationTimer.modeToString(syncModes[i2]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                RNG.syncMode.set(syncModes[n2]);
            }
        });
        RNG.syncMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox producerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < syncModes.length; ++i2) {
            String string = "Producers: " + SynchronizationTimer.modeToString(syncModes[i2]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                RNG.producerMode.set(syncModes[n2]);
            }
        });
        RNG.producerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox consumerSyncModePanel() {
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < syncModes.length; ++i2) {
            String string = "Consumers: " + SynchronizationTimer.modeToString(syncModes[i2]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                RNG.consumerMode.set(syncModes[n2]);
            }
        });
        RNG.consumerMode.set(syncModes[0]);
        jComboBox.setSelectedIndex(0);
        return jComboBox;
    }

    JComboBox contentionBox() {
        final Fraction[] fractionArray = new Fraction[]{new Fraction(0L, 1L), new Fraction(1L, 16L), new Fraction(1L, 8L), new Fraction(1L, 4L), new Fraction(1L, 2L), new Fraction(1L, 1L)};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < fractionArray.length; ++i2) {
            String string = fractionArray[i2].asDouble() * 100.0 + "% contention/sharing";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                SynchronizationTimer.this.contention_.set(fractionArray[n2]);
            }
        });
        this.contention_.set(fractionArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox itersBox() {
        final int[] nArray = new int[]{1, 16, 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string = SynchronizationTimer.p2ToString(nArray[i2]) + " calls per thread per test";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                SynchronizationTimer.this.loopsPerTest_.set(nArray[n2]);
            }
        });
        this.loopsPerTest_.set(nArray[8]);
        jComboBox.setSelectedIndex(8);
        return jComboBox;
    }

    JComboBox cloopBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string = SynchronizationTimer.p2ToString(nArray[i2]) + " computations per call";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                RNG.computeLoops.set(nArray[n2]);
            }
        });
        RNG.computeLoops.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox barrierBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string = SynchronizationTimer.p2ToString(nArray[i2]) + " iterations per barrier";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                RNG.itersPerBarrier.set(nArray[n2]);
            }
        });
        RNG.itersPerBarrier.set(nArray[13]);
        jComboBox.setSelectedIndex(13);
        return jComboBox;
    }

    JComboBox exchangeBox() {
        final int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string = SynchronizationTimer.p2ToString(nArray[i2]) + " max threads per barrier";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                RNG.exchangeParties.set(nArray[n2]);
            }
        });
        RNG.exchangeParties.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox biasBox() {
        final int[] nArray = new int[]{-1, 0, 1};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string = SynchronizationTimer.biasToString(nArray[i2]);
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                RNG.bias.set(nArray[n2]);
            }
        });
        RNG.bias.set(nArray[1]);
        jComboBox.setSelectedIndex(1);
        return jComboBox;
    }

    JComboBox capacityBox() {
        final int[] nArray = new int[]{1, 4, 64, 256, 1024, 4096, 16384, 65536, 262144, 0x100000};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            String string = SynchronizationTimer.p2ToString(nArray[i2]) + " element bounded buffers";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                DefaultChannelCapacity.set(nArray[n2]);
            }
        });
        DefaultChannelCapacity.set(nArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    JComboBox timeoutBox() {
        final long[] lArray = new long[]{0L, 1L, 10L, 100L, 1000L, 10000L, 100000L};
        JComboBox<String> jComboBox = new JComboBox<String>();
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            String string = lArray[i2] + " msec timeouts";
            jComboBox.addItem(string);
        }
        jComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JComboBox jComboBox = (JComboBox)itemEvent.getItemSelectable();
                int n2 = jComboBox.getSelectedIndex();
                RNG.timeout.set(lArray[n2]);
            }
        });
        RNG.timeout.set(lArray[3]);
        jComboBox.setSelectedIndex(3);
        return jComboBox;
    }

    void startPoolStatus(final JLabel jLabel) {
        Runnable runnable = new Runnable(){
            int lastps = 0;

            public void run() {
                int n2 = Threads.activeThreads.get();
                if (this.lastps != n2) {
                    this.lastps = n2;
                    SwingUtilities.invokeLater(new Runnable(this, n2){
                        private final /* synthetic */ int val$ps;
                        private final /* synthetic */ 22 this$1;
                        {
                            this.this$1 = var1_1;
                            this.val$ps = n2;
                        }

                        public void run() {
                            22.access$400(this.this$1).setText("Active threads: " + this.val$ps);
                        }
                    });
                }
            }

            static /* synthetic */ JLabel access$400(22 var0) {
                return var0.jLabel;
            }
        };
        this.timeDaemon.executePeriodically(250L, runnable, false);
    }

    private void runOneTest(Runnable runnable) throws InterruptedException {
        int n2 = this.testNumber_.get();
        Threads.pool.execute(runnable);
        this.testNumber_.whenNotEqual(n2, null);
    }

    private void endOneTest() {
        this.testNumber_.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancel() {
        Object object = RNG.constructionLock;
        synchronized (object) {
            try {
                Threads.pool.interruptAll();
            }
            catch (Exception exception) {
                System.out.println("\nException during cancel:\n" + exception);
                return;
            }
        }
    }

    void startTestSeries(Runnable runnable) throws InterruptedException {
        this.running_.set(true);
        this.startstop_.setText("Stop");
        Threads.pool.execute(runnable);
    }

    void endTestSeries() {
        this.running_.set(false);
        SwingUtilities.invokeLater(new PrintStart());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OneTest
    implements Runnable {
        final int clsIdx;
        final int nthreadsIdx;

        OneTest(int n2, int n3) {
            this.clsIdx = n2;
            this.nthreadsIdx = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Color color;
            JLabel jLabel;
            boolean bl;
            block26: {
                block25: {
                    block24: {
                        boolean bl2;
                        block23: {
                            Thread.currentThread().setPriority(2);
                            bl = false;
                            TestedClass testedClass = TestedClass.classes[this.clsIdx];
                            jLabel = (JLabel)SynchronizationTimer.this.resultTable_[this.clsIdx + 1][this.nthreadsIdx + 1];
                            color = jLabel.getForeground();
                            try {
                                try {
                                    if (Thread.interrupted()) {
                                        Object var21_5 = null;
                                        bl2 = bl;
                                        break block23;
                                    }
                                    if (!SynchronizationTimer.this.threadEnabled(this.nthreadsIdx)) {
                                        break block24;
                                    }
                                    int n2 = nthreadsChoices[this.nthreadsIdx];
                                    int n3 = SynchronizationTimer.this.loopsPerTest_.get();
                                    Fraction fraction = (Fraction)SynchronizationTimer.this.contention_.get();
                                    if (!testedClass.isEnabled(n2, fraction)) {
                                        break block25;
                                    }
                                    BarrierTimer barrierTimer = new BarrierTimer();
                                    CyclicBarrier cyclicBarrier = new CyclicBarrier(n2 + 1, barrierTimer);
                                    Class clazz = testedClass.cls;
                                    Class clazz2 = testedClass.buffCls;
                                    try {
                                        SwingUtilities.invokeAndWait(new Runnable(this, jLabel){
                                            private final /* synthetic */ JLabel val$cell;
                                            private final /* synthetic */ OneTest this$1;
                                            {
                                                this.this$1 = oneTest;
                                                this.val$cell = jLabel;
                                            }

                                            public void run() {
                                                this.val$cell.setForeground(Color.blue);
                                                this.val$cell.setText("RUN");
                                                this.val$cell.repaint();
                                            }
                                        });
                                    }
                                    catch (InvocationTargetException invocationTargetException) {
                                        invocationTargetException.printStackTrace();
                                        System.exit(-1);
                                    }
                                    Object object = RNG.constructionLock;
                                    synchronized (object) {
                                        Object object2;
                                        RNG.reset(n2);
                                        if (clazz2 == null) {
                                            RNG rNG = (RNG)clazz.newInstance();
                                            for (int i2 = 0; i2 < n2; ++i2) {
                                                RNG rNG2 = (RNG)clazz.newInstance();
                                                object2 = new TestLoop(rNG, rNG2, fraction, n3, cyclicBarrier);
                                                Threads.pool.execute(((TestLoop)object2).testLoop());
                                            }
                                        } else {
                                            Channel channel = (Channel)clazz2.newInstance();
                                            if (n2 == 1) {
                                                ChanRNG chanRNG = (ChanRNG)clazz.newInstance();
                                                chanRNG.setSingle(true);
                                                PCTestLoop pCTestLoop = new PCTestLoop(chanRNG.getDelegate(), chanRNG, fraction, n3, cyclicBarrier, channel, channel);
                                                Threads.pool.execute(pCTestLoop.testLoop(true));
                                            } else {
                                                if (n2 % 2 != 0) {
                                                    throw new Error("Must have even number of threads!");
                                                }
                                                int n4 = n2 / 2;
                                                for (int i3 = 0; i3 < n4; ++i3) {
                                                    object2 = (ChanRNG)clazz.newInstance();
                                                    ((ChanRNG)object2).setSingle(false);
                                                    Channel channel2 = (Channel)clazz2.newInstance();
                                                    PCTestLoop pCTestLoop = new PCTestLoop(((DelegatedRNG)object2).getDelegate(), (RNG)object2, fraction, n3, cyclicBarrier, channel, channel2);
                                                    Threads.pool.execute(pCTestLoop.testLoop(false));
                                                    Threads.pool.execute(pCTestLoop.testLoop(true));
                                                }
                                            }
                                        }
                                        if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                            System.out.print(testedClass.name + " " + n2 + "T " + fraction + "S " + RNG.computeLoops.get() + "I " + RNG.syncMode.get() + "Lm " + RNG.timeout.get() + "TO " + RNG.producerMode.get() + "Pm " + RNG.consumerMode.get() + "Cm " + RNG.bias.get() + "B " + DefaultChannelCapacity.get() + "C " + RNG.exchangeParties.get() + "Xp " + RNG.itersPerBarrier.get() + "Ib : ");
                                        }
                                    }
                                    cyclicBarrier.barrier();
                                    cyclicBarrier.barrier();
                                    long l2 = barrierTimer.getTime();
                                    long l3 = n2 * n3;
                                    double d2 = (double)l2 * 1000.0 * 10.0 / (double)l3;
                                    long l4 = Math.round(d2);
                                    SynchronizationTimer.this.setTime(l4, this.clsIdx, this.nthreadsIdx);
                                    if (SynchronizationTimer.this.echoToSystemOut.get()) {
                                        System.out.println(SynchronizationTimer.formatTime(l4, true));
                                    }
                                    break block26;
                                }
                                catch (BrokenBarrierException brokenBarrierException) {
                                    bl = true;
                                    Object var21_9 = null;
                                    boolean bl3 = bl;
                                    SwingUtilities.invokeLater(new Runnable(this, bl3, jLabel, color){
                                        private final /* synthetic */ boolean val$clear;
                                        private final /* synthetic */ JLabel val$cell;
                                        private final /* synthetic */ Color val$oldfg;
                                        private final /* synthetic */ OneTest this$1;
                                        {
                                            this.this$1 = oneTest;
                                            this.val$clear = bl;
                                            this.val$cell = jLabel;
                                            this.val$oldfg = color;
                                        }

                                        public void run() {
                                            if (this.val$clear) {
                                                this.val$cell.setText("");
                                            }
                                            this.val$cell.setForeground(this.val$oldfg);
                                            this.val$cell.repaint();
                                        }
                                    });
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                                catch (InterruptedException interruptedException) {
                                    bl = true;
                                    Thread.currentThread().interrupt();
                                    Object var21_10 = null;
                                    boolean bl4 = bl;
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    System.out.println("Construction Exception?");
                                    System.exit(-1);
                                    Object var21_11 = null;
                                    boolean bl5 = bl;
                                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    Thread.currentThread().setPriority(5);
                                    SynchronizationTimer.this.endOneTest();
                                    return;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var21_12 = null;
                                boolean bl6 = bl;
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                Thread.currentThread().setPriority(5);
                                SynchronizationTimer.this.endOneTest();
                                throw throwable;
                            }
                        }
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        Thread.currentThread().setPriority(5);
                        SynchronizationTimer.this.endOneTest();
                        return;
                    }
                    Object var21_6 = null;
                    boolean bl7 = bl;
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    Thread.currentThread().setPriority(5);
                    SynchronizationTimer.this.endOneTest();
                    return;
                }
                Object var21_7 = null;
                boolean bl8 = bl;
                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                Thread.currentThread().setPriority(5);
                SynchronizationTimer.this.endOneTest();
                return;
            }
            Object var21_8 = null;
            boolean bl9 = bl;
            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
            Thread.currentThread().setPriority(5);
            SynchronizationTimer.this.endOneTest();
        }
    }

    static class BarrierTimer
    implements Runnable {
        private long startTime_ = 0L;
        private long endTime_ = 0L;

        BarrierTimer() {
        }

        public synchronized long getTime() {
            return this.endTime_ - this.startTime_;
        }

        public synchronized void run() {
            long l2 = System.currentTimeMillis();
            if (this.startTime_ == 0L) {
                this.startTime_ = l2;
            } else {
                this.endTime_ = l2;
            }
        }
    }

    class TestSeries
    implements Runnable {
        final int firstclass;
        final int firstnthreads;

        TestSeries() {
            this.firstclass = 0;
            this.firstnthreads = 0;
        }

        TestSeries(int n2, int n3) {
            this.firstclass = n2;
            this.firstnthreads = n3;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block10: {
                Thread.currentThread().setPriority(5);
                try {
                    int n2 = this.firstnthreads;
                    int n3 = this.firstclass;
                    if (n2 >= nthreadsChoices.length || n3 >= TestedClass.classes.length) break block10;
                    while (true) {
                        if (SynchronizationTimer.this.threadEnabled(n2)) {
                            TestedClass testedClass = TestedClass.classes[n3];
                            int n4 = nthreadsChoices[n2];
                            int n5 = SynchronizationTimer.this.loopsPerTest_.get();
                            Fraction fraction = (Fraction)SynchronizationTimer.this.contention_.get();
                            if (testedClass.isEnabled(n4, fraction)) {
                                SynchronizationTimer.this.runOneTest(new OneTest(n3, n2));
                            }
                        }
                        if (++n3 >= TestedClass.classes.length) {
                            n3 = 0;
                            if (++n2 >= nthreadsChoices.length) {
                                break;
                            }
                        }
                        SynchronizationTimer.this.nextClassIdx_.set(n3);
                        SynchronizationTimer.this.nextThreadIdx_.set(n2);
                    }
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                finally {
                    SynchronizationTimer.this.endTestSeries();
                }
            }
        }
    }

    class PrintStart
    implements Runnable {
        PrintStart() {
        }

        public void run() {
            SynchronizationTimer.this.startstop_.setText("Start");
        }
    }

    static class ThreadInfo {
        final String name;
        final int number;
        Boolean enabled;

        ThreadInfo(int n2) {
            this.number = n2;
            this.name = SynchronizationTimer.p2ToString(n2);
            this.enabled = new Boolean(true);
        }

        synchronized Boolean getEnabled() {
            return this.enabled;
        }

        synchronized void setEnabled(Boolean bl) {
            this.enabled = bl;
        }

        synchronized void toggleEnabled() {
            this.enabled = new Boolean(this.enabled == false);
        }
    }

    static class TestedClass {
        final String name;
        final Class cls;
        final boolean multipleOK;
        final boolean singleOK;
        final Class buffCls;
        Boolean enabled_ = new Boolean(true);
        static final TestedClass dummy = new TestedClass("", null, false, false);
        static final TestedClass[] classes = new TestedClass[]{new TestedClass("NoSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.NoSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$NoSynchRNG, false, true), new TestedClass("PublicSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PublicSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PublicSynchRNG, true, true), new TestedClass("NestedSynchronization", class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.AllSynchRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$AllSynchRNG, true, true), new TestedClass("SDelegated", class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SDelegatedRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SDelegatedRNG, true, true), new TestedClass("SynchLongUsingSet", class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SynchLongRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SynchLongRNG, true, true), new TestedClass("SynchLongUsingCommit", class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.AClongRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$AClongRNG, true, true), new TestedClass("Semaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.SemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$SemRNG, true, true), new TestedClass("WaiterPrefSemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.WpSemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$WpSemRNG, true, true), new TestedClass("FIFOSemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.FifoRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$FifoRNG, true, true), new TestedClass("PrioritySemaphore", class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PrioritySemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PrioritySemRNG, true, true), new TestedClass("Mutex", class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.MutexRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$MutexRNG, true, true), new TestedClass("ReentrantLock", class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.RlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$RlockRNG, true, true), new TestedClass("WriterPrefRWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.WpRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$WpRWlockRNG, true, true), new TestedClass("ReaderPrefRWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ReaderPrefRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ReaderPrefRWlockRNG, true, true), new TestedClass("FIFORWLock", class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.FIFORWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$FIFORWlockRNG, true, true), new TestedClass("ReentrantRWL", class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ReentrantRWlockRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ReentrantRWlockRNG, true, true), new TestedClass("LinkedQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.LinkedQueue")) : class$EDU$oswego$cs$dl$util$concurrent$LinkedQueue), new TestedClass("WaitFreeQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.WaitFreeQueue")) : class$EDU$oswego$cs$dl$util$concurrent$WaitFreeQueue), new TestedClass("BoundedLinkedQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedLinkedQueue")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedLinkedQueue), new TestedClass("BoundedBuffer", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedBuffer")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedBuffer), new TestedClass("CondVarBoundedBuffer", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.CVBuffer")) : class$EDU$oswego$cs$dl$util$concurrent$misc$CVBuffer), new TestedClass("BoundedPriorityQueue", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue == null ? (class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.BoundedPriorityQueue")) : class$EDU$oswego$cs$dl$util$concurrent$BoundedPriorityQueue), new TestedClass("Slot", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, true, class$EDU$oswego$cs$dl$util$concurrent$Slot == null ? (class$EDU$oswego$cs$dl$util$concurrent$Slot = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.Slot")) : class$EDU$oswego$cs$dl$util$concurrent$Slot), new TestedClass("SynchronousChannel", class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ChanRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ChanRNG, true, false, class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel == null ? (class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.SynchronousChannel")) : class$EDU$oswego$cs$dl$util$concurrent$SynchronousChannel), new TestedClass("DirectExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.DirectExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$DirectExecutorRNG, true, true), new TestedClass("SemaphoreLckExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.LockedSemRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$LockedSemRNG, true, true), new TestedClass("QueuedExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.QueuedExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$QueuedExecutorRNG, true, true), new TestedClass("ThreadedExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.ThreadedExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$ThreadedExecutorRNG, true, true), new TestedClass("PooledExecutor", class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG == null ? (class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG = SynchronizationTimer.class$("EDU.oswego.cs.dl.util.concurrent.misc.PooledExecutorRNG")) : class$EDU$oswego$cs$dl$util$concurrent$misc$PooledExecutorRNG, true, true)};

        synchronized void setEnabled(Boolean bl) {
            this.enabled_ = bl;
        }

        synchronized Boolean getEnabled() {
            return this.enabled_;
        }

        synchronized void toggleEnabled() {
            boolean bl = this.enabled_;
            this.enabled_ = new Boolean(!bl);
        }

        synchronized boolean isEnabled(int n2, Fraction fraction) {
            boolean bl = this.enabled_;
            if (!bl) {
                return false;
            }
            if (!this.singleOK && n2 <= 1) {
                return false;
            }
            return this.multipleOK || n2 <= 1 || fraction.compareTo(0L) <= 0;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = null;
        }

        TestedClass(String string, Class clazz, boolean bl, boolean bl2, Class clazz2) {
            this.name = string;
            this.cls = clazz;
            this.multipleOK = bl;
            this.singleOK = bl2;
            this.buffCls = clazz2;
        }
    }
}

