/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.vcf;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.broad.igv.feature.tribble.CodecFactory;
import org.broad.tribble.FeatureCodec;
import org.broad.tribble.iterators.CloseableTribbleIterator;
import org.broad.tribble.source.BasicFeatureSource;
import org.broad.tribble.util.variantcontext.VariantContext;
import org.broad.tribble.vcf.VCFCodec;

public class VCFtoBed {
    public static void main(String[] args) throws IOException {
        VCFtoBed.convert(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String vcfFile, String bedFile) throws IOException {
        BasicFeatureSource basicReader = null;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(bedFile)));
            FeatureCodec codec = CodecFactory.getCodec(vcfFile);
            boolean isVCF = codec.getClass().isAssignableFrom(VCFCodec.class);
            basicReader = BasicFeatureSource.getFeatureSource(vcfFile, codec, true);
            CloseableTribbleIterator iter = basicReader.iterator();
            while (iter.hasNext()) {
                VariantContext vc = (VariantContext)iter.next();
                String chr = vc.getChr();
                if (!chr.startsWith("chr")) {
                    chr = "chr" + chr;
                }
                int start = vc.getStart() - 1;
                int end = vc.getEnd();
                String id = vc.getID();
                if (id == null) {
                    id = ".";
                }
                String af = vc.getAttributeAsString("AF", "");
                writer.println(chr + "\t" + start + "\t" + end + "\t" + id + "\t" + af);
            }
        }
        finally {
            if (basicReader != null) {
                basicReader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

