/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.util.stats;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.util.stats.KaplanMeierEstimator;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYStepRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class KMPlotFrame
extends JFrame {
    Collection<Track> tracks;
    private XYPlot plot;
    int maxTime = 60;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JComboBox censurColumnControl;
    private JComboBox sampleColumnControl;
    private JComboBox survivalColumnControl;
    private JComboBox groupByControl;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JButton updateButton;

    public KMPlotFrame(Collection<Track> tracks) {
        this.tracks = tracks;
        this.initComponents();
        this.censurColumnControl.addItem("");
        this.sampleColumnControl.addItem("");
        this.survivalColumnControl.addItem("");
        this.groupByControl.addItem("");
        for (String key : AttributeManager.getInstance().getAttributeKeys()) {
            this.censurColumnControl.addItem(key);
            this.sampleColumnControl.addItem(key);
            this.survivalColumnControl.addItem(key);
            this.groupByControl.addItem(key);
        }
        this.censurColumnControl.setSelectedItem("CENSURED");
        this.sampleColumnControl.setSelectedItem("LINKING_ID");
        this.survivalColumnControl.setSelectedItem("SURVIVAL (DAYS)");
        this.groupByControl.setSelectedItem("SUBTYPE");
        XYDataset dataset = this.updateDataset();
        JFreeChart chart = ChartFactory.createXYLineChart("", "Months", "Survival", dataset, PlotOrientation.VERTICAL, true, true, false);
        XYStepRenderer renderer = new XYStepRenderer();
        this.plot = chart.getXYPlot();
        this.plot.setRenderer(renderer);
        ChartPanel plotPanel = new ChartPanel(chart);
        this.contentPanel.add((Component)plotPanel, "Center");
    }

    private void closeButtonActionPerformed(ActionEvent e2) {
        this.setVisible(false);
    }

    public XYDataset updateDataset() {
        ArrayList<DataPoint> dataPoints = new ArrayList<DataPoint>(this.tracks.size());
        HashSet<String> participants = new HashSet<String>();
        for (Track t : this.tracks) {
            try {
                int survivalDays;
                String participant = t.getAttributeValue(this.sampleColumnControl.getSelectedItem().toString());
                if (participants.contains(participant)) continue;
                participants.add(participant);
                String survivalString = t.getAttributeValue(this.survivalColumnControl.getSelectedItem().toString());
                int survival = survivalDays = Integer.parseInt(survivalString);
                String censureString = t.getAttributeValue(this.censurColumnControl.getSelectedItem().toString());
                boolean censured = censureString != null && censureString.equals("1");
                String group = t.getAttributeValue(this.groupByControl.getSelectedItem().toString());
                dataPoints.add(new DataPoint(participant, survival, censured, group));
            }
            catch (NumberFormatException e2) {}
        }
        HashMap<String, ArrayList<DataPoint>> map = new HashMap<String, ArrayList<DataPoint>>();
        for (DataPoint dp : dataPoints) {
            String g2 = dp.group;
            ArrayList<DataPoint> pts = (ArrayList<DataPoint>)map.get(g2);
            if (pts == null) {
                pts = new ArrayList<DataPoint>();
                map.put(g2, pts);
            }
            pts.add(dp);
        }
        XYSeriesCollection dataset = new XYSeriesCollection();
        for (Map.Entry entry : map.entrySet()) {
            List pts = (List)entry.getValue();
            Collections.sort(pts);
            int[] time = new int[pts.size()];
            boolean[] censured = new boolean[pts.size()];
            for (int i2 = 0; i2 < pts.size(); ++i2) {
                int months;
                time[i2] = months = Math.max(1, ((DataPoint)pts.get((int)i2)).time / 30);
                censured[i2] = ((DataPoint)pts.get((int)i2)).censured;
            }
            List<KaplanMeierEstimator.Interval> controlIntervals = KaplanMeierEstimator.compute(time, censured);
            XYSeries series1 = new XYSeries((Comparable)entry.getKey());
            for (KaplanMeierEstimator.Interval interval : controlIntervals) {
                if (interval.getEnd() >= 60) continue;
                series1.add((double)interval.getEnd(), interval.getCumulativeSurvival());
            }
            dataset.addSeries(series1);
        }
        return dataset;
    }

    private void updateButtonActionPerformed(ActionEvent e2) {
        XYDataset dataset = this.updateDataset();
        this.plot.setDataset(dataset);
        this.repaint();
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.censurColumnControl = new JComboBox();
        this.sampleColumnControl = new JComboBox();
        this.survivalColumnControl = new JComboBox();
        this.groupByControl = new JComboBox();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.label4 = new JLabel();
        this.updateButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Kaplan-Meier Plot");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setLayout(new BorderLayout());
        this.panel1.setLayout(null);
        this.panel1.add(this.censurColumnControl);
        this.censurColumnControl.setBounds(145, 62, 215, this.censurColumnControl.getPreferredSize().height);
        this.panel1.add(this.sampleColumnControl);
        this.sampleColumnControl.setBounds(145, 0, 215, this.sampleColumnControl.getPreferredSize().height);
        this.panel1.add(this.survivalColumnControl);
        this.survivalColumnControl.setBounds(145, 31, 215, this.survivalColumnControl.getPreferredSize().height);
        this.panel1.add(this.groupByControl);
        this.groupByControl.setBounds(145, 93, 215, this.groupByControl.getPreferredSize().height);
        this.label1.setText("Sample column");
        this.panel1.add(this.label1);
        this.label1.setBounds(5, 5, 115, this.label1.getPreferredSize().height);
        this.label2.setText("Survival column");
        this.panel1.add(this.label2);
        this.label2.setBounds(5, 36, 115, 16);
        this.label3.setText("Censure column");
        this.panel1.add(this.label3);
        this.label3.setBounds(5, 67, 115, 16);
        this.label4.setText("Group by");
        this.panel1.add(this.label4);
        this.label4.setBounds(5, 98, 115, 16);
        this.updateButton.setText("Update Plot");
        this.updateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e2) {
                KMPlotFrame.this.updateButtonActionPerformed(e2);
            }
        });
        this.panel1.add(this.updateButton);
        this.updateButton.setBounds(385, 90, 145, this.updateButton.getPreferredSize().height);
        Dimension preferredSize = new Dimension();
        for (int i2 = 0; i2 < this.panel1.getComponentCount(); ++i2) {
            Rectangle bounds = this.panel1.getComponent(i2).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.panel1.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.panel1.setMinimumSize(preferredSize);
        this.panel1.setPreferredSize(preferredSize);
        this.contentPanel.add((Component)this.panel1, "North");
        this.dialogPane.add((Component)this.contentPanel, "Center");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(565, 510);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static class DataPoint
    implements Comparable<DataPoint> {
        String participant;
        int time;
        boolean censured;
        String group;

        DataPoint(String participant, int time, boolean censured, String group) {
            this.censured = censured;
            this.participant = participant;
            this.group = group;
            this.time = time;
        }

        @Override
        public int compareTo(DataPoint dataPoint) {
            return this.time - dataPoint.time;
        }
    }
}

